/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.security.PrivilegedAccessController;

public abstract class InterfaceContainerPolicy
extends ContainerPolicy {
    protected Class containerClass;
    protected String containerClassName;
    protected transient Method cloneMethod;

    public InterfaceContainerPolicy() {
    }

    public InterfaceContainerPolicy(Class clazz) {
        this.setContainerClass(clazz);
    }

    public InterfaceContainerPolicy(String string) {
        this.setContainerClassName(string);
    }

    public Object cloneFor(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.invokeCloneMethodOn(this.getCloneMethod(), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.invokeCloneMethodOn(this.getCloneMethod(object.getClass()), object);
        }
    }

    public Method getCloneMethod() {
        if (this.cloneMethod == null) {
            this.setCloneMethod(this.getCloneMethod(this.getContainerClass()));
        }
        return this.cloneMethod;
    }

    protected Method getCloneMethod(Class clazz) {
        try {
            return PrivilegedAccessController.getMethod(clazz, "clone", null, false);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw QueryException.methodDoesNotExistInContainerClass("clone", clazz);
        }
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    public abstract Class getInterfaceType();

    public boolean hasNext(Object object) {
        return ((Iterator)object).hasNext();
    }

    protected Object invokeCloneMethodOn(Method method, Object object) {
        try {
            return PrivilegedAccessController.invokeMethod(method, object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.cannotAccessMethodOnObject(method, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw QueryException.methodInvocationFailed(method, object, invocationTargetException);
        }
    }

    public boolean isValidContainerType(Class clazz) {
        return Helper.classImplementsInterface(clazz, this.getInterfaceType());
    }

    protected Object next(Object object) {
        return ((Iterator)object).next();
    }

    public void setCloneMethod(Method method) {
        this.cloneMethod = method;
    }

    public void setContainerClass(Class clazz) {
        this.containerClass = clazz;
        this.initializeConstructor();
    }

    public void setContainerClassName(String string) {
        this.containerClassName = string;
    }

    protected Object toStringInfo() {
        return this.getContainerClass();
    }
}

