/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing.ejbql;

import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.Vector;
import oracle.toplink.exceptions.EJBQLException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.internal.parsing.ParseTreeConstructor;
import oracle.toplink.internal.parsing.Parser;
import oracle.toplink.internal.parsing.ejbql.EJBQLParser;

public class EJBQLParserBase
extends Parser {
    private boolean verbose = false;
    private Vector errors;
    private String theEjbql = null;

    protected EJBQLParserBase(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.initialize();
    }

    public EJBQLParserBase(ParserSharedInputState parserSharedInputState, int n) {
        super(parserSharedInputState, n);
    }

    protected EJBQLParserBase(TokenStream tokenStream, int n) {
        super(tokenStream, n);
    }

    public void addError(EJBQLException eJBQLException) {
        this.getErrors().add(eJBQLException);
    }

    public void addError(Exception exception) {
        this.addError(EJBQLException.generalParsingException(this.getEjbqlString(), exception));
    }

    public static EJBQLParser buildParserFor(String string) {
        return EJBQLParser.buildParserFor(string);
    }

    public static ParseTree buildParseTree(String string) throws Exception {
        EJBQLParser eJBQLParser = EJBQLParserBase.buildParserFor(string);
        try {
            eJBQLParser.document();
        }
        catch (Exception exception) {
            eJBQLParser.addError(exception);
        }
        if (eJBQLParser.hasErrors()) {
            throw eJBQLParser.generateException();
        }
        return eJBQLParser.getParseTree();
    }

    public void conditionalTermFound() {
        this.output("conditionalTerm found");
    }

    public void finishedAll() {
        this.getParseTreeConstructor().finishConstruction();
    }

    public void finishedAbs() {
        this.output("Finished Abs ");
        this.getParseTreeConstructor().finishedAbs();
    }

    public void finishedAbsVariable() {
        this.output("Finished Abs variable");
        this.getParseTreeConstructor().finishedAbsVariable();
    }

    public void finishedAggregate() {
        this.output("Finished Aggregate");
        this.getParseTreeConstructor().finishedAggregate();
    }

    public void finishedAnd() {
        this.output("Finished And");
        this.getParseTreeConstructor().finishedAnd();
    }

    public void finishedFirstArithmeticExpressionInMOD() {
        this.output("Finished FirstArithmeticExpressionInMOD");
        this.getParseTreeConstructor().finishedFirstArithmeticExpressionInMOD();
    }

    public void finishedSecondArithmeticExpressionInMOD() {
        this.output("Finished SecondArithmeticExpressionInMOD");
        this.getParseTreeConstructor().finishedSecondArithmeticExpressionInMOD();
    }

    public void finishedBetweenAnd() {
        this.output("Finished BETWEEN AND found");
        this.getParseTreeConstructor().finishedBetweenAnd();
    }

    public void finishedConcat() {
        this.output("Finished CONCAT");
        this.getParseTreeConstructor().finishedConcat();
    }

    public void finishedComparisonExpression() {
        this.output("Finished ComparisonExpression");
        this.getParseTreeConstructor().finishedComparisonExpression();
    }

    public void finishedEmpty() {
    }

    public void finishedEscape() {
        this.output("Finished Escape");
        this.getParseTreeConstructor().finishedEscape();
    }

    public void finishedFrom() {
        this.output("Finished FROM");
        this.getParseTreeConstructor().finishedFrom();
    }

    public void finishedNumericOther() {
        this.output("Finished Numeric other");
        this.getParseTreeConstructor().finishedNumericOther();
    }

    public void finishedMultiplyOrDivide() {
        this.getParseTreeConstructor().finishedMultiplyOrDivide();
    }

    public void finishedIn() {
        this.output("Finished IN");
        this.getParseTreeConstructor().finishedIn();
    }

    public final void finishedInClauseInFrom() throws TokenStreamException {
        this.output("Finished In Clause in FROM");
        this.getParseTreeConstructor().finishedInClauseInFrom();
    }

    public void finishedLength() {
        this.output("Finished Length");
        this.getParseTreeConstructor().finishedLength();
    }

    public void finishedLengthVariable() {
        this.output("Finished Length variable");
        this.getParseTreeConstructor().finishedLengthVariable();
    }

    public void finishedLike() {
        this.getParseTreeConstructor().finishedLike();
    }

    public void finishedLocate() {
        this.getParseTreeConstructor().finishedLocate();
    }

    public void finishedLocateLiteral() {
        this.getParseTreeConstructor().finishedLocateLiteral();
    }

    public void finishedLocateVariable() {
        this.getParseTreeConstructor().finishedLocateVariable();
    }

    public void finishedMemberOf() {
        this.getParseTreeConstructor().finishedMemberOf();
    }

    public void finishedNull() {
        this.getParseTreeConstructor().finishedNull();
    }

    public void finishedOr() {
        this.output("Finished or found");
        this.getParseTreeConstructor().finishedOr();
    }

    public void finishedOrderBy() {
        this.output("Finished ORDER BY");
        this.getParseTreeConstructor().finishedOrderBy();
    }

    public void finishedOrderByItem() {
        this.output("Finished ORDER BY item");
        this.getParseTreeConstructor().finishedOrderByItem();
    }

    public void finishedSelect() {
        this.output("Finished SELECT");
        this.getParseTreeConstructor().finishedSelect();
    }

    public void finishedSet() {
        this.output("Finished Set");
        this.getParseTreeConstructor().finishedSet();
    }

    public void finishedEqualsAssignment() {
        this.output("Finished EqualsAssignment");
        this.getParseTreeConstructor().finishedEqualsAssignment();
    }

    public void finishedModSingleValuedPathExpression() {
        this.output("Finished MOD Single Valued Path Expression");
        this.getParseTreeConstructor().finishedModSingleValuedPathExpression();
    }

    public void finishedSqrtVariable() {
        this.output("Finished SQRT variable");
        this.getParseTreeConstructor().finishedSqrtVariable();
    }

    public void finishedSubstring() {
        this.output("Finished substring");
        this.getParseTreeConstructor().finishedSubstring();
    }

    public void finishedSubstringVariable() {
        this.getParseTreeConstructor().finishedSubstringVariable();
    }

    public void finishedUpdate() {
        this.output("Finished UPDATE");
        this.getParseTreeConstructor().finishedUpdate();
    }

    public void finishedWhere() {
        this.output("Finished Where");
        this.getParseTreeConstructor().finishedWhere();
    }

    public Exception generateException() {
        Exception exception = (Exception)this.getErrors().elementAt(0);
        if (exception instanceof EJBQLException) {
            return exception;
        }
        EJBQLException eJBQLException = EJBQLException.generalParsingException(this.getEjbqlString());
        eJBQLException.setInternalExceptions(this.getErrors());
        return eJBQLException;
    }

    private Vector getErrors() {
        return this.errors;
    }

    public String getText() throws TokenStreamException {
        this.rewind(this.mark() - 1);
        String string = this.LT(1).getText();
        this.rewind(this.mark() + 1);
        return string;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public void initialize() {
        this.setParseTreeConstructor(new ParseTreeConstructor());
        this.setErrors(new Vector());
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void matchedAbs() {
        this.output("ABS Found");
        this.getParseTreeConstructor().handleAbs();
    }

    public final void matchedAbstractSchemaIdentifier() throws TokenStreamException {
        this.output("Abstract schema identifier: " + this.getText());
        this.getParseTreeConstructor().registerAbstractSchemaIdentifier(this.getText());
    }

    public final void matchedAbstractSchemaName() throws TokenStreamException {
        this.output("Schema Name found: " + this.getText());
        this.getParseTreeConstructor().registerAbstractSchemaName(this.getText());
    }

    public void matchedAnd() {
        this.output("and found");
        this.getParseTreeConstructor().handleAnd();
    }

    public void matchedAndAfterBetween() {
        this.output("AND found after BETWEEN");
        this.getParseTreeConstructor().handleAndAfterBetween();
    }

    public void matchedAscDirection() {
        this.output("ASC Found");
        this.getParseTreeConstructor().handleAsc();
    }

    public void matchedAvg() {
        this.output("AVG Found");
        this.getParseTreeConstructor().handleAvg();
    }

    public void matchedBetween() {
        this.output("BETWEEN");
        this.getParseTreeConstructor().handleBetween();
    }

    public final void matchedCollectionMemberIdentifier() throws TokenStreamException {
        this.output("Collection member variable found: " + this.getText());
        this.getParseTreeConstructor().registerCollectionVariableName(this.getText());
    }

    public void matchedConcat() {
        this.output("CONCAT found");
        this.getParseTreeConstructor().handleConcat();
    }

    public void matchedCommaAfterConcat() {
        this.output("Comma found after CONCAT");
        this.getParseTreeConstructor().handleCommaAfterConcat();
    }

    public void matchedCount() {
        this.output("COUNT found");
        this.getParseTreeConstructor().handleCount();
    }

    public void matchedDescDirection() {
        this.output("DESC Found");
        this.getParseTreeConstructor().handleDesc();
    }

    public void matchedDistinct() {
        this.output("DISTINCT found");
        this.getParseTreeConstructor().handleDistinct();
    }

    public void matchedDivide() {
        this.output("/ found");
        this.getParseTreeConstructor().handleDivide();
    }

    public void matchedDot() {
        this.output("dot found");
        this.getParseTreeConstructor().handleDot();
    }

    public void matchedEmpty() {
        this.output("Empty found");
        this.getParseTreeConstructor().handleEmpty();
    }

    public void matchedEqualsComparison() {
        this.output("= found");
        this.getParseTreeConstructor().handleEqualsComparison();
    }

    public void matchedEscape() {
        this.output("escape found");
        this.getParseTreeConstructor().handleEscape();
    }

    public final void matchedFALSE() throws TokenStreamException {
        this.output("FALSE found");
        this.getParseTreeConstructor().handleFalse();
    }

    public final void matchedFloat() throws TokenStreamException {
        String string = this.getText();
        int n = string.indexOf(".");
        int n2 = string.length() - n;
        Number number = n2 > 6 ? (Number)new Double(string) : (Number)new Float(string);
        this.output("Float found: " + string + " converted: " + number);
        this.getParseTreeConstructor().handleFloat(number);
    }

    public final void matchedFrom() {
        this.output("FROM found");
        this.getParseTreeConstructor().handleFrom();
    }

    public void matchedGreaterThan() {
        this.output("> found");
        this.getParseTreeConstructor().handleGreaterThan();
    }

    public void matchedGreaterThanEqualTo() {
        this.output(">= (or =>) found");
        this.getParseTreeConstructor().handleGreaterThanEqualTo();
    }

    public final void matchedIdentifier() throws TokenStreamException {
        String string = this.getText();
        this.output("Identifier Name found: " + string);
        this.getParseTreeConstructor().handleLocalVariable(string);
    }

    public void matchedIn() {
        this.output("IN found");
        this.getParseTreeConstructor().handleIn();
    }

    public void matchedInputParameter() throws TokenStreamException {
        this.output("Input parameter found -> " + this.getText());
        this.getParseTreeConstructor().handleInputParameter(this.getText());
    }

    public final void matchedInteger() throws TokenStreamException {
        this.output("Integer found: " + this.getText() + " converted: " + new Integer(this.getText()));
        this.getParseTreeConstructor().handleInteger(new Integer(this.getText()));
    }

    public void matchedNamedInputParameter() throws TokenStreamException {
        this.output("Named Input parameter found -> " + this.getText());
        this.getParseTreeConstructor().handleInputParameter(this.getText());
    }

    public final void matchedLeftMostIdentifier() throws TokenStreamException {
        String string = this.getText();
        this.output("Left Most Identifier Name found: " + string);
        this.getParseTreeConstructor().handleLeftMostLocalVariable(string);
    }

    public final void matchedLeftRoundBracket() throws TokenStreamException {
        this.output("(");
        this.getParseTreeConstructor().handleLeftRoundBracket();
    }

    public void matchedLength() {
        this.output("LENGTH found");
        this.getParseTreeConstructor().handleLength();
    }

    public void matchedLessThan() {
        this.output("< found");
        this.getParseTreeConstructor().handleLessThan();
    }

    public void matchedLessThanEqualTo() {
        this.output("<= (or =<) found");
        this.getParseTreeConstructor().handleLessThanEqualTo();
    }

    public void matchedLike() {
        this.output("like found");
        this.getParseTreeConstructor().handleLike();
    }

    public void matchedLocate() {
        this.output("locate found");
        this.getParseTreeConstructor().handleLocate();
    }

    public void matchedMax() {
        this.output("MAX found");
        this.getParseTreeConstructor().handleMax();
    }

    public void matchedMemberOf() {
        this.output("MEMBER [OF] found");
        this.getParseTreeConstructor().handleMemberOf();
    }

    public void matchedMin() {
        this.output("MIN found");
        this.getParseTreeConstructor().handleMin();
    }

    public void matchedMinus() {
        this.output("- found");
        this.getParseTreeConstructor().handleMinus();
    }

    public void matchedMod() {
        this.output("MOD Found");
        this.getParseTreeConstructor().handleMod();
    }

    public void matchedMultiply() {
        this.output("* found");
        this.getParseTreeConstructor().handleMultiply();
    }

    public void matchedNot() {
        this.output("not found");
        this.getParseTreeConstructor().handleNot();
    }

    public void matchedNotEqualTo() {
        this.output("<> found");
        this.getParseTreeConstructor().handleNotEqualTo();
    }

    public void matchedNull() {
        this.output("Null found");
        this.getParseTreeConstructor().handleNull();
    }

    public void matchedOr() {
        this.output("or found");
        this.getParseTreeConstructor().handleOr();
    }

    public void matchedOrderBy() {
        this.output("ORDER BY found");
        this.getParseTreeConstructor().handleOrderBy();
    }

    public void matchedOrderByItem() {
        this.output("ORDER BY item found");
        this.getParseTreeConstructor().handleOrderByItem();
    }

    public void matchedPlus() {
        this.output("+ found");
        this.getParseTreeConstructor().handlePlus();
    }

    public final void matchedRightRoundBracket() throws TokenStreamException {
        this.output(")");
        this.getParseTreeConstructor().handleRightRoundBracket();
    }

    public void matchedSelect() {
        this.output("SELECT Found");
        this.getParseTreeConstructor().handleSelect();
    }

    public void matchedSet() {
        this.output("SET Found");
        this.getParseTreeConstructor().handleSet();
    }

    public void matchedEqualsAssignment() {
        this.output("EqualsAssignment found");
        this.getParseTreeConstructor().handleEqualsAssignment();
    }

    public void matchedSqrt() {
        this.output("SQRT found");
        this.getParseTreeConstructor().handleSqrt();
    }

    public void matchedSum() {
        this.output("SUM found");
        this.getParseTreeConstructor().handleSum();
    }

    public void matchedQuotedString(String string, String string2) {
        int n;
        this.output("String found -> " + string2);
        String string3 = string2.substring(1, string2.length() - 1);
        while ((n = string3.indexOf("''")) != -1) {
            string3 = string3.substring(0, n) + string3.substring(n + 1, string3.length());
        }
        this.getParseTreeConstructor().handleString(string3);
    }

    public void matchedDoubleQuotedString() throws TokenStreamException {
        this.matchedQuotedString("\"", this.getText());
    }

    public void matchedSingleQuotedString() throws TokenStreamException {
        this.matchedQuotedString("'", this.getText());
    }

    public void matchedSubstring() {
        this.output("Substring found");
        this.getParseTreeConstructor().handleSubstring();
    }

    public final void matchedTRUE() throws TokenStreamException {
        this.output("TRUE found");
        this.getParseTreeConstructor().handleTrue();
    }

    public void matchedUpdate() {
        this.output("UPDATE Found");
        this.getParseTreeConstructor().handleUpdate();
    }

    public void matchedWhere() {
        this.output("WHERE found");
        this.getParseTreeConstructor().handleWhere();
    }

    public void startEqualsAssignment() {
        this.output("EqualsAssignment starting");
        this.getParseTreeConstructor().startEqualsAssignment();
    }

    public void output(String string) {
        if (this.isVerbose()) {
            System.out.println(string);
        }
    }

    public void reportError(RecognitionException recognitionException) {
        EJBQLException eJBQLException = EJBQLException.recognitionException(this.getEjbqlString(), recognitionException.getMessage());
        this.addError(eJBQLException);
        throw eJBQLException;
    }

    private void setErrors(Vector vector) {
        this.errors = vector;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public short getDistinctState() {
        return this.getParseTree().getDistinctState();
    }

    public String getEjbqlString() {
        return this.theEjbql;
    }

    public void setEjbqlString(String string) {
        this.theEjbql = string;
    }

    public static EJBQLParser parseEJBQLString(String string) throws QueryException {
        EJBQLParser eJBQLParser = EJBQLParserBase.buildParserFor(string);
        try {
            eJBQLParser.document();
        }
        catch (EJBQLException eJBQLException) {
            eJBQLParser.addError(eJBQLException);
        }
        catch (Exception exception) {
            eJBQLParser.addError(exception);
        }
        if (eJBQLParser.hasErrors()) {
            throw (EJBQLException)eJBQLParser.generateException();
        }
        return eJBQLParser;
    }
}

