/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.DotNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.internal.parsing.QueryNode;
import oracle.toplink.internal.parsing.SelectGenerationContext;
import oracle.toplink.internal.parsing.VariableNode;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public class SelectNode
extends QueryNode {
    private ParseTree parseTree;

    public void applyToQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
        if (this.getLeft() == null) {
            return;
        }
        if (!this.getLeft().isCountNode() && generationContext.getParseTree().usesDistinct()) {
            objectLevelReadQuery.setDistinctState(generationContext.getParseTree().getDistinctState());
        }
        if (this.hasAttributeSelected(generationContext) || this.getLeft().isCountNode() || this.getLeft().isAggregateNode()) {
            this.getLeft().applyToQuery(objectLevelReadQuery, generationContext);
        }
        if (this.hasOneToOneSelected(generationContext)) {
            objectLevelReadQuery.setProperty("return null if primary key is null", Boolean.TRUE);
        } else {
            objectLevelReadQuery.removeProperty("return null if primary key is null");
        }
    }

    public boolean hasOneToOneSelected(GenerationContext generationContext) {
        if (this.hasCountSelected(generationContext)) {
            return false;
        }
        if (this.hasAttributeSelected(generationContext)) {
            return false;
        }
        return this.getLeft() != null && this.getLeft().isDotNode();
    }

    public boolean hasCountSelected(GenerationContext generationContext) {
        return this.getLeft() != null && this.getLeft().isCountNode();
    }

    public boolean selectedOneToOneClassIsDeclaredInFROM(GenerationContext generationContext) {
        boolean bl;
        if (!this.getLeft().isDotNode()) {
            return false;
        }
        DotNode dotNode = (DotNode)this.getLeft();
        boolean bl2 = bl = !dotNode.resolveMapping(generationContext).isDirectToFieldMapping();
        return bl && generationContext.getParseTreeContext().hasVariableNameForClass(dotNode.resolveClass(generationContext), generationContext);
    }

    public boolean selectedOneToOneClassIsDeclaredInFROM(String string, GenerationContext generationContext) {
        String string2;
        boolean bl;
        if (!this.getLeft().isDotNode()) {
            return false;
        }
        DotNode dotNode = (DotNode)this.getLeft();
        boolean bl2 = bl = !dotNode.resolveMapping(generationContext).isDirectToFieldMapping();
        if (bl && (string2 = generationContext.getParseTreeContext().getVariableNameForClass(dotNode.resolveClass(generationContext), generationContext)) != null) {
            return string2.equals(string);
        }
        return false;
    }

    public boolean hasAttributeSelected(GenerationContext generationContext) {
        Node node;
        if (this.getLeft() == null) {
            return false;
        }
        if (this.getLeft().isDotNode() && ((DotNode)this.getLeft()).endsWithDirectToField(generationContext)) {
            return true;
        }
        if ((this.getLeft().isCountNode() || this.getLeft().isAggregateNode()) && (node = this.getLeft().getLeft()).isDotNode()) {
            return ((DotNode)node).endsWithDirectToField(generationContext);
        }
        return false;
    }

    public void verifySelectedAlias(GenerationContext generationContext) {
        if (this.getLeft().isDotNode()) {
            return;
        }
        this.getLeft().resolveClass(generationContext);
    }

    public boolean isSelected(String string) {
        if (!this.getLeft().isVariableNode()) {
            return false;
        }
        return ((VariableNode)this.getLeft()).getVariableName().equals(string);
    }

    public boolean isSelectNode() {
        return true;
    }

    public void setParseTree(ParseTree parseTree) {
        this.parseTree = parseTree;
    }

    public Class resolveClass(GenerationContext generationContext) {
        return this.getLeft().resolveClass(generationContext);
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Object object;
        if (this.getLeft().isVariableNode()) {
            object = ((VariableNode)this.getLeft()).getVariableName();
            if (!generationContext.getParseTreeContext().isDeclaredInINClause((String)object)) {
                return null;
            }
        }
        if (this.selectingDirectToField(generationContext)) {
            return null;
        }
        if (this.getLeft().isAggregateNode()) {
            return null;
        }
        if (!this.hasAttributeSelected(generationContext) && !this.getLeft().isCountNode()) {
            ((SelectGenerationContext)generationContext).useOuterJoins();
        }
        object = this.getLeft().generateExpression(generationContext);
        ((SelectGenerationContext)generationContext).dontUseOuterJoins();
        return object;
    }

    public boolean isVariableInINClauseSelected(GenerationContext generationContext) {
        if (this.getLeft().isVariableNode()) {
            String string = ((VariableNode)this.getLeft()).getVariableName();
            if (generationContext.getParseTreeContext().isDeclaredInINClause(string)) {
                return true;
            }
        }
        return false;
    }

    public boolean selectingDirectToField(GenerationContext generationContext) {
        if (!this.getLeft().isDotNode()) {
            return false;
        }
        return ((DotNode)this.getLeft()).endsWithDirectToField(generationContext);
    }
}

