/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.DotNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReportQuery;

public class AggregateNode
extends Node {
    private int aggregateOperator;

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ((ReportQuery)objectLevelReadQuery).returnSingleAttribute();
            ((ReportQuery)objectLevelReadQuery).dontRetrievePrimaryKeys();
            if (this.hasItemToAddToQuery()) {
                this.addItemToQuery((ReportQuery)objectLevelReadQuery, generationContext);
            }
        }
    }

    private void addItemToQuery(ReportQuery reportQuery, GenerationContext generationContext) {
        Expression expression = this.getAggregateExpressionFor(this.getAggregateOperator(), this.getLeft().generateExpression(generationContext));
        reportQuery.addItem(this.resolveAttributeForSelect(generationContext), expression);
    }

    private Expression getAggregateExpressionFor(int n, Expression expression) {
        return expression.getFunction(n);
    }

    public boolean hasItemToAddToQuery() {
        return true;
    }

    public void placeNode(Node node) {
        this.setLeft(node);
    }

    public String resolveAttributeForSelect(GenerationContext generationContext) {
        return ((DotNode)this.getLeft()).resolveAttributeForSelect(generationContext);
    }

    public void useAvg() {
        this.setAggregateOperator(21);
    }

    public void useMax() {
        this.setAggregateOperator(22);
    }

    public void useMin() {
        this.setAggregateOperator(23);
    }

    public void useSum() {
        this.setAggregateOperator(20);
    }

    public int getAggregateOperator() {
        return this.aggregateOperator;
    }

    public void setAggregateOperator(int n) {
        this.aggregateOperator = n;
    }

    public Class resolveClass(GenerationContext generationContext) {
        return this.getLeft().resolveClass(generationContext);
    }

    public Expression generateExpression(GenerationContext generationContext) {
        return this.getLeft().generateExpression(generationContext);
    }

    public boolean isAggregateNode() {
        return true;
    }
}

