/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.ox.XMLConstants;
import oracle.toplink.xml.tools.Base64;

public class XMLConversionManager
extends ConversionManager {
    protected static HashMap defaultXMLTypes;
    protected static HashMap defaultJavaTypes;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TIME_MS_FORMAT = "HH:mm:ss.SSS";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATE_TIME_MS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    protected static XMLConversionManager defaultXMLManager;

    public static XMLConversionManager getDefaultXMLManager() {
        if (defaultXMLManager == null) {
            defaultXMLManager = new XMLConversionManager();
        }
        return defaultXMLManager;
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException {
        if (object == null) {
            return super.convertObject(object, clazz);
        }
        if (clazz == XMLConstants.QNAME_CLASS && object != null) {
            return this.convertObjectToQName(object);
        }
        if (clazz == ClassConstants.List_Class && object instanceof String) {
            return this.convertStringToList(object);
        }
        if (clazz == ClassConstants.STRING && object instanceof List) {
            return this.convertListToString(object);
        }
        if (clazz == ClassConstants.CALENDAR) {
            return this.convertObjectToCalendar(object);
        }
        if (clazz == ClassConstants.UTILDATE) {
            return this.convertObjectToUtilDate(object, XMLConstants.DATE_TIME_QNAME);
        }
        if (clazz == ClassConstants.SQLDATE) {
            return this.convertObjectToSQLDate(object, XMLConstants.DATE_QNAME);
        }
        if (clazz == ClassConstants.TIME) {
            return this.convertObjectToSQLTime(object, XMLConstants.TIME_QNAME);
        }
        if (clazz == ClassConstants.TIMESTAMP) {
            return this.convertObjectToTimestamp(object, XMLConstants.DATE_TIME_QNAME);
        }
        try {
            return super.convertObject(object, clazz);
        }
        catch (ConversionException conversionException) {
            if (object.getClass() == ClassConstants.STRING) {
                return super.convertObject(((String)object).trim(), clazz);
            }
            throw conversionException;
        }
    }

    public Object convertObject(Object object, Class clazz, QName qName) throws ConversionException {
        if (qName == null) {
            return this.convertObject(object, clazz);
        }
        if (object == null) {
            return super.convertObject(object, clazz);
        }
        if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
            return this.convertObjectToCalendar(object, qName);
        }
        if (clazz == ClassConstants.ABYTE) {
            if (qName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteObjectArray(object);
            }
            if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteObjectArray(object);
            }
        } else if (clazz == ClassConstants.APBYTE) {
            if (qName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteArray(object);
            }
            if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteArray(object);
            }
        } else {
            if (clazz == ClassConstants.List_Class && object instanceof String) {
                return this.convertStringToList(object);
            }
            if (clazz == ClassConstants.STRING && object instanceof List) {
                return this.convertListToString(object);
            }
            if (object instanceof byte[]) {
                if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromBytes((byte[])object);
                }
                return Helper.buildHexStringFromBytes((byte[])object);
            }
            if (object instanceof Byte[]) {
                if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromObjectBytes((Byte[])object);
                }
                return this.buildHexStringFromObjectBytes((Byte[])object);
            }
            if (clazz == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(object, qName);
            }
            if (clazz == ClassConstants.SQLDATE) {
                return this.convertObjectToSQLDate(object, qName);
            }
            if (clazz == ClassConstants.TIME) {
                return this.convertObjectToSQLTime(object, qName);
            }
            if (clazz == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(object, qName);
            }
            if (clazz == XMLConstants.QNAME_CLASS && object != null) {
                return this.convertObjectToQName(object);
            }
            if (clazz == ClassConstants.STRING) {
                return this.convertObjectToString(object, qName);
            }
            try {
                return super.convertObject(object, clazz);
            }
            catch (ConversionException conversionException) {
                if (object.getClass() == ClassConstants.STRING) {
                    return super.convertObject(((String)object).trim(), clazz);
                }
                throw conversionException;
            }
        }
        throw ConversionException.couldNotBeConverted(object, clazz);
    }

    protected QName convertObjectToQName(Object object) throws ConversionException {
        if (object instanceof QName) {
            return (QName)object;
        }
        if (object instanceof String) {
            return this.qnameFromString((String)object);
        }
        throw ConversionException.couldNotBeConverted(object, XMLConstants.QNAME_CLASS);
    }

    protected Calendar convertObjectToCalendar(Object object) throws ConversionException {
        if (object instanceof String) {
            String string = (String)object;
            if (string.lastIndexOf("T") != -1) {
                return this.convertStringToCalendar((String)object, XMLConstants.DATE_TIME_QNAME);
            }
            if (string.lastIndexOf(":") != -1) {
                return this.convertStringToCalendar((String)object, XMLConstants.TIME_QNAME);
            }
            return this.convertStringToCalendar((String)object, XMLConstants.DATE_QNAME);
        }
        return super.convertObjectToCalendar(object);
    }

    protected String convertObjectToString(Object object) throws ConversionException {
        if (object instanceof Calendar) {
            return this.stringFromCalendar((Calendar)object);
        }
        if (object instanceof QName) {
            return this.stringFromQName((QName)object);
        }
        if (object instanceof Date) {
            return this.stringFromSQLDate((Date)object);
        }
        if (object instanceof Time) {
            return this.stringFromSQLTime((Time)object);
        }
        if (object instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)object);
        }
        return super.convertObjectToString(object);
    }

    protected String convertObjectToString(Object object, QName qName) throws ConversionException {
        if (object instanceof Calendar) {
            return this.stringFromCalendar((Calendar)object, qName);
        }
        if (object instanceof QName) {
            return this.stringFromQName((QName)object);
        }
        if (object instanceof Date) {
            return this.stringFromSQLDate((Date)object, qName);
        }
        if (object instanceof Time) {
            return this.stringFromSQLTime((Time)object, qName);
        }
        if (object instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)object, qName);
        }
        if (object instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)object, qName);
        }
        return super.convertObjectToString(object);
    }

    private Calendar convertObjectToCalendar(Object object, QName qName) {
        if (!(object instanceof String)) {
            return super.convertObjectToCalendar(object);
        }
        return this.convertStringToCalendar((String)object, qName);
    }

    private Calendar convertStringToCalendar(String string, QName qName) {
        Cloneable cloneable;
        if (qName.getLocalPart().equals("date")) {
            try {
                new SimpleDateFormat(DATE_FORMAT).parse(string);
                Timestamp timestamp = Helper.timestampFromString(string);
                java.util.Date date = Helper.utilDateFromTimestamp(timestamp);
                return Helper.calendarFromUtilDate(date);
            }
            catch (Exception exception) {
                throw ConversionException.incorrectDateFormat(string);
            }
        }
        if (qName.getLocalPart().equals("time")) {
            Cloneable cloneable2;
            try {
                cloneable2 = new SimpleDateFormat(TIME_MS_FORMAT);
                cloneable2.setLenient(true);
                cloneable2.parse(string);
            }
            catch (ParseException parseException) {
                try {
                    new SimpleDateFormat(TIME_FORMAT).parse(string);
                }
                catch (Exception exception) {
                    throw ConversionException.incorrectTimeFormat(string);
                }
            }
            cloneable2 = Helper.timestampFromString("1970-01-01 " + string);
            java.util.Date date = Helper.utilDateFromTimestamp((Timestamp)cloneable2);
            return Helper.calendarFromUtilDate(date);
        }
        try {
            cloneable = new SimpleDateFormat(DATE_TIME_MS_FORMAT);
            cloneable.setLenient(true);
            cloneable.parse(string);
        }
        catch (ParseException parseException) {
            try {
                new SimpleDateFormat(DATE_TIME_FORMAT).parse(string);
            }
            catch (Exception exception) {
                throw ConversionException.incorrectDateTimeFormat(string);
            }
        }
        cloneable = Helper.timestampFromString(string.replace('T', ' '));
        java.util.Date date = Helper.utilDateFromTimestamp((Timestamp)cloneable);
        return Helper.calendarFromUtilDate(date);
    }

    private java.util.Date convertObjectToUtilDate(Object object, QName qName) {
        if (object instanceof String) {
            Timestamp timestamp = this.convertStringToTimestamp((String)object, qName);
            return Helper.utilDateFromTimestamp(timestamp);
        }
        return super.convertObjectToUtilDate(object);
    }

    protected Date convertObjectToSQLDate(Object object, QName qName) {
        if (object instanceof String) {
            java.util.Date date = this.convertObjectToUtilDate(object, qName);
            return new Date(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToDate(object);
    }

    protected Time convertObjectToSQLTime(Object object, QName qName) {
        if (object instanceof String) {
            java.util.Date date = this.convertObjectToUtilDate(object, qName);
            return new Time(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToTime(object);
    }

    protected Timestamp convertStringToTimestamp(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_MS_FORMAT);
            simpleDateFormat.setLenient(true);
            simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                new SimpleDateFormat(DATE_TIME_FORMAT).parse(string);
            }
            catch (Exception exception) {
                throw ConversionException.incorrectDateTimeFormat(string);
            }
        }
        try {
            return Helper.timestampFromString(string.replace('T', ' '));
        }
        catch (Exception exception) {
            throw ConversionException.incorrectDateTimeFormat(string);
        }
    }

    protected Timestamp convertObjectToTimestamp(Object object, QName qName) {
        if (!(object instanceof String)) {
            return super.convertObjectToTimestamp(object);
        }
        return this.convertStringToTimestamp((String)object, qName);
    }

    protected Timestamp convertStringToTimestamp(String string, QName qName) {
        if (qName.getLocalPart().equals("date")) {
            try {
                java.util.Date date = new SimpleDateFormat(DATE_FORMAT).parse(string);
                return Helper.timestampFromDate(date);
            }
            catch (Exception exception) {
                throw ConversionException.incorrectDateFormat(string);
            }
        }
        if (qName.getLocalPart().equals("time")) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_MS_FORMAT);
                simpleDateFormat.setLenient(true);
                simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                try {
                    new SimpleDateFormat(TIME_FORMAT).parse(string);
                }
                catch (Exception exception) {
                    throw ConversionException.incorrectTimeFormat(string);
                }
            }
            return Helper.timestampFromString("1970-01-01 " + string);
        }
        return this.convertStringToTimestamp(string);
    }

    private String stringFromCalendar(Calendar calendar, QName qName) {
        return this.stringFromDate(calendar.getTime(), qName);
    }

    private String stringFromCalendar(Calendar calendar) {
        if (!(calendar.isSet(10) || calendar.isSet(12) || calendar.isSet(13) || calendar.isSet(14))) {
            return this.dateFromCalendar(calendar);
        }
        if (!(calendar.isSet(1) || calendar.isSet(2) || calendar.isSet(5))) {
            return this.timeFromCalendar(calendar);
        }
        return this.stringFromDate(calendar.getTime());
    }

    private String stringFromDate(java.util.Date date) {
        String string = Helper.printTimestamp(Helper.timestampFromDate(date));
        return string.replaceAll(" ", "T");
    }

    private String stringFromDate(java.util.Date date, QName qName) {
        if (qName.getLocalPart().equalsIgnoreCase("date")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            return simpleDateFormat.format(date);
        }
        if (qName.getLocalPart().equalsIgnoreCase("time")) {
            int n = (int)(date.getTime() % 1000L);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
            String string = simpleDateFormat.format(date);
            string = 0 == n ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(n, 3);
            return string;
        }
        return this.stringFromDate(date);
    }

    private String stringFromSQLDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        return simpleDateFormat.format(date);
    }

    private String stringFromSQLDate(Date date, QName qName) {
        SimpleDateFormat simpleDateFormat = qName.getLocalPart().equalsIgnoreCase("date") ? new SimpleDateFormat(DATE_FORMAT) : (qName.getLocalPart().equalsIgnoreCase("time") ? new SimpleDateFormat(TIME_FORMAT) : new SimpleDateFormat(DATE_TIME_FORMAT));
        return simpleDateFormat.format(date);
    }

    private String stringFromSQLTime(Time time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        return simpleDateFormat.format(time);
    }

    private String stringFromSQLTime(Time time, QName qName) {
        SimpleDateFormat simpleDateFormat = qName.getLocalPart().equalsIgnoreCase("date") ? new SimpleDateFormat(DATE_FORMAT) : (qName.getLocalPart().equalsIgnoreCase("time") ? new SimpleDateFormat(TIME_FORMAT) : new SimpleDateFormat(DATE_TIME_FORMAT));
        return simpleDateFormat.format(time);
    }

    private String stringFromTimestamp(Timestamp timestamp) {
        String string = Helper.printTimestamp(timestamp);
        return string.replace(' ', 'T');
    }

    private String stringFromTimestamp(Timestamp timestamp, QName qName) {
        if (qName.getLocalPart().equalsIgnoreCase("date")) {
            return this.stringFromDate(timestamp, qName);
        }
        if (qName.getLocalPart().equalsIgnoreCase("time")) {
            String string = this.stringFromTimestamp(timestamp);
            return string.substring(11);
        }
        return this.stringFromTimestamp(timestamp);
    }

    private String stringFromQName(QName qName) {
        return qName.toString();
    }

    private QName qnameFromString(String string) {
        if (string.indexOf("{") != -1) {
            String string2 = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
            String string3 = string.substring(string.indexOf("}") + 1);
            return new QName(string2, string3);
        }
        return new QName(string);
    }

    private String dateFromCalendar(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        return simpleDateFormat.format(calendar.getTime());
    }

    private String timeFromCalendar(Calendar calendar) {
        int n = (int)(calendar.getTimeInMillis() % 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        String string = simpleDateFormat.format(calendar.getTime());
        string = 0 == n ? string + ".0" : string + '.' + Helper.buildZeroPrefixAndTruncTrailZeros(n, 3);
        return string;
    }

    protected byte[] convertSchemaBase64ToByteArray(Object object) throws ConversionException {
        if (!(object instanceof String)) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.APBYTE);
        }
        byte[] byArray = Base64.base64Decode(((String)object).getBytes());
        return byArray;
    }

    protected Byte[] convertSchemaBase64ToByteObjectArray(Object object) throws ConversionException {
        byte[] byArray = this.convertSchemaBase64ToByteArray(object);
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    protected String buildBase64StringFromBytes(byte[] byArray) {
        byte[] byArray2 = Base64.base64Encode(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuffer.append((char)byArray2[i]);
        }
        return stringBuffer.toString();
    }

    protected String buildBase64StringFromObjectBytes(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return this.buildBase64StringFromBytes(byArray);
    }

    protected String buildHexStringFromObjectBytes(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return Helper.buildHexStringFromBytes(byArray);
    }

    protected List convertStringToList(Object object) throws ConversionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object instanceof String) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected String convertListToString(Object object) throws ConversionException {
        String string = new String();
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof String)) continue;
                if (i > 0) {
                    string = string + " ";
                }
                string = string + e;
            }
        }
        return string;
    }

    public HashMap getDefaultXMLTypes() {
        if (defaultXMLTypes == null) {
            defaultXMLTypes = this.buildXMLTypes();
        }
        return defaultXMLTypes;
    }

    public HashMap getDefaultJavaTypes() {
        if (defaultJavaTypes == null) {
            defaultJavaTypes = this.buildJavaTypes();
        }
        return defaultJavaTypes;
    }

    private HashMap buildXMLTypes() {
        HashMap<QName, Class> hashMap = new HashMap<QName, Class>();
        hashMap.put(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
        hashMap.put(XMLConstants.BOOLEAN_QNAME, ClassConstants.PBOOLEAN);
        hashMap.put(XMLConstants.BYTE_QNAME, ClassConstants.PBYTE);
        hashMap.put(XMLConstants.DATE_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
        hashMap.put(XMLConstants.DOUBLE_QNAME, ClassConstants.PDOUBLE);
        hashMap.put(XMLConstants.FLOAT_QNAME, ClassConstants.PFLOAT);
        hashMap.put(XMLConstants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
        hashMap.put(XMLConstants.INT_QNAME, ClassConstants.PINT);
        hashMap.put(XMLConstants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
        hashMap.put(XMLConstants.LONG_QNAME, ClassConstants.PLONG);
        hashMap.put(XMLConstants.QNAME_QNAME, XMLConstants.QNAME_CLASS);
        hashMap.put(XMLConstants.SHORT_QNAME, ClassConstants.PSHORT);
        hashMap.put(XMLConstants.STRING_QNAME, ClassConstants.STRING);
        hashMap.put(XMLConstants.TIME_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.UNSIGNED_BYTE_QNAME, ClassConstants.PSHORT);
        hashMap.put(XMLConstants.UNSIGNED_INT_QNAME, ClassConstants.PLONG);
        hashMap.put(XMLConstants.UNSIGNED_SHORT_QNAME, ClassConstants.PINT);
        hashMap.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.STRING);
        return hashMap;
    }

    private HashMap buildJavaTypes() {
        HashMap<Class, QName> hashMap = new HashMap<Class, QName>();
        hashMap.put(ClassConstants.APBYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(ClassConstants.BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        hashMap.put(ClassConstants.BIGINTEGER, XMLConstants.INTEGER_QNAME);
        hashMap.put(ClassConstants.PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(ClassConstants.PBYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(ClassConstants.CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(ClassConstants.PDOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(ClassConstants.PFLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(ClassConstants.PINT, XMLConstants.INT_QNAME);
        hashMap.put(ClassConstants.PLONG, XMLConstants.LONG_QNAME);
        hashMap.put(ClassConstants.PSHORT, XMLConstants.SHORT_QNAME);
        hashMap.put(XMLConstants.QNAME_CLASS, XMLConstants.QNAME_QNAME);
        hashMap.put(ClassConstants.STRING, XMLConstants.STRING_QNAME);
        hashMap.put(ClassConstants.ABYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(ClassConstants.BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(ClassConstants.BYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(ClassConstants.GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(ClassConstants.DOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(ClassConstants.FLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(ClassConstants.INTEGER, XMLConstants.INT_QNAME);
        hashMap.put(ClassConstants.LONG, XMLConstants.LONG_QNAME);
        hashMap.put(ClassConstants.SHORT, XMLConstants.SHORT_QNAME);
        return hashMap;
    }
}

