/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.util.Vector;
import oracle.toplink.descriptors.changetracking.ChangeTracker;
import oracle.toplink.descriptors.changetracking.CollectionChangeTracker;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.indirection.IndirectCollection;
import oracle.toplink.indirection.IndirectContainer;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.indirection.BackupValueHolder;
import oracle.toplink.internal.indirection.BatchValueHolder;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.indirection.QueryBasedValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.RemoteSession;

public class TransparentIndirectionPolicy
extends IndirectionPolicy {
    protected static Integer defaultContainerSize;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        if (!(object instanceof IndirectContainer) || this.objectIsInstantiated(object)) {
            return super.backupCloneAttribute(object, object2, object3, unitOfWork);
        }
        return this.buildBackupClone((IndirectContainer)object);
    }

    protected Object buildBackupClone(IndirectContainer indirectContainer) {
        UnitOfWorkValueHolder unitOfWorkValueHolder = (UnitOfWorkValueHolder)indirectContainer.getValueHolder();
        BackupValueHolder backupValueHolder = new BackupValueHolder(unitOfWorkValueHolder);
        unitOfWorkValueHolder.setBackupValueHolder(backupValueHolder);
        return this.buildIndirectContainer(backupValueHolder);
    }

    protected IndirectContainer buildIndirectContainer() {
        if (defaultContainerSize != null) {
            return (IndirectContainer)this.getContainerPolicy().containerInstance(TransparentIndirectionPolicy.getDefaultContainerSize());
        }
        return (IndirectContainer)this.getContainerPolicy().containerInstance();
    }

    protected Object buildIndirectContainer(ValueHolderInterface valueHolderInterface) {
        IndirectContainer indirectContainer = this.buildIndirectContainer();
        indirectContainer.setValueHolder(valueHolderInterface);
        return indirectContainer;
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        ValueHolderInterface valueHolderInterface = null;
        Object object4 = null;
        if (object instanceof IndirectContainer) {
            valueHolderInterface = ((IndirectContainer)object).getValueHolder();
        }
        if (!bl && unitOfWork.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                object4 = this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWork, false);
            } else {
                if (!(object instanceof IndirectContainer)) {
                    valueHolderInterface = new ValueHolder(object);
                }
                DatabaseRow databaseRow = null;
                if (valueHolderInterface instanceof DatabaseValueHolder) {
                    databaseRow = ((DatabaseValueHolder)valueHolderInterface).getRow();
                }
                UnitOfWorkValueHolder unitOfWorkValueHolder = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, databaseRow, unitOfWork, bl);
                object4 = this.buildIndirectContainer(unitOfWorkValueHolder);
                Object object5 = this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWork, false);
                unitOfWorkValueHolder.privilegedSetValue(object5);
                unitOfWorkValueHolder.setInstantiated();
            }
        } else {
            if (!(object instanceof IndirectContainer)) {
                valueHolderInterface = new ValueHolder(object);
            }
            DatabaseRow databaseRow = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                databaseRow = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            object4 = this.buildIndirectContainer(this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, databaseRow, unitOfWork, bl));
        }
        if (this.getMapping().getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && ((ChangeTracker)object3).getTopLinkPropertyChangeListener() != null && object4 instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)object4).setTopLinkAttributeName(this.getMapping().getAttributeName());
            ((CollectionChangeTracker)object4).setTopLinkPropertyChangeListener(((ChangeTracker)object3).getTopLinkPropertyChangeListener());
        }
        return object4;
    }

    protected boolean containerPolicyIsValid() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.IndirectContainer_Class);
    }

    public Vector extractPrimaryKeyForReferenceObject(Object object, Session session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public DatabaseRow extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)object).getValueHolder()).getRow();
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getMapping().getAttributeValueFromObject(object);
        if (object2 instanceof IndirectContainer || !(((IndirectContainer)object2).getValueHolder() instanceof RemoteValueHolder)) {
            RemoteValueHolder remoteValueHolder = (RemoteValueHolder)((IndirectContainer)object2).getValueHolder();
            remoteValueHolder.setSession(remoteSession);
            remoteValueHolder.setMapping(this.getMapping());
            if (!objectLevelReadQuery.shouldMaintainCache() && (!objectLevelReadQuery.shouldCascadeParts() || objectLevelReadQuery.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                remoteValueHolder.setQuery(null);
            } else {
                remoteValueHolder.setQuery(objectLevelReadQuery);
            }
            remoteValueHolder.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
        }
    }

    protected Class getContainerClass() {
        return this.getContainerPolicy().getContainerClass();
    }

    protected ContainerPolicy getContainerPolicy() {
        return this.getCollectionMapping().getContainerPolicy();
    }

    protected static int getDefaultContainerSize() {
        return defaultContainerSize;
    }

    public Object getOriginalIndirectionObject(Object object, Session session) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        if (indirectContainer.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolder();
            if (valueHolderInterface == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildIndirectContainer(valueHolderInterface);
        }
        return indirectContainer;
    }

    public Object getRealAttributeValueFromObject(Object object) {
        return object;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        Object object = remoteValueHolder.getServerIndirectionObject();
        this.getContainerPolicy().sizeFor(object);
        return object;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        super.setRealAttributeValueInObject(object, object2);
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object instanceof IndirectContainer) {
            descriptorIterator.iterateIndirectContainerForMapping((IndirectContainer)object, this.getMapping());
        } else {
            super.iterateOnAttributeValue(descriptorIterator, object);
        }
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        IndirectContainer indirectContainer = (IndirectContainer)this.getMapping().getAttributeValueFromObject(object2);
        RemoteValueHolder remoteValueHolder = (RemoteValueHolder)indirectContainer.getValueHolder();
        this.mergeClientIntoServerValueHolder(remoteValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(object, indirectContainer);
    }

    public Object nullValueFromRow() {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof IndirectContainer) {
            return ((IndirectContainer)object).isInstantiated();
        }
        return true;
    }

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object) || object instanceof IndirectCollection && ((IndirectCollection)object).hasDeferredChanges();
    }

    public static void setDefaultContainerSize(int n) {
        defaultContainerSize = new Integer(n);
    }

    protected boolean typeIsValid(Class clazz) {
        if (Helper.classIsSubclass(this.getContainerClass(), clazz)) {
            return true;
        }
        return Helper.classImplementsInterface(this.getContainerClass(), clazz);
    }

    public boolean usesTransparentIndirection() {
        return true;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object == null) {
            return this.buildIndirectContainer();
        }
        if (!this.getContainerPolicy().isValidContainer(object)) {
            throw DescriptorException.indirectContainerInstantiationMismatch(object, this.getMapping());
        }
        return object;
    }

    public void validateContainerPolicy(IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateContainerPolicy(integrityChecker);
        if (!this.containerPolicyIsValid()) {
            integrityChecker.handleError(DescriptorException.invalidContainerPolicyWithTransparentIndirection(this.getMapping(), this.getContainerPolicy()));
        }
        if (this.getContainerPolicy().isMapPolicy() && (((ForeignReferenceMapping)this.getMapping()).getRelationshipPartnerAttributeName() != null || this.getMapping().getRelationshipPartner() != null)) {
            integrityChecker.handleError(DescriptorException.unsupportedTypeForBidirectionalRelationshipMaintenance(this.getMapping(), this.getContainerPolicy()));
        }
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    protected String validTypeName() {
        return Helper.getShortClassName(this.getContainerClass());
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        return this.buildIndirectContainer(new BatchValueHolder(readQuery, databaseRow, this.getForeignReferenceMapping(), objectLevelReadQuery));
    }

    public Object valueFromMethod(Object object, DatabaseRow databaseRow, Session session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        return this.buildIndirectContainer(new QueryBasedValueHolder(readQuery, databaseRow, session));
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Object object, Session session) {
        return this.valueFromQuery(readQuery, databaseRow, session);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

