/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;

    public QueryBasedValueHolder(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        this.row = databaseRow;
        this.session = session;
        if (!session.isUnitOfWork()) {
            this.session = session.getRootSession(readQuery);
        }
        this.query = readQuery;
    }

    protected ReadQuery getQuery() {
        return this.query;
    }

    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.getSession());
    }

    protected Object instantiate(Session session) throws DatabaseException {
        return session.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    public void releaseWrappedValueHolder() {
        Session session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(session.getRootSession(this.query));
        }
    }

    protected void resetFields() {
        super.resetFields();
        this.setQuery(null);
    }

    protected void setQuery(ReadQuery readQuery) {
        this.query = readQuery;
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.getQuery() == null || !this.getQuery().isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        return objectLevelReadQuery.isLockQuery(this.getSession());
    }
}

