/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.RemoteSession;

public abstract class IndirectionPolicy
implements Cloneable,
Serializable {
    protected DatabaseMapping mapping;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        return this.getMapping().buildBackupCloneForPartObject(object, object2, object3, unitOfWork);
    }

    protected ReadObjectQuery buildCascadeQuery(MergeManager mergeManager) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        if (mergeManager.shouldCascadeAllParts()) {
            readObjectQuery.cascadeAllParts();
            readObjectQuery.refreshIdentityMapResult();
        }
        if (mergeManager.shouldCascadePrivateParts() && this.getForeignReferenceMapping().isPrivateOwned()) {
            readObjectQuery.cascadePrivateParts();
            readObjectQuery.refreshIdentityMapResult();
        }
        return readObjectQuery;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract Object cloneAttribute(Object var1, Object var2, Object var3, UnitOfWork var4, boolean var5);

    public Vector extractPrimaryKeyForReferenceObject(Object object, Session session) {
        return this.getOneToOneMapping().extractPrimaryKeysFromRealReferenceObject(object, session);
    }

    public abstract DatabaseRow extractReferenceRow(Object var1);

    public abstract void fixObjectReferences(Object var1, IdentityHashtable var2, IdentityHashtable var3, ObjectLevelReadQuery var4, RemoteSession var5);

    protected CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    protected ForeignReferenceMapping getForeignReferenceMapping() {
        return (ForeignReferenceMapping)this.getMapping();
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected ObjectReferenceMapping getOneToOneMapping() {
        return (ObjectReferenceMapping)this.getMapping();
    }

    public abstract Object getOriginalIndirectionObject(Object var1, Session var2);

    public abstract Object getRealAttributeValueFromObject(Object var1);

    protected AbstractTransformationMapping getTransformationMapping() {
        return (AbstractTransformationMapping)this.getMapping();
    }

    public static Object getValueFromProxy(Object object) {
        return object;
    }

    public abstract Object getValueFromRemoteValueHolder(RemoteValueHolder var1);

    public void initialize() {
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object != null) {
            this.getMapping().iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    protected void mergeClientIntoServerValueHolder(RemoteValueHolder remoteValueHolder, MergeManager mergeManager) {
        remoteValueHolder.setMapping(this.getMapping());
        remoteValueHolder.setSession(mergeManager.getSession());
        if (this.getMapping().isForeignReferenceMapping()) {
            ReadObjectQuery readObjectQuery = this.buildCascadeQuery(mergeManager);
            remoteValueHolder.setQuery(readObjectQuery);
        }
    }

    public abstract void mergeRemoteValueHolder(Object var1, Object var2, MergeManager var3);

    public abstract Object nullValueFromRow();

    public abstract boolean objectIsInstantiated(Object var1);

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object);
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public boolean usesIndirection() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return false;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) throws DescriptorException {
        return object;
    }

    public void validateContainerPolicy(IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateDeclaredAttributeTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateGetMethodReturnTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateSetMethodParameterTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public abstract Object valueFromBatchQuery(ReadQuery var1, DatabaseRow var2, ObjectLevelReadQuery var3);

    public abstract Object valueFromMethod(Object var1, DatabaseRow var2, Session var3);

    public abstract Object valueFromQuery(ReadQuery var1, DatabaseRow var2, Session var3);

    public abstract Object valueFromRow(Object var1);
}

