/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.internal.identitymaps.IdentityMapEnumeration;
import oracle.toplink.internal.identitymaps.IdentityMapKeyEnumeration;

public class FullIdentityMap
extends IdentityMap {
    protected Hashtable cacheKeys;

    public FullIdentityMap(int n) {
        super(n);
        this.cacheKeys = new Hashtable(n);
    }

    public Object clone() {
        FullIdentityMap fullIdentityMap = (FullIdentityMap)super.clone();
        fullIdentityMap.setCacheKeys(new Hashtable(this.getCacheKeys().size()));
        Enumeration enumeration = this.getCacheKeys().elements();
        while (enumeration.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)((CacheKey)enumeration.nextElement()).clone();
            fullIdentityMap.getCacheKeys().put(cacheKey, cacheKey);
        }
        return fullIdentityMap;
    }

    public void collectLocks(HashMap hashMap) {
        Iterator iterator = this.cacheKeys.values().iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = (CacheKey)iterator.next();
            if (!cacheKey.isAcquired()) continue;
            Thread thread = cacheKey.getMutex().getActiveThread();
            HashSet<CacheKey> hashSet = (HashSet<CacheKey>)hashMap.get(thread);
            if (hashSet == null) {
                hashSet = new HashSet<CacheKey>();
                hashMap.put(thread, hashSet);
            }
            hashSet.add(cacheKey);
        }
    }

    public Enumeration elements() {
        return new IdentityMapEnumeration(this);
    }

    protected synchronized CacheKey getCacheKey(CacheKey cacheKey) {
        return (CacheKey)this.getCacheKeys().get(cacheKey);
    }

    public Hashtable getCacheKeys() {
        return this.cacheKeys;
    }

    public int getSize() {
        return this.cacheKeys.size();
    }

    public int getSize(Class clazz, boolean bl) {
        int n = 0;
        Enumeration enumeration = this.getCacheKeys().keys();
        while (enumeration.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumeration.nextElement();
            Object object = cacheKey.getObject();
            if (object == null) continue;
            if (bl && clazz.isInstance(object)) {
                ++n;
                continue;
            }
            if (!object.getClass().equals(clazz)) continue;
            ++n;
        }
        return n;
    }

    public Enumeration keys() {
        return new IdentityMapKeyEnumeration(this);
    }

    public CacheKey put(Vector vector, Object object, Object object2, long l) {
        CacheKey cacheKey = this.getCacheKey(vector);
        if (cacheKey != null) {
            this.resetCacheKey(cacheKey, object, object2, l);
            this.put(cacheKey);
        } else {
            cacheKey = this.createCacheKey(vector, object, object2, l);
            this.put(cacheKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(CacheKey cacheKey) {
        FullIdentityMap fullIdentityMap = this;
        synchronized (fullIdentityMap) {
            this.getCacheKeys().put(cacheKey, cacheKey);
        }
        cacheKey.setOwningMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(CacheKey cacheKey) {
        if (cacheKey != null) {
            cacheKey.acquire();
            FullIdentityMap fullIdentityMap = this;
            synchronized (fullIdentityMap) {
                this.getCacheKeys().remove(cacheKey);
            }
        } else {
            return null;
        }
        cacheKey.release();
        return cacheKey.getObject();
    }

    public void resetCacheKey(CacheKey cacheKey, Object object, Object object2, long l) {
        cacheKey.acquire();
        cacheKey.setObject(object);
        cacheKey.setWriteLockValue(object2);
        cacheKey.setReadTime(l);
        cacheKey.release();
    }

    protected void setCacheKeys(Hashtable hashtable) {
        this.cacheKeys = hashtable;
    }
}

