/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.util.HashMap;
import java.util.Map;
import oracle.toplink.internal.helper.ConcurrencyManager;

public class ManagedConcurrencyHashMap
extends HashMap {
    protected ConcurrencyManager mutex = new ConcurrencyManager();

    public ManagedConcurrencyHashMap() {
    }

    public ManagedConcurrencyHashMap(int n) {
        super(n);
    }

    public ManagedConcurrencyHashMap(int n, float f) {
        super(n, f);
    }

    public ManagedConcurrencyHashMap(Map map) {
        super(map);
    }

    public void clear() {
        this.getMutex().acquire();
        super.clear();
        this.getMutex().release();
    }

    public Object clone() {
        this.getMutex().acquireReadLock();
        Object object = super.clone();
        this.getMutex().releaseReadLock();
        return object;
    }

    public boolean containsKey(Object object) {
        this.getMutex().acquireReadLock();
        boolean bl = super.containsKey(object);
        this.getMutex().releaseReadLock();
        return bl;
    }

    public boolean containsValue(Object object) {
        this.getMutex().acquireReadLock();
        boolean bl = super.containsValue(object);
        this.getMutex().releaseReadLock();
        return bl;
    }

    public Object get(Object object) {
        this.getMutex().acquireReadLock();
        Object v = super.get(object);
        this.getMutex().releaseReadLock();
        return v;
    }

    public ConcurrencyManager getMutex() {
        return this.mutex;
    }

    public Object put(Object object, Object object2) {
        this.getMutex().acquire();
        Object object3 = super.put(object, object2);
        this.getMutex().release();
        return object3;
    }

    public void putAll(Map map) {
        this.getMutex().acquire();
        super.putAll(map);
        this.getMutex().release();
    }

    public Object remove(Object object) {
        this.getMutex().acquire();
        Object v = super.remove(object);
        this.getMutex().release();
        return v;
    }
}

