/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IdentityHashtable
extends Dictionary
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1421746759512286392L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int KEYS = 0;
    static final int ELEMENTS = 1;
    private static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    protected transient Entry[] entries;
    protected transient int count = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;

    public IdentityHashtable(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.entries = new Entry[n2];
    }

    public IdentityHashtable(int n) {
        this(n, 0.75f);
    }

    public IdentityHashtable() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public synchronized void clear() {
        if (this.count > 0) {
            Entry[] entryArray = this.entries;
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
            this.count = 0;
        }
    }

    public synchronized Object clone() {
        try {
            Entry[] entryArray = this.entries;
            IdentityHashtable identityHashtable = (IdentityHashtable)super.clone();
            identityHashtable.entries = new Entry[entryArray.length];
            int n = entryArray.length;
            while (n-- > 0) {
                identityHashtable.entries[n] = entryArray[n] != null ? (Entry)entryArray[n].clone() : null;
            }
            return identityHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(1);
    }

    public synchronized Object get(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(0);
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.entries;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    private void rehash() {
        int n = this.entries.length;
        Entry[] entryArray = this.entries;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.entries = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public synchronized Object remove(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == object) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.entries.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            Entry entry = this.entries[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.entries = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.key == entry.getKey() && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class Enumerator
    implements Enumeration {
        int enumeratorType;
        int index;
        Entry entry;

        Enumerator(int n) {
            this.enumeratorType = n;
            this.index = IdentityHashtable.this.entries.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = IdentityHashtable.this.entries[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = IdentityHashtable.this.entries[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.entry;
                this.entry = entry.next;
                if (this.enumeratorType == 0) {
                    return entry.key;
                }
                return entry.value;
            }
            throw new NoSuchElementException("IdentityHashtable.Enumerator");
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

