/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.descriptors.FetchGroupManager;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.NestedTable;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.TableExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectCollectionMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.querykeys.DirectQueryKey;
import oracle.toplink.querykeys.ForeignReferenceQueryKey;
import oracle.toplink.querykeys.QueryKey;

public class QueryKeyExpression
extends ObjectExpression {
    protected String name;
    protected DatabaseField aliasedField;
    protected boolean shouldQueryToManyRelationship;
    protected transient QueryKey queryKey;
    protected boolean hasQueryKey;
    protected transient DatabaseMapping mapping;
    protected boolean hasMapping;

    public QueryKeyExpression() {
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public QueryKeyExpression(String string, Expression expression) {
        this.name = string;
        this.baseExpression = expression;
        this.shouldUseOuterJoin = false;
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression expression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (expression != null) {
            expression = this.getBaseExpression().twist(expression, this);
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                expression.convertToUseOuterJoin();
            }
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            Expression expression2 = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            expression = expression != null ? expression.and(expression2) : expression2;
        }
        return expression;
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        if (this.isAttribute() || this.getMapping() != null && (this.getMapping().isAggregateObjectMapping() || this.getMapping().isTransformationMapping())) {
            return ((DataExpression)this.getBaseExpression()).aliasForTable(databaseTable);
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            DatabaseTable databaseTable2 = this.getBaseExpression().aliasForTable((DatabaseTable)this.getMapping().getDescriptor().getTables().firstElement());
            databaseTable2.setName(databaseTable2.getName() + "." + this.getMapping().getField().getName());
            return databaseTable2;
        }
        return super.aliasForTable(databaseTable);
    }

    public String descriptionOfNodeType() {
        return "Query Key";
    }

    public void doQueryToManyRelationship() {
        this.shouldQueryToManyRelationship = true;
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    protected DatabaseTable getAliasedTable() {
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        DatabaseTable databaseTable = dataExpression.aliasForTable(this.getField().getTable());
        if (databaseTable == null) {
            return this.getField().getTable();
        }
        return databaseTable;
    }

    public Descriptor getContainingDescriptor() {
        return ((DataExpression)this.getBaseExpression()).getDescriptor();
    }

    public DatabaseField getField() {
        if (!this.isAttribute()) {
            return null;
        }
        return this.getContainingDescriptor().getObjectBuilder().getFieldForQueryKeyName(this.getName());
    }

    public Vector getFields() {
        if (this.isAttribute()) {
            Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
            DatabaseField databaseField = this.getField();
            if (databaseField != null) {
                vector.addElement(databaseField);
            }
            return vector;
        }
        if (this.getMapping() != null && this.getMapping().isTransformationMapping()) {
            return this.getMapping().getFields();
        }
        return super.getFields();
    }

    public Object getFieldValue(Object vector) {
        DatabaseMapping databaseMapping = this.getMapping();
        Vector<Object> vector2 = vector;
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            if (vector instanceof Vector) {
                Vector vector3 = vector;
                Vector<Object> vector4 = new Vector<Object>(vector3.size());
                for (int i = 0; i < vector3.size(); ++i) {
                    vector4.addElement(this.getFieldValue(vector3.get(i)));
                }
                vector2 = vector4;
            } else {
                vector2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(vector, this.getSession());
            }
        }
        return vector2;
    }

    public DatabaseMapping getMapping() {
        if (!this.hasMapping) {
            return null;
        }
        if (this.mapping == null) {
            this.mapping = super.getMapping();
            if (this.mapping == null) {
                this.hasMapping = false;
            }
        }
        return this.mapping;
    }

    public DatabaseMapping getMappingFromQueryKey() {
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey == null || !(queryKey instanceof DirectQueryKey)) {
            throw QueryException.cannotConformExpression();
        }
        this.mapping = queryKey.getDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)queryKey).getField());
        if (this.mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public Vector getOwnedTables() {
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            Vector<NestedTable> vector = null;
            vector = this.shouldQueryToManyRelationship() ? (Vector<NestedTable>)super.getOwnedTables().clone() : new Vector<NestedTable>(1);
            vector.addElement(new NestedTable(this));
            return vector;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            return null;
        }
        return super.getOwnedTables();
    }

    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        if (this.getContainingDescriptor() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        if (this.queryKey == null) {
            this.queryKey = this.getContainingDescriptor().getQueryKeyNamed(this.getName());
            if (this.queryKey == null) {
                this.hasQueryKey = false;
            }
        }
        return this.queryKey;
    }

    protected void initializeAliasedField() {
        DatabaseField databaseField = (DatabaseField)this.getField().clone();
        DatabaseTable databaseTable = this.getAliasedTable();
        this.aliasedField = databaseField;
        this.aliasedField.setTable(databaseTable);
    }

    public boolean isAttribute() {
        if (this.getSession() == null) {
            return false;
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey != null) {
            return queryKey.isDirectQueryKey();
        }
        DatabaseMapping databaseMapping = this.getMapping();
        if (databaseMapping != null) {
            if (databaseMapping.isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(databaseMapping, databaseMapping.getDescriptor());
            }
            return databaseMapping.isDirectToFieldMapping();
        }
        return false;
    }

    public boolean isQueryKeyExpression() {
        return true;
    }

    public Expression mappingCriteria() {
        Expression expression;
        if (this.getQueryKeyOrNull() == null) {
            if (this.getMapping() == null || !this.getMapping().isForeignReferenceMapping()) {
                return null;
            }
            expression = ((ForeignReferenceMapping)this.getMapping()).getJoinCriteria(this);
        } else {
            if (!this.getQueryKeyOrNull().isForeignReferenceQueryKey()) {
                return null;
            }
            expression = ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getJoinCriteria();
            expression = this.getBaseExpression().twist(expression, this);
        }
        if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
            expression = expression.convertToUseOuterJoin();
        }
        return expression;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        return this.normalize(expressionNormalizer, null);
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer, Vector vector) {
        Expression expression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        super.normalize(expressionNormalizer);
        this.setHasBeenNormalized(true);
        if (this.getMapping() != null && this.getMapping().isDirectToXMLTypeMapping()) {
            expressionNormalizer.getStatement().setRequiresAliases(true);
        }
        if (this.isAttribute()) {
            return this;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            expressionNormalizer.getStatement().setRequiresAliases(true);
            return this;
        }
        if (this.shouldQueryToManyRelationship() && !expressionNormalizer.getStatement().isDistinctComputed() && !expressionNormalizer.getStatement().isAggregateSelect()) {
            expressionNormalizer.getStatement().useDistinct();
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            if (!this.shouldQueryToManyRelationship()) {
                return this;
            }
            expressionNormalizer.getStatement().dontUseDistinct();
        }
        if ((expression = this.mappingCriteria()) != null) {
            expression = expression.normalize(expressionNormalizer);
        }
        if (expression != null) {
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin()) {
                expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(this);
                expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(expression);
                expressionNormalizer.addAdditionalExpression(expression.and(this.additionalExpressionCriteria()));
            } else if (this.shouldUseOuterJoin() && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(this);
                expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(expression);
                expressionNormalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteria());
            } else if (vector != null) {
                vector.add(expression);
            } else {
                expressionNormalizer.addAdditionalExpression(expression.and(this.additionalExpressionCriteria()));
            }
        }
        return this;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        Cloneable cloneable;
        if (this.isAttribute()) {
            expressionSQLPrinter.printField(this.getAliasedField());
        }
        if (this.getMapping() != null && this.getMapping().isDirectCollectionMapping()) {
            cloneable = (DirectCollectionMapping)this.getMapping();
            TableExpression tableExpression = (TableExpression)this.getTable(((DirectCollectionMapping)cloneable).getReferenceTable());
            DatabaseTable databaseTable = tableExpression.aliasForTable(tableExpression.getTable());
            DatabaseField databaseField = (DatabaseField)((DirectCollectionMapping)cloneable).getDirectField().clone();
            databaseField.setTable(databaseTable);
            expressionSQLPrinter.printField(databaseField);
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            cloneable = this.aliasForTable(new NestedTable(this));
            expressionSQLPrinter.printString(((DatabaseTable)cloneable).getName());
        }
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        this.getBaseExpression().printJava(expressionJavaPrinter);
        if (!this.shouldUseOuterJoin()) {
            if (!this.shouldQueryToManyRelationship()) {
                expressionJavaPrinter.printString(".get(");
            } else {
                expressionJavaPrinter.printString(".anyOf(");
            }
        } else if (!this.shouldQueryToManyRelationship()) {
            expressionJavaPrinter.printString(".getAllowingNull(");
        } else {
            expressionJavaPrinter.printString(".anyOfAllowingNone(");
        }
        expressionJavaPrinter.printString("\"" + this.getName() + "\")");
    }

    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        QueryKeyExpression queryKeyExpression = null;
        queryKeyExpression = this.shouldUseOuterJoin ? (QueryKeyExpression)expression2.getAllowingNull(this.getName()) : (QueryKeyExpression)expression2.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        queryKeyExpression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return queryKeyExpression;
    }

    public Expression rebuildOn(Expression expression, Expression expression2) {
        if (this == expression) {
            return expression2;
        }
        Expression expression3 = ((QueryKeyExpression)this.getBaseExpression()).rebuildOn(expression, expression2);
        QueryKeyExpression queryKeyExpression = null;
        queryKeyExpression = this.shouldUseOuterJoin ? (QueryKeyExpression)expression3.getAllowingNull(this.getName()) : (QueryKeyExpression)expression3.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        return queryKeyExpression;
    }

    protected void resetCache() {
        this.hasMapping = true;
        this.mapping = null;
        this.hasQueryKey = true;
        this.queryKey = null;
    }

    public boolean shouldQueryToManyRelationship() {
        return this.shouldQueryToManyRelationship;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression3.get(this.getName());
        if (this.shouldUseOuterJoin) {
            queryKeyExpression.doUseOuterJoin();
        }
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        return queryKeyExpression;
    }

    public void validateNode() {
        if (this.getQueryKeyOrNull() == null && this.getMapping() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        DatabaseMapping databaseMapping = this.getMapping();
        Cloneable cloneable = null;
        if (queryKey != null) {
            cloneable = queryKey;
        }
        if (databaseMapping != null) {
            cloneable = databaseMapping;
        }
        boolean bl = false;
        if (queryKey != null) {
            boolean bl2 = bl = queryKey.isManyToManyQueryKey() || queryKey.isOneToManyQueryKey();
        }
        if (databaseMapping != null) {
            if (!(!this.shouldUseOuterJoin || databaseMapping.isOneToOneMapping() || databaseMapping.isOneToManyMapping() || databaseMapping.isManyToManyMapping() || databaseMapping.isAggregateCollectionMapping() || databaseMapping.isDirectCollectionMapping())) {
                throw QueryException.outerJoinIsOnlyValidForOneToOneMappings(this.getMapping());
            }
            bl = databaseMapping.isCollectionMapping();
        }
        if (!this.shouldQueryToManyRelationship() && bl && !databaseMapping.isNestedTableMapping()) {
            throw QueryException.invalidUseOfToManyQueryKeyInExpression(cloneable);
        }
        if (this.shouldQueryToManyRelationship() && !bl) {
            throw QueryException.invalidUseOfAnyOfInExpression(cloneable);
        }
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        if (this.getBuilder() != this.getBaseExpression() && this.getBaseExpression().isQueryKeyExpression()) {
            object = this.getBaseExpression().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
            if (object == null) {
                return null;
            }
            if (object instanceof Vector) {
                Vector<Object> vector = new Vector<Object>(((Vector)object).size() + 2);
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e == null) {
                        vector.addElement(e);
                        continue;
                    }
                    Object object2 = this.valuesFromCollection(e, session, inMemoryQueryIndirectionPolicy, bl);
                    if (object2 instanceof Vector) {
                        Enumeration enumeration2 = ((Vector)object2).elements();
                        while (enumeration2.hasMoreElements()) {
                            vector.addElement(enumeration2.nextElement());
                        }
                        continue;
                    }
                    vector.addElement(object2);
                }
                return vector;
            }
        }
        return this.valuesFromCollection(object, session, inMemoryQueryIndirectionPolicy, bl);
    }

    public Object valuesFromCollection(Object object, Session session, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        Object object2;
        DatabaseMapping databaseMapping;
        boolean bl2 = false;
        if (this.getMapping() == null) {
            this.getMappingFromQueryKey();
            bl2 = true;
        }
        if ((databaseMapping = this.mapping).getDescriptor().hasInheritance() && databaseMapping.getDescriptor().getJavaClass() != object.getClass()) {
            databaseMapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForAttributeName(this.getName());
        }
        if (databaseMapping.getDescriptor().hasFetchGroupManager() && ((FetchGroupManager)(object2 = databaseMapping.getDescriptor().getFetchGroupManager())).isPartialObject(object) && !((FetchGroupManager)object2).isAttributeFetched(object, databaseMapping.getAttributeName())) {
            throw QueryException.cannotConformUnfetchedAttribute(databaseMapping.getAttributeName());
        }
        if (databaseMapping.isForeignReferenceMapping()) {
            Object object3;
            UnitOfWork unitOfWork;
            object2 = databaseMapping.getAttributeValueFromObject(object);
            if (!((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object2) && !inMemoryQueryIndirectionPolicy.shouldTriggerIndirection()) {
                throw QueryException.mustInstantiateValueholders();
            }
            Object object4 = databaseMapping.getRealAttributeValueFromObject(object, session);
            UnitOfWork unitOfWork2 = unitOfWork = bl ? (UnitOfWork)session : null;
            if (databaseMapping.isCollectionMapping() && object4 != null) {
                object4 = databaseMapping.getContainerPolicy().vectorFor(object4, session);
                if (bl && unitOfWork.getCloneMapping().get(object) == null) {
                    Vector vector = (Vector)object4;
                    for (int i = 0; i < vector.size(); ++i) {
                        Object e = vector.elementAt(i);
                        Object object5 = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(e);
                        if (object5 == null) continue;
                        vector.setElementAt(object5, i);
                    }
                }
            } else if (bl && unitOfWork.getCloneMapping().get(object) == null && (object3 = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(object4)) != null) {
                object4 = object3;
            }
            return object4;
        }
        if (databaseMapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)databaseMapping).valueFromObject(object, databaseMapping.getField(), session);
        }
        if (databaseMapping.isAggregateMapping()) {
            object2 = ((AggregateMapping)databaseMapping).getAttributeValueFromObject(object);
            while (bl2 && databaseMapping.isAggregateObjectMapping() && !((AggregateObjectMapping)databaseMapping).getReferenceClass().equals(this.queryKey.getDescriptor().getJavaClass())) {
                databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)this.queryKey).getField());
                object2 = databaseMapping.getRealAttributeValueFromObject(object2, session);
            }
            return object2;
        }
        throw QueryException.cannotConformExpression();
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getName());
        bufferedWriter.write(this.tableAliasesDescription());
    }
}

