/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.ManualQueryKeyExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.querykeys.ForeignReferenceQueryKey;

public abstract class ObjectExpression
extends DataExpression {
    public transient Descriptor descriptor;
    public Vector derivedExpressions;
    protected boolean shouldUseOuterJoin = false;

    public void addDerivedExpression(Expression expression) {
        if (this.derivedExpressions == null) {
            this.derivedExpressions = NonSynchronizedVector.newInstance();
        }
        this.derivedExpressions.addElement(expression);
    }

    public Expression anyOf(String string) {
        QueryKeyExpression queryKeyExpression = this.newDerivedExpressionNamed(string);
        queryKeyExpression.doQueryToManyRelationship();
        return queryKeyExpression;
    }

    public QueryKeyExpression derivedExpressionNamed(String string) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        return this.newDerivedExpressionNamed(string);
    }

    public Expression derivedManualExpressionNamed(String string, Descriptor descriptor) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        return this.newManualDerivedExpressionNamed(string, descriptor);
    }

    protected void doNotUseOuterJoin() {
        this.shouldUseOuterJoin = false;
    }

    protected void doUseOuterJoin() {
        this.shouldUseOuterJoin = true;
    }

    public QueryKeyExpression existingDerivedExpressionNamed(String string) {
        if (this.derivedExpressions == null) {
            return null;
        }
        Enumeration enumeration = this.derivedExpressions.elements();
        while (enumeration.hasMoreElements()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)enumeration.nextElement();
            if (!queryKeyExpression.getName().equals(string)) continue;
            return queryKeyExpression;
        }
        return null;
    }

    public Expression get(String string, Vector vector) {
        Expression expression = super.get(string, vector);
        if (expression != null) {
            return expression;
        }
        QueryKeyExpression queryKeyExpression = this.derivedExpressionNamed(string);
        queryKeyExpression.doNotUseOuterJoin();
        return queryKeyExpression;
    }

    public Expression getAllowingNull(String string, Vector vector) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        queryKeyExpression = this.derivedExpressionNamed(string);
        queryKeyExpression.doUseOuterJoin();
        return queryKeyExpression;
    }

    public Descriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey foreignReferenceQueryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (foreignReferenceQueryKey != null) {
                this.descriptor = this.getSession().getDescriptor(foreignReferenceQueryKey.getReferenceClass());
                return this.descriptor;
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getReferenceDescriptor();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
        }
        return this.descriptor;
    }

    public Vector getFields() {
        if (this.getDescriptor() == null) {
            return new Vector(1);
        }
        return this.descriptor.getFields();
    }

    protected Vector getForUpdateOfFields() {
        Vector vector = this.getFields();
        int n = this.getTableAliases().size();
        Vector<DatabaseField> vector2 = new Vector<DatabaseField>(n);
        DatabaseTable databaseTable = null;
        DatabaseField databaseField = null;
        int n2 = 0;
        while (n2 < vector.size() && vector2.size() < n) {
            int n3;
            databaseField = (DatabaseField)vector.elementAt(n2++);
            if (databaseTable != null && databaseField.getTable().equals(databaseTable)) continue;
            databaseTable = databaseField.getTable();
            for (n3 = 0; n3 < vector2.size() && !databaseTable.equals(((DatabaseField)vector2.elementAt(n3)).getTable()); ++n3) {
            }
            if (n3 != vector2.size()) continue;
            vector2.addElement(databaseField);
        }
        return vector2;
    }

    public Expression getManualQueryKey(String string, Descriptor descriptor) {
        return this.derivedManualExpressionNamed(string, descriptor);
    }

    protected boolean hasDerivedExpressions() {
        return this.derivedExpressions != null;
    }

    public boolean isObjectExpression() {
        return true;
    }

    public QueryKeyExpression newDerivedExpressionNamed(String string) {
        QueryKeyExpression queryKeyExpression = new QueryKeyExpression(string, this);
        this.addDerivedExpression(queryKeyExpression);
        return queryKeyExpression;
    }

    public Expression newManualDerivedExpressionNamed(String string, Descriptor descriptor) {
        ManualQueryKeyExpression manualQueryKeyExpression = new ManualQueryKeyExpression(string, this, descriptor);
        this.addDerivedExpression(manualQueryKeyExpression);
        return manualQueryKeyExpression;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        this.derivedExpressions = this.copyCollection(this.derivedExpressions, dictionary);
    }

    public void postCopyIn(Dictionary dictionary, Vector vector, Vector vector2) {
        if (vector != null) {
            if (this.derivedFields == null) {
                this.derivedFields = this.copyCollection(vector, dictionary);
            } else {
                this.derivedFields.addAll(this.copyCollection(vector, dictionary));
            }
        }
        if (vector2 != null) {
            if (this.derivedTables == null) {
                this.derivedTables = this.copyCollection(vector2, dictionary);
            } else {
                this.derivedTables.addAll(this.copyCollection(vector2, dictionary));
            }
        }
    }

    public boolean shouldUseOuterJoin() {
        return this.shouldUseOuterJoin;
    }

    protected void writeForUpdateOfFields(ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        Enumeration enumeration = this.getForUpdateOfFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            this.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }
}

