/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import oracle.toplink.ejb.cmp3.base.EntityManagerFactoryProvider;
import oracle.toplink.ejb.cmp3.persistence.PersistenceInfo;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp3.base.DataSourceConfig;
import oracle.toplink.internal.ejb.cmp3.base.EntityManagerSetupImpl;
import oracle.toplink.internal.ejb.cmp3.jdbc.base.DataSourceImpl;
import oracle.toplink.internal.ejb.cmp3.naming.base.InitialContextImpl;
import oracle.toplink.internal.ejb.cmp3.transaction.base.TransactionManagerImpl;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.threetier.ServerSession;

public abstract class EntityContainer {
    protected TransactionManagerImpl txnMgr;
    protected InitialContextImpl ctx;
    protected static EntityContainer entityContainer;
    public static final String TXN_MGR_NAME = "java:comp/pm/TransactionManager";
    public static final String USER_TXN_NAME = "java:comp/UserTransaction";
    public static final String JNDI_CTX_FACTORY_NAME = "java.naming.factory.initial";
    public static final String EM_CONFIG_FACTORY_NAME_PROPERTY = "java.persistence.setup.config";
    public static final String EM_CONFIG_FACTORY_METHOD_NAME_PREFIX_PROPERTY = "getClassList";
    protected EntityManagerSetupImpl emSetupImpl;
    protected HashMap persistenceInfoMap = null;
    protected PersistenceInfo persistenceInfo = null;
    protected ClassLoader sessionClassLoader = null;

    protected abstract InitialContextImpl createInitialContextImpl();

    protected abstract String getJNDI_CTX_FACTORY_CLASS();

    protected void bindInJndi(String string, Object object) {
        try {
            this.ctx.rebind(string, object);
        }
        catch (NamingException namingException) {
            throw ValidationException.couldNotBindJndi(string, object, namingException);
        }
    }

    public static EntityContainer getEntityContainer() {
        return entityContainer;
    }

    public boolean usesTopLinkJNDI() {
        return this.ctx != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeFromMain(Class clazz, Map map) throws Exception {
        if (entityContainer != null) {
            return false;
        }
        entityContainer = (EntityContainer)clazz.newInstance();
        entityContainer.loadPersistenceConfigFiles();
        entityContainer.logDebug("ec_initializeFromMain");
        boolean bl = false;
        try {
            bl = entityContainer.initialize(map);
        }
        finally {
            if (!bl) {
                entityContainer = null;
            }
        }
        return bl;
    }

    protected void initDataSource(DataSourceConfig dataSourceConfig) {
        DataSourceImpl dataSourceImpl = new DataSourceImpl(dataSourceConfig.dsName, dataSourceConfig.url, dataSourceConfig.user, dataSourceConfig.password);
        this.bindInJndi(dataSourceConfig.jndiName, dataSourceImpl);
        this.logDebug("ec_bound_jta_datasource", dataSourceConfig.jndiName);
        dataSourceImpl.setTransactionManager(this.txnMgr);
        try {
            this.logDebug("ec_load_jdbc");
            Class.forName(dataSourceConfig.driver);
            this.logDebug("ec_jdbc_loaded", dataSourceConfig.driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ValidationException validationException = ValidationException.couldNotFindDriverClass(dataSourceConfig.driver, classNotFoundException);
            this.logSevere(validationException);
            throw validationException;
        }
    }

    protected void initializeJNDI() {
        if (this.ctx != null) {
            return;
        }
        System.setProperty(JNDI_CTX_FACTORY_NAME, this.getJNDI_CTX_FACTORY_CLASS());
        this.ctx = this.createInitialContextImpl();
        this.logDebug("ec_initialize_jndi", JNDI_CTX_FACTORY_NAME, this.getJNDI_CTX_FACTORY_CLASS());
    }

    protected void initializeTransactionManager() {
        if (this.txnMgr != null) {
            return;
        }
        this.txnMgr = new TransactionManagerImpl();
        this.bindInJndi(TXN_MGR_NAME, this.txnMgr);
        this.logDebug("ec_bound_TransactionManager", TXN_MGR_NAME);
        this.bindInJndi(USER_TXN_NAME, this.txnMgr);
        this.logDebug("ec_bound_UserTransaction", USER_TXN_NAME);
    }

    /*
     * Loose catch block
     */
    public void loadPersistenceConfigFiles() {
        block11: {
            InputStream inputStream = null;
            if (this.persistenceInfo == null) {
                block10: {
                    PersistenceInfo persistenceInfo;
                    URL uRL = Thread.currentThread().getContextClassLoader().getResource("META-INF/persistence.xml");
                    if (uRL == null) break block10;
                    inputStream = uRL.openStream();
                    this.persistenceInfo = persistenceInfo = PersistenceInfo.getPersistenceInfo(inputStream);
                }
                Object var5_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    this.logWarning(ValidationException.errorClosingPersistenceXML(iOException));
                }
                break block11;
                {
                    catch (Exception exception) {
                        throw ValidationException.exceptionConfiguringEMFactory(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.logWarning(ValidationException.errorClosingPersistenceXML(iOException));
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void logConfig(String string) {
        AbstractSessionLog.getLog().log(4, string, null, true);
    }

    protected void logConfig(String string, Object object, Object object2) {
        AbstractSessionLog.getLog().log(4, string, object, object2);
    }

    protected void logDebug(String string) {
        AbstractSessionLog.getLog().log(2, string, null, true);
    }

    protected void logDebug(String string, Object object) {
        AbstractSessionLog.getLog().log(2, string, object);
    }

    protected void logDebug(String string, Object object, Object object2) {
        AbstractSessionLog.getLog().log(2, string, object, object2);
    }

    protected void logWarning(Exception exception) {
        AbstractSessionLog.getLog().logThrowable(6, exception);
    }

    protected void logSevere(Exception exception) {
        AbstractSessionLog.getLog().logThrowable(7, exception);
    }

    public boolean initialize(Map map) {
        this.emSetupImpl = new EntityManagerSetupImpl();
        this.sessionClassLoader = this.getMainLoader();
        return true;
    }

    public ServerSession getServerSession(Map map) {
        if (this.sessionClassLoader != this.getMainLoader()) {
            this.emSetupImpl.undeploy();
            this.initialize(map);
        }
        this.updateContainer(map);
        ServerSession serverSession = this.emSetupImpl.getServerSession(map, this.getMainLoader());
        if (serverSession != null && !serverSession.isConnected() && serverSession.getLogin().shouldUseExternalTransactionController() && this.usesTopLinkJNDI() && serverSession.getLogin().getConnector() instanceof JNDIConnector) {
            JNDIConnector jNDIConnector = (JNDIConnector)serverSession.getLogin().getConnector();
            jNDIConnector.setContext(null);
        }
        return serverSession;
    }

    protected ClassLoader getMainLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected void updateContainer(Map map) {
        String string;
        if (!this.usesTopLinkJNDI() && (string = EntityManagerFactoryProvider.getConfigProperty("use.toplink.jta", map)) != null && string.equalsIgnoreCase("true")) {
            this.initializeJNDI();
            this.initializeTransactionManager();
            System.setProperty("toplink.server.platform.class.name", "oracle.toplink.platform.server.CustomServerPlatform");
            System.setProperty("toplink.external.transaction.controller.class.name", "oracle.toplink.transaction.oc4j.Oc4jTransactionController");
        }
        if (this.usesTopLinkJNDI()) {
            string = EntityManagerFactoryProvider.getConfigProperty("datasource.name", map);
            if (string == null || string.equals("")) {
                return;
            }
            String string2 = EntityManagerFactoryProvider.getConfigProperty("datasource.jndi.name", map);
            if (string2 == null || string2.equals("")) {
                return;
            }
            String string3 = EntityManagerFactoryProvider.getConfigProperty("jdbc.connection.string", map);
            if (string3 == null || string3.equals("")) {
                return;
            }
            String string4 = EntityManagerFactoryProvider.getConfigProperty("jdbc.driver", map);
            if (string4 == null || string4.equals("")) {
                return;
            }
            String string5 = EntityManagerFactoryProvider.getConfigProperty("jdbc.user", map);
            if (string5 == null || string5.equals("")) {
                return;
            }
            String string6 = EntityManagerFactoryProvider.getConfigProperty("jdbc.password", map);
            if (string5 == null || string5.equals("")) {
                return;
            }
            DataSourceConfig dataSourceConfig = new DataSourceConfig(string, string2, string3, string4, string5, string6);
            this.initDataSource(dataSourceConfig);
        }
    }
}

