/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.ejb.cmp3.base.EntityManagerFactoryProvider;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.internal.ejb.cmp3.naming.InitialContextFactoryImpl;
import oracle.toplink.internal.ejb.cmp3.naming.base.InitialContextImpl;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.threetier.ServerSession;

public class EntityContainer
extends oracle.toplink.internal.ejb.cmp3.base.EntityContainer {
    protected Collection classList;
    public static Instrumentation globalInstrumentation;
    protected String configClassName = null;
    public static final String EM_CONFIG_FACTORY_METHOD_NAME_PREFIX_PROPERTY = "getClassList";
    public static final String TOPLINK_AGENT_LOGGING_LEVEL_PROPERTY = "toplink.agent.logging.level";
    protected boolean shouldCreateInternalLoader = true;

    public EntityContainer() {
        this.emSetupImpl = new EntityManagerSetupImpl();
    }

    protected void callPredeploy(Map map) {
        ClassFileTransformer classFileTransformer;
        ClassLoader classLoader = this.createTempLoader();
        this.logDebug("ec_invoke_predeploy");
        Collection collection = this.loadEntityClasses(this.classList, classLoader);
        if (globalInstrumentation == null) {
            map.put("no.weaving", "true");
        }
        if ((classFileTransformer = this.getSetupImpl().basePredeploy(collection, classLoader, map, this.persistenceInfo)) != null && globalInstrumentation != null) {
            this.logDebug("ec_register_transformer", classFileTransformer);
            globalInstrumentation.addTransformer(classFileTransformer);
        } else if (classFileTransformer == null) {
            this.logDebug("ec_transformer_is_null");
        } else if (globalInstrumentation == null) {
            this.logDebug("ec_globalInstrumentation_is_null");
        }
    }

    protected ServerSession callDeploy() {
        this.logDebug("ec_invoke_baseDeploy");
        ClassLoader classLoader = this.getMainLoader();
        Collection collection = this.loadEntityClasses(this.classList, classLoader);
        ServerSession serverSession = this.getSetupImpl().baseDeploy(collection, classLoader);
        this.logDebug("ec_completed_deploy");
        return serverSession;
    }

    protected ClassLoader createTempLoader() {
        return this.createTempLoader(this.classList);
    }

    protected ClassLoader createTempLoader(Collection collection) {
        return this.createTempLoader(collection, true);
    }

    protected ClassLoader createTempLoader(Collection collection, boolean bl) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            return classLoader;
        }
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        TempEntityLoader tempEntityLoader = new TempEntityLoader(uRLArray, classLoader, collection, bl);
        this.logDebug("ec_tempLoader_created", tempEntityLoader);
        this.logDebug("ec_shouldOverrideLoadClassForCollectionMembers", new Boolean(bl));
        return tempEntityLoader;
    }

    public Collection getClassList() {
        return this.classList;
    }

    protected void initEntityManager(Map map) {
        this.callPredeploy(map);
        this.callDeploy();
    }

    public boolean initialize(Map map) {
        if (this.persistenceInfo != null) {
            Enumeration<Object> enumeration = this.persistenceInfo.getProperties().keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (map.get(object) != null) continue;
                map.put(object, this.persistenceInfo.getProperties().get(object));
            }
        }
        this.emSetupImpl = new EntityManagerSetupImpl();
        this.sessionClassLoader = this.getMainLoader();
        this.logDebug("ec_initialize");
        this.classList = this.getClassListFromPersistenceInfo();
        if (this.classList == null) {
            try {
                this.classList = this.getClassListFromConfig(map);
            }
            catch (Exception exception) {
                throw ValidationException.methodFailed("getClassListFromConfig", exception);
            }
        }
        if (this.classList == null) {
            this.logSevere(ValidationException.classListMustNotBeNull());
            return false;
        }
        this.logDebug("ec_classlist", this.classList.toString());
        this.initContainer(this.classList, map);
        return true;
    }

    protected Collection getClassListFromPersistenceInfo() {
        if (this.persistenceInfo != null && this.persistenceInfo.getEntityClassNames() != null && !this.persistenceInfo.getEntityClassNames().isEmpty()) {
            Vector vector = new Vector();
            vector.addAll(this.persistenceInfo.getEntityClassNames());
            return vector;
        }
        return null;
    }

    protected Collection getClassListFromConfig(Map map) throws Exception {
        Class<?> clazz;
        block12: {
            if (this.configClassName == null) {
                this.configClassName = EntityManagerFactoryProvider.getConfigProperty("java.persistence.setup.config", map);
            }
            if (this.configClassName == null) {
                this.logSevere(ValidationException.configFactoryNamePropertyNotSpecified("java.persistence.setup.config"));
                return null;
            }
            this.logConfig("config_factory", "java.persistence.setup.config", this.configClassName);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("java.util.Collection");
            clazz = null;
            ClassNotFoundException classNotFoundException = null;
            try {
                try {
                    clazz = Class.forName(this.configClassName, true, this.createTempLoader(hashSet, false));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    classNotFoundException = classNotFoundException2;
                    if (globalInstrumentation == null) {
                        this.logDebug("ec_could_not_load_class_on_internal_class_loader", classNotFoundException2);
                        this.shouldCreateInternalLoader = false;
                        clazz = Class.forName(this.configClassName, true, this.createTempLoader(hashSet, false));
                        break block12;
                    }
                    throw classNotFoundException2;
                }
            }
            catch (ClassNotFoundException classNotFoundException3) {
                this.logSevere(ValidationException.configFactoryNamePropertyNotFound(this.configClassName, "java.persistence.setup.config", classNotFoundException3));
                this.shouldCreateInternalLoader = true;
                throw classNotFoundException;
            }
        }
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith(EM_CONFIG_FACTORY_METHOD_NAME_PREFIX_PROPERTY) || !Modifier.isStatic(methodArray[i].getModifiers()) || methodArray[i].getGenericParameterTypes().length != 0 || !methodArray[i].getGenericReturnType().equals(Collection.class)) continue;
            method = methodArray[i];
            break;
        }
        if (method != null) {
            this.logConfig("class_list_created_by", this.configClassName, method.getName());
            try {
                this.classList = (Collection)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                ValidationException validationException = ValidationException.cannotInvokeMethodOnConfigClass(method.getName(), this.configClassName, "java.persistence.setup.config", exception);
                this.logSevere(validationException);
                throw validationException;
            }
        } else {
            this.logSevere(ValidationException.configMethodNotDefined(this.configClassName, EM_CONFIG_FACTORY_METHOD_NAME_PREFIX_PROPERTY));
            return null;
        }
        return this.classList;
    }

    protected void initContainer(Collection collection, Map map) {
        this.logDebug("ec_initializeContainer");
        this.classList = collection;
        this.initEntityManager(map);
    }

    protected static boolean initializeFromAgent(Instrumentation instrumentation) throws Exception {
        int n = AbstractSessionLog.getLog().getLevel();
        String string = System.getProperty(TOPLINK_AGENT_LOGGING_LEVEL_PROPERTY);
        if (string != null) {
            int bl = new Integer(string);
            AbstractSessionLog.getLog().setLevel(bl);
        }
        globalInstrumentation = instrumentation;
        entityContainer = new EntityContainer();
        entityContainer.loadPersistenceConfigFiles();
        boolean bl = entityContainer.initialize(new HashMap());
        AbstractSessionLog.getLog().setLevel(n);
        return bl;
    }

    protected EntityManagerSetupImpl getSetupImpl() {
        return (EntityManagerSetupImpl)this.emSetupImpl;
    }

    protected Collection loadEntityClasses(Collection collection, ClassLoader classLoader) {
        Vector vector = new Vector();
        this.logDebug("ec_loading_entity_using_loader", classLoader);
        for (String string : collection) {
            try {
                vector.add(classLoader.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.entityClassNotFound(string, classLoader, classNotFoundException);
            }
        }
        return vector;
    }

    public void setConfigClassName(String string) {
        this.configClassName = string;
    }

    protected InitialContextImpl createInitialContextImpl() {
        return new oracle.toplink.internal.ejb.cmp3.naming.InitialContextImpl();
    }

    protected String getJNDI_CTX_FACTORY_CLASS() {
        return InitialContextFactoryImpl.class.getName();
    }

    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        public TempEntityLoader(URL[] uRLArray, ClassLoader classLoader, Collection collection, boolean bl) {
            super(uRLArray, classLoader);
            this.classNames = collection;
            this.shouldOverrideLoadClassForCollectionMembers = bl;
        }

        public TempEntityLoader(URL[] uRLArray, ClassLoader classLoader, Collection collection) {
            this(uRLArray, classLoader, collection, true);
        }

        protected boolean shouldOverrideLoadClass(String string) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(string);
            }
            return !string.startsWith("java.") && !string.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(string));
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(string)) {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    clazz = this.findClass(string);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

