/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.wls11;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.tools.ejb11.CMPBeanDefinition;
import oracle.toplink.tools.ejb11.FinderDefinition;

public class FinderGenerator {
    protected static final char EOL = '\n';
    protected static final String TAB = "   ";
    protected static final char SPACE = ' ';
    protected static final String BEANTMP = "__bean";
    protected static final String FINDERNAMETMP = "ejbF";
    protected static final String QUERYTMP = "__query";
    protected static final String VECTORTMP = "__args";
    protected static final String EXPRESSIONTMP = "__exp";
    protected static final String BUILDERTMP = "builder";
    protected static final Class EJBObject_class = class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = FinderGenerator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject;
    public Method method;
    public FinderDefinition finderDefinition;
    public CMPBeanDefinition beanDefinition;
    public boolean isFindByPrimaryKey = false;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public FinderGenerator() {
    }

    public FinderGenerator(Method method, CMPBeanDefinition cMPBeanDefinition) {
        this();
        this.setMethod(method);
        this.setBeanDefinition(cMPBeanDefinition);
    }

    public FinderGenerator(Method method, FinderDefinition finderDefinition, CMPBeanDefinition cMPBeanDefinition) {
        this(method, cMPBeanDefinition);
        this.setFinderDefinition(finderDefinition);
    }

    private void addArgumentsToFinder(Enumeration enumeration, StringBuffer stringBuffer) {
        while (enumeration.hasMoreElements()) {
            this.eoltab(stringBuffer);
            stringBuffer.append(VECTORTMP);
            stringBuffer.append(".addElement(");
            String string = enumeration.nextElement().toString();
            this.addArgumentToFinder(string, stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addArgumentsToSQLFinder(Enumeration enumeration, StringBuffer stringBuffer) {
        while (enumeration.hasMoreElements()) {
            this.eoltabtab(stringBuffer);
            stringBuffer.append(VECTORTMP);
            stringBuffer.append(".addElement(");
            String string = enumeration.nextElement().toString();
            this.addArgumentToFinder(string, stringBuffer);
            stringBuffer.append(");");
            this.eoltabtab(stringBuffer);
            stringBuffer.append(QUERYTMP);
            stringBuffer.append(".addArgument(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");");
        }
    }

    private void addArgumentToFinder(String string, StringBuffer stringBuffer) {
        int n = this.getFinderDefinition().getMethodParamNames().indexOf(string);
        Class[] classArray = PrivilegedAccessController.getMethodParameterTypes(this.getMethod());
        Class clazz = classArray[n];
        if (clazz.isPrimitive()) {
            stringBuffer.append("new ");
            Class clazz2 = ConversionManager.getObjectClass(clazz);
            stringBuffer.append(clazz2.getName());
            stringBuffer.append("(");
        }
        stringBuffer.append(string);
        if (clazz.isPrimitive()) {
            stringBuffer.append(")");
        }
    }

    private void appendQuerySettings(StringBuffer stringBuffer) {
        Boolean bl;
        String string = this.hasFinderDefinition() && this.getFinderDefinition().getCacheUsage() != null ? this.getFinderDefinition().getCacheUsage() : this.getBeanDefinition().getCacheUsage();
        if (string != null) {
            stringBuffer.append(TAB);
            stringBuffer.append(QUERYTMP);
            stringBuffer.append(".setCacheUsage(");
            stringBuffer.append("oracle.toplink.queryframework.ObjectLevelReadQuery.");
            stringBuffer.append(string);
            stringBuffer.append(");");
            stringBuffer.append('\n');
        }
        if ((bl = this.hasFinderDefinition() && this.getFinderDefinition().getRefreshCache() != null ? this.getFinderDefinition().getRefreshCache() : this.getBeanDefinition().getRefreshCache()) != null) {
            stringBuffer.append(TAB);
            stringBuffer.append(QUERYTMP);
            stringBuffer.append(".setShouldRefreshIdentityMapResult(");
            stringBuffer.append(bl.toString());
            stringBuffer.append(");");
            stringBuffer.append('\n');
            if (bl.booleanValue()) {
                stringBuffer.append(QUERYTMP);
                stringBuffer.append(".cascadePrivateParts();");
                stringBuffer.append('\n');
            }
        }
    }

    private void checkForNull(StringBuffer stringBuffer) {
        stringBuffer.append(TAB);
        stringBuffer.append("if (");
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" == null) {");
        this.eoltabtab(stringBuffer);
        stringBuffer.append("throw EJBExceptionFactory.objectNotFound(getPersistenceManagerTopLink().getBeanName(), \"" + this.getFinderDefinition().getMethodName() + "\");");
        this.eoltab(stringBuffer);
        stringBuffer.append("}");
    }

    private void closeTryAndCatchExceptions(StringBuffer stringBuffer) {
        this.eoltab(stringBuffer);
        stringBuffer.append("} catch( RuntimeException ex){");
        this.eoltabtab(stringBuffer);
        stringBuffer.append("throw EJBExceptionFactory.errorDuringFind(\"" + this.getFinderDefinition().getMethodName() + "\", getPersistenceManagerTopLink().getBeanName(), ex);");
        this.eoltab(stringBuffer);
        stringBuffer.append("}");
        stringBuffer.append('\n');
    }

    private void eoltab(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append(TAB);
    }

    private void eoltabtab(StringBuffer stringBuffer) {
        this.eoltab(stringBuffer);
        stringBuffer.append(TAB);
    }

    private void finderFooter(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append("}");
    }

    private void finderHeader(StringBuffer stringBuffer) {
        stringBuffer.append(this.methodSignature());
        stringBuffer.append("{");
        stringBuffer.append('\n');
    }

    public CMPBeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public FinderDefinition getFinderDefinition() {
        return this.finderDefinition;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean hasFinderDefinition() {
        return this.getFinderDefinition() != null;
    }

    public String implementation() throws Exception {
        if (this.isFindByPrimaryKey()) {
            return this.implementFindByPrimaryKey();
        }
        if (!this.hasFinderDefinition()) {
            return this.implementNullFinder("no XML Finder Definition");
        }
        if (this.isSingleCustomSQLFinder()) {
            return this.implementSingleCustomSQLFinder();
        }
        if (this.isEnumerationCustomSQLFinder()) {
            return this.implementEnumerationCustomSQLFinder();
        }
        if (this.isCollectionCustomSQLFinder()) {
            return this.implementCollectionCustomSQLFinder();
        }
        if (this.isSingleExpressionFinder()) {
            return this.implementSingleExpressionFinder();
        }
        if (this.isEnumerationExpressionFinder()) {
            return this.implementEnumerationExpressionFinder();
        }
        if (this.isCollectionExpressionFinder()) {
            return this.implementCollectionExpressionFinder();
        }
        if (this.isSingleNamedFinder()) {
            return this.implementSingleNamedFinder();
        }
        if (this.isEnumerationNamedFinder()) {
            return this.implementEnumerationNamedFinder();
        }
        if (this.isCollectionNamedFinder()) {
            return this.implementCollectionNamedFinder();
        }
        if (this.isSingleRedirectFinder()) {
            return this.implementSingleRedirectFinder();
        }
        if (this.isEnumerationRedirectFinder()) {
            return this.implementEnumerationRedirectFinder();
        }
        if (this.isCollectionRedirectFinder()) {
            return this.implementCollectionRedirectFinder();
        }
        if (this.isSingleReadObjectFinder()) {
            return this.implementSingleReadObjectFinder();
        }
        if (this.isEnumerationReadAllFinder()) {
            return this.implementEnumerationReadAllFinder();
        }
        if (this.isCollectionReadAllFinder()) {
            return this.implementCollectionReadAllFinder();
        }
        return this.implementNullFinder("unknown XML Finder Definition type");
    }

    public String implementCollectionCustomSQLFinder() {
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadAllQuery(stringBuffer);
        stringBuffer.append('\n');
        this.appendQuerySettings(stringBuffer);
        stringBuffer.append(TAB);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSQLString(\"" + string);
        stringBuffer.append("\");");
        if (this.getFinderDefinition().hasParameters()) {
            this.eoltabtab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToSQLFinder(enumeration, stringBuffer);
            this.eoltabtab(stringBuffer);
            stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
            stringBuffer.append(QUERYTMP);
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
            stringBuffer.append(");");
        } else {
            this.eoltabtab(stringBuffer);
            stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
            stringBuffer.append(QUERYTMP);
            stringBuffer.append(");");
        }
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementCollectionExpressionFinder() {
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadAllQuery(stringBuffer);
        this.appendQuerySettings(stringBuffer);
        this.newExpressionBuilder(stringBuffer);
        this.eoltab(stringBuffer);
        stringBuffer.append("Expression ");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append(TAB);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSelectionCriteria(");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(");");
        this.eoltabtab(stringBuffer);
        stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementCollectionNamedFinder() {
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        stringBuffer.append('\n');
        if (this.getFinderDefinition().hasParameters()) {
            stringBuffer.append(TAB);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
            this.eoltab(stringBuffer);
            this.openTryBlock(stringBuffer);
            this.eoltabtab(stringBuffer);
            stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(\"");
            stringBuffer.append(string);
            stringBuffer.append("\", this.getClass(), ");
            stringBuffer.append(VECTORTMP);
            stringBuffer.append(");");
        } else {
            this.eoltab(stringBuffer);
            this.openTryBlock(stringBuffer);
            this.eoltabtab(stringBuffer);
            stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(\"");
            stringBuffer.append(string);
            stringBuffer.append("\", this.getClass());");
        }
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementCollectionReadAllFinder() {
        String string = (String)this.getFinderDefinition().getMethodParamNames().elementAt(0);
        String string2 = this.getFinderDefinition().getMethodParamNames().size() == 1 ? "new Vector()" : (String)this.getFinderDefinition().getMethodParamNames().elementAt(1);
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append("ReadAllQuery ");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(";");
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append("java.util.Vector ");
        stringBuffer.append(VECTORTMP);
        stringBuffer.append(" = ");
        stringBuffer.append(string2);
        stringBuffer.append(";");
        this.eoltabtab(stringBuffer);
        stringBuffer.append("return (java.util.Collection) getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(",");
        stringBuffer.append(VECTORTMP);
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementCollectionRedirectFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        if (bl) {
            this.eoltab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
        }
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append("return(java.util.Collection)");
        stringBuffer.append(string);
        stringBuffer.append("(getPersistenceManagerTopLink().getSessionOrUnitOfWork()");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementDefaultFindByPrimaryKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.primaryKeyHeader());
        this.eoltab(stringBuffer);
        stringBuffer.append("return null;");
        stringBuffer.append('\n');
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementEnumerationCustomSQLFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadAllQuery(stringBuffer);
        this.appendQuerySettings(stringBuffer);
        stringBuffer.append(TAB);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSQLString(\"");
        stringBuffer.append(string);
        stringBuffer.append("\");");
        if (bl) {
            this.eoltabtab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToSQLFinder(enumeration, stringBuffer);
        }
        this.eoltabtab(stringBuffer);
        this.returnEnumerationFor(stringBuffer);
        stringBuffer.append(QUERYTMP);
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append("));");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementEnumerationExpressionFinder() {
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadAllQuery(stringBuffer);
        this.appendQuerySettings(stringBuffer);
        this.eoltab(stringBuffer);
        this.newExpressionBuilder(stringBuffer);
        this.eoltab(stringBuffer);
        stringBuffer.append("Expression ");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append(TAB);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSelectionCriteria(");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(");");
        this.eoltabtab(stringBuffer);
        this.returnEnumerationFor(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append("));");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementEnumerationNamedFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        if (bl) {
            this.eoltab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
        }
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        this.returnEnumerationFor(stringBuffer);
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\", this.getClass()");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append("));");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementEnumerationReadAllFinder() {
        String string = null;
        String string2 = null;
        if (!this.getFinderDefinition().hasParameters()) {
            return this.implementNullFinder("ReadAll Finders requires at least one parameter.");
        }
        Serializable serializable = this.getFinderDefinition().getMethodParamNames();
        if (((Vector)serializable).size() > 2) {
            return this.implementNullFinder("ReadAll Finders cannot have more than two parameters.");
        }
        string = (String)((Vector)serializable).elementAt(0);
        if (((Vector)serializable).size() == 2) {
            string2 = (String)((Vector)serializable).elementAt(1);
        }
        serializable = new StringBuffer();
        this.finderHeader((StringBuffer)serializable);
        this.eoltab((StringBuffer)serializable);
        ((StringBuffer)serializable).append(string);
        this.setReferenceClass((StringBuffer)serializable);
        this.eoltab((StringBuffer)serializable);
        this.openTryBlock((StringBuffer)serializable);
        this.eoltabtab((StringBuffer)serializable);
        this.returnEnumerationFor((StringBuffer)serializable);
        ((StringBuffer)serializable).append(string);
        if (string2 != null) {
            ((StringBuffer)serializable).append(", ");
            ((StringBuffer)serializable).append(string2);
        }
        ((StringBuffer)serializable).append("));");
        this.closeTryAndCatchExceptions((StringBuffer)serializable);
        this.finderFooter((StringBuffer)serializable);
        return ((StringBuffer)serializable).toString();
    }

    public String implementEnumerationRedirectFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        if (bl) {
            this.eoltab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
        }
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append("return new oracle.toplink.internal.ejb.cmp.finders.EnumeratorImpl((Vector)");
        stringBuffer.append(string);
        stringBuffer.append("(getPersistenceManagerTopLink().getSessionOrUnitOfWork()");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append("));");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementFindByPrimaryKey() {
        if (this.getFinderDefinition() == null) {
            return this.implementDefaultFindByPrimaryKey();
        }
        return this.implementDefaultFindByPrimaryKey();
    }

    public String implementNullFinder(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        stringBuffer.append("throw EJBExceptionFactory.notYetImplemented(\"");
        stringBuffer.append(string);
        stringBuffer.append("\");");
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementSingleCustomSQLFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newNullBean(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadObjectQuery(stringBuffer);
        this.appendQuerySettings(stringBuffer);
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSQLString(\"");
        stringBuffer.append(string);
        stringBuffer.append("\");");
        if (bl) {
            this.eoltabtab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToSQLFinder(enumeration, stringBuffer);
        }
        this.eoltabtab(stringBuffer);
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" = (");
        stringBuffer.append(this.returnTypeStringFromMethod());
        stringBuffer.append(") getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
        stringBuffer.append(QUERYTMP);
        if (bl) {
            stringBuffer.append(",");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.checkForNull(stringBuffer);
        this.returnBean(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementSingleExpressionFinder() {
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newNullBean(stringBuffer);
        this.eoltab(stringBuffer);
        this.newReadObjectQuery(stringBuffer);
        this.appendQuerySettings(stringBuffer);
        this.eoltab(stringBuffer);
        this.newExpressionBuilder(stringBuffer);
        this.eoltab(stringBuffer);
        stringBuffer.append("Expression ");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append(TAB);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        this.setReferenceClass(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(".setSelectionCriteria(");
        stringBuffer.append(EXPRESSIONTMP);
        stringBuffer.append(");");
        this.eoltabtab(stringBuffer);
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" = (");
        stringBuffer.append(this.returnTypeStringFromMethod());
        stringBuffer.append(") getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.checkForNull(stringBuffer);
        this.returnBean(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementSingleNamedFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newNullBean(stringBuffer);
        if (bl) {
            this.eoltab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
        }
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" = (");
        stringBuffer.append(this.returnTypeStringFromMethod());
        stringBuffer.append(") getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(\"");
        stringBuffer.append(string);
        stringBuffer.append("\", this.getClass()");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.checkForNull(stringBuffer);
        this.returnBean(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public String implementSingleReadObjectFinder() {
        String string = null;
        String string2 = null;
        if (!this.getFinderDefinition().hasParameters()) {
            return this.implementNullFinder("ReadObject Finders requires at least one parameter.");
        }
        Serializable serializable = this.getFinderDefinition().getMethodParamNames();
        if (((Vector)serializable).size() > 2) {
            return this.implementNullFinder("ReadObject Finders cannot have more than two parameters.");
        }
        string = (String)((Vector)serializable).elementAt(0);
        if (((Vector)serializable).size() == 2) {
            string2 = (String)((Vector)serializable).elementAt(1);
        }
        serializable = new StringBuffer();
        this.finderHeader((StringBuffer)serializable);
        this.eoltab((StringBuffer)serializable);
        this.newNullBean((StringBuffer)serializable);
        this.eoltab((StringBuffer)serializable);
        this.openTryBlock((StringBuffer)serializable);
        this.eoltabtab((StringBuffer)serializable);
        ((StringBuffer)serializable).append(string);
        this.setReferenceClass((StringBuffer)serializable);
        this.eoltabtab((StringBuffer)serializable);
        ((StringBuffer)serializable).append(BEANTMP);
        ((StringBuffer)serializable).append(" = (");
        ((StringBuffer)serializable).append(this.returnTypeStringFromMethod());
        ((StringBuffer)serializable).append(") getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
        ((StringBuffer)serializable).append(string);
        if (string2 != null) {
            ((StringBuffer)serializable).append(", ");
            ((StringBuffer)serializable).append(string2);
        }
        ((StringBuffer)serializable).append(");");
        this.closeTryAndCatchExceptions((StringBuffer)serializable);
        this.checkForNull((StringBuffer)serializable);
        this.returnBean((StringBuffer)serializable);
        this.finderFooter((StringBuffer)serializable);
        return ((StringBuffer)serializable).toString();
    }

    public String implementSingleRedirectFinder() {
        boolean bl = this.getFinderDefinition().hasParameters();
        String string = this.getFinderDefinition().getFinderQuery();
        StringBuffer stringBuffer = new StringBuffer();
        this.finderHeader(stringBuffer);
        this.eoltab(stringBuffer);
        this.newNullBean(stringBuffer);
        this.eoltab(stringBuffer);
        if (bl) {
            this.eoltab(stringBuffer);
            this.newArgumentsVector(stringBuffer);
            Enumeration enumeration = this.getFinderDefinition().getMethodParamNames().elements();
            this.addArgumentsToFinder(enumeration, stringBuffer);
        }
        this.eoltab(stringBuffer);
        this.openTryBlock(stringBuffer);
        this.eoltabtab(stringBuffer);
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" = (");
        stringBuffer.append(this.returnTypeStringFromMethod());
        stringBuffer.append(") ");
        stringBuffer.append(string);
        stringBuffer.append("(getPersistenceManagerTopLink().getSessionOrUnitOfWork()");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(VECTORTMP);
        }
        stringBuffer.append(");");
        this.closeTryAndCatchExceptions(stringBuffer);
        this.checkForNull(stringBuffer);
        this.returnBean(stringBuffer);
        this.finderFooter(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isCollection() throws Exception {
        return ClassConstants.Collection_Class.isAssignableFrom(PrivilegedAccessController.getMethodReturnType(this.getMethod()));
    }

    public boolean isCollectionCustomSQLFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("SQL") && this.isCollection();
    }

    public boolean isCollectionExpressionFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("EXPRESSION") && this.isCollection();
    }

    public boolean isCollectionNamedFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("NAMED") && this.isCollection();
    }

    public boolean isCollectionReadAllFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("READALL") && this.isCollection();
    }

    public boolean isCollectionRedirectFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("REDIRECT") && this.isCollection();
    }

    public boolean isEnumeration() throws Exception {
        return ClassConstants.Enumeration_Class.isAssignableFrom(PrivilegedAccessController.getMethodReturnType(this.getMethod()));
    }

    public boolean isEnumerationCustomSQLFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("SQL") && this.isEnumeration();
    }

    public boolean isEnumerationExpressionFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("EXPRESSION") && this.isEnumeration();
    }

    public boolean isEnumerationNamedFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("NAMED") && this.isEnumeration();
    }

    public boolean isEnumerationReadAllFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("READALL") && this.isEnumeration();
    }

    public boolean isEnumerationRedirectFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("REDIRECT") && this.isEnumeration();
    }

    public boolean isFindByPrimaryKey() throws Exception {
        return this.isFindByPrimaryKey;
    }

    public boolean isSingle() throws Exception {
        return EJBObject_class.isAssignableFrom(PrivilegedAccessController.getMethodReturnType(this.getMethod()));
    }

    public boolean isSingleCustomSQLFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("SQL") && this.isSingle();
    }

    public boolean isSingleExpressionFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("EXPRESSION") && this.isSingle();
    }

    public boolean isSingleNamedFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("NAMED") && this.isSingle();
    }

    public boolean isSingleReadObjectFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("READOBJECT") && this.isSingle();
    }

    public boolean isSingleRedirectFinder() throws Exception {
        return this.getFinderDefinition().getFinderType().equalsIgnoreCase("REDIRECT") && this.isSingle();
    }

    public String methodSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        stringBuffer.append(PrivilegedAccessController.getMethodReturnType(this.getMethod()).getName());
        stringBuffer.append(" ");
        StringBuffer stringBuffer2 = new StringBuffer(this.getMethod().getName());
        stringBuffer2.deleteCharAt(0);
        stringBuffer2.insert(0, FINDERNAMETMP);
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("(");
        if (this.hasFinderDefinition()) {
            stringBuffer.append(this.methodSignatureArgumentsFromFinderDefinition());
        } else {
            stringBuffer.append(this.methodSignatureArgumentsFromMethod());
        }
        stringBuffer.append(")");
        stringBuffer.append(" throws javax.ejb.FinderException, java.rmi.RemoteException ");
        return stringBuffer.toString();
    }

    public String methodSignatureArgumentsFromFinderDefinition() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getFinderDefinition().getMethodParamTypes().elements();
        Enumeration enumeration2 = this.getFinderDefinition().getMethodParamNames().elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)enumeration2.nextElement();
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String methodSignatureArgumentsFromMethod() {
        Class[] classArray = PrivilegedAccessController.getMethodParameterTypes(this.getMethod());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            String string = classArray[i].getName();
            String string2 = "arg" + i;
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void newArgumentsVector(StringBuffer stringBuffer) {
        stringBuffer.append("Vector ");
        stringBuffer.append(VECTORTMP);
        stringBuffer.append(" = new Vector();");
    }

    private void newExpressionBuilder(StringBuffer stringBuffer) {
        stringBuffer.append("ExpressionBuilder ");
        stringBuffer.append(BUILDERTMP);
        stringBuffer.append(" = new ExpressionBuilder();");
        stringBuffer.append('\n');
    }

    private void newNullBean(StringBuffer stringBuffer) {
        stringBuffer.append(this.returnTypeStringFromMethod());
        stringBuffer.append(' ');
        stringBuffer.append(BEANTMP);
        stringBuffer.append(" = null;");
    }

    private void newReadAllQuery(StringBuffer stringBuffer) {
        stringBuffer.append("ReadAllQuery ");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(" = new ReadAllQuery();");
        stringBuffer.append('\n');
    }

    private void newReadObjectQuery(StringBuffer stringBuffer) {
        stringBuffer.append("ReadObjectQuery ");
        stringBuffer.append(QUERYTMP);
        stringBuffer.append(" = new ReadObjectQuery();");
        stringBuffer.append('\n');
    }

    private void openTryBlock(StringBuffer stringBuffer) {
        stringBuffer.append("try {");
    }

    public String primaryKeyHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.primaryKeyMethodSignature());
        stringBuffer.append("{");
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public String primaryKeyMethodSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        stringBuffer.append(PrivilegedAccessController.getMethodReturnType(this.getMethod()).getName());
        stringBuffer.append(" ");
        stringBuffer.append("ejbFindByPrimaryKey");
        stringBuffer.append("(");
        Class[] classArray = PrivilegedAccessController.getMethodParameterTypes(this.method);
        Class clazz = classArray[0];
        stringBuffer.append(clazz.getName());
        stringBuffer.append(" ");
        stringBuffer.append("pk");
        stringBuffer.append(")");
        stringBuffer.append(" throws javax.ejb.FinderException, java.rmi.RemoteException");
        return stringBuffer.toString();
    }

    private void returnBean(StringBuffer stringBuffer) {
        this.eoltab(stringBuffer);
        stringBuffer.append("return ");
        stringBuffer.append(BEANTMP);
        stringBuffer.append(";");
        stringBuffer.append('\n');
    }

    private void returnEnumerationFor(StringBuffer stringBuffer) {
        stringBuffer.append("return oracle.toplink.internal.ejb.cmp.finders.CollectionFactory.createEnumeratorFor(getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(");
    }

    public String returnTypeStringFromMethod() {
        return PrivilegedAccessController.getMethodReturnType(this.getMethod()).getName();
    }

    public void setBeanDefinition(CMPBeanDefinition cMPBeanDefinition) {
        this.beanDefinition = cMPBeanDefinition;
    }

    public void setFinderDefinition(FinderDefinition finderDefinition) {
        this.finderDefinition = finderDefinition;
    }

    public void setIsFindByPrimaryKey(boolean bl) {
        this.isFindByPrimaryKey = bl;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    private void setReferenceClass(StringBuffer stringBuffer) {
        stringBuffer.append(".setReferenceClass(this.getClass());");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

