/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.cursors;

import java.util.Collection;
import javax.ejb.EJBException;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.PersistenceManagerBase;
import oracle.toplink.internal.ejb.cmp.cursors.CursoredIteratorRemote;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.queryframework.CursoredStream;

public class CursoredIteratorRemoteImpl
implements CursoredIteratorRemote {
    protected CursoredStream cursoredStream;
    protected boolean wrapLocal;

    public CursoredIteratorRemoteImpl(boolean bl, CursoredStream cursoredStream) {
        this.cursoredStream = cursoredStream;
        this.wrapLocal = bl;
    }

    public void close() {
        this.cursoredStream.close();
    }

    public boolean hasNext() {
        return this.cursoredStream.hasMoreElements();
    }

    public Object next() {
        return this.wrapFinderResults(this.cursoredStream.nextElement());
    }

    public Collection next(int n) {
        return (Collection)this.wrapFinderResults(this.cursoredStream.nextElements(n));
    }

    protected boolean shouldWrapLocal() {
        return this.wrapLocal;
    }

    protected CursoredStream getCursoredStream() {
        return this.cursoredStream;
    }

    protected Object wrapFinderResults(Object object) {
        String string = this.getCursoredStream().getQuery().getName();
        PersistenceManagerBase persistenceManagerBase = (PersistenceManagerBase)this.cursoredStream.getQuery().getDescriptor().getProperty("PERSISTENCE_MANAGER");
        try {
            return persistenceManagerBase.getFinderManager().wrapFinderResults(this.shouldWrapLocal(), object, this.getCursoredStream().getSession());
        }
        catch (Error error) {
            AbstractSessionLog.getLog().log(6, "an_error_executing_finder", string);
            AbstractSessionLog.getLog().logThrowable(6, error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            EJBException eJBException = EJBExceptionFactory.errorDuringFind(string, persistenceManagerBase.getEntityDescriptor().getBeanName(), runtimeException);
            AbstractSessionLog.getLog().logThrowable(6, eJBException);
            throw eJBException;
        }
    }
}

