/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.codegen;

import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.tools.codegen.AttributeDefinition;
import oracle.toplink.tools.codegen.ClassDefinition;
import oracle.toplink.tools.codegen.MethodDefinition;
import oracle.toplink.tools.codegen.NonreflectiveAttributeDefinition;
import oracle.toplink.tools.codegen.NonreflectiveMethodDefinition;
import oracle.toplink.tools.codegen.ReflectiveMethodDefinition;

public class FetchGroupCodeGenerator {
    public static final String FETCH_GROUP_ATTRIBUTE = "fetchGroup";
    private static final String SHOULD_REFRESH_FETCH_GROUP_ATTRIBUTE = "shouldRefreshFetchGroup";
    private static final String LOAD_UNFETCHED_ATTRIBUTES = "loadUnfetchedAttributes";
    private static final String GET_FETCHGROUP = "getFetchGroup";
    private static final String SET_FETCHGROUP = "setFetchGroup";
    private static final String IS_OBJECT_PARTIALLY_FETCHED = "isObjectPartiallyFetched";
    private static final String IS_ATTRIBUTE_FETCHED = "isAttributeFetched";
    private static final String RESET = "resetFetchGroup";
    private static final String SHOULD_REFRESH_FETCH_GROUP = "shouldRefreshFetchGroup";
    private static final String SET_SHOULD_REFRESH_FETCH_GROUP = "setShouldRefreshFetchGroup";
    static /* synthetic */ Class class$java$lang$String;

    public void generateCodeForFetchGroup(EntityDescriptor entityDescriptor, ClassDefinition classDefinition) {
        classDefinition.addInterface("FetchGroupTracker");
        classDefinition.addImport("oracle.toplink.queryframework.*");
        classDefinition.addImport("oracle.toplink.descriptors.*");
        classDefinition.addImport("oracle.toplink.exceptions.ValidationException");
        classDefinition.addAttribute(this.buildFetchGroupAttribute());
        classDefinition.addAttribute(this.buildShouldRefreshFetchGroupAttribute());
        classDefinition.addMethod(this.buildLoadUnfetchedAttributesMethod(entityDescriptor));
        classDefinition.addMethod(this.buildGetFetchGroupMethod());
        classDefinition.addMethod(this.buildSetFetchGroupMethod());
        classDefinition.addMethod(this.buildIsAttributeFetched());
        classDefinition.addMethod(this.buildReset());
        classDefinition.addMethod(this.buildShouldRefreshFetchGroup());
        classDefinition.addMethod(this.buildSetShouldRefreshFetchGroup());
    }

    protected AttributeDefinition buildFetchGroupAttribute() {
        NonreflectiveAttributeDefinition nonreflectiveAttributeDefinition = new NonreflectiveAttributeDefinition();
        nonreflectiveAttributeDefinition.setName(FETCH_GROUP_ATTRIBUTE);
        nonreflectiveAttributeDefinition.setType("FetchGroup");
        nonreflectiveAttributeDefinition.setInitialValue("null");
        return nonreflectiveAttributeDefinition;
    }

    protected AttributeDefinition buildShouldRefreshFetchGroupAttribute() {
        NonreflectiveAttributeDefinition nonreflectiveAttributeDefinition = new NonreflectiveAttributeDefinition();
        nonreflectiveAttributeDefinition.setName("shouldRefreshFetchGroup");
        nonreflectiveAttributeDefinition.setType("boolean");
        nonreflectiveAttributeDefinition.setInitialValue("false");
        return nonreflectiveAttributeDefinition;
    }

    protected MethodDefinition buildLoadUnfetchedAttributesMethod(EntityDescriptor entityDescriptor) {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(LOAD_UNFETCHED_ATTRIBUTES);
        nonreflectiveMethodDefinition.setReturnType("void");
        nonreflectiveMethodDefinition.addArgument(entityDescriptor.getConcreteBeanClassName(), "obj");
        nonreflectiveMethodDefinition.addLine("ReadObjectQuery query = new ReadObjectQuery(" + entityDescriptor.getConcreteBeanClassName() + ".class);");
        nonreflectiveMethodDefinition.addLine("query.setSelectionObject(obj);");
        nonreflectiveMethodDefinition.addLine("query.setShouldUseDefaultFetchGroup(false);");
        nonreflectiveMethodDefinition.addLine("getPersistenceManagerTopLink().getSessionOrUnitOfWork().executeQuery(query);");
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildGetFetchGroupMethod() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(GET_FETCHGROUP);
        reflectiveMethodDefinition.setReturnType("FetchGroup");
        reflectiveMethodDefinition.addLine("return fetchGroup;");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildSetFetchGroupMethod() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(SET_FETCHGROUP);
        nonreflectiveMethodDefinition.setReturnType("void");
        nonreflectiveMethodDefinition.addArgument("FetchGroup", "newGroup");
        nonreflectiveMethodDefinition.addLine("this.fetchGroup = newGroup;");
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildIsAttributeFetched() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(IS_ATTRIBUTE_FETCHED);
        reflectiveMethodDefinition.setReturnType("boolean");
        reflectiveMethodDefinition.addArgument(class$java$lang$String == null ? (class$java$lang$String = FetchGroupCodeGenerator.class$("java.lang.String")) : class$java$lang$String, "attributeName");
        reflectiveMethodDefinition.addLine("return ((fetchGroup == null) || fetchGroup.getAttributes().contains(attributeName));");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildReset() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(RESET);
        reflectiveMethodDefinition.setReturnType("void");
        reflectiveMethodDefinition.addLine("clearFieldsForPoolingTopLink();");
        reflectiveMethodDefinition.addLine("initFieldsForCreateTopLink();");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildShouldRefreshFetchGroup() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName("shouldRefreshFetchGroup");
        reflectiveMethodDefinition.setReturnType("boolean");
        reflectiveMethodDefinition.addLine("return shouldRefreshFetchGroup;");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildSetShouldRefreshFetchGroup() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(SET_SHOULD_REFRESH_FETCH_GROUP);
        reflectiveMethodDefinition.setReturnType("void");
        reflectiveMethodDefinition.addArgument(Boolean.TYPE, "shouldRefreshFetchGroup");
        reflectiveMethodDefinition.addLine("this.shouldRefreshFetchGroup = shouldRefreshFetchGroup;");
        return reflectiveMethodDefinition;
    }

    public static void appendGetMethodCheck(MethodDefinition methodDefinition, String string) {
        methodDefinition.addLine("if (!isAttributeFetched(\"" + string + "\")) {");
        methodDefinition.addLine("    loadUnfetchedAttributes(this);");
        methodDefinition.addLine("}");
    }

    public static void appendSetMethodCheck(MethodDefinition methodDefinition, String string) {
        methodDefinition.addLine("if (!isAttributeFetched(\"" + string + "\")) {");
        methodDefinition.addLine("    throw ValidationException.unfetchedAttributeNotEditable(\"" + string + "\");");
        methodDefinition.addLine("}");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

