/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.cmr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.transaction.Transaction;
import oracle.toplink.ejb.cmp.EjbCollection;
import oracle.toplink.internal.ejb.cmp.CmpEnvironment;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity;
import oracle.toplink.internal.ejb.cmp.cmr.CmrCollection;
import oracle.toplink.internal.ejb.cmp.cmr.CmrIterator;

public class CmrCollectionImpl
extends EjbCollection
implements CmrCollection,
Cloneable {
    private transient Transaction transaction = null;
    protected transient Class collectionType = null;
    protected transient TopLinkCmpEntity owner = null;

    public CmrCollectionImpl(int n) {
        super(n);
    }

    public CmrCollectionImpl(TopLinkCmpEntity topLinkCmpEntity, int n) {
        super(n);
        this.setOwner(topLinkCmpEntity);
    }

    public CmrCollectionImpl(Collection collection) {
        super(collection);
    }

    public Object clone() {
        return (CmrCollectionImpl)super.clone();
    }

    public Iterator iterator() {
        return new CmrIteratorImpl();
    }

    public boolean contains(Object object) {
        this.checkParameter(object, "contains");
        return this.privateContains(object);
    }

    public boolean privateContains(Object object) {
        return super.contains(object);
    }

    public void clear() {
        this.checkReadOnly("clear");
        this.checkTransaction();
        this.privateClear();
    }

    public void privateClear() {
        Iterator iterator = new ArrayList(this).iterator();
        while (iterator.hasNext()) {
            this.relMaintRemove(iterator.next());
        }
    }

    public boolean add(Object object) {
        this.checkReadOnly("add");
        this.checkParameter(object, "add");
        this.checkTransaction();
        return this.relMaintAdd(object);
    }

    public boolean addAll(Collection collection) {
        this.checkReadOnly("addAll");
        this.checkTransaction();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkParameter(e, "addAll");
            bl |= this.relMaintAdd(e);
        }
        return bl;
    }

    public boolean remove(Object object) {
        this.checkReadOnly("remove");
        this.checkParameter(object, "remove");
        this.checkTransaction();
        return this.relMaintRemove(object);
    }

    public boolean removeAll(Collection collection) {
        this.checkReadOnly("removeAll");
        this.checkTransaction();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkParameter(e, "removeAll");
            bl |= this.relMaintRemove(e);
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        this.checkReadOnly("retainAll");
        this.checkTransaction();
        boolean bl = false;
        if (!(collection instanceof CmrCollection)) {
            collection = new CmrCollectionImpl(collection);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean relationshipMaintenanceCheckAlreadyAdded(Object object) {
        if (this.isInstantiated()) {
            return this.privateContains(object);
        }
        return this.hasAddedElements() && this.getAddedElements().contains(object);
    }

    public boolean relationshipMaintenanceCheckAlreadyRemoved(Object object) {
        if (this.isInstantiated()) {
            return !this.privateContains(object);
        }
        return this.hasRemovedElements() && this.getRemovedElements().contains(object);
    }

    public boolean relMaintAdd(Object object) {
        return this.privateAdd(object);
    }

    public boolean privateAdd(Object object) {
        return super.add(object);
    }

    public boolean relMaintRemove(Object object) {
        return this.privateRemove(object);
    }

    public boolean privateRemove(Object object) {
        return super.remove(object);
    }

    protected void checkParameter(Object object, String string) {
        if (this.getOwner() != null) {
            if (CmpEnvironment.getEnv().shouldCheckCollectionParameters() && object != null && !this.getCollectionType().isInstance(object)) {
                throw EJBExceptionFactory.invalidCollectionParameterType(object, this.getCollectionType().getName());
            }
            this.getOwner().getPersistenceManagerTopLink().checkIfParameterRemoved(object, string);
        }
    }

    protected void checkReadOnly(String string) {
    }

    protected Class getCollectionType() {
        return this.collectionType;
    }

    public void storeOriginatingTransaction() {
        if (CmpEnvironment.getEnv().shouldCheckCollectionTransaction() && this.owner != null && this.owner.isWorkingCopyCloneTopLink() && this.getOriginatingTransaction() == null) {
            this.transaction = this.getCurrentTransaction();
        }
    }

    protected void checkTransaction() {
        if (CmpEnvironment.getEnv().shouldCheckCollectionTransaction() && this.owner != null && this.owner.isWorkingCopyCloneTopLink() && (this.getOriginatingTransaction() == null || this.getOriginatingTransaction() != this.getCurrentTransaction())) {
            throw EJBExceptionFactory.invalidTransactionState();
        }
    }

    protected Transaction getCurrentTransaction() {
        try {
            return CmpEnvironment.getEnv().getTransactionManager().getTransaction();
        }
        catch (Exception exception) {
            throw EJBExceptionFactory.errorObtainingTransaction(exception);
        }
    }

    protected Transaction getOriginatingTransaction() {
        return this.transaction;
    }

    public void setOwner(TopLinkCmpEntity topLinkCmpEntity) {
        this.owner = topLinkCmpEntity;
        if (this.owner != null && this.owner.isWorkingCopyCloneTopLink()) {
            this.storeOriginatingTransaction();
        }
    }

    public TopLinkCmpEntity getOwner() {
        return this.owner;
    }

    static /* synthetic */ int access$100(CmrCollectionImpl cmrCollectionImpl) {
        return cmrCollectionImpl.modCount;
    }

    private class CmrIteratorImpl
    implements CmrIterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = CmrCollectionImpl.access$100(CmrCollectionImpl.this);

        private CmrIteratorImpl() {
        }

        public boolean hasNext() {
            CmrCollectionImpl.this.checkTransaction();
            return this.privateHasNext();
        }

        public boolean privateHasNext() {
            return this.cursor != CmrCollectionImpl.this.size();
        }

        public Object next() {
            CmrCollectionImpl.this.checkTransaction();
            return this.privateNext();
        }

        public Object privateNext() {
            try {
                this.checkForComodification();
                Object object = CmrCollectionImpl.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CmrCollectionImpl.this.remove(CmrCollectionImpl.this.get(this.lastRet));
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CmrCollectionImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CmrCollectionImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

