/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.internal.ejb.cmp.NonDeferredUnitOfWork;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.transaction.AbstractTransactionController;

public class UOWManager {
    private static final Class NONDEFERRED_UOW_CLASS = class$oracle$toplink$internal$ejb$cmp$NonDeferredUnitOfWork == null ? (class$oracle$toplink$internal$ejb$cmp$NonDeferredUnitOfWork = UOWManager.class$("oracle.toplink.internal.ejb.cmp.NonDeferredUnitOfWork")) : class$oracle$toplink$internal$ejb$cmp$NonDeferredUnitOfWork;
    protected Boolean hasNonDeferredClasses;
    protected static Hashtable managerTable;
    protected Session session;
    public AbstractTransactionController transactionController;
    static /* synthetic */ Class class$oracle$toplink$internal$ejb$cmp$NonDeferredUnitOfWork;
    static /* synthetic */ Class class$oracle$toplink$threetier$ServerSession;

    protected Session acquireNonSynchronizedClient() {
        AbstractSession abstractSession = null;
        if (this.getSession().getClass() == (class$oracle$toplink$threetier$ServerSession == null ? (class$oracle$toplink$threetier$ServerSession = UOWManager.class$("oracle.toplink.threetier.ServerSession")) : class$oracle$toplink$threetier$ServerSession)) {
            ServerSession serverSession = (ServerSession)this.getSession();
            abstractSession = serverSession.acquireClientSession();
        } else {
            SessionBroker sessionBroker = (SessionBroker)this.getSession();
            abstractSession = sessionBroker.acquireClientSessionBroker();
        }
        abstractSession.setExternalTransactionController(null);
        return abstractSession;
    }

    public UnitOfWork acquireNonSynchronizedUnitOfWork() {
        Session session = this.acquireNonSynchronizedClient();
        if (this.hasNonDeferredClasses()) {
            return this.buildNonDeferredUnitOfWork(session);
        }
        return session.acquireUnitOfWork();
    }

    protected NonDeferredUnitOfWork buildNonDeferredUnitOfWork(Session session) {
        Session session2 = this.session;
        if (session.isServerSession()) {
            session2 = ((ServerSession)session).acquireClientSession();
        } else if (session.isSessionBroker()) {
            session2 = ((SessionBroker)session).acquireClientSessionBroker();
        }
        NonDeferredUnitOfWork nonDeferredUnitOfWork = new NonDeferredUnitOfWork(session2);
        nonDeferredUnitOfWork.setUseOldCommit(session.usesOldCommit());
        if (session.shouldLog(2, "transaction")) {
            session.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(nonDeferredUnitOfWork)));
        }
        return nonDeferredUnitOfWork;
    }

    protected void clearForRedployment() {
        Hashtable hashtable = this.getTransactionController().getUnitsOfWork();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            UnitOfWork unitOfWork = (UnitOfWork)hashtable.get(enumeration.nextElement());
            unitOfWork.release();
        }
        this.setSession(null);
    }

    public UnitOfWork getActiveUnitOfWork() {
        return this.getTransactionController().lookupActiveUnitOfWork();
    }

    public static UOWManager getOrCreateManager(String string, Session session) {
        UOWManager uOWManager = null;
        if (managerTable == null) {
            managerTable = new Hashtable();
        }
        if ((uOWManager = (UOWManager)managerTable.get(string)) == null) {
            uOWManager = new UOWManager();
            uOWManager.setSession(session);
            uOWManager.setTransactionController((AbstractTransactionController)session.getExternalTransactionController());
            managerTable.put(string, uOWManager);
        }
        return uOWManager;
    }

    public static UOWManager getManagerForName(String string) {
        UOWManager uOWManager = null;
        if (managerTable == null) {
            throw DeploymentException.noSuchProjectIdentifier(string);
        }
        uOWManager = (UOWManager)managerTable.get(string);
        if (uOWManager == null) {
            throw DeploymentException.noSuchProjectIdentifier(string);
        }
        return uOWManager;
    }

    public UnitOfWork getOrCreateActiveUnitOfWork() {
        UnitOfWork unitOfWork = null;
        if (!this.hasNonDeferredClasses()) {
            unitOfWork = this.getTransactionController().getActiveUnitOfWork();
        } else {
            unitOfWork = this.getTransactionController().lookupActiveUnitOfWork();
            if (unitOfWork != null) {
                if (!unitOfWork.getClass().equals(NONDEFERRED_UOW_CLASS)) {
                    NonDeferredUnitOfWork nonDeferredUnitOfWork = this.buildNonDeferredUnitOfWork(this.getSession());
                    Enumeration enumeration = unitOfWork.getCloneMapping().keys();
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        nonDeferredUnitOfWork.mergeCloneWithReferences(e);
                        nonDeferredUnitOfWork.markObjectForUpdate(e, null);
                    }
                    this.getTransactionController().addUnitOfWork(this.getTransactionController().getTransaction(), nonDeferredUnitOfWork);
                    unitOfWork.getCloneMapping().clear();
                    unitOfWork.getNewObjectsCloneToOriginal().clear();
                    unitOfWork.getNewObjectsOriginalToClone().clear();
                    unitOfWork = nonDeferredUnitOfWork;
                }
            } else {
                unitOfWork = this.buildNonDeferredUnitOfWork(this.getSession());
                this.getTransactionController().addUnitOfWork(this.getTransactionController().getTransaction(), unitOfWork);
            }
        }
        unitOfWork.setShouldNewObjectsBeCached(true);
        UnitOfWork.setSmartMerge(true);
        return unitOfWork;
    }

    public Session getSession() {
        return this.session;
    }

    protected AbstractTransactionController getTransactionController() {
        return this.transactionController;
    }

    public boolean hasNonDeferredClasses() {
        if (this.hasNonDeferredClasses == null) {
            this.hasNonDeferredClasses = new Boolean(false);
            Iterator iterator = this.getSession().getDescriptors().values().iterator();
            while (iterator.hasNext()) {
                Descriptor descriptor = (Descriptor)iterator.next();
                if (descriptor.getCMPPolicy() == null || descriptor.getCMPPolicy().getDeferModificationsUntilCommit() == 2) continue;
                this.hasNonDeferredClasses = new Boolean(true);
                break;
            }
        }
        return this.hasNonDeferredClasses;
    }

    public void incrementCallDepthIfRequired(UnitOfWork unitOfWork) {
        if (this.hasNonDeferredClasses()) {
            ((NonDeferredUnitOfWork)unitOfWork).incrementCallStackDepth();
        }
    }

    public void markObjectForUpdateIfRequired(Object object, UnitOfWork unitOfWork) {
        if (this.hasNonDeferredClasses() && unitOfWork != null) {
            ((NonDeferredUnitOfWork)unitOfWork).markObjectForUpdate(object, null);
        }
    }

    public static void resetManagerFor(String string) {
        UOWManager uOWManager = null;
        if (managerTable == null) {
            return;
        }
        uOWManager = (UOWManager)managerTable.get(string);
        if (uOWManager != null) {
            uOWManager.clearForRedployment();
            managerTable.remove(string);
        }
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void setTransactionController(AbstractTransactionController abstractTransactionController) {
        this.transactionController = abstractTransactionController;
    }

    public void writeChangesIfRequired() {
        if (this.hasNonDeferredClasses()) {
            this.writeChangesIfRequired(this.getTransactionController().getActiveUnitOfWork());
        }
    }

    public void writeChangesIfRequired(UnitOfWork unitOfWork) {
        if (this.hasNonDeferredClasses() && unitOfWork != null) {
            ((NonDeferredUnitOfWork)unitOfWork).writeChanges();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

