/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.PersistenceManagerBase;
import oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public abstract class EJBFactory {
    protected PersistenceManagerBase persistenceManager = null;
    protected Class primaryKeyClass;
    protected Field[] primaryKeyFields;
    protected Field[] ejbPrimaryKeyFields;
    protected boolean hasCustomPrimaryKey;
    protected EntityDescriptor entityDescriptor;

    public EJBFactory(PersistenceManagerBase persistenceManagerBase, EntityDescriptor entityDescriptor) {
        this.setPersistenceManager(persistenceManagerBase);
        this.setPrimaryKeyClass(entityDescriptor.getPrimaryKeyClass());
        this.setHasCustomPrimaryKey(entityDescriptor.getPrimaryKeyField() == null && !entityDescriptor.hasUnknownPrimaryKey());
        this.setEntityDescriptor(entityDescriptor);
    }

    public abstract EntityContext allocateContextIfRequired(TopLinkCmpEntity var1, EJBObject var2);

    public abstract EntityContext allocateContextIfRequired(TopLinkCmpEntity var1, EJBLocalObject var2);

    public abstract EJBObject allocateEJBObject(Object var1, TopLinkCmpEntity var2);

    public abstract EJBLocalObject allocateEJBLocalObject(Object var1, TopLinkCmpEntity var2);

    public TopLinkCmpEntity createBean() {
        TopLinkCmpEntity topLinkCmpEntity = null;
        try {
            topLinkCmpEntity = (TopLinkCmpEntity)PrivilegedAccessController.newInstanceFromClass(this.getEntityDescriptor().getConcreteBeanClass());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw EJBExceptionFactory.errorAccessingBean(this.getEntityDescriptor().getBeanName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw EJBExceptionFactory.errorAccessingBean(this.getEntityDescriptor().getBeanName(), instantiationException);
        }
        this.setPersistenceManagerOn(topLinkCmpEntity);
        return topLinkCmpEntity;
    }

    public void releaseBean(TopLinkCmpEntity topLinkCmpEntity) {
    }

    public void setPersistenceManagerOn(TopLinkCmpEntity topLinkCmpEntity) {
        topLinkCmpEntity.setPersistenceManagerTopLink(this.getPersistenceManager());
    }

    public TopLinkCmpEntity createBeanUsingKey(Object object) {
        return this.copyKeyIntoBean(object, this.createBean());
    }

    public TopLinkCmpEntity copyKeyIntoBean(Object object, TopLinkCmpEntity topLinkCmpEntity) {
        try {
            if (this.hasCustomPrimaryKey()) {
                Field[] fieldArray = this.getPrimaryKeyFields();
                Field[] fieldArray2 = this.getEjbPrimaryKeyFields();
                for (int i = 0; i < fieldArray2.length; ++i) {
                    fieldArray2[i].set(topLinkCmpEntity, fieldArray[i].get(object));
                }
            } else {
                this.getEjbPrimaryKeyFields()[0].set(topLinkCmpEntity, object);
            }
            return topLinkCmpEntity;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw EJBExceptionFactory.errorUsingPrimaryKey(this.getEntityDescriptor().getBeanName(), illegalAccessException);
        }
    }

    public void setPKInReadOnlyBean(TopLinkCmpEntity topLinkCmpEntity) {
    }

    public Vector createPkVectorFromKey(Object object) {
        Vector<Object> vector;
        Session session = this.getPersistenceManager().getSession();
        Descriptor descriptor = this.getPersistenceManager().getDescriptor();
        if (descriptor.hasSimplePrimaryKey()) {
            try {
                int n;
                Object object2;
                if (this.hasCustomPrimaryKey()) {
                    object2 = this.getPrimaryKeyFields();
                    vector = new Vector<Object>(((Field[])object2).length);
                    for (n = 0; n < ((Field[])object2).length; ++n) {
                        vector.add(((Field)object2[n]).get(object));
                    }
                } else {
                    vector = new Vector<Object>(1);
                    vector.add(object);
                }
                object2 = descriptor.getObjectBuilder().getPrimaryKeyMappings();
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)((Vector)object2).get(n);
                    Object object3 = abstractDirectMapping.getFieldValue(vector.get(n), session);
                    vector.set(n, object3);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EJBExceptionFactory.errorUsingPrimaryKey(this.getEntityDescriptor().getBeanName(), illegalAccessException);
            }
        } else {
            TopLinkCmpEntity topLinkCmpEntity = this.createBeanUsingKey(object);
            vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(topLinkCmpEntity, session);
        }
        return vector;
    }

    public Object createKeyFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Vector vector) {
        Session session = this.getPersistenceManager().getSession();
        Descriptor descriptor = this.getPersistenceManager().getDescriptor();
        if (descriptor.hasSimplePrimaryKey()) {
            try {
                if (this.hasCustomPrimaryKey()) {
                    Object object = PrivilegedAccessController.newInstanceFromClass(this.getPrimaryKeyClass());
                    Field[] fieldArray = this.getPrimaryKeyFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        fieldArray[i].set(object, vector.get(i));
                    }
                    return object;
                }
                return vector.get(0);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EJBExceptionFactory.errorUsingPrimaryKey(this.getEntityDescriptor().getBeanName(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw EJBExceptionFactory.errorAccessingBean(this.getEntityDescriptor().getBeanName(), instantiationException);
            }
        }
        TopLinkCmpEntity topLinkCmpEntity = (TopLinkCmpEntity)descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildPrimaryKeyAttributesIntoObject(topLinkCmpEntity, databaseRow, objectLevelReadQuery);
        return this.createKeyUsingBean(topLinkCmpEntity);
    }

    public Object createKeyUsingBean(TopLinkCmpEntity topLinkCmpEntity) {
        Object object = topLinkCmpEntity.getPrimaryKeyTopLink();
        if (object == null) {
            object = this.refreshKeyUsingBean(topLinkCmpEntity);
        }
        return object;
    }

    public Object refreshKeyUsingBean(TopLinkCmpEntity topLinkCmpEntity) {
        try {
            Object object = null;
            if (this.hasCustomPrimaryKey()) {
                object = PrivilegedAccessController.newInstanceFromClass(this.getPrimaryKeyClass());
                Field[] fieldArray = this.getPrimaryKeyFields();
                Field[] fieldArray2 = this.getEjbPrimaryKeyFields();
                for (int i = 0; i < fieldArray2.length; ++i) {
                    fieldArray[i].set(object, fieldArray2[i].get(topLinkCmpEntity));
                }
            } else {
                object = this.getEjbPrimaryKeyFields()[0].get(topLinkCmpEntity);
            }
            topLinkCmpEntity.setPrimaryKeyTopLink(object);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw EJBExceptionFactory.errorUsingPrimaryKey(this.getEntityDescriptor().getBeanName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw EJBExceptionFactory.errorAccessingBean(this.getEntityDescriptor().getBeanName(), instantiationException);
        }
    }

    protected PersistenceManagerBase getPersistenceManager() {
        return this.persistenceManager;
    }

    public abstract EJBObject getEJBObjectFor(TopLinkCmpEntity var1);

    public abstract EJBLocalObject getEJBLocalObjectFor(TopLinkCmpEntity var1);

    protected synchronized Field[] getEjbPrimaryKeyFields() {
        if (this.ejbPrimaryKeyFields == null) {
            this.initializePrimaryKeyFields();
        }
        return this.ejbPrimaryKeyFields;
    }

    protected Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    protected synchronized Field[] getPrimaryKeyFields() {
        if (this.primaryKeyFields == null) {
            this.initializePrimaryKeyFields();
        }
        return this.primaryKeyFields;
    }

    public boolean hasCustomPrimaryKey() {
        return this.hasCustomPrimaryKey;
    }

    protected void initializePrimaryKeyFields() {
        EntityDescriptor entityDescriptor = this.getEntityDescriptor();
        try {
            Class clazz = entityDescriptor.getPrimaryKeyClass();
            Class clazz2 = entityDescriptor.getConcreteBeanClass();
            Collection collection = this.getPrimaryKeyFieldNames();
            int n = collection.size();
            Field[] fieldArray = new Field[n];
            Field[] fieldArray2 = new Field[n];
            Iterator iterator = collection.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.hasCustomPrimaryKey()) {
                    fieldArray[n2] = PrivilegedAccessController.getDeclaredField(clazz, string, false);
                }
                fieldArray2[n2] = PrivilegedAccessController.getDeclaredField(clazz2, string, false);
                ++n2;
            }
            this.setPrimaryKeyFields(fieldArray);
            this.setEjbPrimaryKeyFields(fieldArray2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw EJBExceptionFactory.errorUsingPrimaryKey(entityDescriptor.getBeanName(), noSuchFieldException);
        }
    }

    private Field getFieldNamed(String string, Field[] fieldArray) {
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string)) continue;
            return fieldArray[i];
        }
        return null;
    }

    private Collection getPrimaryKeyFieldNames() {
        EntityDescriptor entityDescriptor = this.getEntityDescriptor();
        Vector<String> vector = new Vector<String>();
        if (this.hasCustomPrimaryKey()) {
            Descriptor descriptor = this.getPersistenceManager().getDescriptor();
            if (descriptor.hasSimplePrimaryKey()) {
                Vector vector2 = descriptor.getObjectBuilder().getPrimaryKeyMappings();
                for (int i = 0; i < vector2.size(); ++i) {
                    DatabaseMapping databaseMapping = (DatabaseMapping)vector2.get(i);
                    vector.add(databaseMapping.getAttributeName());
                }
            } else {
                Class clazz = entityDescriptor.getPrimaryKeyClass();
                Field[] fieldArray = PrivilegedAccessController.getFields(clazz);
                for (int i = 0; i < fieldArray.length; ++i) {
                    String string = fieldArray[i].getName();
                    if (string.equalsIgnoreCase("_someRejectedName")) continue;
                    vector.add(string);
                }
            }
        } else if (entityDescriptor.hasUnknownPrimaryKey()) {
            vector.add("tl_unknown_pk");
        } else {
            vector.add(entityDescriptor.getPrimaryKeyField().getName());
        }
        return vector;
    }

    protected void setPersistenceManager(PersistenceManagerBase persistenceManagerBase) {
        this.persistenceManager = persistenceManagerBase;
    }

    protected void setEjbPrimaryKeyFields(Field[] fieldArray) {
        this.ejbPrimaryKeyFields = fieldArray;
    }

    protected void setHasCustomPrimaryKey(boolean bl) {
        this.hasCustomPrimaryKey = bl;
    }

    protected void setPrimaryKeyClass(Class clazz) {
        this.primaryKeyClass = clazz;
    }

    protected void setPrimaryKeyFields(Field[] fieldArray) {
        this.primaryKeyFields = fieldArray;
    }

    public void setEntityDescriptor(EntityDescriptor entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }
}

