/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.internal.ejb.cmp.CmpEnvironment;
import oracle.toplink.internal.ejb.cmp.api.CmpDom;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.sessions.Project;
import oracle.toplink.tools.workbench.XMLProjectReader;

public class CmpProjectReader {
    protected CmpDom cmpDom;
    protected InputStream inputStream;
    protected ClassLoader jarLoader;
    private static final String META_INF = "META-INF";

    public CmpProjectReader(InputStream inputStream, CmpDom cmpDom, ClassLoader classLoader) {
        this(cmpDom, classLoader);
        this.inputStream = inputStream;
    }

    public CmpProjectReader(CmpDom cmpDom, ClassLoader classLoader) {
        this.cmpDom = cmpDom;
        this.jarLoader = classLoader;
    }

    public Project readProject() {
        String string = this.getCmpDom().getProjectFileName();
        String string2 = this.getCmpDom().getProjectClass();
        Project project = null;
        if (string2 == null && string == null) {
            throw DeploymentException.noProjectSpecified();
        }
        try {
            if (string2 != null) {
                return (Project)PrivilegedAccessController.newInstanceFromClass(this.getJarLoader().loadClass(string2));
            }
            InputStream inputStream = this.getInputStream(string);
            project = inputStream != null ? XMLProjectReader.read(new InputStreamReader(inputStream), this.getJarLoader()) : XMLProjectReader.read(this.getFilePath(this.getTopLinkHomeDir(), string), this.getJarLoader());
            if (project == null) {
                throw new FileNotFoundException(string);
            }
        }
        catch (Exception exception) {
            throw DeploymentException.errorCreatingProject(exception);
        }
        return project;
    }

    private InputStream getInputStream(String string) {
        InputStream inputStream = this.inputStream;
        if (inputStream == null) {
            inputStream = this.getJarLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = this.getJarLoader().getResourceAsStream(META_INF + File.separator + string);
        }
        if (inputStream == null) {
            inputStream = this.getJarLoader().getResourceAsStream("META-INF/" + string);
        }
        return inputStream;
    }

    protected ClassLoader getJarLoader() {
        return this.jarLoader;
    }

    protected String getFilePath(String string, String string2) {
        File file = new File(string2);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(string, string2).getAbsolutePath();
    }

    public String getTopLinkHomeDir() {
        return CmpEnvironment.getEnv().getTopLinkHomeDir();
    }

    protected CmpDom getCmpDom() {
        return this.cmpDom;
    }
}

