/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.cobol.helper;

import java.io.StringWriter;
import oracle.toplink.internal.eis.cobol.ByteArrayException;
import oracle.toplink.internal.eis.cobol.FieldMetaData;
import oracle.toplink.internal.eis.cobol.helper.Helper;

public class ByteConverter {
    private byte[] myRecordData;
    FieldMetaData myFieldMetaData;
    public static int wordSize = 2;
    private boolean isLittleEndian;

    public ByteConverter() {
        this.initialize();
    }

    public ByteConverter(FieldMetaData fieldMetaData, byte[] byArray) {
        this.initialize(fieldMetaData, byArray);
    }

    protected void initialize() {
        this.isLittleEndian = false;
    }

    protected void initialize(FieldMetaData fieldMetaData, byte[] byArray) {
        this.myFieldMetaData = fieldMetaData;
        this.myRecordData = byArray;
        this.isLittleEndian = false;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void setIsLittleEndian(boolean bl) {
        this.isLittleEndian = bl;
    }

    public int getWordSize() {
        return wordSize;
    }

    public void setWordSize(int n) {
        wordSize = n;
    }

    protected String insertDecimalInString(String string) {
        int n;
        if (this.getFieldMetaData().hasDecimal() && (n = this.getFieldMetaData().getDecimalPosition()) < string.length()) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(string.substring(0, n - 1));
            stringWriter.write(".");
            stringWriter.write(string.substring(n - 1));
            return stringWriter.toString();
        }
        return string;
    }

    protected String removeDecimalInString(String string) {
        int n;
        if (this.getFieldMetaData().hasDecimal() && (n = this.getFieldMetaData().getDecimalPosition()) < string.length()) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(string.substring(0, n - 1));
            stringWriter.write(string.substring(n));
            return stringWriter.toString();
        }
        return string;
    }

    public String getStringValue() {
        int n = this.getFieldMetaData().getOffset();
        String string = new String();
        if (this.getFieldMetaData().getType() != 5 && this.getFieldMetaData().getType() != 6 && this.getFieldMetaData().getType() != 7) {
            int n2;
            for (n2 = 0; n2 < this.getFieldMetaData().getSize() && this.getRecordData()[n + n2] != 0; ++n2) {
            }
            string = new String(this.getRecordData(), n, n2);
        } else if (this.getFieldMetaData().getType() == 5) {
            if (this.isLittleEndian()) {
                this.swapEndians(n, this.getFieldMetaData().getSize());
            }
            string = this.getStringFromBinaryData(n, this.getFieldMetaData().getSize());
        } else {
            string = this.getFieldMetaData().getType() == 7 ? this.getStringValueFromPackedDecimal() : null;
        }
        return this.insertDecimalInString(string);
    }

    public void setBytesToValue(String string) {
        string = this.removeDecimalInString(string);
        if (this.getFieldMetaData().getType() != 5 && this.getFieldMetaData().getType() != 6 && this.getFieldMetaData().getType() != 7) {
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > this.getFieldMetaData().getSize()) {
                n = this.getFieldMetaData().getSize();
            }
            int n2 = 0;
            int n3 = this.getFieldMetaData().getOffset();
            while (n2 < n) {
                this.getRecordData()[n3] = byArray[n2];
                ++n2;
                ++n3;
            }
            if (n < this.getFieldMetaData().getSize()) {
                this.getRecordData()[n3] = 0;
            }
        } else if (this.getFieldMetaData().getType() == 5) {
            this.setBinaryDataToStringValue(string, this.getFieldMetaData().getOffset(), this.getFieldMetaData().getSize());
        } else if (this.getFieldMetaData().getType() == 7) {
            this.setByteArrayToPackedDecimalValue(string);
        }
    }

    public FieldMetaData getFieldMetaData() {
        return this.myFieldMetaData;
    }

    public void setFieldMetaData(FieldMetaData fieldMetaData) {
        this.myFieldMetaData = fieldMetaData;
    }

    public byte[] getRecordData() {
        return this.myRecordData;
    }

    public void setRecordData(byte[] byArray) {
        this.myRecordData = byArray;
    }

    protected String getStringValueFromPackedDecimal() {
        int n = 240;
        boolean bl = this.getFieldMetaData().isSigned();
        String string = new String();
        int n2 = this.getFieldMetaData().getOffset();
        int n3 = this.getFieldMetaData().getSize();
        String string2 = new String();
        int n4 = 0;
        if (bl) {
            byte by = (byte)(this.myRecordData[n2 + n3 - 1] | n);
            if (by == 13) {
                string = "-";
            } else if (by == 12) {
                string = "+";
            }
        }
        for (int i = n2; i < n2 + n3; ++i) {
            String string3 = Integer.toHexString(Helper.intFromByte(this.myRecordData[i]));
            if (string3.length() > 2) {
                string3 = string3.substring(string3.length() - 2);
            }
            string2 = string2 + string3;
        }
        while (string2.charAt(n4) == '0') {
            ++n4;
        }
        string2 = string2.substring(n4, string2.length() - 1);
        if (bl) {
            return string + string2;
        }
        return string2;
    }

    protected void setByteArrayToPackedDecimalValue(String string) {
        int n = this.getFieldMetaData().getSize();
        int n2 = this.getFieldMetaData().getOffset();
        boolean bl = this.getFieldMetaData().isSigned();
        if (bl) {
            string = string.startsWith("-") ? string + "d" : string + "c";
            string = string.substring(1);
        } else {
            string = string + "f";
        }
        while (string.length() < n * 2) {
            string = "0" + string;
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 < n2 + n) {
            this.myRecordData[n3] = Helper.byteFromInt(Helper.intFromHexString(string.substring(n4, n4 + 2)));
            ++n3;
            n4 += 2;
        }
    }

    protected void swapEndians(int n, int n2) {
        if (wordSize > 0 && wordSize % 2 == 0) {
            int n3;
            int n4 = n2 - n;
            int n5 = n2;
            if (n4 % wordSize != 0) {
                n3 = n4 % wordSize;
                n5 = n2 - n3;
            }
            n3 = wordSize / 2;
            for (int i = n; i < n5; i += wordSize) {
                for (int j = 0; j < n3; ++j) {
                    byte by;
                    byte by2 = this.myRecordData[i + j];
                    this.myRecordData[i + j] = by = this.myRecordData[i + j + n3];
                    this.myRecordData[i + j + n3] = by2;
                }
            }
        } else {
            throw ByteArrayException.unrecognizedDataType();
        }
    }

    protected void twosComplement(int n, int n2) {
        int n3;
        int n4 = 255;
        for (n3 = n; n3 < n + n2; ++n3) {
            this.myRecordData[n3] = Helper.byteFromInt(~Helper.intFromByte(this.myRecordData[n3]));
        }
        --n3;
        while (n3 >= n && Helper.intFromByte(this.myRecordData[n3]) == -1) {
            int n5 = n3--;
            this.myRecordData[n5] = (byte)(this.myRecordData[n5] + 1);
        }
        if (n3 >= n) {
            int n6 = n3;
            this.myRecordData[n6] = (byte)(this.myRecordData[n6] + 1);
        }
    }

    protected String getStringFromBinaryData(int n, int n2) {
        int n3;
        int n4;
        boolean bl = this.getFieldMetaData().isSigned();
        String string = new String();
        int n5 = 0;
        if (bl) {
            n4 = this.myRecordData[n];
            n3 = 255;
            if ((n4 >> 3 & n3) == 255) {
                string = "-";
                this.twosComplement(n, n2);
            } else {
                string = "+";
            }
        }
        n3 = n + n2 - 1;
        n4 = 0;
        while (n3 >= n) {
            if (Helper.intFromByte(this.myRecordData[n3]) < 0) {
                int n6 = n3;
                this.myRecordData[n6] = (byte)(this.myRecordData[n6] & 0x7F);
                n5 += Helper.power(2, (n4 + 1) * 8 - 1);
            }
            n5 += Helper.intFromByte(this.myRecordData[n3]) * Helper.power(2, n4 * 8);
            --n3;
            ++n4;
        }
        if (bl) {
            return string + String.valueOf(n5);
        }
        return String.valueOf(n5);
    }

    protected void setBinaryDataToStringValue(String string, int n, int n2) {
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            string = string.substring(1);
        } else if (string.startsWith("+")) {
            string = string.substring(1);
        }
        int n3 = Helper.integerFromString(string);
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 < n2 + n) {
            this.myRecordData[n4] = Helper.byteFromInt(n3 / Helper.power(2, n5 * 8));
            n3 %= Helper.power(2, n5 * 8);
            ++n4;
            --n5;
        }
        if (bl) {
            this.twosComplement(n, n2);
        }
    }
}

