/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.adapters.xmlfile;

import java.io.File;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import oracle.toplink.eis.EISDOMRecord;
import oracle.toplink.eis.EISException;
import oracle.toplink.internal.eis.adapters.xmlfile.XMLFileConnection;
import oracle.toplink.internal.eis.adapters.xmlfile.XMLFileInteractionSpec;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.ox.XMLField;

public class XMLFileInteraction
implements Interaction {
    protected XMLFileConnection connection;

    public XMLFileInteraction(XMLFileConnection xMLFileConnection) {
        this.connection = xMLFileConnection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        boolean bl = false;
        if (!this.connection.getXMLFileTransaction().isInTransaction()) {
            bl = true;
            this.connection.getXMLFileTransaction().begin();
        }
        try {
            XMLFileInteractionSpec xMLFileInteractionSpec = (XMLFileInteractionSpec)interactionSpec;
            File file = new File(this.connection.getConnectionSpec().getDirectory() + "/" + xMLFileInteractionSpec.getFileName());
            if (xMLFileInteractionSpec.getInteractionType() == 1) {
                bl = false;
                Record record2 = this.executeRead(xMLFileInteractionSpec, file);
                return record2;
            }
            if (xMLFileInteractionSpec.getInteractionType() == 0) {
                Record record3 = this.executeInsert(xMLFileInteractionSpec, file, (EISDOMRecord)record);
                return record3;
            }
            if (xMLFileInteractionSpec.getInteractionType() == 2) {
                Record record4 = this.executeUpdate(xMLFileInteractionSpec, file, (EISDOMRecord)record);
                return record4;
            }
            if (xMLFileInteractionSpec.getInteractionType() == 3) {
                Record record5 = this.executeDelete(xMLFileInteractionSpec, file);
                return record5;
            }
            Record record6 = null;
            return record6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ResourceException(exception.toString());
        }
        finally {
            if (bl) {
                this.connection.getXMLFileTransaction().commit();
            }
        }
    }

    public Record executeRead(XMLFileInteractionSpec xMLFileInteractionSpec, File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        EISDOMRecord eISDOMRecord = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
        if (xMLFileInteractionSpec.getXPath() != null) {
            Object object = eISDOMRecord.getValues(this.buildField(xMLFileInteractionSpec));
            EISDOMRecord eISDOMRecord2 = new EISDOMRecord();
            if (object instanceof List) {
                List list = (List)object;
                eISDOMRecord2.setDOM(eISDOMRecord2.createNewDocument("results"));
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        eISDOMRecord2.add(new DatabaseField("result"), list.get(i));
                    }
                }
            } else {
                eISDOMRecord2.setDOM(eISDOMRecord2.createNewDocument("results"));
                eISDOMRecord2.add(new DatabaseField("result"), object);
            }
            return eISDOMRecord2;
        }
        return eISDOMRecord;
    }

    public Record executeInsert(XMLFileInteractionSpec xMLFileInteractionSpec, File file, EISDOMRecord eISDOMRecord) throws Exception {
        EISDOMRecord eISDOMRecord2 = eISDOMRecord;
        if (xMLFileInteractionSpec.getXPath() != null) {
            eISDOMRecord2 = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            eISDOMRecord2.add(this.buildField(xMLFileInteractionSpec), eISDOMRecord);
        }
        return null;
    }

    public Record executeUpdate(XMLFileInteractionSpec xMLFileInteractionSpec, File file, EISDOMRecord eISDOMRecord) throws Exception {
        if (!file.exists()) {
            return null;
        }
        EISDOMRecord eISDOMRecord2 = eISDOMRecord;
        if (xMLFileInteractionSpec.getXPath() != null) {
            eISDOMRecord2 = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            eISDOMRecord2.put(this.buildField(xMLFileInteractionSpec), (Object)eISDOMRecord);
        }
        return null;
    }

    public Record executeDelete(XMLFileInteractionSpec xMLFileInteractionSpec, File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        if (xMLFileInteractionSpec.getXPath() != null) {
            EISDOMRecord eISDOMRecord = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            eISDOMRecord.remove(this.buildField(xMLFileInteractionSpec));
        } else {
            boolean bl = file.delete();
            if (!bl) {
                throw EISException.couldNotDeleteFile(new Object[]{file});
            }
        }
        return null;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        EISDOMRecord eISDOMRecord = (EISDOMRecord)this.execute(interactionSpec, record);
        if (eISDOMRecord == null) {
            return false;
        }
        ((EISDOMRecord)record2).setDOM(eISDOMRecord.getDOM());
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    protected DatabaseField buildField(XMLFileInteractionSpec xMLFileInteractionSpec) {
        XMLField xMLField = new XMLField(xMLFileInteractionSpec.getXPath());
        xMLField.setNamespaceResolver(xMLFileInteractionSpec.getNamespaceResolver());
        return xMLField;
    }
}

