/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.adapters.jms;

import javax.jms.Connection;
import javax.jms.Session;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import oracle.toplink.eis.EISException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.eis.adapters.jms.CciJMSConnectionMetaData;
import oracle.toplink.internal.eis.adapters.jms.CciJMSConnectionSpec;
import oracle.toplink.internal.eis.adapters.jms.CciJMSInteraction;
import oracle.toplink.internal.eis.adapters.jms.CciJMSTransaction;

public class CciJMSConnection
implements javax.resource.cci.Connection {
    protected Connection connection;
    protected CciJMSConnectionSpec connectionSpec;
    protected Session session;
    protected CciJMSTransaction transaction;

    public CciJMSConnection(Session session, Connection connection, CciJMSConnectionSpec cciJMSConnectionSpec) {
        this.session = session;
        this.connection = connection;
        this.connectionSpec = cciJMSConnectionSpec;
        this.transaction = new CciJMSTransaction(this);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public void close() throws EISException {
        try {
            this.getSession().close();
            this.getConnection().close();
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
    }

    public Interaction createInteraction() {
        return new CciJMSInteraction(this);
    }

    public CciJMSConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public LocalTransaction getLocalTransaction() {
        return this.transaction;
    }

    public CciJMSTransaction getJMSTransaction() {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() {
        return new CciJMSConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() {
        throw ValidationException.operationNotSupported("getResultSetInfo");
    }
}

