/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.descriptors.TopLinkEntity;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.DeferredLockManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.helper.TopLinkIdentityHashSet;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.sessions.AggregateObjectChangeSet;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.OneToOneMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEvent;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.querykeys.DirectQueryKey;
import oracle.toplink.querykeys.QueryKey;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public class ObjectBuilder
implements Cloneable,
Serializable {
    protected Descriptor descriptor;
    protected Map mappingsByAttribute;
    protected Map mappingsByField = new HashMap(20);
    protected Map readOnlyMappingsByField = new HashMap(20);
    protected Vector primaryKeyMappings;
    protected Vector primaryKeyClassifications;
    protected transient Vector nonPrimaryKeyMappings;
    protected transient Expression primaryKeyExpression;
    protected Vector joinedAttributes = null;
    protected List cloningMappings;

    public ObjectBuilder(Descriptor descriptor) {
        this.mappingsByAttribute = new HashMap(20);
        this.primaryKeyMappings = NonSynchronizedVector.newInstance(5);
        this.nonPrimaryKeyMappings = NonSynchronizedVector.newInstance(10);
        this.cloningMappings = new ArrayList(10);
        this.descriptor = descriptor;
    }

    public DatabaseRow createRecord() {
        return new DatabaseRecord();
    }

    public DatabaseRow createRecord(int n) {
        return new DatabaseRecord(n);
    }

    public void addPrimaryKeyForNonDefaultTable(DatabaseRow databaseRow) {
        this.addPrimaryKeyForNonDefaultTable(databaseRow, null, null);
    }

    public void addPrimaryKeyForNonDefaultTable(DatabaseRow databaseRow, Object object, Session session) {
        if (!this.getDescriptor().hasMultipleTables()) {
            return;
        }
        Enumeration enumeration = this.getDescriptor().getTables().elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            Map map = (Map)this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(databaseTable);
            if (map == null) continue;
            Iterator iterator = map.keySet().iterator();
            Iterator iterator2 = map.values().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator.next();
                DatabaseField databaseField2 = (DatabaseField)iterator2.next();
                Object object2 = databaseRow.get(databaseField);
                if (object2 == null && !databaseRow.containsKey(databaseField)) {
                    if (object != null) {
                        DatabaseMapping databaseMapping = this.getMappingForField(databaseField2);
                        databaseMapping.writeFromObjectIntoRow(object, databaseRow, session);
                    }
                    databaseRow.put(databaseField, databaseRow.get(databaseField2));
                    continue;
                }
                databaseRow.put(databaseField2, object2);
            }
        }
    }

    public void assignReturnRow(Object object, Session session, DatabaseRow databaseRow) throws DatabaseException {
        session.log(1, "query", "assign_return_row", databaseRow);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSession(session);
        HashSet hashSet = new HashSet(databaseRow.size());
        for (int i = 0; i < databaseRow.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)databaseRow.getFields().elementAt(i);
            this.assignReturnValueForField(object, readObjectQuery, databaseRow, databaseField, hashSet);
        }
    }

    public void assignReturnValueForField(Object object, ReadObjectQuery readObjectQuery, DatabaseRow databaseRow, DatabaseField databaseField, Collection collection) {
        Vector vector;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping != null) {
            this.assignReturnValueToMapping(object, readObjectQuery, databaseRow, databaseField, databaseMapping, collection);
        }
        if ((vector = this.getReadOnlyMappingsForField(databaseField)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                databaseMapping = (DatabaseMapping)vector.elementAt(i);
                this.assignReturnValueToMapping(object, readObjectQuery, databaseRow, databaseField, databaseMapping, collection);
            }
        }
    }

    protected void assignReturnValueToMapping(Object object, ReadObjectQuery readObjectQuery, DatabaseRow databaseRow, DatabaseField databaseField, DatabaseMapping databaseMapping, Collection collection) {
        if (collection.contains(databaseMapping)) {
            return;
        }
        if (databaseMapping.isAggregateObjectMapping()) {
            Object object2 = ((AggregateObjectMapping)databaseMapping).readFromReturnRowIntoObject(databaseRow, object, readObjectQuery, collection);
        } else if (databaseMapping.isTransformationMapping()) {
            Object object3 = ((AbstractTransformationMapping)databaseMapping).readFromReturnRowIntoObject(databaseRow, object, readObjectQuery, collection);
        } else if (databaseMapping.isDirectToFieldMapping()) {
            Object object4 = databaseMapping.readFromRowIntoObject(databaseRow, object, readObjectQuery);
        } else {
            readObjectQuery.getSession().log(1, "query", "field_for_unsupported_mapping_returned", databaseField, this.getDescriptor());
        }
    }

    public Object assignSequenceNumber(Object object, Session session) throws DatabaseException {
        DatabaseField databaseField = this.getDescriptor().getSequenceNumberField();
        Object object2 = this.getBaseValueForField(databaseField, object);
        if (object2 != null && !session.getSequencing().shouldOverrideExistingValue(object.getClass(), object2)) {
            return null;
        }
        Object object3 = session.getSequencing().getNextValue(object.getClass());
        session.log(1, "sequencing", "assign_sequence", object3, object);
        if (object3 == null) {
            return null;
        }
        DatabaseRow databaseRow = this.createRecord(1);
        databaseRow.put(databaseField, object3);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSession(session);
        DatabaseMapping databaseMapping = this.getBaseMappingForField(databaseField);
        Object object4 = this.getParentObjectForField(databaseField, object);
        Object object5 = databaseMapping.readFromRowIntoObject(databaseRow, object4, readObjectQuery);
        return object5;
    }

    public void buildAttributesIntoObject(Object object, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, boolean bl) throws DatabaseException {
        Session session = objectLevelReadQuery.getExecutionSession();
        Vector vector = this.getDescriptor().getMappings();
        boolean bl2 = objectLevelReadQuery.shouldReadAllMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!bl2 && !objectLevelReadQuery.shouldReadMapping(databaseMapping)) continue;
            databaseMapping.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, session);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            oracle.toplink.descriptors.DescriptorEvent descriptorEvent = new oracle.toplink.descriptors.DescriptorEvent(object);
            descriptorEvent.setQuery(objectLevelReadQuery);
            descriptorEvent.setSession(objectLevelReadQuery.getSession());
            descriptorEvent.setRow(databaseRow);
            if (bl) {
                descriptorEvent.setEventCode(9);
            } else {
                descriptorEvent.setEventCode(8);
            }
            this.getDescriptor().getEventManager().executeEvent(descriptorEvent);
        }
    }

    public Object buildBackupClone(Object object, UnitOfWork unitOfWork) {
        Object object2 = this.getDescriptor().getCopyPolicy().buildClone(object, unitOfWork);
        List list = this.getCloningMappings();
        for (int i = 0; i < list.size(); ++i) {
            ((DatabaseMapping)list.get(i)).buildBackupClone(object, object2, unitOfWork);
        }
        return object2;
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, DatabaseRow databaseRow) {
        if (this.getDescriptor().usesOptimisticLocking() && this.getDescriptor().getTables().firstElement().equals(databaseTable)) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildDeleteExpression(databaseTable, this.primaryKeyExpression, databaseRow);
        }
        return this.buildPrimaryKeyExpression(databaseTable);
    }

    public Expression buildExpressionFromExample(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, IdentityHashtable identityHashtable, Session session) {
        if (identityHashtable.containsKey(object)) {
            return null;
        }
        identityHashtable.put(object, object);
        Expression expression2 = null;
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            expression2 = expression2 == null ? databaseMapping.buildExpression(object, queryByExamplePolicy, expression, identityHashtable, session) : expression2.and(databaseMapping.buildExpression(object, queryByExamplePolicy, expression, identityHashtable, session));
        }
        return expression2;
    }

    public Object buildNewInstance() {
        return this.getDescriptor().getInstantiationPolicy().buildNewInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObject(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow) throws DatabaseException, QueryException {
        Object object;
        Session session = objectLevelReadQuery.getSession();
        session.startOperationProfile("object building");
        Vector vector = this.extractPrimaryKeyFromRow(databaseRow, session);
        if (vector == null && !objectLevelReadQuery.hasPartialAttributeExpressions() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            session.endOperationProfile("object building");
            if (objectLevelReadQuery.getProperty("return null if primary key is null") != null) {
                return null;
            }
            throw QueryException.nullPrimaryKeyInBuildingObject(objectLevelReadQuery, databaseRow);
        }
        Descriptor descriptor = this.getDescriptor();
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses()) {
            object = descriptor.getInheritancePolicy().classFromRow(databaseRow, session);
            if ((descriptor = session.getDescriptor((Class)object)) == null && objectLevelReadQuery.hasPartialAttributeExpressions()) {
                descriptor = this.getDescriptor();
            }
            if (descriptor == null) {
                session.endOperationProfile("object building");
                throw QueryException.noDescriptorForClassFromInheritancePolicy(objectLevelReadQuery, (Class)object);
            }
        }
        object = null;
        try {
            if (session.isUnitOfWork()) {
                object = this.buildObjectInUnitOfWork(objectLevelReadQuery, databaseRow, (UnitOfWork)session, vector, descriptor);
            } else {
                object = this.buildObject(objectLevelReadQuery, databaseRow, session, vector, descriptor);
                if (objectLevelReadQuery.shouldCacheQueryResults()) {
                    objectLevelReadQuery.cacheResult(object);
                }
                if (objectLevelReadQuery.shouldUseWrapperPolicy()) {
                    object = descriptor.getObjectBuilder().wrapObject(object, session);
                }
            }
        }
        finally {
            session.endOperationProfile("object building");
        }
        return object;
    }

    protected Object buildObjectInUnitOfWork(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, UnitOfWork unitOfWork, Vector vector, Descriptor descriptor) throws DatabaseException, QueryException {
        if (!descriptor.shouldUseSessionCacheInUnitOfWorkEarlyTransaction() && (unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely() || descriptor.shouldIsolateObjectsInUnitOfWork()) && !unitOfWork.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return descriptor.getObjectBuilder().buildWorkingCopyCloneFromRow(objectLevelReadQuery, databaseRow, unitOfWork, vector);
        }
        return this.buildWorkingCopyCloneNormally(objectLevelReadQuery, databaseRow, unitOfWork, vector, descriptor);
    }

    protected Object buildWorkingCopyCloneNormally(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, UnitOfWork unitOfWork, Vector vector, Descriptor descriptor) throws DatabaseException, QueryException {
        Session session = unitOfWork.getParentIdentityMapSession(objectLevelReadQuery);
        Object object = null;
        Object object2 = null;
        objectLevelReadQuery.setSession(session);
        object = session.isUnitOfWork() ? this.buildObjectInUnitOfWork(objectLevelReadQuery, databaseRow, (UnitOfWork)session, vector, descriptor) : this.buildObject(objectLevelReadQuery, databaseRow, session, vector, descriptor);
        if (objectLevelReadQuery.shouldCacheQueryResults()) {
            objectLevelReadQuery.cacheResult(object);
        }
        objectLevelReadQuery.setSession(unitOfWork);
        object2 = objectLevelReadQuery.registerIndividualResult(object, unitOfWork);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object buildObject(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, Session session, Vector vector, Descriptor descriptor) throws DatabaseException, QueryException {
        CacheKey cacheKey;
        Object object;
        block25: {
            object = null;
            cacheKey = null;
            try {
                block27: {
                    Enumeration enumeration;
                    block33: {
                        int n2;
                        Vector vector2;
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        block29: {
                                            int n;
                                            block26: {
                                                if (objectLevelReadQuery.shouldMaintainCache()) {
                                                    if (!DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS || !descriptor.shouldAcquireCascadedLocks() && !objectLevelReadQuery.hasJoinedAttributes()) {
                                                        cacheKey = session.getIdentityMapAccessorInstance().acquireLock(vector, descriptor.getJavaClass(), descriptor);
                                                        object = cacheKey.getObject();
                                                    } else {
                                                        cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(vector, descriptor.getJavaClass(), descriptor);
                                                        object = cacheKey.getObject();
                                                        for (n = 0; object == null && n < 1000 && cacheKey.getMutex().getActiveThread() != Thread.currentThread(); ++n) {
                                                            cacheKey.releaseDeferredLock();
                                                            try {
                                                                Thread.sleep(10L);
                                                            }
                                                            catch (InterruptedException interruptedException) {
                                                                // empty catch block
                                                            }
                                                            cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(vector, descriptor.getJavaClass(), descriptor);
                                                            object = cacheKey.getObject();
                                                        }
                                                        if (n == 1000) {
                                                            throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getMutex().getActiveThread(), Thread.currentThread());
                                                        }
                                                    }
                                                }
                                                if (object != null) break block26;
                                                object = objectLevelReadQuery.isReadObjectQuery() && ((ReadObjectQuery)objectLevelReadQuery).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)objectLevelReadQuery).getSelectionObject() : descriptor.getObjectBuilder().buildNewInstance();
                                                if (objectLevelReadQuery.shouldMaintainCache()) {
                                                    cacheKey.setObject(object);
                                                    this.copyQueryInfoToCacheKey(cacheKey, objectLevelReadQuery, databaseRow, session, descriptor);
                                                    if (descriptor.hasFetchGroupManager()) {
                                                        descriptor.getFetchGroupManager().setObjectFetchGroup(object, objectLevelReadQuery.getFetchGroup());
                                                    }
                                                }
                                                descriptor.getObjectBuilder().buildAttributesIntoObject(object, databaseRow, objectLevelReadQuery, false);
                                                break block27;
                                            }
                                            if (objectLevelReadQuery.isReadObjectQuery() && ((ReadObjectQuery)objectLevelReadQuery).shouldLoadResultIntoSelectionObject()) {
                                                this.copyInto(object, ((ReadObjectQuery)objectLevelReadQuery).getSelectionObject());
                                                object = ((ReadObjectQuery)objectLevelReadQuery).getSelectionObject();
                                            }
                                            n = descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, objectLevelReadQuery.getExecutionTime());
                                            if (cacheKey.getMutex().getActiveThread() != Thread.currentThread() || !objectLevelReadQuery.shouldRefreshIdentityMapResult() && !descriptor.shouldAlwaysRefreshCache() && n == 0 || cacheKey.getLastUpdatedQueryId() == objectLevelReadQuery.getQueryId() || cacheKey.getMutex().isLockedByMergeManager()) break block28;
                                            if (!descriptor.hasFetchGroupManager() || !descriptor.getFetchGroupManager().isPartialObject(object)) break block29;
                                            this.revertFetchGroupData(object, descriptor, cacheKey, objectLevelReadQuery, databaseRow, session);
                                            break block27;
                                        }
                                        boolean bl = true;
                                        if (descriptor.usesOptimisticLocking()) {
                                            OptimisticLockingPolicy optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy();
                                            Object object2 = optimisticLockingPolicy.getValueToPutInCache(databaseRow, session);
                                            if (descriptor.shouldOnlyRefreshCacheIfNewerVersion() && !(bl = optimisticLockingPolicy.isNewerVersion(databaseRow, object, vector, session))) {
                                                cacheKey.setReadTime(objectLevelReadQuery.getExecutionTime());
                                            }
                                            if (bl) {
                                                cacheKey.setWriteLockValue(object2);
                                            }
                                        }
                                        if (bl) {
                                            cacheKey.setLastUpdatedQueryId(objectLevelReadQuery.getQueryId());
                                            descriptor.getObjectBuilder().buildAttributesIntoObject(object, databaseRow, objectLevelReadQuery, true);
                                            cacheKey.setReadTime(objectLevelReadQuery.getExecutionTime());
                                        }
                                        break block27;
                                    }
                                    if (!descriptor.hasFetchGroupManager() || !descriptor.getFetchGroupManager().isPartialObject(object) || descriptor.getFetchGroupManager().isObjectValidForFetchGroup(object, objectLevelReadQuery.getFetchGroup())) break block30;
                                    descriptor.getObjectBuilder().buildAttributesIntoObject(object, databaseRow, objectLevelReadQuery, false);
                                    descriptor.getFetchGroupManager().unionFetchGroupIntoObject(object, objectLevelReadQuery.getFetchGroup());
                                    break block27;
                                }
                                if (!objectLevelReadQuery.hasJoinedAttributes() || objectLevelReadQuery.getJoinedAttributeExpressions().isEmpty()) break block31;
                                vector2 = objectLevelReadQuery.getJoinedAttributeExpressions();
                                n2 = vector2.size();
                                break block32;
                            }
                            if (!objectLevelReadQuery.isReadAllQuery() || !((ReadAllQuery)objectLevelReadQuery).hasBatchReadAttributes()) break block27;
                            enumeration = ((ReadAllQuery)objectLevelReadQuery).getBatchReadAttributeExpressions().elements();
                            break block33;
                        }
                        for (int i = 0; i < n2; ++i) {
                            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector2.get(i);
                            if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                            DatabaseMapping databaseMapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                            if (databaseMapping == null) {
                                throw ValidationException.missingMappingForAttribute(descriptor, queryKeyExpression.getName(), this.toString());
                            }
                            Object object3 = databaseMapping.getAttributeValueFromObject(object);
                            if (object3 != null && databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).usesIndirection() && ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object3)) continue;
                            databaseMapping.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, objectLevelReadQuery.getExecutionSession());
                        }
                        break block27;
                    }
                    while (enumeration.hasMoreElements()) {
                        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)enumeration.nextElement();
                        if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping databaseMapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                        if (databaseMapping == null) {
                            throw ValidationException.missingMappingForAttribute(descriptor, queryKeyExpression.getName(), this.toString());
                        }
                        Object object4 = databaseMapping.getAttributeValueFromObject(object);
                        if (object4 != null && databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).usesIndirection() && ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4)) continue;
                        databaseMapping.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, objectLevelReadQuery.getExecutionSession());
                    }
                }
                Object var16_23 = null;
                if (!objectLevelReadQuery.shouldMaintainCache() || cacheKey == null) break block25;
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (descriptor.shouldAcquireCascadedLocks() || objectLevelReadQuery.hasJoinedAttributes())) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
            catch (Throwable throwable) {
                Object var16_24 = null;
                if (!objectLevelReadQuery.shouldMaintainCache()) throw throwable;
                if (cacheKey == null) throw throwable;
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (descriptor.shouldAcquireCascadedLocks() || objectLevelReadQuery.hasJoinedAttributes())) {
                    cacheKey.releaseDeferredLock();
                    throw throwable;
                }
                cacheKey.release();
                throw throwable;
            }
        }
        if (!(object instanceof TopLinkEntity)) return object;
        ((TopLinkEntity)object).setCacheKey(cacheKey);
        ((TopLinkEntity)object).setPKVector(vector);
        return object;
    }

    private void revertFetchGroupData(Object object, Descriptor descriptor, CacheKey cacheKey, ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, Session session) {
        descriptor.getFetchGroupManager().reset(object);
        descriptor.getObjectBuilder().buildAttributesIntoObject(object, databaseRow, objectLevelReadQuery, false);
        descriptor.getFetchGroupManager().setObjectFetchGroup(object, objectLevelReadQuery.getFetchGroup());
        descriptor.getFetchGroupManager().setRefreshOnFetchGroupToObject(object, objectLevelReadQuery.shouldRefreshIdentityMapResult() || descriptor.shouldAlwaysRefreshCache());
        cacheKey.setLastUpdatedQueryId(objectLevelReadQuery.getQueryId());
        if (descriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy();
            cacheKey.setWriteLockValue(optimisticLockingPolicy.getValueToPutInCache(databaseRow, session));
        }
        cacheKey.setReadTime(objectLevelReadQuery.getExecutionTime());
        cacheKey.setInvalidationState(0);
    }

    public Object buildObjectsInto(ReadAllQuery readAllQuery, Vector vector, Object object) throws DatabaseException {
        Set set = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRow databaseRow = (DatabaseRow)enumeration.nextElement();
            if (databaseRow == null) continue;
            Object object2 = this.buildObject(readAllQuery, databaseRow);
            if (readAllQuery.isOneToManyJoinQuery()) {
                if (set == null) {
                    set = new TopLinkIdentityHashSet(vector.size());
                }
                if (set.contains(object2)) continue;
                set.add(object2);
                readAllQuery.getContainerPolicy().addInto(object2, object, readAllQuery.getSession());
                continue;
            }
            readAllQuery.getContainerPolicy().addInto(object2, object, readAllQuery.getSession());
        }
        return object;
    }

    public Expression buildPrimaryKeyExpression(DatabaseTable databaseTable) throws DescriptorException {
        if (this.getDescriptor().getTables().firstElement().equals(databaseTable)) {
            return this.getPrimaryKeyExpression();
        }
        Map map = (Map)this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(databaseTable);
        if (map == null) {
            throw DescriptorException.multipleTablePrimaryKeyNotSpecified(this.getDescriptor());
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            expression = expressionBuilder.getField(databaseField).equal(expressionBuilder.getParameter(databaseField)).and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromKeys(Vector vector, Session session) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            Object e = vector.get(i);
            DatabaseField databaseField = (DatabaseField)list.get(i);
            if (e == null) continue;
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(e);
            expression = expression2.and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromObject(Object object, Session session) {
        return this.buildPrimaryKeyExpressionFromKeys(this.extractPrimaryKeyFromObject(object, session), session);
    }

    public DatabaseRow buildRow(Object object, Session session) {
        return this.buildRow(this.createRecord(), object, session);
    }

    public DatabaseRow buildRow(DatabaseRow databaseRow, Object object, Session session) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowForShallowInsert(Object object, Session session) {
        return this.buildRowForShallowInsert(this.createRecord(), object, session);
    }

    public DatabaseRow buildRowForShallowInsert(DatabaseRow databaseRow, Object object, Session session) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRowForShallowInsert(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowWithChangeSet(ObjectChangeSet objectChangeSet, Session session) {
        return this.buildRowWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public DatabaseRow buildRowWithChangeSet(DatabaseRow databaseRow, ObjectChangeSet objectChangeSet, Session session) {
        Enumeration enumeration = objectChangeSet.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            ChangeRecord changeRecord = (ChangeRecord)enumeration.nextElement();
            DatabaseMapping databaseMapping = changeRecord.getMapping();
            databaseMapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowForShallowInsertWithChangeSet(ObjectChangeSet objectChangeSet, Session session) {
        return this.buildRowForShallowInsertWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public DatabaseRow buildRowForShallowInsertWithChangeSet(DatabaseRow databaseRow, ObjectChangeSet objectChangeSet, Session session) {
        Enumeration enumeration = objectChangeSet.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            ChangeRecord changeRecord = (ChangeRecord)enumeration.nextElement();
            DatabaseMapping databaseMapping = changeRecord.getMapping();
            databaseMapping.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowForTranslation(Object object, Session session) {
        DatabaseRow databaseRow = this.createRecord();
        Enumeration enumeration = this.getPrimaryKeyMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (databaseMapping == null) continue;
            databaseMapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        return databaseRow;
    }

    public DatabaseRow buildRowForUpdate(WriteObjectQuery writeObjectQuery) {
        DatabaseRow databaseRow = this.createRecord();
        Enumeration enumeration = this.getNonPrimaryKeyMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            databaseMapping.writeFromObjectIntoRowForUpdate(writeObjectQuery, databaseRow);
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().isAggregateDescriptor() && writeObjectQuery.getObject() != null) {
            if (writeObjectQuery.getBackupClone() == null) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            } else if (!writeObjectQuery.getObject().getClass().equals(writeObjectQuery.getBackupClone().getClass())) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            }
        }
        return databaseRow;
    }

    public DatabaseRow buildRowForUpdateWithChangeSet(WriteObjectQuery writeObjectQuery) {
        DatabaseRow databaseRow = this.createRecord();
        Session session = writeObjectQuery.getSession();
        Vector vector = writeObjectQuery.getObjectChangeSet().getChanges();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ChangeRecord changeRecord = (ChangeRecord)vector.get(i);
            DatabaseMapping databaseMapping = changeRecord.getMapping();
            databaseMapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery) {
        DatabaseRow databaseRow = this.createRecord();
        Enumeration enumeration = this.getDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            databaseMapping.writeFromObjectIntoRowForWhereClause(objectLevelModifyQuery, databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public DatabaseRow buildRowFromPrimaryKeyValues(Vector vector, Session session) {
        DatabaseRow databaseRow = this.createRecord(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getDescriptor().getPrimaryKeyFields().get(i);
            Object object = vector.elementAt(i);
            object = session.getPlatform(this.getDescriptor().getJavaClass()).getConversionManager().convertObject(object, databaseField.getType());
            databaseRow.put(databaseField, object);
        }
        return databaseRow;
    }

    public DatabaseRow buildTemplateInsertRow(Session session) {
        DatabaseRow databaseRow = this.createRecord();
        this.buildTemplateInsertRow(session, databaseRow);
        return databaseRow;
    }

    public void buildTemplateInsertRow(Session session, DatabaseRow databaseRow) {
        Enumeration enumeration = this.getDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            databaseMapping.writeInsertFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToInsertRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        if (this.getDescriptor().usesSequenceNumbers() && session.getSequencing().shouldAcquireValueAfterInsert(this.getDescriptor().getJavaClass())) {
            databaseRow.remove(this.getDescriptor().getSequenceNumberField());
        }
        if (this.getDescriptor().hasReturningPolicy()) {
            this.getDescriptor().getReturningPolicy().trimModifyRowForInsert(databaseRow);
        }
    }

    public DatabaseRow buildTemplateUpdateRow(Session session) {
        DatabaseRow databaseRow = this.createRecord();
        Enumeration enumeration = this.getNonPrimaryKeyMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            databaseMapping.writeUpdateFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        return databaseRow;
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        Expression expression = this.buildPrimaryKeyExpression(databaseTable);
        if (this.getDescriptor().usesOptimisticLocking()) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildUpdateExpression(databaseTable, expression, databaseRow, databaseRow2);
        }
        return expression;
    }

    public void buildPrimaryKeyAttributesIntoObject(Object object, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) throws DatabaseException, QueryException {
        Session session = objectLevelReadQuery.getExecutionSession();
        Vector vector = this.getPrimaryKeyMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.buildShallowOriginalFromRow(databaseRow, object, objectLevelReadQuery, session);
        }
    }

    public void buildAttributesIntoShallowObject(Object object, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) throws DatabaseException, QueryException {
        Session session = objectLevelReadQuery.getExecutionSession();
        Vector vector = this.getPrimaryKeyMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (databaseMapping.isDirectToFieldMapping()) continue;
            databaseMapping.buildShallowOriginalFromRow(databaseRow, object, objectLevelReadQuery, session);
        }
        Vector vector2 = this.getDescriptor().getMappings();
        for (int i = 0; i < vector2.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector2.get(i);
            if (!databaseMapping.isDirectToFieldMapping()) continue;
            databaseMapping.buildShallowOriginalFromRow(databaseRow, object, objectLevelReadQuery, session);
        }
    }

    public void buildAttributesIntoWorkingCopyClone(Object object, ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, UnitOfWork unitOfWork, boolean bl) throws DatabaseException, QueryException {
        Session session = objectLevelReadQuery.getExecutionSession();
        boolean bl2 = objectLevelReadQuery.shouldReadAllMappings();
        Vector vector = this.getDescriptor().getMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!bl2 && !objectLevelReadQuery.shouldReadMapping(databaseMapping)) continue;
            databaseMapping.buildCloneFromRow(databaseRow, object, objectLevelReadQuery, unitOfWork, session);
        }
        if (this.descriptor.hasCMPPolicy()) {
            this.descriptor.getCMPPolicy().invokeEJBLoad(object, objectLevelReadQuery.getSession());
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            oracle.toplink.descriptors.DescriptorEvent descriptorEvent = new oracle.toplink.descriptors.DescriptorEvent(object);
            descriptorEvent.setQuery(objectLevelReadQuery);
            descriptorEvent.setSession(objectLevelReadQuery.getSession());
            descriptorEvent.setRow(databaseRow);
            if (bl) {
                descriptorEvent.setEventCode(9);
            } else {
                descriptorEvent.setEventCode(8);
            }
            this.getDescriptor().getEventManager().executeEvent(descriptorEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneFromRow(ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, UnitOfWork unitOfWork, Vector vector) throws DatabaseException, QueryException {
        Session session = unitOfWork.getParentIdentityMapSession(objectLevelReadQuery);
        Descriptor descriptor = this.getDescriptor();
        CacheKey cacheKey = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(vector, descriptor.getJavaClass(), false, descriptor);
        Object object = cacheKey.getObject();
        try {
            Object object2;
            boolean bl;
            boolean bl2 = object != null;
            boolean bl3 = bl = objectLevelReadQuery.shouldRefreshIdentityMapResult() || objectLevelReadQuery.isLockQuery() && (!bl2 || !objectLevelReadQuery.isClonePessimisticLocked(object, unitOfWork));
            if (bl2 && !bl) {
                Object object3 = object;
                return object3;
            }
            boolean bl4 = false;
            boolean bl5 = descriptor.shouldIsolateObjectsInUnitOfWork() || descriptor.shouldIsolateObjectsInUnitOfWorkEarlyTransaction() && unitOfWork.wasTransactionBegunPrematurely();
            Object object4 = null;
            if (!bl && !bl5 && (object2 = session.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, descriptor.getJavaClass(), descriptor)) != null) {
                try {
                    ((CacheKey)object2).acquireReadLock();
                    object4 = ((CacheKey)object2).getObject();
                }
                finally {
                    ((CacheKey)object2).releaseReadLock();
                }
                bl4 = object4 != null;
                boolean bl6 = bl = bl4 && (descriptor.shouldAlwaysRefreshCache() || descriptor.getCacheInvalidationPolicy().isInvalidated((CacheKey)object2, objectLevelReadQuery.getExecutionTime()));
                if (bl4 && !bl) {
                    Object object5 = unitOfWork.cloneAndRegisterObject(object4, (CacheKey)object2, cacheKey, descriptor);
                    return object5;
                }
            }
            if (!bl2) {
                if (bl4) {
                    object = this.instantiateWorkingCopyClone(object4, unitOfWork);
                    unitOfWork.getCloneToOriginals().put(object, object4);
                } else {
                    object = this.instantiateWorkingCopyCloneFromRow(databaseRow, objectLevelReadQuery, vector, unitOfWork);
                }
                cacheKey.setObject(object);
                unitOfWork.getCloneMapping().put(object, object);
            }
            if (bl2 && cacheKey.getLastUpdatedQueryId() >= objectLevelReadQuery.getQueryId()) {
                object2 = object;
                return object2;
            }
            this.copyQueryInfoToCacheKey(cacheKey, objectLevelReadQuery, databaseRow, unitOfWork, descriptor);
            object2 = descriptor.getObjectChangePolicy();
            if (!bl2) {
                object2.setChangeListener(object, unitOfWork, descriptor);
            }
            object2.dissableEventProcessing(object);
            this.buildAttributesIntoWorkingCopyClone(object, objectLevelReadQuery, databaseRow, unitOfWork, bl2);
            Object object6 = object2.buildBackupClone(object, this, unitOfWork);
            if (bl2) {
                object2.clearChanges(object, unitOfWork, descriptor);
            }
            object2.enableEventProcessing(object);
            unitOfWork.getCloneMapping().put(object, object6);
            objectLevelReadQuery.recordCloneForPessimisticLocking(object, unitOfWork);
            if (object instanceof TopLinkEntity) {
                ((TopLinkEntity)object).setPKVector(vector);
            }
        }
        finally {
            cacheKey.release();
        }
        return object;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ObjectBuilder)object).setMappingsByAttribute(new HashMap(this.getMappingsByAttribute()));
        ((ObjectBuilder)object).setMappingsByField(new HashMap(this.getMappingsByField()));
        ((ObjectBuilder)object).setReadOnlyMappingsByField(new HashMap(this.getReadOnlyMappingsByField()));
        ((ObjectBuilder)object).setPrimaryKeyMappings((Vector)this.getPrimaryKeyMappings().clone());
        ((ObjectBuilder)object).setNonPrimaryKeyMappings((Vector)this.getNonPrimaryKeyMappings().clone());
        return object;
    }

    public void cascadePerformRemove(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Iterator iterator = this.getDescriptor().getMappings().iterator();
        while (iterator.hasNext()) {
            ((DatabaseMapping)iterator.next()).cascadePerformRemoveIfRequired(object, unitOfWork, identityHashtable);
        }
    }

    public void cascadeRegisterNewForCreate(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Iterator iterator = this.getDescriptor().getMappings().iterator();
        while (iterator.hasNext()) {
            ((DatabaseMapping)iterator.next()).cascadeRegisterNewIfRequired(object, unitOfWork, identityHashtable);
        }
    }

    public ObjectChangeSet compareForChange(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session) {
        return this.descriptor.getObjectChangePolicy().calculateChanges(object, object2, unitOfWorkChangeSet, session, this.getDescriptor());
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (databaseMapping.compareObjects(object, object2, session)) continue;
            Object object3 = databaseMapping.getAttributeValueFromObject(object);
            Object object4 = databaseMapping.getAttributeValueFromObject(object2);
            session.log(1, "query", "compare_failed", databaseMapping, object3, object4);
            return false;
        }
        return true;
    }

    public void copyInto(Object object, Object object2) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.setAttributeValueInObject(object2, databaseMapping.getAttributeValueFromObject(object));
        }
    }

    public Object copyObject(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        int n;
        Object object2 = objectCopyingPolicy.getCopies().get(object);
        if (object2 != null) {
            return object2;
        }
        object2 = this.instantiateClone(object, objectCopyingPolicy.getSession());
        objectCopyingPolicy.getCopies().put(object, object2);
        List list = this.getCloningMappings();
        for (n = 0; n < list.size(); ++n) {
            ((DatabaseMapping)list.get(n)).buildCopy(object2, object, objectCopyingPolicy);
        }
        if (objectCopyingPolicy.shouldResetPrimaryKey() && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            n = 0;
            Enumeration enumeration = this.getPrimaryKeyMappings().elements();
            while (enumeration.hasMoreElements()) {
                if (!((DatabaseMapping)enumeration.nextElement()).isOneToOneMapping()) continue;
                n = 1;
            }
            if (n == 0) {
                enumeration = this.getPrimaryKeyMappings().elements();
                while (enumeration.hasMoreElements()) {
                    DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
                    if (databaseMapping.isDirectToFieldMapping()) {
                        Object object3 = ((AbstractDirectMapping)databaseMapping).getAttributeValue(null, objectCopyingPolicy.getSession());
                        databaseMapping.setAttributeValueInObject(object2, object3);
                        continue;
                    }
                    if (!databaseMapping.isTransformationMapping()) continue;
                    databaseMapping.setAttributeValueInObject(object2, null);
                }
            }
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            oracle.toplink.descriptors.DescriptorEvent descriptorEvent = new oracle.toplink.descriptors.DescriptorEvent(object2);
            descriptorEvent.setSession(objectCopyingPolicy.getSession());
            descriptorEvent.setOriginalObject(object);
            descriptorEvent.setEventCode(10);
            this.getDescriptor().getEventManager().executeEvent(descriptorEvent);
        }
        return object2;
    }

    public ObjectChangeSet createObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session) {
        boolean bl = ((UnitOfWork)session).isObjectNew(object);
        return this.createObjectChangeSet(object, unitOfWorkChangeSet, bl, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, Session session) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
        if (objectChangeSet == null) {
            objectChangeSet = this.getDescriptor().isAggregateDescriptor() ? new AggregateObjectChangeSet(new Vector(0), object, unitOfWorkChangeSet, bl) : new ObjectChangeSet(this.extractPrimaryKeyFromObject(object, session, true), object, unitOfWorkChangeSet, bl);
            objectChangeSet.setIsAggregate(this.getDescriptor().isAggregateDescriptor() || this.getDescriptor().isAggregateCollectionDescriptor());
            unitOfWorkChangeSet.addObjectChangeSetForIdentity(objectChangeSet, object);
        }
        return objectChangeSet;
    }

    public void createPrimaryKeyExpression(Session session) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)list.get(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField);
            Expression expression4 = expression2.equal(expression3);
            expression = expression == null ? expression4 : expression.and(expression4);
        }
        this.setPrimaryKeyExpression(expression);
    }

    public Vector extractPrimaryKeyFromExpression(boolean bl, Expression expression, DatabaseRow databaseRow, Session session) {
        DatabaseRow databaseRow2 = this.createRecord(this.getPrimaryKeyMappings().size());
        Session session2 = expression.getBuilder().getSession();
        expression.getBuilder().setSession(session);
        boolean bl2 = expression.extractPrimaryKeyValues(bl, this.getDescriptor(), databaseRow2, databaseRow);
        expression.getBuilder().setSession(session2);
        if (bl && !bl2) {
            return null;
        }
        if (databaseRow2.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(databaseRow2, session);
    }

    public Vector extractPrimaryKeyFromObject(Object object, Session session) {
        return this.extractPrimaryKeyFromObject(object, session, false);
    }

    public Vector extractPrimaryKeyFromObject(Object object, Session session, boolean bl) {
        Cloneable cloneable;
        boolean bl2 = object instanceof TopLinkEntity;
        if (bl2 && (cloneable = ((TopLinkEntity)object).getPKVector()) != null) {
            return cloneable;
        }
        cloneable = this.getDescriptor();
        boolean bl3 = false;
        if (((Descriptor)cloneable).hasInheritance() && object.getClass() != ((Descriptor)cloneable).getJavaClass() && !object.getClass().getSuperclass().equals(((Descriptor)cloneable).getJavaClass())) {
            return session.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, session, bl);
        }
        List list = ((Descriptor)cloneable).getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        Vector vector2 = this.getPrimaryKeyMappings();
        int n = vector2.size();
        if (((Descriptor)cloneable).hasSimplePrimaryKey()) {
            for (int i = 0; i < n; ++i) {
                AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)vector2.get(i);
                Object object2 = abstractDirectMapping.valueFromObject(object, (DatabaseField)list.get(i), session);
                if (object2 == null) {
                    if (bl) {
                        return null;
                    }
                    bl3 = true;
                }
                vector.add(object2);
            }
        } else {
            Cloneable cloneable2;
            DatabaseRow databaseRow = this.createRecord(n);
            for (int i = 0; i < n; ++i) {
                cloneable2 = (DatabaseMapping)vector2.get(i);
                if (cloneable2 == null) continue;
                ((DatabaseMapping)cloneable2).writeFromObjectIntoRow(object, databaseRow, session);
            }
            Vector vector3 = this.getPrimaryKeyClassifications();
            cloneable2 = session.getPlatform(object.getClass());
            for (int i = 0; i < n; ++i) {
                Class clazz = (Class)vector3.get(i);
                Object object3 = databaseRow.get((DatabaseField)list.get(i));
                if (object3 == null) {
                    if (bl) {
                        return null;
                    }
                    bl3 = true;
                }
                vector.add(cloneable2.convertObject(object3, clazz));
            }
        }
        if (bl2 && !bl3) {
            ((TopLinkEntity)object).setPKVector(vector);
        }
        return vector;
    }

    public Vector extractPrimaryKeyFromRow(DatabaseRow databaseRow, Session session) {
        List list = this.getDescriptor().getPrimaryKeyFields();
        Vector vector = this.getPrimaryKeyClassifications();
        int n = list.size();
        Vector<Object> vector2 = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)list.get(i);
            Class clazz = (Class)vector.get(i);
            Object object = databaseRow.get(databaseField);
            if (object != null) {
                if (object.getClass() != clazz) {
                    object = session.getPlatform(this.getDescriptor().getJavaClass()).convertObject(object, clazz);
                }
            } else {
                return null;
            }
            vector2.addElement(object);
        }
        return vector2;
    }

    public DatabaseRow extractPrimaryKeyRowFromExpression(Expression expression, DatabaseRow databaseRow, Session session) {
        DatabaseRow databaseRow2 = this.createRecord(this.getPrimaryKeyMappings().size());
        Session session2 = expression.getBuilder().getSession();
        expression.getBuilder().setSession(session);
        boolean bl = expression.extractPrimaryKeyValues(true, this.getDescriptor(), databaseRow2, databaseRow);
        expression.getBuilder().setSession(session);
        if (!bl) {
            return null;
        }
        if (databaseRow2.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return databaseRow2;
    }

    public DatabaseRow extractPrimaryKeyRowFromObject(Object object, Session session) {
        DatabaseRow databaseRow = this.createRecord(this.getPrimaryKeyMappings().size());
        for (int i = 0; i < this.getPrimaryKeyMappings().size(); ++i) {
            ((DatabaseMapping)this.getPrimaryKeyMappings().get(i)).writeFromObjectIntoRow(object, databaseRow, session);
        }
        if (this.getDescriptor().hasSimplePrimaryKey()) {
            return databaseRow;
        }
        DatabaseRow databaseRow2 = this.createRecord(this.getPrimaryKeyMappings().size());
        List list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            Class clazz = (Class)this.getPrimaryKeyClassifications().get(i);
            DatabaseField databaseField = (DatabaseField)list.get(i);
            Object object2 = databaseRow.get(databaseField);
            databaseRow2.put(databaseField, session.getPlatform(object.getClass()).convertObject(object2, clazz));
        }
        return databaseRow2;
    }

    public Object extractValueFromObjectForField(Object object, DatabaseField databaseField, Session session) throws DescriptorException {
        Descriptor descriptor = null;
        if (this.getDescriptor().hasInheritance() && object.getClass() != this.getDescriptor().getJavaClass() && (descriptor = session.getDescriptor(object)).getJavaClass() != this.getDescriptor().getJavaClass()) {
            return descriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField, session);
        }
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping == null) {
            throw DescriptorException.missingMappingForField(databaseField, this.getDescriptor());
        }
        return databaseMapping.valueFromObject(object, databaseField, session);
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            ((DatabaseMapping)vector.get(i)).fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
        }
    }

    public DatabaseMapping getBaseMappingForField(DatabaseField databaseField) {
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            databaseMapping = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return databaseMapping;
    }

    public Object getBaseValueForField(DatabaseField databaseField, Object object) {
        Object object2 = object;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            object2 = databaseMapping.getAttributeValueFromObject(object2);
            databaseMapping = ((AggregateMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return databaseMapping.getAttributeValueFromObject(object2);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField);
    }

    public DatabaseField getFieldForQueryKeyName(String string) {
        QueryKey queryKey = this.getDescriptor().getQueryKeyNamed(string);
        if (queryKey == null) {
            DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
            if (databaseMapping == null) {
                return null;
            }
            if (databaseMapping.getFields().isEmpty()) {
                return null;
            }
            return (DatabaseField)databaseMapping.getFields().firstElement();
        }
        if (queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public List getCloningMappings() {
        return this.cloningMappings;
    }

    public Vector getJoinedAttributes() {
        return this.joinedAttributes;
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null;
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        return (DatabaseMapping)this.getMappingsByAttribute().get(string);
    }

    public DatabaseMapping getMappingForField(DatabaseField databaseField) {
        return (DatabaseMapping)this.getMappingsByField().get(databaseField);
    }

    public Vector getReadOnlyMappingsForField(DatabaseField databaseField) {
        return (Vector)this.getReadOnlyMappingsByField().get(databaseField);
    }

    protected Map getMappingsByAttribute() {
        return this.mappingsByAttribute;
    }

    public Map getMappingsByField() {
        return this.mappingsByField;
    }

    public Map getReadOnlyMappingsByField() {
        return this.readOnlyMappingsByField;
    }

    protected Vector getNonPrimaryKeyMappings() {
        return this.nonPrimaryKeyMappings;
    }

    public Object getParentObjectForField(DatabaseField databaseField, Object object) {
        Object object2 = object;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            object2 = databaseMapping.getAttributeValueFromObject(object2);
            databaseMapping = ((AggregateMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return object2;
    }

    public Vector getPrimaryKeyClassifications() {
        if (this.primaryKeyClassifications == null) {
            List list = this.getDescriptor().getPrimaryKeyFields();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(list.size());
            for (int i = 0; i < list.size(); ++i) {
                DatabaseMapping databaseMapping = (DatabaseMapping)this.getPrimaryKeyMappings().get(i);
                DatabaseField databaseField = (DatabaseField)list.get(i);
                if (databaseMapping != null) {
                    ((Vector)nonSynchronizedVector).add(Helper.getObjectClass(databaseMapping.getFieldClassification(databaseField)));
                } else {
                    ((Vector)nonSynchronizedVector).add(null);
                }
                this.primaryKeyClassifications = nonSynchronizedVector;
            }
        }
        return this.primaryKeyClassifications;
    }

    public Expression getPrimaryKeyExpression() {
        return this.primaryKeyExpression;
    }

    public Vector getPrimaryKeyMappings() {
        return this.primaryKeyMappings;
    }

    public DatabaseField getTargetFieldForQueryKeyName(String string) {
        DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)databaseMapping).getField();
        }
        QueryKey queryKey = this.getDescriptor().getQueryKeyNamed(string);
        if (queryKey != null && queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public void initialize(Session session) throws DescriptorException {
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        Enumeration enumeration = this.getDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(databaseMapping.getAttributeName(), databaseMapping);
            }
            if (databaseMapping.isCloningRequired()) {
                this.getCloningMappings().add(databaseMapping);
            }
            Enumeration enumeration2 = databaseMapping.getFields().elements();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (!databaseMapping.isReadOnly()) {
                    if (this.getMappingsByField().containsKey(e)) {
                        if (databaseMapping.isAggregateObjectMapping()) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(e.toString(), databaseMapping));
                        continue;
                    }
                    this.getMappingsByField().put(e, databaseMapping);
                    continue;
                }
                Vector vector = (Vector)this.getReadOnlyMappingsByField().get(e);
                if (vector == null) {
                    vector = NonSynchronizedVector.newInstance();
                    this.getReadOnlyMappingsByField().put(e, vector);
                }
                vector.add(databaseMapping);
            }
        }
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
    }

    public void initializeJoinedAttributes() {
        NonSynchronizedVector nonSynchronizedVector = null;
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!databaseMapping.isOneToOneMapping() || !databaseMapping.isRelationalMapping() || !((OneToOneMapping)databaseMapping).shouldUseJoining()) continue;
            if (nonSynchronizedVector == null) {
                nonSynchronizedVector = NonSynchronizedVector.newInstance();
            }
            ((Vector)nonSynchronizedVector).add(databaseMapping.getAttributeName());
        }
        this.joinedAttributes = nonSynchronizedVector;
    }

    protected void copyQueryInfoToCacheKey(CacheKey cacheKey, ObjectLevelReadQuery objectLevelReadQuery, DatabaseRow databaseRow, Session session, Descriptor descriptor) {
        cacheKey.setLastUpdatedQueryId(objectLevelReadQuery.getQueryId());
        if (descriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy();
            Object object = optimisticLockingPolicy.getValueToPutInCache(databaseRow, session);
            cacheKey.setWriteLockValue(object);
        }
        cacheKey.setReadTime(objectLevelReadQuery.getExecutionTime());
    }

    public void initializePrimaryKey(Session session) throws DescriptorException {
        DatabaseMapping databaseMapping;
        int n;
        Cloneable cloneable;
        this.createPrimaryKeyExpression(session);
        List list = this.getDescriptor().getPrimaryKeyFields();
        this.getPrimaryKeyMappings().clear();
        this.getNonPrimaryKeyMappings().clear();
        Object object = this.getMappingsByField().keySet().iterator();
        while (object.hasNext()) {
            DatabaseField databaseField = (DatabaseField)object.next();
            if (list.contains(databaseField)) continue;
            cloneable = this.getMappingForField(databaseField);
            if (this.getNonPrimaryKeyMappings().contains(cloneable)) continue;
            this.getNonPrimaryKeyMappings().addElement(cloneable);
        }
        object = this.getDescriptor().getPrimaryKeyFields();
        for (n = 0; n < object.size(); ++n) {
            cloneable = (DatabaseField)object.get(n);
            databaseMapping = this.getMappingForField((DatabaseField)cloneable);
            if (databaseMapping == null && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
                throw DescriptorException.noMappingForPrimaryKey((DatabaseField)cloneable, this.getDescriptor());
            }
            this.getPrimaryKeyMappings().addElement(databaseMapping);
            if (databaseMapping != null) {
                databaseMapping.setIsPrimaryKeyMapping(true);
            }
            if (!this.getDescriptor().hasMultipleTables()) continue;
            Iterator iterator = this.getDescriptor().getAdditionalTablePrimaryKeyFields().values().iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                DatabaseField databaseField = (DatabaseField)map.get(cloneable);
                if (databaseField == null || databaseMapping == null) continue;
                this.getMappingsByField().put(databaseField, databaseMapping);
            }
        }
        n = 1;
        for (int i = 0; i < this.getPrimaryKeyMappings().size(); ++i) {
            databaseMapping = (DatabaseMapping)this.getPrimaryKeyMappings().get(i);
            if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) continue;
            n = 0;
            break;
        }
        this.getDescriptor().setHasSimplePrimaryKey(n != 0);
    }

    public Object instantiateClone(Object object, Session session) {
        return this.getDescriptor().getCopyPolicy().buildClone(object, session);
    }

    public Object instantiateWorkingCopyClone(Object object, Session session) {
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyClone(object, session);
    }

    public Object instantiateWorkingCopyCloneFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Vector vector, UnitOfWork unitOfWork) {
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyCloneFromRow(databaseRow, objectLevelReadQuery, vector, unitOfWork);
    }

    public boolean isPrimaryKeyMapping(DatabaseMapping databaseMapping) {
        return this.getPrimaryKeyMappings().contains(databaseMapping);
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            ((DatabaseMapping)vector.get(i)).iterate(descriptorIterator);
        }
    }

    public void mergeChangesIntoObject(Object object, ObjectChangeSet objectChangeSet, Object object2, MergeManager mergeManager) {
        Object object3 = objectChangeSet.getChanges().elements();
        while (object3.hasMoreElements()) {
            ChangeRecord changeRecord = (ChangeRecord)object3.nextElement();
            DatabaseMapping databaseMapping = this.getMappingForAttributeName(changeRecord.getAttribute());
            databaseMapping.mergeChangesIntoObject(object, changeRecord, object2, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            object3 = new oracle.toplink.descriptors.DescriptorEvent(object);
            ((DescriptorEvent)object3).setSession(mergeManager.getSession());
            ((DescriptorEvent)object3).setOriginalObject(object2);
            ((DescriptorEvent)object3).setChangeSet(objectChangeSet);
            ((DescriptorEvent)object3).setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent((oracle.toplink.descriptors.DescriptorEvent)object3);
        }
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Vector vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            ((DatabaseMapping)vector.get(i)).mergeIntoObject(object, bl, object2, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            oracle.toplink.descriptors.DescriptorEvent descriptorEvent = new oracle.toplink.descriptors.DescriptorEvent(object);
            descriptorEvent.setSession(mergeManager.getSession());
            descriptorEvent.setOriginalObject(object2);
            descriptorEvent.setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent(descriptorEvent);
        }
    }

    public void populateAttributesForClone(Object object, Object object2, UnitOfWork unitOfWork) {
        List list = this.getCloningMappings();
        for (int i = 0; i < list.size(); ++i) {
            ((DatabaseMapping)list.get(i)).buildClone(object, object2, unitOfWork);
        }
        if (this.descriptor.hasCMPPolicy()) {
            this.descriptor.getCMPPolicy().invokeEJBLoad(object2, unitOfWork);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            oracle.toplink.descriptors.DescriptorEvent descriptorEvent = new oracle.toplink.descriptors.DescriptorEvent(object2);
            descriptorEvent.setSession(unitOfWork);
            descriptorEvent.setOriginalObject(object);
            descriptorEvent.setEventCode(10);
            this.getDescriptor().getEventManager().executeEvent(descriptorEvent);
        }
    }

    public void rehashFieldDependancies(Session session) {
        this.setMappingsByField(Helper.rehashMap(this.getMappingsByField()));
        this.setReadOnlyMappingsByField(Helper.rehashMap(this.getReadOnlyMappingsByField()));
        this.setPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.setNonPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.initializePrimaryKey(session);
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setMappingsByAttribute(Map map) {
        this.mappingsByAttribute = map;
    }

    public void setMappingsByField(Map map) {
        this.mappingsByField = map;
    }

    public void setReadOnlyMappingsByField(Map map) {
        this.readOnlyMappingsByField = map;
    }

    protected void setNonPrimaryKeyMappings(Vector vector) {
        this.nonPrimaryKeyMappings = vector;
    }

    protected void setPrimaryKeyClassifications(Vector vector) {
        this.primaryKeyClassifications = vector;
    }

    public void setPrimaryKeyExpression(Expression expression) {
        this.primaryKeyExpression = expression;
    }

    protected void setPrimaryKeyMappings(Vector vector) {
        this.primaryKeyMappings = vector;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor().toString() + ")";
    }

    public Object unwrapObject(Object object, Session session) {
        Descriptor descriptor;
        if (object == null) {
            return null;
        }
        if (this.getDescriptor().getJavaClass() == object.getClass() || this.getDescriptor().hasWrapperPolicy() && !this.getDescriptor().getWrapperPolicy().isWrapped(object)) {
            return object;
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasChildren() && (descriptor = session.getDescriptor(object)) != this.getDescriptor()) {
            return descriptor.getObjectBuilder().unwrapObject(object, session);
        }
        if (this.getDescriptor().hasWrapperPolicy()) {
            return this.getDescriptor().getWrapperPolicy().unwrapObject(object, session);
        }
        if (session.getProject().hasProxyIndirection()) {
            return ProxyIndirectionPolicy.getValueFromProxy(object);
        }
        return object;
    }

    public void validate(Session session) throws DescriptorException {
        if (this.getDescriptor().usesSequenceNumbers() && this.getMappingForField(this.getDescriptor().getSequenceNumberField()) == null) {
            throw DescriptorException.mappingForSequenceNumberField(this.getDescriptor());
        }
    }

    public boolean verifyDelete(Object object, Session session) {
        Cloneable cloneable;
        Object object2;
        DatabaseRow databaseRow = this.buildRowForTranslation(object, session);
        if (this.getDescriptor().getQueryManager().getReadObjectQuery() != null && this.getDescriptor().getQueryManager().getReadObjectQuery().isCallQuery()) {
            object2 = session.readObject(object);
            if (object2 != null) {
                return false;
            }
        } else {
            object2 = this.getDescriptor().getTables().elements();
            while (object2.hasMoreElements()) {
                cloneable = (DatabaseTable)object2.nextElement();
                SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
                sQLSelectStatement.addTable((DatabaseTable)cloneable);
                if (cloneable == this.getDescriptor().getTables().firstElement()) {
                    sQLSelectStatement.setWhereClause((Expression)this.getPrimaryKeyExpression().clone());
                } else {
                    sQLSelectStatement.setWhereClause(this.buildPrimaryKeyExpression((DatabaseTable)cloneable));
                }
                DatabaseField databaseField = new DatabaseField("*");
                databaseField.setTable((DatabaseTable)cloneable);
                sQLSelectStatement.addField(databaseField);
                sQLSelectStatement.normalize(session, null);
                DataReadQuery dataReadQuery = new DataReadQuery();
                dataReadQuery.setSQLStatement(sQLSelectStatement);
                dataReadQuery.setSessionName(this.getDescriptor().getSessionName());
                Vector vector = (Vector)session.executeQuery((DatabaseQuery)dataReadQuery, databaseRow);
                if (vector.isEmpty()) continue;
                return false;
            }
        }
        object2 = this.getDescriptor().getMappings().elements();
        while (object2.hasMoreElements()) {
            cloneable = (DatabaseMapping)object2.nextElement();
            if (((DatabaseMapping)cloneable).verifyDelete(object, session)) continue;
            return false;
        }
        return true;
    }

    public Object wrapObject(Object object, Session session) {
        if (object == null) {
            return null;
        }
        if (this.getDescriptor().hasWrapperPolicy() && this.getDescriptor().getWrapperPolicy().isWrapped(object)) {
            return object;
        }
        if (this.getDescriptor().hasInheritance() && object.getClass() != this.getDescriptor().getJavaClass()) {
            return session.getDescriptor(object).getObjectBuilder().wrapObject(object, session);
        }
        if (this.getDescriptor().hasWrapperPolicy()) {
            return this.getDescriptor().getWrapperPolicy().wrapObject(object, session);
        }
        return object;
    }
}

