/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName;
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeMethod(this.getGetMethod(), object, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), nullPointerException);
        }
    }

    protected Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class getGetMethodReturnType() {
        return PrivilegedAccessController.getMethodReturnType(this.getGetMethod());
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class getSetMethodParameterType() {
        return PrivilegedAccessController.getMethodParameterTypes(this.getSetMethod())[0];
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(clazz, this.getGetMethodName(), null));
            Class[] classArray = new Class[]{this.getGetMethodReturnType()};
            this.setSetMethod(Helper.getDeclaredMethod(clazz, this.getSetMethodName(), classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), clazz.getName());
            descriptorException.setInternalException(noSuchMethodException);
            throw descriptorException;
        }
        catch (SecurityException securityException) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), clazz.getName());
            descriptorException.setInternalException(securityException);
            throw descriptorException;
        }
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        Object[] objectArray = new Object[]{object2};
        try {
            PrivilegedAccessController.invokeMethod(this.getSetMethod(), object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                if (object2 instanceof String) {
                    Object object3 = ConversionManager.getDefaultManager().convertObject(object2, this.getAttributeClass());
                    Object[] objectArray2 = new Object[]{object3};
                    PrivilegedAccessController.invokeMethod(this.getSetMethod(), object, objectArray2);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            try {
                Class clazz = this.getSetMethodParameterType();
                if (!clazz.isPrimitive() || object2 != null) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
                objectArray[0] = ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz);
                PrivilegedAccessController.invokeMethod(this.getSetMethod(), object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
            }
        }
    }

    protected void setGetMethod(Method method) {
        this.getMethod = method;
    }

    public void setGetMethodName(String string) {
        this.getMethodName = string;
    }

    protected void setSetMethod(Method method) {
        this.setMethod = method;
    }

    public void setSetMethodName(String string) {
        this.setMethodName = string;
    }
}

