/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class InstantiationPolicy
implements Cloneable,
Serializable {
    protected String methodName;
    protected transient Method method;
    protected Class factoryClass;
    protected String factoryClassName;
    protected String factoryMethodName;
    protected Object factory;
    protected Descriptor descriptor;
    private transient Constructor defaultConstructor;

    public Object buildNewInstance() throws DescriptorException {
        if (this.isUsingDefaultConstructor()) {
            return this.buildNewInstanceUsingDefaultConstructor();
        }
        return this.buildNewInstanceUsingFactory();
    }

    protected Object buildNewInstanceUsingDefaultConstructor() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeConstructor(this.getDefaultConstructor(), null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileConstructorInstantiation(this.getDescriptor(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileConstructorInstantiation(this.getDescriptor(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw DescriptorException.instantiationWhileConstructorInstantiation(this.getDescriptor(), instantiationException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw DescriptorException.noSuchMethodWhileConstructorInstantiation(this.getDescriptor(), noSuchMethodError);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileConstructorInstantiation(this.getDescriptor(), nullPointerException);
        }
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeMethod(this.getMethod(), this.getFactory(), new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), nullPointerException);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Constructor getDefaultConstructor() throws DescriptorException {
        if (this.defaultConstructor == null) {
            this.setDefaultConstructor(this.buildDefaultConstructor());
        }
        return this.defaultConstructor;
    }

    protected Constructor buildDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getDescriptor().getJavaClass());
    }

    protected Constructor buildDefaultConstructorFor(Class clazz) throws DescriptorException {
        try {
            return PrivilegedAccessController.getDeclaredConstructorFor(clazz, new Class[0], true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(clazz.getName() + ".<Default Constructor>", this.getDescriptor(), noSuchMethodException);
        }
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public Object getFactory() {
        return this.factory;
    }

    public Class getFactoryClass() {
        return this.factoryClass;
    }

    public String getFactoryClassName() {
        if (this.factoryClassName == null && this.factoryClass != null) {
            this.factoryClassName = this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    protected Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void initialize(Session session) throws DescriptorException {
        if (this.isUsingDefaultConstructor()) {
            return;
        }
        try {
            if (this.getFactory() == null) {
                this.setFactory(this.buildFactory());
            }
            this.initializeMethod();
        }
        catch (DescriptorException descriptorException) {
            session.getIntegrityChecker().handleError(descriptorException);
        }
    }

    protected Object buildFactory() throws DescriptorException {
        if (this.getFactoryClass() == null) {
            return null;
        }
        if (this.getFactoryMethodName() == null) {
            return this.buildFactoryUsingDefaultConstructor();
        }
        return this.buildFactoryUsingStaticMethod();
    }

    protected Object buildFactoryUsingDefaultConstructor() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeConstructor(this.buildFactoryDefaultConstructor(), null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileConstructorInstantiationOfFactory(this.getDescriptor(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileConstructorInstantiationOfFactory(this.getDescriptor(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw DescriptorException.instantiationWhileConstructorInstantiationOfFactory(this.getDescriptor(), instantiationException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory(this.getDescriptor(), noSuchMethodError);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileConstructorInstantiationOfFactory(this.getDescriptor(), nullPointerException);
        }
    }

    protected Constructor buildFactoryDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getFactoryClass());
    }

    protected Object buildFactoryUsingStaticMethod() throws DescriptorException {
        Method method = this.buildMethod(this.getFactoryClass(), this.getFactoryMethodName(), new Class[0]);
        try {
            return PrivilegedAccessController.invokeMethod(method, null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), nullPointerException);
        }
    }

    protected void initializeMethod() throws DescriptorException {
        Class<?> clazz = this.getFactory() == null ? this.getDescriptor().getJavaClass() : this.getFactory().getClass();
        this.setMethod(this.buildMethod(clazz, this.getMethodName(), new Class[0]));
    }

    protected Method buildMethod(Class clazz, String string, Class[] classArray) throws DescriptorException {
        try {
            return Helper.getDeclaredMethod(clazz, string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(clazz.getName() + "." + string, this.getDescriptor(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityWhileInitializingInstantiationPolicy(clazz.getName() + "." + string, this.getDescriptor(), securityException);
        }
    }

    public boolean isUsingDefaultConstructor() {
        return this.getMethodName() == null;
    }

    protected void setDefaultConstructor(Constructor constructor) {
        this.defaultConstructor = constructor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setFactoryMethodName(String string) {
        this.factoryMethodName = string;
    }

    protected void setFactory(Object object) {
        this.factory = object;
    }

    protected void setFactoryClass(Class clazz) {
        this.factoryClass = clazz;
    }

    protected void setFactoryClassName(String string) {
        this.factoryClassName = string;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public void createFactory(Class clazz, String string) throws DescriptorException {
        this.setFactoryClass(clazz);
        this.setFactoryClassName(clazz.getName());
        this.setFactoryMethodName(string);
        this.setFactory(this.buildFactory());
        this.initializeMethod();
    }

    public String toString() {
        String string = null;
        string = this.isUsingDefaultConstructor() ? "<CONSTRUCTOR>" : this.getMethodName();
        return Helper.getShortClassName(this) + "(" + string + ")";
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.setMethodName(null);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string) {
        this.setMethodName(string);
        this.setFactory(null);
        this.setFactoryClass(clazz);
        this.setFactoryClassName(clazz.getName());
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string, String string2) {
        this.setMethodName(string);
        this.setFactory(null);
        this.setFactoryClass(clazz);
        this.setFactoryClassName(clazz.getName());
        this.setFactoryMethodName(string2);
    }

    public void useFactoryInstantiationPolicy(String string, String string2) {
        this.setMethodName(string2);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(string);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(String string, String string2, String string3) {
        this.setMethodName(string2);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(string);
        this.setFactoryMethodName(string3);
    }

    public void useFactoryInstantiationPolicy(Object object, String string) {
        this.setMethodName(string);
        this.setFactory(object);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useMethodInstantiationPolicy(String string) {
        this.setMethodName(string);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }
}

