/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors;

import java.lang.reflect.Field;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.AttributeAccessor;

public class InstanceVariableAttributeAccessor
extends AttributeAccessor {
    protected transient Field attributeField;

    public Class getAttributeClass() {
        if (this.getAttributeField() == null) {
            return null;
        }
        return this.getAttributeType();
    }

    protected Field getAttributeField() {
        return this.attributeField;
    }

    public Class getAttributeType() {
        return this.attributeField.getType();
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return PrivilegedAccessController.getValueFromField(this.attributeField, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), object.getClass().getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), object.getClass().getName(), illegalAccessException);
        }
        catch (NullPointerException nullPointerException) {
            String string = null;
            if (object != null) {
                string = object.getClass().getName();
            }
            throw DescriptorException.nullPointerWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), string, nullPointerException);
        }
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setAttributeField(Helper.getDeclaredField(clazz, this.getAttributeName()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw DescriptorException.noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), clazz.getName(), noSuchFieldException);
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), clazz.getName(), securityException);
        }
    }

    protected void setAttributeField(Field field) {
        this.attributeField = field;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        try {
            PrivilegedAccessController.setValueInField(this.attributeField, object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                if (object2 == null) {
                    Class clazz = this.getAttributeClass();
                    if (Helper.isPrimitiveWrapper(clazz)) {
                        PrivilegedAccessController.setValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz));
                    }
                    return;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, illegalArgumentException);
            }
            try {
                if (object2 instanceof String) {
                    Object object3 = ConversionManager.getDefaultManager().convertObject(object2, this.getAttributeClass());
                    PrivilegedAccessController.setValueInField(this.attributeField, object, object3);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DescriptorException.illegalArgumentWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), object2, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (object2 == null) {
                return;
            }
            throw DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object.getClass().getName(), object2, illegalAccessException);
        }
        catch (NullPointerException nullPointerException) {
            try {
                Class clazz;
                if (object != null) {
                    clazz = this.getAttributeClass();
                    if (!Helper.isPrimitiveWrapper(clazz) || object2 != null) {
                        throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                    }
                } else {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
                PrivilegedAccessController.setValueInField(this.attributeField, object, ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
            }
        }
    }
}

