/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.ValueReadQuery;

public class SQLServerPlatform
extends DatabasePlatform {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$RelationExpression;

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL() && !this.usesByteArrayBinding()) {
            writer.write("0x");
            Helper.writeHexString(byArray, writer);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendSybaseTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(58);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 3); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 3) {
            string = string.substring(0, 3 - n);
        }
        writer.write(string);
        writer.write("'");
    }

    protected void appendSybaseCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLServerPlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("BIT default 0", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLServerPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = SQLServerPlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = SQLServerPlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("FLOAT(16)", false));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = SQLServerPlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("FLOAT(32)", false));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = SQLServerPlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLServerPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SQLServerPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("NUMERIC", 28));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLServerPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = SQLServerPlatform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = SQLServerPlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = SQLServerPlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("IMAGE", false));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = SQLServerPlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("TEXT", false));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = SQLServerPlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = SQLServerPlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLServerPlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("DATETIME", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT @@IDENTITY");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public String getBatchDelimiterString() {
        return "";
    }

    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    public String getCreationOutputProcedureToken() {
        return "OUTPUT";
    }

    public String getInOutputProcedureToken() {
        return "OUT";
    }

    public int getMaxFieldNameSize() {
        return 22;
    }

    public Vector getNativeTableInfo(String string, String string2, Session session) {
        String string3 = "SELECT * FROM sysobjects WHERE table_type <> 'SYSTEM_TABLE'";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND table_name LIKE " + string : string3 + " AND table_name = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND table_owner LIKE " + string2 : string3 + " AND table_owner = " + string2;
        }
        return session.executeSelectingCall(new SQLCall(string3));
    }

    public String getOutputProcedureToken() {
        return "";
    }

    public String getProcedureArgumentString() {
        return "@";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE ";
    }

    public String getStoredProcedureParameterPrefix() {
        return "@";
    }

    public String getStoredProcedureTerminationToken() {
        return " go";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT GETDATE()");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.simpleFunction(54, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTRING"));
        this.addOperator(ExpressionOperator.addDate());
        this.addOperator(ExpressionOperator.dateName());
        this.addOperator(ExpressionOperator.datePart());
        this.addOperator(ExpressionOperator.dateDifference());
        this.addOperator(ExpressionOperator.difference());
        this.addOperator(ExpressionOperator.charIndex());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.reverse());
        this.addOperator(ExpressionOperator.replicate());
        this.addOperator(ExpressionOperator.right());
        this.addOperator(ExpressionOperator.cot());
        this.addOperator(ExpressionOperator.sybaseAtan2Operator());
        this.addOperator(ExpressionOperator.sybaseAddMonthsOperator());
        this.addOperator(ExpressionOperator.sybaseInStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "ISNULL"));
        this.addOperator(ExpressionOperator.sybaseToNumberOperator());
        this.addOperator(ExpressionOperator.sybaseToDateToStringOperator());
        this.addOperator(ExpressionOperator.sybaseToDateOperator());
        this.addOperator(ExpressionOperator.sybaseToCharOperator());
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "LEN"));
        this.addOperator(this.modOperator());
    }

    public boolean isSQLServer() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLServerPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = SQLServerPlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MAX_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = SQLServerPlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(0.0));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = SQLServerPlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLServerPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = SQLServerPlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(0.0f));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SQLServerPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLServerPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = SQLServerPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = SQLServerPlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MIN_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = SQLServerPlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(-9.0));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = SQLServerPlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = SQLServerPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = SQLServerPlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(-9.0f));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SQLServerPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-9999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLServerPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("-999999999.9999999999999999999"));
        return hashtable;
    }

    public ExpressionOperator modOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(67);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(" % ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = SQLServerPlatform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(" =* ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$RelationExpression == null ? (class$oracle$toplink$internal$expressions$RelationExpression = SQLServerPlatform.class$("oracle.toplink.internal.expressions.RelationExpression")) : class$oracle$toplink$internal$expressions$RelationExpression);
        return expressionOperator;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    public boolean requiresProcedureCallOuputToken() {
        return true;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return false;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldNativeSequenceAcquireValueAfterInsert() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

