/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.AppendCallCustomParameter;
import oracle.toplink.internal.databaseaccess.BindCallCustomParameter;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.objectrelational.ObjectRelationalDatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.StoredProcedureCall;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.TableSequence;

public class DatabasePlatform
extends DatasourcePlatform {
    protected transient Hashtable fieldTypes;
    protected boolean usesNativeSQL;
    protected boolean usesByteArrayBinding;
    protected boolean usesBatchWriting;
    protected boolean shouldBindAllParameters;
    protected boolean shouldCacheAllStatements;
    protected int statementCacheSize;
    protected boolean shouldForceFieldNamesToUpperCase;
    protected boolean shouldTrimStrings;
    protected boolean usesStreamsForBinding;
    protected int stringBindingSize;
    protected boolean usesStringBinding;
    protected int maxBatchWritingSize;
    protected boolean usesJDBCBatchWriting;
    protected boolean usesNativeBatchWriting;
    protected int cursorCode;
    protected int transactionIsolation;
    protected boolean supportsAutoCommit;
    protected boolean shouldOptimizeDataConversion;
    protected transient Hashtable classTypes;
    protected static boolean shouldIgnoreCaseOnFieldComparisons = false;
    public static int DEFAULT_MAX_BATCH_WRITING_SIZE = 32000;
    public static int DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE = 100;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public DatabasePlatform() {
        this.tableQualifier = "";
        this.usesNativeSQL = false;
        this.usesByteArrayBinding = true;
        this.usesStringBinding = false;
        this.stringBindingSize = 255;
        this.shouldTrimStrings = true;
        this.shouldBindAllParameters = false;
        this.shouldCacheAllStatements = false;
        this.shouldOptimizeDataConversion = true;
        this.statementCacheSize = 50;
        this.shouldForceFieldNamesToUpperCase = false;
        this.maxBatchWritingSize = DEFAULT_MAX_BATCH_WRITING_SIZE;
        this.usesJDBCBatchWriting = true;
        this.transactionIsolation = -1;
        this.cursorCode = -10;
        this.supportsAutoCommit = true;
        this.usesNativeBatchWriting = false;
    }

    public int addBatch(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.addBatch();
        return 0;
    }

    public boolean allowsSizeInProcedureArguments() {
        return true;
    }

    protected void appendBoolean(Boolean bl, Writer writer) throws IOException {
        if (bl.booleanValue()) {
            writer.write("1");
        } else {
            writer.write("0");
        }
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        writer.write("{b '");
        Helper.writeHexString(byArray, writer);
        writer.write("'}");
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        writer.write("{d '");
        writer.write(Helper.printDate(date));
        writer.write("'}");
    }

    protected void appendNumber(Number number, Writer writer) throws IOException {
        writer.write(number.toString());
    }

    public void appendParameter(Call call, Writer writer, Object object) {
        DatabaseCall databaseCall = (DatabaseCall)call;
        try {
            if (object instanceof Calendar && !databaseCall.usesBinding(this)) {
                this.appendCalendar((Calendar)object, writer);
                return;
            }
            Object object2 = this.convertToDatabaseType(object);
            if (databaseCall.usesBinding(this)) {
                databaseCall.bindParameter(writer, object2);
            } else if (object2 instanceof String) {
                if (this.usesStringBinding() && ((String)object2).length() >= this.getStringBindingSize()) {
                    databaseCall.bindParameter(writer, object2);
                } else {
                    this.appendString((String)object2, writer);
                }
            } else if (object2 instanceof Number) {
                this.appendNumber((Number)object2, writer);
            } else if (object2 instanceof Time) {
                this.appendTime((Time)object2, writer);
            } else if (object2 instanceof Timestamp) {
                this.appendTimestamp((Timestamp)object2, writer);
            } else if (object2 instanceof Date) {
                this.appendDate((Date)object2, writer);
            } else if (object2 == null) {
                writer.write("NULL");
            } else if (object2 instanceof Boolean) {
                this.appendBoolean((Boolean)object2, writer);
            } else if (object2 instanceof byte[]) {
                if (this.usesByteArrayBinding()) {
                    databaseCall.bindParameter(writer, object2);
                } else {
                    this.appendByteArray((byte[])object2, writer);
                }
            } else if (object2 instanceof Vector) {
                this.printValuelist((Vector)object2, databaseCall, writer);
            } else if (object instanceof Struct || object instanceof Array || object instanceof Ref) {
                databaseCall.bindParameter(writer, object);
            } else if (Helper.isCollection(object2)) {
                this.printValuelist(Helper.makeVectorFromObject(object2), databaseCall, writer);
            } else if (object2.getClass() == (array$I == null ? (array$I = DatabasePlatform.class$("[I")) : array$I)) {
                this.printValuelist((int[])object2, databaseCall, writer);
            } else if (object2 instanceof AppendCallCustomParameter) {
                ((AppendCallCustomParameter)object2).append(writer);
            } else if (object2 instanceof BindCallCustomParameter) {
                databaseCall.bindParameter(writer, object2);
            } else if (object2 instanceof Struct || object2 instanceof Array || object2 instanceof Ref) {
                databaseCall.bindParameter(writer, object2);
            } else {
                writer.write(object2.toString());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected void appendString(String string, Writer writer) throws IOException {
        writer.write(39);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\'') {
                writer.write("''");
                continue;
            }
            writer.write(string.charAt(i));
        }
        writer.write(39);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        writer.write("{t '");
        writer.write(Helper.printTime(time));
        writer.write("'}");
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printTimestamp(timestamp));
        writer.write("'}");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'}");
    }

    public void autoCommit(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            Statement statement = databaseAccessor.getConnection().createStatement();
            try {
                statement.executeUpdate("BEGIN TRANSACTION");
            }
            finally {
                statement.close();
            }
        }
    }

    public DatabaseCall buildCallWithReturning(SQLCall sQLCall, Vector vector) {
        throw ValidationException.platformDoesNotSupportCallWithReturning(Helper.getShortClassName(this));
    }

    protected Hashtable buildClassTypes() {
        Hashtable<String, Class> hashtable = new Hashtable<String, Class>();
        hashtable.put("NUMBER", class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabasePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashtable.put("DECIMAL", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DatabasePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        hashtable.put("INTEGER", class$java$lang$Integer == null ? (class$java$lang$Integer = DatabasePlatform.class$("java.lang.Integer")) : class$java$lang$Integer);
        hashtable.put("INT", class$java$lang$Integer == null ? (class$java$lang$Integer = DatabasePlatform.class$("java.lang.Integer")) : class$java$lang$Integer);
        hashtable.put("NUMERIC", class$java$lang$Long == null ? (class$java$lang$Long = DatabasePlatform.class$("java.lang.Long")) : class$java$lang$Long);
        hashtable.put("FLOAT(16)", class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float);
        hashtable.put("FLOAT(32)", class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double);
        hashtable.put("NUMBER(1) default 0", class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabasePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        hashtable.put("SHORT", class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short);
        hashtable.put("BYTE", class$java$lang$Byte == null ? (class$java$lang$Byte = DatabasePlatform.class$("java.lang.Byte")) : class$java$lang$Byte);
        hashtable.put("DOUBLE", class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double);
        hashtable.put("FLOAT", class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float);
        hashtable.put("SMALLINT", class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short);
        hashtable.put("BIT", class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabasePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        hashtable.put("SMALLINT DEFAULT 0", class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabasePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        hashtable.put("VARCHAR", class$java$lang$String == null ? (class$java$lang$String = DatabasePlatform.class$("java.lang.String")) : class$java$lang$String);
        hashtable.put("CHAR", class$java$lang$Character == null ? (class$java$lang$Character = DatabasePlatform.class$("java.lang.Character")) : class$java$lang$Character);
        hashtable.put("LONGVARBINARY", array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DatabasePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        hashtable.put("TEXT", array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        hashtable.put("LONGTEXT", array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        hashtable.put("MEMO", array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        hashtable.put("VARCHAR2", class$java$lang$String == null ? (class$java$lang$String = DatabasePlatform.class$("java.lang.String")) : class$java$lang$String);
        hashtable.put("LONG RAW", array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DatabasePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        hashtable.put("LONG", array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        hashtable.put("DATE", class$java$sql$Date == null ? (class$java$sql$Date = DatabasePlatform.class$("java.sql.Date")) : class$java$sql$Date);
        hashtable.put("TIMESTAMP", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DatabasePlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        hashtable.put("TIME", class$java$sql$Time == null ? (class$java$sql$Time = DatabasePlatform.class$("java.sql.Time")) : class$java$sql$Time);
        hashtable.put("DATETIME", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DatabasePlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        hashtable.put("BIGINT", class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabasePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashtable.put("DOUBLE PRECIS", class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double);
        hashtable.put("IMAGE", array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DatabasePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        hashtable.put("LONGVARCHAR", array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        hashtable.put("REAL", class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float);
        hashtable.put("TINYINT", class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short);
        hashtable.put("BLOB", array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DatabasePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        return hashtable;
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabasePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("NUMBER", 1));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DatabasePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("NUMBER", 10));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DatabasePlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("NUMBER", 5));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DatabasePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("NUMBER", 3));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabasePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DatabasePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("NUMBER", 19, 0).setLimits(19, 0, 19));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = DatabasePlatform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR"));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = DatabasePlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR"));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DatabasePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("BLOB"));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DatabasePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("CLOB"));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = DatabasePlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE"));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DatabasePlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("TIMESTAMP"));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = DatabasePlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("TIME"));
        return hashtable;
    }

    public String buildProcedureCallString(StoredProcedureCall storedProcedureCall, Session session) {
        int n;
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(storedProcedureCall.getCallHeader(this));
        stringWriter.write(storedProcedureCall.getProcedureName());
        if (this.requiresProcedureCallBrackets()) {
            stringWriter.write("(");
        } else {
            stringWriter.write(" ");
        }
        for (int i = n = storedProcedureCall.getFirstParameterIndexForCallString(); i < storedProcedureCall.getParameters().size(); ++i) {
            String string = (String)storedProcedureCall.getProcedureArgumentNames().elementAt(i);
            Object e = storedProcedureCall.getParameters().elementAt(i);
            Integer n2 = (Integer)storedProcedureCall.getParameterTypes().elementAt(i);
            if (string != null) {
                stringWriter.write(this.getProcedureArgumentString());
                stringWriter.write(string);
                stringWriter.write(this.getProcedureArgumentSetter());
            }
            stringWriter.write("?");
            if (storedProcedureCall.isOutputParameterType(n2) && this.requiresProcedureCallOuputToken()) {
                stringWriter.write(" ");
                stringWriter.write(this.getOutputProcedureToken());
            }
            if (i + 1 >= storedProcedureCall.getParameters().size()) continue;
            stringWriter.write(", ");
        }
        storedProcedureCall.setProcedureArgumentNames(null);
        if (this.requiresProcedureCallBrackets()) {
            stringWriter.write(")");
        }
        stringWriter.write(this.getProcedureCallTail());
        return stringWriter.toString();
    }

    public boolean canBuildCallWithReturning() {
        return false;
    }

    public void commitTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().commit();
        }
    }

    public Object convertToDatabaseType(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == ClassConstants.UTILDATE) {
            return Helper.timestampFromDate((java.util.Date)object);
        }
        if (object instanceof Character) {
            return ((Character)object).toString();
        }
        if (object instanceof Calendar) {
            return Helper.timestampFromDate(((Calendar)object).getTime());
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Character[]) {
            return this.convertObject(object, ClassConstants.STRING);
        }
        if (object instanceof Byte[]) {
            return this.convertObject(object, ClassConstants.APBYTE);
        }
        return object;
    }

    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof DatabasePlatform)) {
            return;
        }
        DatabasePlatform databasePlatform = (DatabasePlatform)platform;
        databasePlatform.setShouldTrimStrings(this.shouldTrimStrings());
        databasePlatform.setUsesNativeSQL(this.usesNativeSQL());
        databasePlatform.setUsesByteArrayBinding(this.usesByteArrayBinding());
        databasePlatform.setUsesStringBinding(this.usesStringBinding());
        databasePlatform.setShouldBindAllParameters(this.shouldBindAllParameters());
        databasePlatform.setShouldCacheAllStatements(this.shouldCacheAllStatements());
        databasePlatform.setStatementCacheSize(this.getStatementCacheSize());
        databasePlatform.setTransactionIsolation(this.getTransactionIsolation());
        databasePlatform.setMaxBatchWritingSize(this.getMaxBatchWritingSize());
        databasePlatform.setShouldForceFieldNamesToUpperCase(this.shouldForceFieldNamesToUpperCase());
        databasePlatform.setShouldOptimizeDataConversion(this.shouldOptimizeDataConversion());
        databasePlatform.setStringBindingSize(this.getStringBindingSize());
        databasePlatform.setUsesBatchWriting(this.usesBatchWriting());
        databasePlatform.setUsesStreamsForBinding(this.usesStreamsForBinding());
    }

    public String getBatchBeginString() {
        return "";
    }

    public String getBatchDelimiterString() {
        return "; ";
    }

    public String getBatchEndString() {
        return "";
    }

    public String getConstraintDeletionString() {
        return " DROP CONSTRAINT ";
    }

    public String getCreateViewString() {
        return "CREATE VIEW ";
    }

    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    public String getProcedureAsString() {
        return " AS";
    }

    public Hashtable getClassTypes() {
        if (this.classTypes == null) {
            this.classTypes = this.buildClassTypes();
        }
        return this.classTypes;
    }

    public String getAssignmentString() {
        return "= ";
    }

    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    public String getCreationOutputProcedureToken() {
        return this.getOutputProcedureToken();
    }

    public int getCursorCode() {
        return this.cursorCode;
    }

    public FieldTypeDefinition getFieldTypeDefinition(Class clazz) {
        return (FieldTypeDefinition)this.getFieldTypes().get(clazz);
    }

    public Hashtable getFieldTypes() {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.buildFieldTypes();
        }
        return this.fieldTypes;
    }

    public String getFunctionCallHeader() {
        return this.getProcedureCallHeader() + "? " + this.getAssignmentString();
    }

    public String getInOutputProcedureToken() {
        return "IN OUT";
    }

    public int getJDBCType(DatabaseField databaseField) {
        if (databaseField != null) {
            if (databaseField.getSqlType() != -1) {
                return databaseField.getSqlType();
            }
            return this.getJDBCType(ConversionManager.getObjectClass(databaseField.getType()));
        }
        return this.getJDBCType((Class)null);
    }

    public int getJDBCType(Class clazz) {
        if (clazz == null) {
            return 12;
        }
        if (clazz == ClassConstants.STRING) {
            return 12;
        }
        if (clazz == ClassConstants.BIGDECIMAL) {
            return 3;
        }
        if (clazz == ClassConstants.BIGINTEGER) {
            return -5;
        }
        if (clazz == ClassConstants.BOOLEAN) {
            return -7;
        }
        if (clazz == ClassConstants.DOUBLE) {
            return 8;
        }
        if (clazz == ClassConstants.FLOAT) {
            return 6;
        }
        if (clazz == ClassConstants.INTEGER) {
            return 4;
        }
        if (clazz == ClassConstants.LONG) {
            return 4;
        }
        if (clazz == ClassConstants.NUMBER) {
            return 3;
        }
        if (clazz == ClassConstants.TIME) {
            return 92;
        }
        if (clazz == ClassConstants.SQLDATE) {
            return 91;
        }
        if (clazz == ClassConstants.TIMESTAMP || clazz == ClassConstants.UTILDATE) {
            return 93;
        }
        if (clazz == ClassConstants.APBYTE) {
            return -4;
        }
        if (clazz == ClassConstants.BLOB) {
            return 2004;
        }
        return 12;
    }

    public String getJdbcTypeName(int n) {
        return null;
    }

    public int getMaxBatchWritingSize() {
        return this.maxBatchWritingSize;
    }

    public int getMaxFieldNameSize() {
        return 50;
    }

    public int getMaxForeignKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2, Session session) throws SQLException {
        return resultSet.getObject(n);
    }

    public String getOutputProcedureToken() {
        return "OUT";
    }

    public String getProcedureArgumentSetter() {
        return " = ";
    }

    public String getProcedureArgumentString() {
        return "";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE PROCEDURE ";
    }

    public String getProcedureCallTail() {
        return "";
    }

    public String getQualifiedSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            String string = ((TableSequence)this.getDefaultSequence()).getTableName();
            if (this.getTableQualifier().equals("")) {
                return string;
            }
            return this.getTableQualifier() + "." + string;
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public String getSelectForUpdateNoWaitString() {
        return " NOWAIT";
    }

    public String getSelectForUpdateOfString() {
        return " FOR UPDATE OF ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE OF *";
    }

    public String getSequenceCounterFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getCounterFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getCounterFieldName");
    }

    public String getSequenceNameFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getNameFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getNameFieldName");
    }

    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public String getSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getTableName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public String getStoredProcedureParameterPrefix() {
        return "";
    }

    public String getStoredProcedureTerminationToken() {
        return ";";
    }

    public int getStringBindingSize() {
        return this.stringBindingSize;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public boolean isInformixOuterJoin() {
        return false;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DatabasePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DatabasePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MAX_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(Double.MAX_VALUE));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DatabasePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MAX_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabasePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("999999999999999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DatabasePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("99999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DatabasePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DatabasePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MIN_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DatabasePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(Double.MIN_VALUE));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DatabasePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DatabasePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DatabasePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MIN_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabasePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-99999999999999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DatabasePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public void printFieldIdentityClause(Writer writer, Session session, String string) throws ValidationException {
        if (!this.supportsNativeSequenceNumbers() || !this.shouldNativeSequenceAcquireValueAfterInsert()) {
            return;
        }
        if (session.getSequencing() == null || session.getSequencing().whenShouldAcquireValueForAll() == -1) {
            return;
        }
        boolean bl = false;
        DatabaseField databaseField = new DatabaseField(string);
        Iterator iterator = session.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.usesSequenceNumbers() || !descriptor.getSequenceNumberField().equals(databaseField)) continue;
            String string2 = descriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(string2);
            bl = sequence.shouldAcquireValueAfterInsert();
            break;
        }
        if (bl) {
            this.printFieldIdentityClause(writer);
        }
    }

    public Statement prepareBatchStatement(Statement statement) throws SQLException {
        return statement;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
    }

    public void printFieldNotNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NOT NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
    }

    public void printValuelist(int[] nArray, DatabaseCall databaseCall, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < nArray.length; ++i) {
            this.appendParameter(databaseCall, writer, new Integer(nArray[i]));
            if (i >= nArray.length - 1) continue;
            writer.write(", ");
        }
        writer.write(")");
    }

    public void printValuelist(Vector vector, DatabaseCall databaseCall, Writer writer) throws IOException {
        writer.write("(");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.appendParameter(databaseCall, writer, enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            writer.write(", ");
        }
        writer.write(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processResultSet(ResultSet resultSet, DatabaseCall databaseCall, PreparedStatement preparedStatement, DatabaseAccessor databaseAccessor, Session session) throws SQLException {
        Cloneable cloneable = null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        session.startOperationProfile("row fetch");
        try {
            if (databaseCall.isOneRowReturned()) {
                if (resultSet.next()) {
                    cloneable = databaseAccessor.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, session);
                    if (resultSet.next()) {
                        session.getEventManager().moreRowsDetected(databaseCall);
                    }
                } else {
                    cloneable = null;
                }
            } else {
                Vector<DatabaseRow> vector = new Vector<DatabaseRow>(20);
                while (resultSet.next()) {
                    vector.addElement(databaseAccessor.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, session));
                }
                cloneable = vector;
            }
            resultSet.close();
        }
        finally {
            session.endOperationProfile("row fetch");
        }
        return cloneable;
    }

    public void registerOutputParameter(CallableStatement callableStatement, int n, int n2) throws SQLException {
        callableStatement.registerOutParameter(n, n2);
    }

    public boolean requiresNamedPrimaryKeyConstraints() {
        return false;
    }

    public boolean requiresProcedureCallBrackets() {
        return true;
    }

    public boolean requiresProcedureCallOuputToken() {
        return false;
    }

    public boolean requiresTypeNameToRegisterOutputParameter() {
        return false;
    }

    public void rollbackTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().rollback();
        }
    }

    protected void setClassTypes(Hashtable hashtable) {
        this.classTypes = hashtable;
    }

    public void setCursorCode(int n) {
        this.cursorCode = n;
    }

    protected void setFieldTypes(Hashtable hashtable) {
        this.fieldTypes = hashtable;
    }

    public void setMaxBatchWritingSize(int n) {
        this.maxBatchWritingSize = n;
    }

    public void setSequenceCounterFieldName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setCounterFieldName(string);
        } else if (!string.equals(new TableSequence().getCounterFieldName())) {
            ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setCounterFieldName");
        }
    }

    public void setSequenceNameFieldName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setNameFieldName(string);
        } else if (!string.equals(new TableSequence().getNameFieldName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setNameFieldName");
        }
    }

    public void setSequenceTableName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setTableName(string);
        } else if (!string.equals(new TableSequence().getTableName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setTableName");
        }
    }

    public void setShouldBindAllParameters(boolean bl) {
        this.shouldBindAllParameters = bl;
    }

    public void setShouldCacheAllStatements(boolean bl) {
        this.shouldCacheAllStatements = bl;
    }

    public void setShouldForceFieldNamesToUpperCase(boolean bl) {
        this.shouldForceFieldNamesToUpperCase = bl;
    }

    public static void setShouldIgnoreCaseOnFieldComparisons(boolean bl) {
        shouldIgnoreCaseOnFieldComparisons = bl;
    }

    public void setShouldOptimizeDataConversion(boolean bl) {
        this.shouldOptimizeDataConversion = bl;
    }

    public void setShouldTrimStrings(boolean bl) {
        this.shouldTrimStrings = bl;
    }

    public void setStatementCacheSize(int n) {
        this.statementCacheSize = n;
    }

    public void setStringBindingSize(int n) {
        this.stringBindingSize = n;
    }

    public void setSupportsAutoCommit(boolean bl) {
        this.supportsAutoCommit = bl;
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation = n;
    }

    public void setUsesBatchWriting(boolean bl) {
        this.usesBatchWriting = bl;
    }

    public void setUsesByteArrayBinding(boolean bl) {
        this.usesByteArrayBinding = bl;
    }

    public void setUsesJDBCBatchWriting(boolean bl) {
        this.usesJDBCBatchWriting = bl;
    }

    public void setUsesNativeBatchWriting(boolean bl) {
        this.usesNativeBatchWriting = bl;
    }

    public void setUsesNativeSQL(boolean bl) {
        this.usesNativeSQL = bl;
    }

    public void setUsesStreamsForBinding(boolean bl) {
        this.usesStreamsForBinding = bl;
    }

    public void setUsesStringBinding(boolean bl) {
        this.usesStringBinding = bl;
    }

    public boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public boolean shouldCacheAllStatements() {
        return this.shouldCacheAllStatements;
    }

    public boolean shouldForceFieldNamesToUpperCase() {
        return this.shouldForceFieldNamesToUpperCase;
    }

    public static boolean shouldIgnoreCaseOnFieldComparisons() {
        return shouldIgnoreCaseOnFieldComparisons;
    }

    public boolean shouldIgnoreException(SQLException sQLException) {
        return false;
    }

    public boolean shouldOptimizeDataConversion() {
        return this.shouldOptimizeDataConversion;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return false;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return false;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean shouldTrimStrings() {
        return this.shouldTrimStrings;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return true;
    }

    public boolean supportsAutoCommit() {
        return this.supportsAutoCommit;
    }

    public boolean supportsForeignKeyConstraints() {
        return true;
    }

    public boolean supportsNativeSequenceNumbers() {
        return false;
    }

    public boolean supportsPrimaryKeyConstraint() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return false;
    }

    public int executeBatch(Statement statement, boolean bl) throws SQLException {
        statement.executeBatch();
        return 1;
    }

    public Object executeStoredProcedure(DatabaseCall databaseCall, PreparedStatement preparedStatement, DatabaseAccessor databaseAccessor, Session session) throws SQLException {
        Vector vector = null;
        ResultSet resultSet = null;
        if (!databaseCall.getReturnsResultSet()) {
            if (databaseCall.isCursorOutputProcedure()) {
                vector = databaseAccessor.executeNoSelect(databaseCall, preparedStatement, session);
                resultSet = (ResultSet)((CallableStatement)preparedStatement).getObject(databaseCall.getCursorOutIndex());
            } else {
                databaseAccessor.executeDirectNoSelect(preparedStatement, databaseCall, session);
                vector = databaseAccessor.buildOutputRow((CallableStatement)preparedStatement, databaseCall, session);
                if (databaseCall.areManyRowsReturned()) {
                    Vector vector2 = new Vector();
                    vector2.add(vector);
                    vector = vector2;
                }
            }
        } else {
            resultSet = databaseAccessor.executeSelect(databaseCall, preparedStatement, session);
        }
        if (resultSet != null) {
            databaseCall.matchFieldOrder(resultSet, databaseAccessor, session);
            if (databaseCall.isCursorReturned()) {
                databaseCall.setStatement(preparedStatement);
                databaseCall.setResult(resultSet);
                return databaseCall;
            }
            vector = this.processResultSet(resultSet, databaseCall, preparedStatement, databaseAccessor, session);
        }
        return vector;
    }

    public void setParameterValueInDatabaseCall(Object object, PreparedStatement preparedStatement, int n, Session session) throws SQLException {
        if ((object = this.convertToDatabaseType(object)) == null) {
            preparedStatement.setNull(n, this.getJDBCType((Class)null));
        } else if (object instanceof DatabaseField) {
            if (object instanceof ObjectRelationalDatabaseField) {
                ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)object;
                preparedStatement.setNull(n, objectRelationalDatabaseField.getSqlType(), objectRelationalDatabaseField.getSqlTypeName());
            } else {
                int n2 = this.getJDBCType((DatabaseField)object);
                preparedStatement.setNull(n, n2);
            }
        } else if (object instanceof byte[] && this.usesStreamsForBinding()) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, ((byte[])object).length);
        } else if (object instanceof String && this.usesStringBinding() && ((String)object).length() > this.getStringBindingSize()) {
            CharArrayReader charArrayReader = new CharArrayReader(((String)object).toCharArray());
            preparedStatement.setCharacterStream(n, (Reader)charArrayReader, ((String)object).length());
        } else if (object instanceof BindCallCustomParameter) {
            ((BindCallCustomParameter)object).set(this, preparedStatement, n, session);
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    public void setParameterValueInDatabaseCall(Vector vector, PreparedStatement preparedStatement, int n, Session session) throws SQLException {
        this.setParameterValueInDatabaseCall(vector, preparedStatement, n, n + 1, session);
    }

    public void setParameterValueInDatabaseCall(Vector vector, PreparedStatement preparedStatement, int n, int n2, Session session) throws SQLException {
        this.setParameterValueInDatabaseCall(vector.elementAt(n), preparedStatement, n2, session);
    }

    public boolean usesBatchWriting() {
        return this.usesBatchWriting;
    }

    public boolean usesByteArrayBinding() {
        return this.usesByteArrayBinding;
    }

    public boolean usesSequenceTable() {
        return this.getDefaultSequence() instanceof TableSequence;
    }

    public boolean usesJDBCBatchWriting() {
        return this.usesJDBCBatchWriting;
    }

    public boolean usesNativeBatchWriting() {
        return this.usesNativeBatchWriting;
    }

    public boolean usesNativeSQL() {
        return this.usesNativeSQL;
    }

    public boolean usesStreamsForBinding() {
        return this.usesStreamsForBinding;
    }

    public boolean usesStringBinding() {
        return this.usesStringBinding;
    }

    public void writeLOB(DatabaseField databaseField, Object object, ResultSet resultSet, Session session) throws SQLException {
    }

    public boolean shouldNativeSequenceUseTransaction() {
        return false;
    }

    public boolean shouldNativeSequenceAcquireValueAfterInsert() {
        return false;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence() {
        return null;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence(String string, Integer n) {
        return null;
    }

    protected Sequence createPlatformDefaultSequence() {
        return new TableSequence();
    }

    public String getIdentifierQuoteCharacter() {
        return "\"";
    }

    public Connection getConnection(Session session, Connection connection) {
        return connection;
    }

    public Array createArray(String string, Object[] objectArray, Session session) throws SQLException {
        return null;
    }

    public Struct createStruct(String string, Object[] objectArray, Session session) throws SQLException {
        return null;
    }

    public boolean isXDBDocument(Object object) {
        return false;
    }

    public Object getRefValue(Ref ref) throws SQLException {
        return ref.getObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

