/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.lang.reflect.Method;
import java.util.HashSet;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.annotations.CBListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCBListener
extends CBListener {
    protected Class m_entityClass;

    public EntityCBListener(Class clazz) {
        this.m_entityClass = clazz;
    }

    @Override
    public Class getListenerClass() {
        return this.m_entityClass;
    }

    @Override
    protected void invokeMethods(HashSet<Method> hashSet, DescriptorEvent descriptorEvent) {
        if (hashSet != null) {
            for (Method method : hashSet) {
                try {
                    Object[] objectArray = new Object[]{};
                    method.invoke(descriptorEvent.getObject(), objectArray);
                }
                catch (Exception exception) {
                    throw ValidationException.invalidCallbackMethod(descriptorEvent.getObject().getClass(), method.toString());
                }
            }
        }
    }

    @Override
    protected void validateMethod(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw ValidationException.invalidEntityCallbackMethodArguments(this.m_entityClass, method.getName());
        }
    }
}

