/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.persistence.AccessType;
import javax.persistence.AssociationTable;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListener;
import javax.persistence.EntityType;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceJoinColumn;
import javax.persistence.InheritanceJoinColumns;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.LobType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Serialized;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.annotations.Accessor;
import oracle.toplink.internal.annotations.CBListener;
import oracle.toplink.internal.annotations.ColumnDetails;
import oracle.toplink.internal.annotations.DescriptorMetadata;
import oracle.toplink.internal.annotations.EJBAnnotationsLogger;
import oracle.toplink.internal.annotations.EntityCBListener;
import oracle.toplink.internal.annotations.InheritanceJoinColumnDetails;
import oracle.toplink.internal.annotations.JoinColumnDetails;
import oracle.toplink.internal.annotations.SequencingProcessor;
import oracle.toplink.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectToFieldMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.ManyToManyMapping;
import oracle.toplink.mappings.OneToManyMapping;
import oracle.toplink.mappings.OneToOneMapping;
import oracle.toplink.mappings.TypeConversionMapping;
import oracle.toplink.mappings.converters.SerializedObjectConverter;
import oracle.toplink.publicinterface.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotationsProcessor {
    protected static final String DEFAULT_DISCRIMINATOR_COLUMN = "TYPE";
    protected static final String IS_PROPERTY_METHOD_PREFIX = "is";
    protected static final String GET_PROPERTY_METHOD_PREFIX = "get";
    protected static final String SET_PROPERTY_METHOD_PREFIX = "set";
    protected static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    protected static final int POSITION_AFTER_IS_PREFIX = "is".length();
    protected static final int POSITION_AFTER_GET_PREFIX = "get".length();
    private Session m_session;
    private ClassLoader m_loader;
    private Collection<Class> m_classes;
    private EJBAnnotationsLogger m_logger;
    private HashSet<Class> m_relatedClasses;
    private HashSet<DescriptorMetadata> m_dmdsWithQueries;
    private Hashtable<Class, DescriptorMetadata> m_descriptorMetadata;
    private SequencingProcessor m_sequencingProcessor;

    public EJBAnnotationsProcessor(Session session, ClassLoader classLoader) {
        this.m_loader = classLoader;
        this.m_session = session;
        this.m_relatedClasses = new HashSet();
        this.m_logger = new EJBAnnotationsLogger(this.m_session);
        this.m_sequencingProcessor = new SequencingProcessor();
        this.m_dmdsWithQueries = new HashSet();
        this.m_descriptorMetadata = new Hashtable();
    }

    public EJBAnnotationsProcessor(Session session, ClassLoader classLoader, Collection<Class> collection) {
        this(session, classLoader);
        this.setClasses(collection);
    }

    public void addEntityListeners(Session session, Collection<Class> collection, ClassLoader classLoader) {
        this.m_loader = classLoader;
        for (Class clazz : collection) {
            DescriptorMetadata descriptorMetadata = new DescriptorMetadata(session.getDescriptor(clazz));
            if (clazz.isAnnotationPresent(EntityListener.class)) {
                EntityListener entityListener = (EntityListener)EJBAnnotationsProcessor.getAnnotation(clazz, EntityListener.class);
                Class clazz2 = this.getClassForName(entityListener.value());
                this.processEvents(new CBListener(clazz2), descriptorMetadata);
            }
            this.processEvents(new EntityCBListener(clazz), descriptorMetadata);
        }
    }

    public void addNamedQueriesToSession(Session session) {
        for (DescriptorMetadata descriptorMetadata : this.m_dmdsWithQueries) {
            Hashtable<String, String> hashtable = descriptorMetadata.getNamedQueries();
            for (String string : hashtable.keySet()) {
                String string2 = hashtable.get(string);
                if (session.getQuery(string) != null) {
                    this.m_logger.logWarningMessage(29, descriptorMetadata.getJavaClass(), string);
                    continue;
                }
                try {
                    session.addQuery(string, EJBQueryImpl.buildDatabaseQuery(string2, session));
                }
                catch (Exception exception) {
                    throw ValidationException.errorProcessingNamedQueryAnnotation(descriptorMetadata.getJavaClass(), string, exception);
                }
            }
        }
    }

    protected Accessor buildAccessor(AnnotatedElement annotatedElement, String string, Type type) {
        Accessor accessor = new Accessor(annotatedElement, type, string);
        if (this.isGenericCollectionType(type)) {
            accessor.setReferenceClass(this.getReturnTypeFromGeneric(type));
        } else {
            accessor.setReferenceClass((Class)type);
        }
        return accessor;
    }

    protected boolean descriptorAlreadyExists(Class clazz) {
        return this.m_session.hasDescriptor(clazz);
    }

    protected static <T extends Annotation> T getAnnotation(AnnotatedElement annotatedElement, Class clazz) {
        return annotatedElement.getAnnotation(clazz);
    }

    protected AssociationTable getAssociationTableFromReference(Class clazz, String string) {
        DescriptorMetadata descriptorMetadata = this.getDescriptorMetadata(clazz);
        for (Accessor accessor : descriptorMetadata.getRelationshipAccessors()) {
            AnnotatedElement annotatedElement = accessor.getAnnotatedElement();
            ManyToMany manyToMany = (ManyToMany)EJBAnnotationsProcessor.getAnnotation(annotatedElement, ManyToMany.class);
            if (manyToMany == null || !manyToMany.mappedBy().equals(string)) continue;
            return (AssociationTable)EJBAnnotationsProcessor.getAnnotation(annotatedElement, AssociationTable.class);
        }
        return null;
    }

    protected String getAssociationTableName(AssociationTable associationTable, AnnotatedElement annotatedElement, Class clazz, Class clazz2, boolean bl) {
        String string;
        String string2 = Helper.getShortClassName(clazz.getName()).toUpperCase();
        String string3 = Helper.getShortClassName(clazz2.getName()).toUpperCase();
        String string4 = string = bl ? string3 + "_" + string2 : string2 + "_" + string3;
        if (associationTable != null) {
            Table table = associationTable.table();
            return this.getFullyQualifiedTableName(table.name(), string, table.catalog(), table.schema(), 13, annotatedElement);
        }
        this.m_logger.logConfigMessage(13, annotatedElement, string);
        return string;
    }

    protected String getAttributeNameFromMethodName(String string) {
        String string2;
        String string3;
        if (string.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            string3 = string.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            string2 = string.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else {
            string3 = string.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            string2 = string.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return string3.toLowerCase().concat(string2);
    }

    public Collection<Class> getClasses() {
        return this.m_classes;
    }

    protected Class getClassForName(String string) {
        try {
            return PrivilegedAccessController.getClassForName(string, true, this.m_loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.unableToLoadClass(string, classNotFoundException);
        }
    }

    protected String getDeclaredMethod(String string, Class clazz, Class[] classArray) {
        try {
            PrivilegedAccessController.getDeclaredMethod(clazz, string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return string;
    }

    protected DescriptorMetadata getDescriptorMetadata(Class clazz) {
        DescriptorMetadata descriptorMetadata = this.m_descriptorMetadata.get(clazz);
        if (descriptorMetadata == null) {
            if (this.descriptorAlreadyExists(clazz)) {
                descriptorMetadata = new DescriptorMetadata(this.m_session.getDescriptor(clazz));
            } else {
                descriptorMetadata = new DescriptorMetadata(clazz);
                this.m_session.getProject().addDescriptor(descriptorMetadata.getDescriptor());
            }
            this.m_descriptorMetadata.put(clazz, descriptorMetadata);
        }
        return descriptorMetadata;
    }

    protected Field[] getFields(Class clazz) {
        return PrivilegedAccessController.getDeclaredFields(clazz);
    }

    protected String getFullyQualifiedColumnName(String string, String string2) {
        String string3 = string;
        if (string2 != null && !string2.equals("") && string.indexOf(46) < 0) {
            string3 = string2 + "." + string;
        }
        return string3;
    }

    protected String getFullyQualifiedColumnName(String string, String string2, String string3, int n, AnnotatedElement annotatedElement) {
        String string4;
        if (string != null && !string.equals("")) {
            string4 = this.getFullyQualifiedColumnName(string, string3);
        } else {
            string4 = this.getFullyQualifiedColumnName(string2, string3);
            this.m_logger.logConfigMessage(n, annotatedElement, string4);
        }
        return string4;
    }

    protected static String getFullyQualifiedTableName(String string, String string2, String string3) {
        if (!string2.equals("")) {
            string = string2 + "." + string;
        }
        if (!string3.equals("")) {
            string = string3 + "." + string;
        }
        return string;
    }

    protected String getFullyQualifiedTableName(String string, String string2, String string3, String string4, int n, AnnotatedElement annotatedElement) {
        String string5 = string;
        if (string5.equals("")) {
            string5 = string2;
            this.m_logger.logConfigMessage(n, annotatedElement, string5);
        }
        return EJBAnnotationsProcessor.getFullyQualifiedTableName(string5, string3, string4);
    }

    protected Type getGenericReturnType(Method method) {
        return method.getGenericReturnType();
    }

    protected Type getGenericType(Field field) {
        return field.getGenericType();
    }

    protected Class getInheritanceParent(DescriptorMetadata descriptorMetadata) {
        if (descriptorMetadata.getInheritanceParent() == null) {
            Class clazz = descriptorMetadata.getJavaClass();
            for (Class clazz2 = clazz.getSuperclass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                if (!clazz2.isAnnotationPresent(Inheritance.class)) continue;
                clazz = clazz2;
            }
            descriptorMetadata.setInheritanceParent(clazz);
        }
        return descriptorMetadata.getInheritanceParent();
    }

    protected Method[] getMethods(Class clazz) {
        return PrivilegedAccessController.getDeclaredMethods(clazz);
    }

    protected DatabaseMapping getOwnerMapping(DescriptorMetadata descriptorMetadata, String string, DescriptorMetadata descriptorMetadata2, String string2) {
        DatabaseMapping databaseMapping = descriptorMetadata.getMappingForAttributeName(string);
        if (databaseMapping == null) {
            for (Accessor accessor : descriptorMetadata.getRelationshipAccessors()) {
                if (!accessor.getAttributeName().equals(string)) continue;
                this.processRelationshipAccessor(accessor, descriptorMetadata);
            }
            databaseMapping = descriptorMetadata.getMappingForAttributeName(string);
        }
        if (databaseMapping == null) {
            throw ValidationException.noMappedByAttributeFound(descriptorMetadata.getJavaClass(), string, descriptorMetadata2.getJavaClass(), string2);
        }
        return databaseMapping;
    }

    protected Vector<String> getOwnerMappingFKs(DescriptorMetadata descriptorMetadata, String string, DescriptorMetadata descriptorMetadata2, String string2) {
        DatabaseMapping databaseMapping = this.getOwnerMapping(descriptorMetadata, string, descriptorMetadata2, string2);
        if (databaseMapping instanceof OneToManyMapping) {
            return ((OneToManyMapping)databaseMapping).getTargetForeignKeyFieldNames();
        }
        return ((OneToOneMapping)databaseMapping).getForeignKeyFieldNames();
    }

    protected Vector<String> getPrimaryKeyFieldNames(DescriptorMetadata descriptorMetadata) {
        Vector<String> vector = descriptorMetadata.getPrimaryKeyFieldNames();
        if (vector.isEmpty() && this.isInheritanceSubclass(descriptorMetadata)) {
            vector = this.getDescriptorMetadata(this.getInheritanceParent(descriptorMetadata)).getPrimaryKeyFieldNames();
        }
        return vector;
    }

    protected Class getReferenceClass(Class clazz, String string, int n, AnnotatedElement annotatedElement) {
        if (string.equals("")) {
            this.m_logger.logConfigMessage(n, annotatedElement, clazz);
            return clazz;
        }
        return this.getClassForName(string);
    }

    protected Class getReturnType(Method method) {
        return PrivilegedAccessController.getMethodReturnType(method);
    }

    protected Class getReturnTypeFromGeneric(Type type) {
        return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }

    protected String getSetMethodName(Method method, Class clazz) {
        String string = method.getName();
        Class[] classArray = new Class[]{method.getReturnType()};
        if (string.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return this.getDeclaredMethod(SET_PROPERTY_METHOD_PREFIX + string.substring(3), clazz, classArray);
        }
        String string2 = this.getDeclaredMethod(SET_PROPERTY_METHOD_PREFIX + string.substring(2), clazz, classArray);
        if (string2 == null) {
            return this.getDeclaredMethod(string2, clazz, classArray);
        }
        return string2;
    }

    protected Class getType(Field field) {
        return PrivilegedAccessController.getFieldType(field);
    }

    protected String getUnqualifiedColumnName(String string) {
        int n = string.indexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }

    protected boolean hasAssociationTable(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(AssociationTable.class);
    }

    protected boolean hasJoinColumns(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(JoinColumns.class) || annotatedElement.isAnnotationPresent(JoinColumn.class);
    }

    protected OneToOneMapping initOneToOneMapping(AnnotatedElement annotatedElement, String string, Class clazz, boolean bl, CascadeType[] cascadeTypeArray, DescriptorMetadata descriptorMetadata) {
        OneToOneMapping oneToOneMapping = new OneToOneMapping();
        oneToOneMapping.setIsReadOnly(false);
        oneToOneMapping.setIsPrivateOwned(false);
        oneToOneMapping.setAttributeName(string);
        oneToOneMapping.setReferenceClass(clazz);
        oneToOneMapping.setUsesIndirection(bl);
        if (descriptorMetadata.accessUsingMethods() && !bl) {
            this.setAccessorMethods((Method)annotatedElement, oneToOneMapping, descriptorMetadata);
        }
        this.processCascadeType(cascadeTypeArray, oneToOneMapping);
        return oneToOneMapping;
    }

    protected boolean isCollectionClass(Class clazz) {
        return clazz == Collection.class || clazz == Set.class;
    }

    protected boolean isGenericCollectionType(Type type) {
        return type instanceof ParameterizedType;
    }

    protected boolean isInheritanceSubclass(DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        if (clazz.isAnnotationPresent(Inheritance.class)) {
            return clazz != this.getInheritanceParent(descriptorMetadata);
        }
        return false;
    }

    protected boolean isManyToMany(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(ManyToMany.class);
    }

    protected boolean isManyToOne(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(ManyToOne.class);
    }

    protected boolean isOneToMany(AnnotatedElement annotatedElement, Class clazz, Type type) {
        if (!annotatedElement.isAnnotationPresent(OneToMany.class)) {
            if (this.isGenericCollectionType(type) || this.isCollectionClass(clazz)) {
                this.m_logger.logConfigMessage(10, annotatedElement);
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean isOneToOne(AnnotatedElement annotatedElement, Class clazz) {
        if (!annotatedElement.isAnnotationPresent(OneToOne.class)) {
            if (this.isRelationshipTargetClass(clazz)) {
                this.m_logger.logConfigMessage(9, annotatedElement);
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean isRelationship(AnnotatedElement annotatedElement, Class clazz, Type type) {
        return this.isManyToOne(annotatedElement) || this.isManyToMany(annotatedElement) || this.isOneToMany(annotatedElement, clazz, type) || this.isOneToOne(annotatedElement, clazz);
    }

    protected boolean isRelationshipTargetClass(Class clazz) {
        return this.getClasses().contains(clazz);
    }

    protected String populateMappingFromOneToManyAnnotation(OneToMany oneToMany, CollectionMapping collectionMapping, AnnotatedElement annotatedElement, String string, Class clazz, DescriptorMetadata descriptorMetadata) {
        collectionMapping.setIsReadOnly(false);
        collectionMapping.setIsPrivateOwned(false);
        collectionMapping.setAttributeName(string);
        if (descriptorMetadata.accessUsingMethods()) {
            this.setAccessorMethods((Method)annotatedElement, collectionMapping, descriptorMetadata);
        }
        String string2 = "";
        String string3 = "";
        collectionMapping.dontUseIndirection();
        if (oneToMany != null) {
            if (oneToMany.fetch() == FetchType.LAZY) {
                collectionMapping.useTransparentCollection();
            }
            string3 = oneToMany.targetEntity();
            this.processCascadeType(oneToMany.cascade(), collectionMapping);
            string2 = oneToMany.mappedBy();
        }
        Class clazz2 = this.getReferenceClass(clazz, string3, 17, annotatedElement);
        collectionMapping.setReferenceClass(clazz2);
        return string2;
    }

    protected void preProcessSequencing(AnnotatedElement annotatedElement) {
        this.m_sequencingProcessor.preProcessGeneratorTable(annotatedElement);
        this.m_sequencingProcessor.preProcessTableGenerator(annotatedElement);
        this.m_sequencingProcessor.preProcessSequenceGenerator(annotatedElement);
    }

    protected void processAccessor(Accessor accessor, DescriptorMetadata descriptorMetadata) {
        AnnotatedElement annotatedElement = accessor.getAnnotatedElement();
        this.processNamedQueries(annotatedElement, descriptorMetadata);
        this.preProcessSequencing(annotatedElement);
        Class clazz = descriptorMetadata.getJavaClass();
        Type type = accessor.getRelationType();
        String string = accessor.getAttributeName();
        Class clazz2 = accessor.getReferenceClass();
        if (annotatedElement.isAnnotationPresent(Embedded.class)) {
            Embedded embedded = (Embedded)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Embedded.class);
            this.processEmbedded(accessor, embedded.value(), descriptorMetadata, false);
        } else if (annotatedElement.isAnnotationPresent(EmbeddedId.class)) {
            this.processEmbeddedId(accessor, descriptorMetadata);
        } else if (this.isRelationship(annotatedElement, clazz2, type)) {
            if (descriptorMetadata.hasMappingForAttributeName(string)) {
                this.m_logger.logWarningMessage(20, clazz, string);
            } else {
                this.m_relatedClasses.add(clazz);
                descriptorMetadata.addRelationshipAccessor(accessor);
            }
        } else {
            Column column = (Column)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Column.class);
            ColumnDetails columnDetails = this.processColumn(annotatedElement, column, string, descriptorMetadata);
            String string2 = columnDetails.getName();
            boolean bl = columnDetails.isReadOnly();
            if (annotatedElement.isAnnotationPresent(Lob.class)) {
                if (descriptorMetadata.hasMappingForAttributeName(string)) {
                    this.m_logger.logWarningMessage(20, clazz, string);
                } else {
                    this.processLob(annotatedElement, string, string2, bl, clazz2, descriptorMetadata);
                }
            } else {
                if (annotatedElement.isAnnotationPresent(Version.class)) {
                    if (descriptorMetadata.usesOptimisticLocking()) {
                        this.m_logger.logWarningMessage(24, clazz, string);
                    } else {
                        descriptorMetadata.setOptimisticLockingPolicy(string2);
                    }
                } else {
                    this.processId(annotatedElement, string2, string, clazz2, descriptorMetadata);
                }
                if (descriptorMetadata.hasMappingForAttributeName(string)) {
                    this.m_logger.logWarningMessage(20, clazz, string);
                } else {
                    this.processDirectToFieldMapping(annotatedElement, string, string2, bl, descriptorMetadata);
                }
            }
        }
    }

    protected void processAccessorFields(DescriptorMetadata descriptorMetadata) {
        for (Field field : this.getFields(descriptorMetadata.getJavaClass())) {
            if (!this.validPersistenceField(field)) continue;
            Accessor accessor = this.buildAccessor(field, field.getName(), this.getGenericType(field));
            this.processAccessor(accessor, descriptorMetadata);
        }
    }

    protected void processAccessorMethods(DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        for (Method method : this.getMethods(clazz)) {
            if (!this.validPersistenceMethod(method, descriptorMetadata)) continue;
            String string = this.getAttributeNameFromMethodName(method.getName());
            Accessor accessor = this.buildAccessor(method, string, this.getGenericReturnType(method));
            this.processAccessor(accessor, descriptorMetadata);
        }
    }

    protected void processAccessors(DescriptorMetadata descriptorMetadata) {
        if (descriptorMetadata.accessUsingMethods()) {
            this.processAccessorMethods(descriptorMetadata);
        } else {
            this.processAccessorFields(descriptorMetadata);
        }
        if (descriptorMetadata.hasPKClass() && !descriptorMetadata.validatedPKClass()) {
            throw ValidationException.invalidCompositePKSpecification(descriptorMetadata.getJavaClass(), descriptorMetadata.getPKClass());
        }
        if (!(descriptorMetadata.hasPrimaryKeyFieldNames() || this.isInheritanceSubclass(descriptorMetadata) || descriptorMetadata.isDescriptorEmbbedable())) {
            throw ValidationException.noPrimaryKeyAnnotationsFound(descriptorMetadata.getJavaClass());
        }
    }

    protected void processAssociationTable(AnnotatedElement annotatedElement, ManyToManyMapping manyToManyMapping, DescriptorMetadata descriptorMetadata) {
        String string;
        AssociationTable associationTable = (AssociationTable)EJBAnnotationsProcessor.getAnnotation(annotatedElement, AssociationTable.class);
        Class clazz = descriptorMetadata.getJavaClass();
        boolean bl = false;
        String string2 = manyToManyMapping.getAttributeName();
        Class clazz2 = manyToManyMapping.getReferenceClass();
        DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(clazz2);
        if (associationTable == null) {
            associationTable = this.getAssociationTableFromReference(clazz2, string2);
            if (associationTable == null) {
                throw ValidationException.associationTableAnnotationNotFound(clazz, clazz2, string2);
            }
            bl = true;
        }
        String string3 = this.getAssociationTableName(associationTable, annotatedElement, clazz, clazz2, bl);
        manyToManyMapping.setRelationTableName(string3);
        Vector<JoinColumnDetails> vector = new Vector<JoinColumnDetails>();
        vector.add(new JoinColumnDetails());
        Vector<JoinColumnDetails> vector2 = new Vector<JoinColumnDetails>();
        vector2.add(new JoinColumnDetails());
        if (associationTable != null) {
            if (associationTable.joinColumns().length > 0) {
                vector.clear();
                for (JoinColumn object2 : associationTable.joinColumns()) {
                    vector.add(this.processJoinColumn(object2));
                }
            }
            if (associationTable.inverseJoinColumns().length > 0) {
                vector2.clear();
                for (JoinColumn joinColumn : associationTable.inverseJoinColumns()) {
                    vector2.add(this.processJoinColumn(joinColumn));
                }
            }
        }
        JoinColumn[] joinColumnArray = descriptorMetadata.getPrimaryTableName();
        if (vector.size() == 1) {
            String string4 = this.getFullyQualifiedColumnName(((JoinColumnDetails)vector.firstElement()).getPKColumn(), this.getPrimaryKeyFieldNames(descriptorMetadata).firstElement(), (String)joinColumnArray, 5, annotatedElement);
            String string5 = this.getUnqualifiedColumnName(string4);
            String string6 = this.getFullyQualifiedColumnName(((JoinColumnDetails)vector.firstElement()).getFKColumn(), string5, string3, 6, annotatedElement);
            manyToManyMapping.addSourceRelationKeyFieldName(string6, string4);
        } else if (vector.size() > 1) {
            for (JoinColumnDetails joinColumnDetails : vector) {
                String string7 = this.getFullyQualifiedColumnName(joinColumnDetails.getPKColumn(), joinColumnDetails.getPKColumn(), (String)joinColumnArray, 5, annotatedElement);
                string = this.getFullyQualifiedColumnName(joinColumnDetails.getFKColumn(), joinColumnDetails.getFKColumn(), string3, 6, annotatedElement);
                manyToManyMapping.addSourceRelationKeyFieldName(string, string7);
            }
        }
        String string6 = descriptorMetadata2.getPrimaryTableName();
        if (vector2.size() == 1) {
            String string7 = this.getFullyQualifiedColumnName(((JoinColumnDetails)vector2.firstElement()).getPKColumn(), this.getPrimaryKeyFieldNames(descriptorMetadata2).firstElement(), string6, 7, annotatedElement);
            String string8 = this.getUnqualifiedColumnName(string7);
            string = this.getFullyQualifiedColumnName(((JoinColumnDetails)vector2.firstElement()).getFKColumn(), string8, string3, 8, annotatedElement);
            manyToManyMapping.addTargetRelationKeyFieldName(string, string7);
        } else if (vector2.size() > 1) {
            for (JoinColumnDetails joinColumnDetails : vector2) {
                string = this.getFullyQualifiedColumnName(joinColumnDetails.getPKColumn(), joinColumnDetails.getPKColumn(), string6, 7, annotatedElement);
                String string9 = this.getFullyQualifiedColumnName(joinColumnDetails.getFKColumn(), joinColumnDetails.getFKColumn(), string3, 8, annotatedElement);
                manyToManyMapping.addTargetRelationKeyFieldName(string9, string);
            }
        }
    }

    protected void processAttributeOverride(AnnotatedElement annotatedElement, AttributeOverride[] attributeOverrideArray, AggregateObjectMapping aggregateObjectMapping, DescriptorMetadata descriptorMetadata, DescriptorMetadata descriptorMetadata2) {
        String string = aggregateObjectMapping.getAttributeName();
        for (AttributeOverride attributeOverride : attributeOverrideArray) {
            String string2 = this.getFullyQualifiedColumnName(attributeOverride.name(), descriptorMetadata2.getPrimaryTableName());
            Column[] columnArray = attributeOverride.column();
            if (columnArray.length == 0) {
                throw ValidationException.attributeOverrideColumnsNotSpecified(descriptorMetadata2.getJavaClass(), string);
            }
            for (Column column : columnArray) {
                ColumnDetails columnDetails = this.processColumn(annotatedElement, column, string, descriptorMetadata);
                aggregateObjectMapping.addFieldNameTranslation(columnDetails.getName(), string2);
            }
        }
    }

    protected void processBasic(Basic basic, DirectToFieldMapping directToFieldMapping, DescriptorMetadata descriptorMetadata) {
        if (basic != null && basic.fetch() == FetchType.LAZY) {
            throw ValidationException.invalidFetchLazyType(descriptorMetadata.getJavaClass(), directToFieldMapping.getAttributeName());
        }
    }

    protected void processCascadeType(CascadeType[] cascadeTypeArray, ForeignReferenceMapping foreignReferenceMapping) {
        for (CascadeType cascadeType : cascadeTypeArray) {
            if (cascadeType == CascadeType.ALL) {
                foreignReferenceMapping.setCascadeAll(true);
                continue;
            }
            if (cascadeType == CascadeType.MERGE) {
                foreignReferenceMapping.setCascadeMerge(true);
                continue;
            }
            if (cascadeType == CascadeType.PERSIST) {
                foreignReferenceMapping.setCascadePersist(true);
                continue;
            }
            if (cascadeType == CascadeType.REFRESH) {
                foreignReferenceMapping.setCascadeRefresh(true);
                continue;
            }
            if (cascadeType != CascadeType.REMOVE) continue;
            foreignReferenceMapping.setCascadeRemove(true);
        }
    }

    protected ColumnDetails processColumn(AnnotatedElement annotatedElement, Column column, String string, DescriptorMetadata descriptorMetadata) {
        String string2 = null;
        boolean bl = false;
        String string3 = descriptorMetadata.getPrimaryTableName();
        if (column != null) {
            string2 = column.name();
            if (!column.secondaryTable().equals("")) {
                string3 = column.secondaryTable();
            }
            bl = !column.insertable() && !column.updatable();
        }
        string2 = this.getFullyQualifiedColumnName(string2, string.toUpperCase(), string3, 1, annotatedElement);
        return new ColumnDetails(string2, bl);
    }

    protected void processDirectToFieldMapping(AnnotatedElement annotatedElement, String string, String string2, boolean bl, DescriptorMetadata descriptorMetadata) {
        Serialized serialized;
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setFieldName(string2);
        directToFieldMapping.setIsReadOnly(bl);
        directToFieldMapping.setAttributeName(string);
        if (descriptorMetadata.accessUsingMethods()) {
            this.setAccessorMethods((Method)annotatedElement, directToFieldMapping, descriptorMetadata);
        }
        if ((serialized = (Serialized)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Serialized.class)) != null) {
            this.processSerialized(serialized, directToFieldMapping, descriptorMetadata);
        } else {
            Basic basic = (Basic)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Basic.class);
            this.processBasic(basic, directToFieldMapping, descriptorMetadata);
        }
        descriptorMetadata.addMapping(directToFieldMapping);
    }

    protected void processDiscriminatorColumn(DescriptorMetadata descriptorMetadata) {
        String string = DEFAULT_DISCRIMINATOR_COLUMN;
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)EJBAnnotationsProcessor.getAnnotation(descriptorMetadata.getJavaClass(), DiscriminatorColumn.class);
        if (discriminatorColumn != null) {
            string = discriminatorColumn.name().equals("") ? string : discriminatorColumn.name();
        }
        descriptorMetadata.setClassIndicatorFieldName(string);
    }

    protected void processEmbeddable(DescriptorMetadata descriptorMetadata) {
        Embeddable embeddable = (Embeddable)EJBAnnotationsProcessor.getAnnotation(descriptorMetadata.getJavaClass(), Embeddable.class);
        descriptorMetadata.setAccessUsingMethods(embeddable.access() == AccessType.PROPERTY);
    }

    protected DescriptorMetadata processEmbeddableClass(Class clazz, DescriptorMetadata descriptorMetadata, boolean bl) {
        DescriptorMetadata descriptorMetadata2;
        if (this.descriptorAlreadyExists(clazz)) {
            descriptorMetadata2 = this.getDescriptorMetadata(clazz);
        } else {
            descriptorMetadata2 = this.getDescriptorMetadata(clazz);
            descriptorMetadata2.setDescriptorIsEmbeddable();
            this.processEmbeddable(descriptorMetadata2);
            this.processAccessors(descriptorMetadata2);
        }
        if (bl && !descriptorMetadata2.ignoreIDAnnotations()) {
            Enumeration enumeration = descriptorMetadata2.getMappings().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
                String string = this.getFullyQualifiedColumnName(databaseMapping.getField().getName(), descriptorMetadata.getPrimaryTableName());
                descriptorMetadata.addPrimaryKeyFieldName(string);
            }
        }
        return descriptorMetadata2;
    }

    protected void processEmbedded(Accessor accessor, AttributeOverride[] attributeOverrideArray, DescriptorMetadata descriptorMetadata, boolean bl) {
        AnnotatedElement annotatedElement = accessor.getAnnotatedElement();
        String string = accessor.getAttributeName();
        Class clazz = accessor.getReferenceClass();
        DescriptorMetadata descriptorMetadata2 = this.processEmbeddableClass(clazz, descriptorMetadata, bl);
        if (descriptorMetadata.hasMappingForAttributeName(string)) {
            this.m_logger.logWarningMessage(20, descriptorMetadata.getJavaClass(), string);
        } else {
            AggregateObjectMapping aggregateObjectMapping = new AggregateObjectMapping();
            aggregateObjectMapping.setIsReadOnly(false);
            aggregateObjectMapping.setIsNullAllowed(true);
            aggregateObjectMapping.setReferenceClass(clazz);
            aggregateObjectMapping.setAttributeName(string);
            if (descriptorMetadata.accessUsingMethods()) {
                this.setAccessorMethods((Method)annotatedElement, aggregateObjectMapping, descriptorMetadata);
            }
            this.processAttributeOverride(annotatedElement, attributeOverrideArray, aggregateObjectMapping, descriptorMetadata2, descriptorMetadata);
            descriptorMetadata.addMapping(aggregateObjectMapping);
        }
    }

    protected void processEmbeddedId(Accessor accessor, DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        String string = accessor.getAttributeName();
        if (descriptorMetadata.ignoreIDAnnotations()) {
            this.m_logger.logWarningMessage(22, clazz, string);
        } else {
            if (descriptorMetadata.hasEmbeddedIdAttribute()) {
                throw ValidationException.multipleEmbeddedIdAnnotationsFound(clazz, string, descriptorMetadata.getEmbeddedIdAttributeName());
            }
            if (descriptorMetadata.hasIdAttribute()) {
                throw ValidationException.embeddedIdAndIdAnnotationFound(clazz, string, descriptorMetadata.getIdAttributeName());
            }
            descriptorMetadata.setEmbeddedIdAttributeName(string);
        }
        EmbeddedId embeddedId = (EmbeddedId)EJBAnnotationsProcessor.getAnnotation(accessor.getAnnotatedElement(), EmbeddedId.class);
        this.processEmbedded(accessor, embeddedId.value(), descriptorMetadata, true);
    }

    protected void processEntity(Entity entity, DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        String string = entity.name();
        if (string.equals("")) {
            string = Helper.getShortClassName(clazz.getName());
            this.m_logger.logConfigMessage(0, clazz, string);
        }
        descriptorMetadata.setAlias(string);
        this.m_session.getProject().addAlias(string, descriptorMetadata.getDescriptor());
        descriptorMetadata.setAccessUsingMethods(entity.access() == AccessType.PROPERTY);
    }

    protected void processEntityClass(Class clazz) {
        Entity entity = (Entity)EJBAnnotationsProcessor.getAnnotation(clazz, Entity.class);
        if (entity != null && entity.entityType() == EntityType.CMP) {
            DescriptorMetadata descriptorMetadata = this.getDescriptorMetadata(clazz);
            descriptorMetadata.setIgnoreFlags();
            this.processEntity(entity, descriptorMetadata);
            this.processNamedQueries(clazz, descriptorMetadata);
            this.preProcessSequencing(clazz);
            this.processTable(descriptorMetadata);
            this.processIdClass(descriptorMetadata);
            this.processAccessors(descriptorMetadata);
            this.processSecondaryTables(descriptorMetadata);
            if (clazz.isAnnotationPresent(Inheritance.class)) {
                this.m_relatedClasses.add(clazz);
            }
        }
    }

    protected void processEvents(CBListener cBListener, DescriptorMetadata descriptorMetadata) {
        Class clazz = cBListener.getListenerClass();
        for (Method method : this.getMethods(clazz)) {
            if (method.isAnnotationPresent(PostActivate.class)) {
                throw ValidationException.invalidAnnotationSpecified(clazz, PostActivate.class, method.getName());
            }
            if (method.isAnnotationPresent(PrePassivate.class)) {
                throw ValidationException.invalidAnnotationSpecified(clazz, PrePassivate.class, method.getName());
            }
            if (method.isAnnotationPresent(PrePersist.class)) {
                cBListener.setPrePersistMethod(method);
            }
            if (method.isAnnotationPresent(PostPersist.class)) {
                cBListener.setPostInsertMethod(method);
            }
            if (method.isAnnotationPresent(PreRemove.class)) {
                cBListener.setPreRemoveMethod(method);
            }
            if (method.isAnnotationPresent(PostRemove.class)) {
                cBListener.setPostDeleteMethod(method);
            }
            if (method.isAnnotationPresent(PreUpdate.class)) {
                cBListener.setPreUpdateWithChangesMethod(method);
            }
            if (method.isAnnotationPresent(PostUpdate.class)) {
                cBListener.setPostUpdateMethod(method);
            }
            if (!method.isAnnotationPresent(PostLoad.class)) continue;
            cBListener.setPostCloneMethod(method);
        }
        if (cBListener.hasCallbackMethods()) {
            descriptorMetadata.addListener(cBListener);
        }
    }

    protected void processId(AnnotatedElement annotatedElement, String string, String string2, Class clazz, DescriptorMetadata descriptorMetadata) {
        Id id = (Id)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Id.class);
        boolean bl = descriptorMetadata.isPKAttribute(string2, clazz);
        if (id != null || bl) {
            Class clazz2 = descriptorMetadata.getJavaClass();
            if (descriptorMetadata.ignoreIDAnnotations()) {
                this.m_logger.logWarningMessage(21, clazz2, string2);
            } else {
                if (descriptorMetadata.hasEmbeddedIdAttribute()) {
                    throw ValidationException.embeddedIdAndIdAnnotationFound(clazz2, descriptorMetadata.getEmbeddedIdAttributeName(), string2);
                }
                descriptorMetadata.setIdAttributeName(string2);
                descriptorMetadata.addPrimaryKeyFieldName(string);
                this.m_sequencingProcessor.preProcessId(annotatedElement, id, string, descriptorMetadata.getDescriptor());
            }
        }
    }

    protected void processIdClass(DescriptorMetadata descriptorMetadata) {
        block6: {
            Class clazz = descriptorMetadata.getJavaClass();
            IdClass idClass = (IdClass)EJBAnnotationsProcessor.getAnnotation(clazz, IdClass.class);
            if (idClass == null) break block6;
            if (descriptorMetadata.ignoreIDAnnotations()) {
                this.m_logger.logWarningMessage(23, clazz, idClass);
            } else {
                Class clazz2 = this.getClassForName(idClass.value());
                descriptorMetadata.setPKClass(clazz2);
                Field[] fieldArray = this.getFields(clazz2);
                if (fieldArray.length > 0) {
                    for (Field field : fieldArray) {
                        if (!Modifier.isPublic(field.getModifiers())) continue;
                        descriptorMetadata.addPKClassId(field.getName(), this.getType(field));
                    }
                } else {
                    for (Method method : this.getMethods(clazz2)) {
                        String string = method.getName();
                        if (!string.startsWith(GET_PROPERTY_METHOD_PREFIX) && !string.startsWith(IS_PROPERTY_METHOD_PREFIX)) continue;
                        descriptorMetadata.addPKClassId(this.getAttributeNameFromMethodName(method.getName()), this.getReturnType(method));
                    }
                }
            }
        }
    }

    protected void processInheritance(DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        Inheritance inheritance = (Inheritance)EJBAnnotationsProcessor.getAnnotation(clazz, Inheritance.class);
        if (inheritance != null) {
            if (descriptorMetadata.ignoreInheritanceAnnotations()) {
                this.m_logger.logWarningMessage(27, clazz);
            } else {
                Object object;
                Class clazz2 = this.getInheritanceParent(descriptorMetadata);
                DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(clazz2);
                if (clazz2 == clazz) {
                    this.processDiscriminatorColumn(descriptorMetadata);
                } else {
                    object = (Inheritance)EJBAnnotationsProcessor.getAnnotation(clazz2, Inheritance.class);
                    if (object.strategy() == InheritanceType.TABLE_PER_CLASS) {
                        throw ValidationException.tablePerClassInheritanceNotSupported(clazz2);
                    }
                    if (object.strategy() == InheritanceType.JOINED) {
                        String string = descriptorMetadata2.getPrimaryTableName();
                        String string2 = descriptorMetadata.getPrimaryTableName();
                        Vector<InheritanceJoinColumnDetails> vector = this.processInheritanceJoinColumns(clazz);
                        for (String string3 : this.getPrimaryKeyFieldNames(descriptorMetadata2)) {
                            boolean bl = false;
                            String string4 = this.getUnqualifiedColumnName(string3);
                            for (InheritanceJoinColumnDetails inheritanceJoinColumnDetails : vector) {
                                if (!inheritanceJoinColumnDetails.getPKColumn().equals(string4)) continue;
                                String string5 = this.getFullyQualifiedColumnName(inheritanceJoinColumnDetails.getPKColumn(), string3, string, 11, clazz);
                                String string6 = this.getFullyQualifiedColumnName(inheritanceJoinColumnDetails.getFKColumn(), string4, string2, 12, clazz);
                                if (inheritanceJoinColumnDetails.getFKColumn().equals("") || inheritanceJoinColumnDetails.getFKColumn().equals(inheritanceJoinColumnDetails.getPKColumn())) {
                                    descriptorMetadata.addMultipleTablePrimaryKeyFieldName(string5, string6);
                                } else {
                                    descriptorMetadata.addMultipleTableForeignKeyFieldName(string5, string6);
                                }
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            String string7 = this.getFullyQualifiedColumnName(string3, string3, string, 11, clazz);
                            String string8 = this.getFullyQualifiedColumnName(string4, string4, string2, 12, clazz);
                            descriptorMetadata.addMultipleTablePrimaryKeyFieldName(string7, string8);
                        }
                    }
                    descriptorMetadata.setParentClass(clazz2);
                }
                object = inheritance.discriminatorValue();
                object = ((String)object).equals("") ? Helper.getShortClassName(clazz.getName()) : object;
                descriptorMetadata2.addClassIndicator(clazz, (String)object);
            }
        }
    }

    protected InheritanceJoinColumnDetails processInheritanceJoinColumn(InheritanceJoinColumn inheritanceJoinColumn) {
        InheritanceJoinColumnDetails inheritanceJoinColumnDetails = new InheritanceJoinColumnDetails();
        inheritanceJoinColumnDetails.setFKColumn(inheritanceJoinColumn.name());
        inheritanceJoinColumnDetails.setPKColumn(inheritanceJoinColumn.referencedColumnName());
        return inheritanceJoinColumnDetails;
    }

    protected Vector<InheritanceJoinColumnDetails> processInheritanceJoinColumns(Class clazz) {
        InheritanceJoinColumn inheritanceJoinColumn;
        Vector<InheritanceJoinColumnDetails> vector = new Vector<InheritanceJoinColumnDetails>();
        InheritanceJoinColumns inheritanceJoinColumns = (InheritanceJoinColumns)EJBAnnotationsProcessor.getAnnotation(clazz, InheritanceJoinColumns.class);
        if (inheritanceJoinColumns != null) {
            inheritanceJoinColumn = inheritanceJoinColumns.value();
            int n = ((InheritanceJoinColumn[])inheritanceJoinColumn).length;
            for (int i = 0; i < n; ++i) {
                InheritanceJoinColumn inheritanceJoinColumn2 = inheritanceJoinColumn[i];
                vector.add(this.processInheritanceJoinColumn(inheritanceJoinColumn2));
            }
        }
        if ((inheritanceJoinColumn = (InheritanceJoinColumn)EJBAnnotationsProcessor.getAnnotation(clazz, InheritanceJoinColumn.class)) != null) {
            vector.add(this.processInheritanceJoinColumn(inheritanceJoinColumn));
        }
        if (vector.isEmpty()) {
            vector.add(new InheritanceJoinColumnDetails());
        }
        return vector;
    }

    protected JoinColumnDetails processJoinColumn(JoinColumn joinColumn) {
        JoinColumnDetails joinColumnDetails = new JoinColumnDetails();
        joinColumnDetails.setFKColumn(joinColumn.name());
        joinColumnDetails.setPKColumn(joinColumn.referencedColumnName());
        joinColumnDetails.setIsReadOnly(!joinColumn.insertable() && !joinColumn.updatable());
        joinColumnDetails.setSecondaryTable(joinColumn.secondaryTable());
        return joinColumnDetails;
    }

    protected Vector<JoinColumnDetails> processJoinColumns(AnnotatedElement annotatedElement) {
        JoinColumn[] joinColumnArray;
        Vector<JoinColumnDetails> vector = new Vector<JoinColumnDetails>();
        JoinColumns joinColumns = (JoinColumns)EJBAnnotationsProcessor.getAnnotation(annotatedElement, JoinColumns.class);
        if (joinColumns != null) {
            if (joinColumns.value().length == 1) {
                vector.add(this.processJoinColumn(joinColumns.value()[0]));
            } else {
                joinColumnArray = joinColumns.value();
                int n = joinColumnArray.length;
                for (int i = 0; i < n; ++i) {
                    JoinColumn joinColumn = joinColumnArray[i];
                    if (joinColumn.name() == null || joinColumn.referencedColumnName() == null) {
                        throw ValidationException.nameAndReferenceNameMustBeSpecified(joinColumn.name(), joinColumn.referencedColumnName());
                    }
                    vector.add(this.processJoinColumn(joinColumn));
                }
            }
        }
        if ((joinColumnArray = (JoinColumn[])EJBAnnotationsProcessor.getAnnotation(annotatedElement, JoinColumn.class)) != null) {
            vector.add(this.processJoinColumn((JoinColumn)joinColumnArray));
        }
        if (vector.isEmpty()) {
            vector.add(new JoinColumnDetails());
        }
        return vector;
    }

    protected void processLob(AnnotatedElement annotatedElement, String string, String string2, boolean bl, Class clazz, DescriptorMetadata descriptorMetadata) {
        Lob lob = (Lob)EJBAnnotationsProcessor.getAnnotation(annotatedElement, Lob.class);
        TypeConversionMapping typeConversionMapping = new TypeConversionMapping();
        typeConversionMapping.setFieldName(string2);
        typeConversionMapping.setIsReadOnly(bl);
        typeConversionMapping.setAttributeName(string);
        if (lob.fetch() == FetchType.LAZY) {
            throw ValidationException.invalidFetchLazyType(descriptorMetadata.getJavaClass(), typeConversionMapping.getAttributeName());
        }
        if (lob.type() == LobType.BLOB) {
            if (clazz != byte[].class && clazz != Byte[].class && clazz != Blob.class && !Helper.classImplementsInterface(clazz, Serializable.class)) {
                throw ValidationException.invalidClassTypeForBLOBAnnotation(descriptorMetadata.getJavaClass(), typeConversionMapping.getAttributeName());
            }
            typeConversionMapping.setFieldClassification(Blob.class);
        } else {
            if (clazz != String.class && clazz != char[].class && clazz != Character[].class && clazz != Clob.class) {
                throw ValidationException.invalidClassTypeForCLOBAnnotation(descriptorMetadata.getJavaClass(), typeConversionMapping.getAttributeName());
            }
            typeConversionMapping.setFieldClassification(Clob.class);
        }
        descriptorMetadata.addMapping(typeConversionMapping);
    }

    protected void processManyToMany(AnnotatedElement annotatedElement, String string, Class clazz, DescriptorMetadata descriptorMetadata) {
        ManyToMany manyToMany = (ManyToMany)EJBAnnotationsProcessor.getAnnotation(annotatedElement, ManyToMany.class);
        ManyToManyMapping manyToManyMapping = new ManyToManyMapping();
        manyToManyMapping.setIsPrivateOwned(false);
        manyToManyMapping.setAttributeName(string);
        if (descriptorMetadata.accessUsingMethods()) {
            this.setAccessorMethods((Method)annotatedElement, manyToManyMapping, descriptorMetadata);
        }
        Class clazz2 = this.getReferenceClass(clazz, manyToMany.targetEntity(), 19, annotatedElement);
        manyToManyMapping.setReferenceClass(clazz2);
        this.processCascadeType(manyToMany.cascade(), manyToManyMapping);
        if (manyToMany.fetch() == FetchType.LAZY) {
            manyToManyMapping.useTransparentCollection();
        } else {
            manyToManyMapping.dontUseIndirection();
        }
        String string2 = manyToMany.mappedBy();
        if (string2.equals("")) {
            this.processAssociationTable(annotatedElement, manyToManyMapping, descriptorMetadata);
        } else {
            Object object;
            Object object2;
            manyToManyMapping.setIsReadOnly(true);
            DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(clazz2);
            ManyToManyMapping manyToManyMapping2 = (ManyToManyMapping)this.getOwnerMapping(descriptorMetadata2, string2, descriptorMetadata, string);
            manyToManyMapping.setRelationTableName(manyToManyMapping2.getRelationTableName());
            Enumeration enumeration = manyToManyMapping2.getTargetRelationKeyFieldNames().elements();
            Enumeration enumeration2 = manyToManyMapping2.getTargetKeyFieldNames().elements();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)enumeration2.nextElement();
                manyToManyMapping.addSourceRelationKeyFieldName((String)object2, (String)object);
            }
            object2 = manyToManyMapping2.getSourceRelationKeyFieldNames().elements();
            object = manyToManyMapping2.getSourceKeyFieldNames().elements();
            while (object2.hasMoreElements()) {
                String string3 = (String)object2.nextElement();
                String string4 = (String)object.nextElement();
                manyToManyMapping.addTargetRelationKeyFieldName(string3, string4);
            }
        }
        descriptorMetadata.addMapping(manyToManyMapping);
    }

    protected void processManyToOne(AnnotatedElement annotatedElement, String string, Class clazz, DescriptorMetadata descriptorMetadata) {
        ManyToOne manyToOne = (ManyToOne)EJBAnnotationsProcessor.getAnnotation(annotatedElement, ManyToOne.class);
        Class clazz2 = this.getReferenceClass(clazz, manyToOne.targetEntity(), 18, annotatedElement);
        boolean bl = manyToOne.fetch() == FetchType.LAZY;
        CascadeType[] cascadeTypeArray = manyToOne.cascade();
        OneToOneMapping oneToOneMapping = this.initOneToOneMapping(annotatedElement, string, clazz2, bl, cascadeTypeArray, descriptorMetadata);
        DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(clazz2);
        String string2 = descriptorMetadata.getPrimaryTableName();
        String string3 = descriptorMetadata2.getPrimaryTableName();
        Vector<JoinColumnDetails> vector = this.processJoinColumns(annotatedElement);
        if (vector.size() == 1) {
            String string4 = this.getFullyQualifiedColumnName(vector.firstElement().getPKColumn(), this.getPrimaryKeyFieldNames(descriptorMetadata2).firstElement(), string3, 2, annotatedElement);
            String string5 = this.getUnqualifiedColumnName(string4);
            String string6 = this.getFullyQualifiedColumnName(vector.firstElement().getFKColumn(), string5, string2, 3, annotatedElement);
            oneToOneMapping.addForeignKeyFieldName(string6, string4);
        } else if (vector.size() > 1) {
            for (JoinColumnDetails joinColumnDetails : vector) {
                String string7 = this.getFullyQualifiedColumnName(joinColumnDetails.getPKColumn(), joinColumnDetails.getPKColumn(), string3, 2, annotatedElement);
                String string8 = this.getFullyQualifiedColumnName(joinColumnDetails.getFKColumn(), joinColumnDetails.getFKColumn(), string2, 3, annotatedElement);
                oneToOneMapping.addForeignKeyFieldName(string8, string7);
            }
        }
        descriptorMetadata.addMapping(oneToOneMapping);
    }

    protected void processNamedQueries(AnnotatedElement annotatedElement, DescriptorMetadata descriptorMetadata) {
        NamedQuery namedQuery;
        NamedQueries namedQueries = (NamedQueries)EJBAnnotationsProcessor.getAnnotation(annotatedElement, NamedQueries.class);
        if (namedQueries != null) {
            namedQuery = namedQueries.value();
            int n = ((NamedQuery[])namedQuery).length;
            for (int i = 0; i < n; ++i) {
                NamedQuery namedQuery2 = namedQuery[i];
                this.processNamedQuery(namedQuery2, descriptorMetadata);
            }
        }
        if ((namedQuery = (NamedQuery)EJBAnnotationsProcessor.getAnnotation(annotatedElement, NamedQuery.class)) != null) {
            this.processNamedQuery(namedQuery, descriptorMetadata);
        }
    }

    protected void processNamedQuery(NamedQuery namedQuery, DescriptorMetadata descriptorMetadata) {
        String string = namedQuery.name();
        String string2 = namedQuery.queryString();
        if (string.equals("")) {
            throw ValidationException.invalidNamedQueryAnnotationName(descriptorMetadata.getJavaClass(), string2);
        }
        descriptorMetadata.addNamedQuery(string, string2);
        this.m_dmdsWithQueries.add(descriptorMetadata);
    }

    protected void processOneToMany(AnnotatedElement annotatedElement, String string, Class clazz, DescriptorMetadata descriptorMetadata) {
        OneToMany oneToMany = (OneToMany)EJBAnnotationsProcessor.getAnnotation(annotatedElement, OneToMany.class);
        if (this.hasAssociationTable(annotatedElement)) {
            if (this.hasJoinColumns(annotatedElement)) {
                throw ValidationException.oneToManyHasBothAssociationTableAndJoinColumnAnnotations(descriptorMetadata.getJavaClass(), string);
            }
            ManyToManyMapping manyToManyMapping = new ManyToManyMapping();
            this.populateMappingFromOneToManyAnnotation(oneToMany, manyToManyMapping, annotatedElement, string, clazz, descriptorMetadata);
            this.processAssociationTable(annotatedElement, manyToManyMapping, descriptorMetadata);
            descriptorMetadata.addMapping(manyToManyMapping);
        } else {
            OneToManyMapping oneToManyMapping = new OneToManyMapping();
            String string2 = this.populateMappingFromOneToManyAnnotation(oneToMany, oneToManyMapping, annotatedElement, string, clazz, descriptorMetadata);
            DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(oneToManyMapping.getReferenceClass());
            String string3 = descriptorMetadata.getPrimaryTableName();
            String string4 = descriptorMetadata2.getPrimaryTableName();
            if (string2.equals("")) {
                Vector<JoinColumnDetails> vector = this.processJoinColumns(annotatedElement);
                if (vector.size() == 1) {
                    String string5 = this.getFullyQualifiedColumnName(vector.firstElement().getPKColumn(), this.getPrimaryKeyFieldNames(descriptorMetadata).firstElement(), string3, 2, annotatedElement);
                    String string6 = this.getUnqualifiedColumnName(string5);
                    String string7 = this.getFullyQualifiedColumnName(vector.firstElement().getFKColumn(), string6, string4, 3, annotatedElement);
                    oneToManyMapping.addTargetForeignKeyFieldName(string7, string5);
                } else if (vector.size() > 1) {
                    for (JoinColumnDetails joinColumnDetails : vector) {
                        String string8 = this.getFullyQualifiedColumnName(joinColumnDetails.getPKColumn(), joinColumnDetails.getPKColumn(), string3, 2, annotatedElement);
                        String string9 = this.getFullyQualifiedColumnName(joinColumnDetails.getFKColumn(), joinColumnDetails.getFKColumn(), string4, 3, annotatedElement);
                        oneToManyMapping.addTargetForeignKeyFieldName(string9, string8);
                    }
                }
            } else {
                DatabaseMapping databaseMapping = this.getOwnerMapping(descriptorMetadata2, string2, descriptorMetadata, string);
                Map map = ((OneToOneMapping)databaseMapping).getSourceToTargetKeyFields();
                for (DatabaseField databaseField : map.keySet()) {
                    DatabaseField databaseField2 = (DatabaseField)map.get(databaseField);
                    String string10 = this.getFullyQualifiedColumnName(databaseField.getName(), string4);
                    String string11 = this.getFullyQualifiedColumnName(databaseField2.getName(), string3);
                    oneToManyMapping.addTargetForeignKeyFieldName(string10, string11);
                }
            }
            descriptorMetadata.addMapping(oneToManyMapping);
        }
    }

    protected void processOneToOne(AnnotatedElement annotatedElement, String string, Class clazz, DescriptorMetadata descriptorMetadata) {
        OneToOne oneToOne = (OneToOne)EJBAnnotationsProcessor.getAnnotation(annotatedElement, OneToOne.class);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        CascadeType[] cascadeTypeArray = new CascadeType[]{};
        boolean bl2 = false;
        if (oneToOne != null) {
            string3 = oneToOne.targetEntity();
            cascadeTypeArray = oneToOne.cascade();
            bl2 = oneToOne.fetch() == FetchType.LAZY;
            string2 = oneToOne.mappedBy();
            bl = oneToOne.usePKasFK();
        }
        Class clazz2 = this.getReferenceClass(clazz, string3, 16, annotatedElement);
        OneToOneMapping oneToOneMapping = this.initOneToOneMapping(annotatedElement, string, clazz2, bl2, cascadeTypeArray, descriptorMetadata);
        DescriptorMetadata descriptorMetadata2 = this.getDescriptorMetadata(clazz2);
        String string4 = descriptorMetadata.getPrimaryTableName();
        String string5 = descriptorMetadata2.getPrimaryTableName();
        if (string2.equals("")) {
            if (bl) {
                for (String string6 : this.getPrimaryKeyFieldNames(descriptorMetadata2)) {
                    String string7 = this.getFullyQualifiedColumnName(string6, string5);
                    String string8 = this.getFullyQualifiedColumnName(this.getUnqualifiedColumnName(string7), string4);
                    oneToOneMapping.addForeignKeyFieldName(string8, string7);
                }
            } else {
                Vector<JoinColumnDetails> vector = this.processJoinColumns(annotatedElement);
                if (vector.size() == 1) {
                    String string9 = this.getFullyQualifiedColumnName(vector.firstElement().getPKColumn(), this.getPrimaryKeyFieldNames(descriptorMetadata2).firstElement(), string5, 2, annotatedElement);
                    String string10 = this.getUnqualifiedColumnName(string9);
                    String string11 = this.getFullyQualifiedColumnName(vector.firstElement().getFKColumn(), string10, string4, 3, annotatedElement);
                    oneToOneMapping.addForeignKeyFieldName(string11, string9);
                } else if (vector.size() > 1) {
                    for (JoinColumnDetails joinColumnDetails : vector) {
                        String string12 = this.getFullyQualifiedColumnName(joinColumnDetails.getPKColumn(), joinColumnDetails.getPKColumn(), string5, 2, annotatedElement);
                        String string13 = this.getFullyQualifiedColumnName(joinColumnDetails.getFKColumn(), joinColumnDetails.getFKColumn(), string4, 3, annotatedElement);
                        oneToOneMapping.addForeignKeyFieldName(string13, string12);
                    }
                }
            }
        } else {
            DatabaseMapping databaseMapping = this.getOwnerMapping(descriptorMetadata2, string2, descriptorMetadata, string);
            Map map = ((OneToOneMapping)databaseMapping).getSourceToTargetKeyFields();
            for (DatabaseField databaseField : map.keySet()) {
                DatabaseField databaseField2 = (DatabaseField)map.get(databaseField);
                String string14 = this.getFullyQualifiedColumnName(databaseField.getName(), string5);
                String string15 = this.getFullyQualifiedColumnName(databaseField2.getName(), string4);
                oneToOneMapping.addTargetForeignKeyFieldName(string14, string15);
            }
        }
        descriptorMetadata.addMapping(oneToOneMapping);
    }

    public Session processORAnnotations() {
        for (Class clazz : this.m_classes) {
            this.processEntityClass(clazz);
        }
        this.m_sequencingProcessor.process(this.m_session.getProject().getLogin());
        for (Class clazz : this.m_relatedClasses) {
            this.processRelatedClass(clazz);
        }
        return this.m_session;
    }

    protected void processRelatedClass(Class clazz) {
        DescriptorMetadata descriptorMetadata = this.getDescriptorMetadata(clazz);
        this.processInheritance(descriptorMetadata);
        for (Accessor accessor : descriptorMetadata.getRelationshipAccessors()) {
            if (!accessor.needsProcessing()) continue;
            this.processRelationshipAccessor(accessor, descriptorMetadata);
        }
    }

    protected void processRelationshipAccessor(Accessor accessor, DescriptorMetadata descriptorMetadata) {
        Type type = accessor.getRelationType();
        Class clazz = accessor.getReferenceClass();
        String string = accessor.getAttributeName();
        AnnotatedElement annotatedElement = accessor.getAnnotatedElement();
        if (annotatedElement.isAnnotationPresent(Column.class)) {
            throw ValidationException.invalidColumnAnnotationOnRelationship(descriptorMetadata.getJavaClass(), string);
        }
        if (this.isManyToOne(annotatedElement)) {
            this.processManyToOne(annotatedElement, string, clazz, descriptorMetadata);
        } else if (this.isManyToMany(annotatedElement)) {
            this.processManyToMany(annotatedElement, string, clazz, descriptorMetadata);
        } else if (this.isOneToMany(annotatedElement, clazz, type)) {
            this.processOneToMany(annotatedElement, string, clazz, descriptorMetadata);
        } else if (this.isOneToOne(annotatedElement, clazz)) {
            this.processOneToOne(annotatedElement, string, clazz, descriptorMetadata);
        }
        accessor.setNeedsProcessing(false);
    }

    protected void processSecondaryTable(SecondaryTable secondaryTable, DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        if (descriptorMetadata.ignoreTableAnnotations()) {
            this.m_logger.logWarningMessage(26, clazz, secondaryTable.name());
        } else {
            String string = EJBAnnotationsProcessor.getFullyQualifiedTableName(secondaryTable.name(), secondaryTable.catalog(), secondaryTable.schema());
            descriptorMetadata.addTableName(string);
            String string2 = descriptorMetadata.getPrimaryTableName();
            int n = 0;
            int n2 = 0;
            for (DatabaseField databaseField : descriptorMetadata.getPrimaryKeyFields()) {
                String string3;
                String string4;
                Object object;
                Object object2;
                String string5 = databaseField.getName();
                JoinColumn[] joinColumnArray = secondaryTable.join();
                if (joinColumnArray.length > 0) {
                    object2 = joinColumnArray[n2];
                    object = this.getFullyQualifiedColumnName(object2.referencedColumnName(), string5, string2, 14, clazz);
                    string4 = this.getUnqualifiedColumnName((String)object);
                    string3 = this.getFullyQualifiedColumnName(object2.name(), string4, string, 15, clazz);
                    if (object2.referencedColumnName().equals("") || object2.referencedColumnName().equals(string5)) {
                        descriptorMetadata.addMultipleTablePrimaryKeyFieldName((String)object, string3);
                    } else {
                        descriptorMetadata.addMultipleTableForeignKeyFieldName((String)object, string3);
                    }
                    ++n2;
                    continue;
                }
                object2 = this.processJoinColumns(clazz);
                if (((Vector)object2).size() > 0 && !((JoinColumnDetails)((Vector)object2).get(0)).getFKColumn().equals("")) {
                    object = (JoinColumnDetails)((Vector)object2).get(n);
                    string4 = this.getFullyQualifiedColumnName(((InheritanceJoinColumnDetails)object).getPKColumn(), string5, string2, 14, clazz);
                    string3 = this.getUnqualifiedColumnName(string4);
                    String string6 = this.getFullyQualifiedColumnName(((JoinColumnDetails)object).getFKColumn(), string3, string, 15, clazz);
                    if (((InheritanceJoinColumnDetails)object).getPKColumn().equals("") || ((InheritanceJoinColumnDetails)object).getPKColumn().equals(string5)) {
                        descriptorMetadata.addMultipleTablePrimaryKeyFieldName(string4, string6);
                    } else {
                        descriptorMetadata.addMultipleTableForeignKeyFieldName(string4, string6);
                    }
                }
                ++n;
            }
        }
    }

    protected void processSecondaryTables(DescriptorMetadata descriptorMetadata) {
        SecondaryTables secondaryTables = (SecondaryTables)EJBAnnotationsProcessor.getAnnotation(descriptorMetadata.getJavaClass(), SecondaryTables.class);
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTable : secondaryTables.value()) {
                this.processSecondaryTable(secondaryTable, descriptorMetadata);
            }
        } else {
            SecondaryTable secondaryTable = (SecondaryTable)EJBAnnotationsProcessor.getAnnotation(descriptorMetadata.getJavaClass(), SecondaryTable.class);
            if (secondaryTable != null) {
                this.processSecondaryTable(secondaryTable, descriptorMetadata);
            }
        }
    }

    protected void processSerialized(Serialized serialized, DirectToFieldMapping directToFieldMapping, DescriptorMetadata descriptorMetadata) {
        if (serialized.fetch() == FetchType.LAZY) {
            throw ValidationException.invalidFetchLazyType(descriptorMetadata.getJavaClass(), directToFieldMapping.getAttributeName());
        }
        directToFieldMapping.setConverter(new SerializedObjectConverter(directToFieldMapping));
    }

    protected void processTable(DescriptorMetadata descriptorMetadata) {
        if (descriptorMetadata.ignoreTableAnnotations()) {
            this.m_logger.logWarningMessage(25, descriptorMetadata.getJavaClass());
        } else {
            Class clazz;
            Table table;
            String string = descriptorMetadata.getAlias().toUpperCase();
            if (this.isInheritanceSubclass(descriptorMetadata) && (table = (Inheritance)EJBAnnotationsProcessor.getAnnotation(clazz = this.getInheritanceParent(descriptorMetadata), Inheritance.class)).strategy() == InheritanceType.SINGLE_TABLE) {
                if (!this.descriptorAlreadyExists(clazz)) {
                    this.processEntityClass(clazz);
                }
                string = this.getDescriptorMetadata(clazz).getPrimaryTableName();
            }
            if ((table = (Table)EJBAnnotationsProcessor.getAnnotation(clazz = descriptorMetadata.getJavaClass(), Table.class)) != null) {
                string = this.getFullyQualifiedTableName(table.name(), string, table.catalog(), table.schema(), 4, clazz);
            } else {
                this.m_logger.logConfigMessage(4, clazz, string);
            }
            descriptorMetadata.setPrimaryTableName(string);
        }
    }

    protected void setAccessorMethods(Method method, DatabaseMapping databaseMapping, DescriptorMetadata descriptorMetadata) {
        String string = method.getName();
        String string2 = descriptorMetadata.getSetMethodName(string);
        databaseMapping.setGetMethodName(string);
        databaseMapping.setSetMethodName(string2);
    }

    public void setClasses(Collection<Class> collection) {
        this.m_classes = collection;
    }

    protected boolean validPersistenceField(Field field) {
        if (field.isAnnotationPresent(Transient.class)) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    protected boolean validPersistenceMethod(Method method, DescriptorMetadata descriptorMetadata) {
        Class clazz = descriptorMetadata.getJavaClass();
        if (method.isAnnotationPresent(Transient.class)) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        String string = method.getName();
        if (string.startsWith(GET_PROPERTY_METHOD_PREFIX) || string.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            String string2 = this.getSetMethodName(method, clazz);
            if (string2 == null) {
                if (method.getDeclaredAnnotations().length > 0) {
                    throw ValidationException.noCorrespondingSetterMethodDefined(clazz, method);
                }
                this.m_logger.logWarningMessage(28, clazz, method);
            } else {
                descriptorMetadata.addSetMethodName(string, string2);
                return true;
            }
        }
        return false;
    }
}

