/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.indirection;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.toplink.descriptors.changetracking.CollectionChangeEvent;
import oracle.toplink.descriptors.changetracking.CollectionChangeTracker;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.indirection.IndirectCollection;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.changetracking.AttributeChangeListener;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.indirection.UnitOfWorkQueryValueHolder;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;

public class IndirectSet
implements CollectionChangeTracker,
Set,
IndirectCollection,
Cloneable,
Serializable {
    private Set delegate = null;
    private ValueHolderInterface valueHolder;
    private PropertyChangeListener changeListener;
    private String attributeName;
    private transient Set addedElements;
    private transient Set removedElements;
    protected int initialCapacity = 10;
    protected float loadFactor = 0.75f;

    public IndirectSet() {
        this.valueHolder = null;
    }

    public IndirectSet(int n) {
        this.initialCapacity = n;
        this.valueHolder = null;
    }

    public IndirectSet(int n, float f) {
        this.initialCapacity = n;
        this.loadFactor = f;
        this.valueHolder = null;
    }

    public IndirectSet(Collection collection) {
        this.valueHolder = new ValueHolder(new HashSet(collection));
    }

    public synchronized boolean add(Object object) {
        boolean bl = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.getRemovedElements().contains(object)) {
                this.getRemovedElements().remove(object);
            } else {
                if (this.getAddedElements().contains(object)) {
                    return false;
                }
                this.getAddedElements().add(object);
            }
        } else {
            bl = this.getDelegate().add(object);
        }
        this.raiseAddChangeEvent(object);
        return bl;
    }

    public synchronized boolean addAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
            return true;
        }
        return this.getDelegate().addAll(collection);
    }

    protected Set buildDelegate() {
        Iterator iterator;
        Set set = (Set)this.getValueHolder().getValue();
        while (set instanceof IndirectSet) {
            set = ((IndirectSet)set).getDelegate();
        }
        if (this.hasAddedElements()) {
            iterator = this.getAddedElements().iterator();
            while (iterator.hasNext()) {
                set.add(iterator.next());
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            iterator = this.getRemovedElements().iterator();
            while (iterator.hasNext()) {
                set.remove(iterator.next());
            }
            this.removedElements = null;
        }
        return set;
    }

    public void clear() {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public Object clone() {
        try {
            IndirectSet indirectSet = (IndirectSet)super.clone();
            indirectSet.delegate = this.cloneDelegate();
            indirectSet.attributeName = null;
            indirectSet.changeListener = null;
            return indirectSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone not supported");
        }
    }

    protected Set cloneDelegate() {
        Method method;
        try {
            method = PrivilegedAccessController.getMethod(this.getDelegate().getClass(), "clone", null, false);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw QueryException.cloneMethodRequired();
        }
        try {
            return (Set)PrivilegedAccessController.invokeMethod(method, this.getDelegate(), null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.cloneMethodInaccessible();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw QueryException.cloneMethodThrowException(invocationTargetException.getTargetException());
        }
    }

    public boolean contains(Object object) {
        if (this.hasAddedElements() && this.getAddedElements().contains(object)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(object)) {
            return false;
        }
        return this.getDelegate().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    public boolean equals(Object object) {
        return ((Object)this.getDelegate()).equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDelegate() {
        if (this.delegate == null) {
            IndirectSet indirectSet = this;
            synchronized (indirectSet) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectSet indirectSet = this;
            synchronized (indirectSet) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new HashSet(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public int hashCode() {
        return ((Object)this.getDelegate()).hashCode();
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectSet.this.getDelegate().iterator();
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectSet.this.raiseRemoveChangeEvent(this.currentObject);
            }
        };
    }

    public synchronized boolean remove(Object object) {
        if (this.shouldAvoidInstantiation()) {
            if (this.getAddedElements().contains(object)) {
                this.getAddedElements().remove(object);
            } else {
                if (this.getRemovedElements().contains(object)) {
                    return false;
                }
                this.getRemovedElements().add(object);
            }
            this.raiseRemoveChangeEvent(object);
            return true;
        }
        if (this.getDelegate().remove(object)) {
            this.raiseRemoveChangeEvent(object);
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(collection);
    }

    public synchronized boolean retainAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.getDelegate().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                iterator.remove();
                this.raiseRemoveChangeEvent(e);
            }
            return true;
        }
        return this.getDelegate().retainAll(collection);
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.delegate = null;
        this.valueHolder = valueHolderInterface;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getDelegate().toArray(objectArray);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }

    protected void raiseAddChangeEvent(Object object) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTopLinkAttributeName(), this, object, CollectionChangeEvent.ADD));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(object, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object object) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTopLinkAttributeName(), this, object, CollectionChangeEvent.REMOVE));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(object);
        }
    }

    public PropertyChangeListener getTopLinkPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTopLinkPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void setTopLinkPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public String getTopLinkAttributeName() {
        return this.attributeName;
    }

    public void setTopLinkAttributeName(String string) {
        this.attributeName = string;
    }

    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new HashSet();
        }
        return this.removedElements;
    }

    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new HashSet();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this.getTopLinkPropertyChangeListener() instanceof AttributeChangeListener;
    }
}

