/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.history;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.expressions.ConstantExpression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.SQLDeleteStatement;
import oracle.toplink.internal.expressions.SQLInsertStatement;
import oracle.toplink.internal.expressions.SQLUpdateStatement;
import oracle.toplink.internal.expressions.TableExpression;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.history.HistoricalDatabaseTable;
import oracle.toplink.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectCollectionMapping;
import oracle.toplink.mappings.ManyToManyMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class HistoryPolicy
implements Cloneable,
Serializable {
    protected Descriptor descriptor;
    protected DatabaseMapping mapping;
    protected Vector historicalTables;
    protected Vector startFields;
    protected Vector endFields;
    protected boolean shouldHandleWrites = true;
    protected boolean usesLocalTime = true;
    static /* synthetic */ Class class$oracle$toplink$descriptors$ClassDescriptor;

    public Expression additionalHistoryExpression(ObjectExpression objectExpression) {
        Cloneable cloneable;
        AsOfClause asOfClause = objectExpression.getAsOfClause();
        Object object = asOfClause.getValue();
        Expression expression = null;
        Expression expression2 = null;
        Expression expression3 = null;
        Expression expression4 = null;
        if (object == null) {
            return null;
        }
        if (object instanceof Expression) {
            if (object instanceof ConstantExpression && ((ConstantExpression)object).getValue() instanceof String) {
                object = (String)((ConstantExpression)object).getValue();
            }
        } else {
            cloneable = ConversionManager.getDefaultManager();
            object = ((ConversionManager)cloneable).convertObject(object, ClassConstants.TIMESTAMP);
        }
        if (this.getMapping() != null) {
            cloneable = null;
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
            cloneable = (TableExpression)objectExpression.existingDerivedTable(databaseTable);
            expression3 = ((DataExpression)cloneable).getField(this.getStart());
            expression4 = ((DataExpression)cloneable).getField(this.getEnd());
            expression = objectExpression.shouldUseOuterJoin() && objectExpression.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() ? expression3.isNull().or(expression3.lessThanEqual(object)) : expression3.lessThanEqual(object);
            expression = expression.and(expression4.isNull().or(expression4.greaterThan(object)));
            ((TableExpression)cloneable).setTable(databaseTable);
            return expression;
        }
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            expression3 = objectExpression.getField(this.getStart(i));
            expression4 = objectExpression.getField(this.getEnd(i));
            expression2 = objectExpression.shouldUseOuterJoin() && objectExpression.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() ? expression3.isNull().or(expression3.lessThanEqual(object)) : expression3.lessThanEqual(object);
            expression2 = expression2.and(expression4.isNull().or(expression4.greaterThan(object)));
            expression = expression == null ? expression2 : expression.and(expression2);
        }
        return expression;
    }

    public Object clone() {
        Enumeration enumeration;
        HistoryPolicy historyPolicy = null;
        try {
            historyPolicy = (HistoryPolicy)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.startFields != null) {
            historyPolicy.setStartFields(NonSynchronizedVector.newInstance(this.startFields.size()));
            enumeration = this.startFields.elements();
            while (enumeration.hasMoreElements()) {
                historyPolicy.getStartFields().addElement(((DatabaseField)enumeration.nextElement()).clone());
            }
        }
        if (this.endFields != null) {
            historyPolicy.setEndFields(NonSynchronizedVector.newInstance(this.endFields.size()));
            enumeration = this.endFields.elements();
            while (enumeration.hasMoreElements()) {
                historyPolicy.getEndFields().addElement(((DatabaseField)enumeration.nextElement()).clone());
            }
        }
        if (this.historicalTables != null) {
            historyPolicy.setHistoricalTables((Vector)this.historicalTables.clone());
        }
        return historyPolicy;
    }

    public Object getCurrentTime(Session session) {
        if (this.shouldUseLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.shouldUseDatabaseTime()) {
            Session session2 = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (session2.isUnitOfWork()) {
                session2 = ((UnitOfWork)session2).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return session2.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, session2.getName());
        }
        return null;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor;
        }
        throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = HistoryPolicy.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
    }

    public final Vector getHistoricalTables() {
        if (this.historicalTables == null) {
            this.historicalTables = NonSynchronizedVector.newInstance(1);
        }
        return this.historicalTables;
    }

    public Vector getHistoryTableNames() {
        Vector<String> vector = new Vector<String>(this.getHistoricalTables().size());
        Enumeration enumeration = this.getHistoricalTables().elements();
        while (enumeration.hasMoreElements()) {
            HistoricalDatabaseTable historicalDatabaseTable = (HistoricalDatabaseTable)enumeration.nextElement();
            vector.addElement(historicalDatabaseTable.getQualifiedName());
        }
        return vector;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected DatabaseField getStart() {
        if (this.startFields != null) {
            return (DatabaseField)this.startFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getStart(int n) {
        return (DatabaseField)this.startFields.elementAt(n);
    }

    public String getStartFieldName() {
        if (this.getStart() != null) {
            return this.getStart().getName();
        }
        return null;
    }

    public Vector getStartFields() {
        return this.startFields;
    }

    protected DatabaseField getEnd() {
        if (this.endFields != null) {
            return (DatabaseField)this.endFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getEnd(int n) {
        return (DatabaseField)this.endFields.elementAt(n);
    }

    public String getEndFieldName() {
        if (this.getEnd() != null) {
            return this.getEnd().getName();
        }
        return null;
    }

    public Vector getEndFields() {
        return this.endFields;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialize(Session session) {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (this.getMapping() != null) {
            this.setDescriptor(this.getMapping().getDescriptor());
            if (this.getMapping().isDirectCollectionMapping()) {
                DatabaseTable databaseTable = ((DirectCollectionMapping)this.getMapping()).getReferenceTable();
                DatabaseTable databaseTable2 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                databaseTable2.setName(databaseTable.getName());
                databaseTable2.setTableQualifier(databaseTable.getTableQualifier());
                this.getStart().setTable(databaseTable2);
                this.getEnd().setTable(databaseTable2);
            } else if (this.getMapping().isManyToManyMapping()) {
                DatabaseTable databaseTable = ((ManyToManyMapping)this.getMapping()).getRelationTable();
                DatabaseTable databaseTable3 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                databaseTable3.setName(databaseTable.getName());
                databaseTable3.setTableQualifier(databaseTable.getTableQualifier());
                this.getStart().setTable(databaseTable3);
                this.getEnd().setTable(databaseTable3);
            }
            this.verifyTableQualifiers(session.getPlatform());
            return;
        }
        int n = this.getDescriptor().getTables().size() - this.getHistoricalTables().size();
        if (!this.getHistoricalTables().isEmpty() && ((DatabaseTable)this.getHistoricalTables().elementAt(0)).getName().equals("")) {
            for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
                cloneable2 = (HistoricalDatabaseTable)this.getHistoricalTables().elementAt(i);
                if (((DatabaseTable)cloneable2).getName().equals("")) {
                    cloneable = (DatabaseTable)this.getDescriptor().getTables().elementAt(i + n);
                    ((DatabaseTable)cloneable2).setName(((DatabaseTable)cloneable).getName());
                    ((DatabaseTable)cloneable2).setTableQualifier(((DatabaseTable)cloneable).getTableQualifier());
                }
                if (this.getEndFields().size() < i + 1) {
                    cloneable = (DatabaseField)this.getStart(0).clone();
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                    this.getStartFields().addElement(cloneable);
                } else {
                    cloneable = this.getStart(i);
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                }
                if (this.getEndFields().size() < i + 1) {
                    cloneable = (DatabaseField)this.getEnd(0).clone();
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                    this.getEndFields().addElement(cloneable);
                    continue;
                }
                cloneable = this.getEnd(i);
                ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
            }
        } else {
            Vector vector = this.getHistoricalTables();
            cloneable2 = this.getStartFields();
            cloneable = this.getEndFields();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
            NonSynchronizedVector nonSynchronizedVector2 = NonSynchronizedVector.newInstance(vector.size());
            NonSynchronizedVector nonSynchronizedVector3 = NonSynchronizedVector.newInstance(vector.size());
            boolean bl = this.getStartFields().size() == 1 && ((DatabaseField)this.getStartFields().get(0)).getTableName().equals("");
            boolean bl2 = this.getEndFields().size() == 1 && ((DatabaseField)this.getEndFields().get(0)).getTableName().equals("");
            DatabaseTable databaseTable = null;
            HistoricalDatabaseTable historicalDatabaseTable = null;
            DatabaseField databaseField = null;
            Vector vector2 = this.getDescriptor().getTables();
            block1: for (int i = n; i < vector2.size(); ++i) {
                Enumeration enumeration;
                databaseTable = (DatabaseTable)vector2.elementAt(i);
                int n2 = vector.indexOf(databaseTable);
                if (n2 == -1) {
                    // empty if block
                }
                historicalDatabaseTable = (HistoricalDatabaseTable)vector.elementAt(n2);
                historicalDatabaseTable.setTableQualifier(databaseTable.getTableQualifier());
                ((Vector)nonSynchronizedVector).add(historicalDatabaseTable);
                if (bl) {
                    databaseField = (DatabaseField)this.getStart(0).clone();
                    databaseField.setTable(historicalDatabaseTable);
                    ((Vector)nonSynchronizedVector2).add(databaseField);
                } else {
                    enumeration = this.getStartFields().elements();
                    while (enumeration.hasMoreElements()) {
                        databaseField = (DatabaseField)enumeration.nextElement();
                        if (databaseField.getTable().equals(historicalDatabaseTable)) {
                            ((Vector)nonSynchronizedVector2).add(databaseField);
                            break;
                        }
                        if (enumeration.hasMoreElements()) continue;
                    }
                }
                if (bl2) {
                    databaseField = (DatabaseField)this.getEnd(0).clone();
                    databaseField.setTable(historicalDatabaseTable);
                    ((Vector)nonSynchronizedVector3).add(databaseField);
                    continue;
                }
                enumeration = this.getEndFields().elements();
                while (enumeration.hasMoreElements()) {
                    databaseField = (DatabaseField)enumeration.nextElement();
                    if (databaseField.getTable().equals(historicalDatabaseTable)) {
                        ((Vector)nonSynchronizedVector3).add(databaseField);
                        continue block1;
                    }
                    if (enumeration.hasMoreElements()) continue;
                }
            }
            this.setHistoricalTables(nonSynchronizedVector);
            this.setStartFields(nonSynchronizedVector2);
            this.setEndFields(nonSynchronizedVector3);
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        if (this.getDescriptor().hasInheritance()) {
            Descriptor descriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
            while (descriptor != null && descriptor.getHistoryPolicy() == null) {
                descriptor = descriptor.getInheritancePolicy().getParentDescriptor();
            }
            if (descriptor != null) {
                this.setHistoricalTables(Helper.concatenateUniqueVectors(descriptor.getHistoryPolicy().getHistoricalTables(), this.getHistoricalTables()));
                this.setStartFields(Helper.concatenateUniqueVectors(descriptor.getHistoryPolicy().getStartFields(), this.getStartFields()));
                this.setEndFields(Helper.concatenateUniqueVectors(descriptor.getHistoryPolicy().getEndFields(), this.getEndFields()));
            }
        }
    }

    public void addHistoryTableName(String string) {
        HistoricalDatabaseTable historicalDatabaseTable = new HistoricalDatabaseTable("");
        historicalDatabaseTable.setHistoricalName(string);
        this.getHistoricalTables().add(historicalDatabaseTable);
    }

    public void addHistoryTableName(String string, String string2) {
        if (string == null || string.equals("")) {
            this.addHistoryTableName(string2);
        }
        HistoricalDatabaseTable historicalDatabaseTable = new HistoricalDatabaseTable(string);
        historicalDatabaseTable.setHistoricalName(string2);
        int n = this.getHistoricalTables().indexOf(historicalDatabaseTable);
        if (n == -1) {
            this.getHistoricalTables().add(historicalDatabaseTable);
        } else {
            this.getHistoricalTables().set(n, historicalDatabaseTable);
        }
    }

    public void setHistoricalTables(Vector vector) {
        this.historicalTables = vector;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    protected void setStartFields(Vector vector) {
        this.startFields = vector;
    }

    public void addStartFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(ClassConstants.TIMESTAMP);
        if (this.startFields == null) {
            this.startFields = NonSynchronizedVector.newInstance();
            this.startFields.addElement(databaseField);
            return;
        }
        Enumeration enumeration = this.startFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseField2.getTableName())) continue;
            databaseField2.setName(databaseField.getName());
            return;
        }
        this.startFields.addElement(databaseField);
    }

    public void setStartFieldType(Class clazz) {
        Enumeration enumeration = this.startFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseField.setType(clazz);
        }
    }

    protected void setEndFields(Vector vector) {
        this.endFields = vector;
    }

    public void addEndFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(ClassConstants.TIMESTAMP);
        if (this.endFields == null) {
            this.endFields = NonSynchronizedVector.newInstance();
            this.endFields.addElement(databaseField);
            return;
        }
        Enumeration enumeration = this.endFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseField2.getTableName())) continue;
            databaseField2.setName(databaseField.getName());
            return;
        }
        this.endFields.addElement(databaseField);
    }

    public void setEndFieldType(String string, Class clazz) {
        Enumeration enumeration = this.endFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseField.setType(clazz);
        }
    }

    public void setShouldHandleWrites(boolean bl) {
        this.shouldHandleWrites = bl;
    }

    public boolean shouldHandleWrites() {
        return this.shouldHandleWrites;
    }

    public void setShouldUseDatabaseTime(boolean bl) {
        this.usesLocalTime = !bl;
    }

    public boolean shouldUseLocalTime() {
        return this.usesLocalTime;
    }

    public boolean shouldUseDatabaseTime() {
        return !this.usesLocalTime;
    }

    public void useLocalTime() {
        this.usesLocalTime = true;
    }

    public void useDatabaseTime() {
        this.usesLocalTime = false;
    }

    protected void verifyTableQualifiers(Platform platform) {
        String string = platform.getTableQualifier();
        if (string.length() == 0) {
            return;
        }
        Enumeration enumeration = this.getHistoricalTables().elements();
        while (enumeration.hasMoreElements()) {
            HistoricalDatabaseTable historicalDatabaseTable = (HistoricalDatabaseTable)enumeration.nextElement();
            DatabaseTable databaseTable = new DatabaseTable(historicalDatabaseTable.getQualifiedName());
            if (databaseTable.getTableQualifier().length() != 0) continue;
            databaseTable.setTableQualifier(string);
            historicalDatabaseTable.setHistoricalName(databaseTable.getQualifiedName());
        }
    }

    protected boolean checkWastedVersioning(DatabaseRow databaseRow, DatabaseTable databaseTable) {
        Enumeration enumeration = databaseRow.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTable().equals(databaseTable) && databaseField.hasTableName()) continue;
            return true;
        }
        return false;
    }

    public void postDelete(ModifyQuery modifyQuery) {
        this.logicalDelete(modifyQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.logicalDelete(objectLevelModifyQuery, true);
        this.logicalInsert(objectLevelModifyQuery, true);
    }

    public void postInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.logicalInsert(objectLevelModifyQuery, false);
    }

    public void logicalInsert(ObjectLevelModifyQuery objectLevelModifyQuery, boolean bl) {
        Descriptor descriptor = this.getDescriptor();
        DatabaseRow databaseRow = null;
        DatabaseRow databaseRow2 = objectLevelModifyQuery.getModifyRow();
        Object object = null;
        if (bl) {
            databaseRow = descriptor.getObjectBuilder().buildRow(objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
            databaseRow.putAll((Map)databaseRow2);
        } else {
            databaseRow = databaseRow2;
            object = this.getCurrentTime(objectLevelModifyQuery.getSession());
        }
        StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism(objectLevelModifyQuery);
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (bl && !this.checkWastedVersioning(databaseRow2, databaseTable)) continue;
            if (!bl) {
                databaseRow.add(this.getStart(i), object);
            }
            SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
            sQLInsertStatement.setTable(databaseTable);
            statementQueryMechanism.getSQLStatements().add(sQLInsertStatement);
        }
        if (statementQueryMechanism.hasMultipleStatements()) {
            objectLevelModifyQuery.setTranslationRow(databaseRow);
            objectLevelModifyQuery.setModifyRow(databaseRow);
            statementQueryMechanism.insertObject();
        }
    }

    public void mappingLogicalInsert(DataModifyQuery dataModifyQuery, DatabaseRow databaseRow, Session session) {
        SQLInsertStatement sQLInsertStatement = (SQLInsertStatement)dataModifyQuery.getSQLStatement();
        DatabaseTable databaseTable = sQLInsertStatement.getTable();
        DataModifyQuery dataModifyQuery2 = new DataModifyQuery();
        SQLInsertStatement sQLInsertStatement2 = new SQLInsertStatement();
        DatabaseTable databaseTable2 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        sQLInsertStatement2.setTable(databaseTable2);
        DatabaseRow databaseRow2 = (DatabaseRow)dataModifyQuery.getModifyRow().clone();
        DatabaseRow databaseRow3 = (DatabaseRow)databaseRow.clone();
        if (!databaseRow2.containsKey(this.getStart())) {
            Object object = this.getCurrentTime(session);
            databaseRow2.add(this.getStart(), object);
            databaseRow3.add(this.getStart(), object);
        }
        dataModifyQuery2.setSQLStatement(sQLInsertStatement2);
        dataModifyQuery2.setModifyRow(databaseRow2);
        sQLInsertStatement2.setModifyRow(databaseRow2);
        session.executeQuery((DatabaseQuery)dataModifyQuery2, databaseRow3);
    }

    public void logicalDelete(ModifyQuery modifyQuery, boolean bl) {
        Descriptor descriptor = modifyQuery.getDescriptor();
        DatabaseRow databaseRow = modifyQuery.getModifyRow();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism(modifyQuery);
        Object object = this.getCurrentTime(modifyQuery.getSession());
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (bl && !this.checkWastedVersioning(databaseRow, databaseTable)) continue;
            SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
            sQLUpdateStatement.setTable(databaseTable);
            Expression expression = null;
            if (modifyQuery instanceof DeleteAllQuery) {
                if (modifyQuery.getSelectionCriteria() != null) {
                    expression = (Expression)modifyQuery.getSelectionCriteria().clone();
                }
            } else {
                expression = descriptor.getObjectBuilder().buildPrimaryKeyExpression(databaseTable);
            }
            ExpressionBuilder expressionBuilder = expression == null ? new ExpressionBuilder() : expression.getBuilder();
            expression = expressionBuilder.getField(this.getEnd(i)).isNull().and(expression);
            sQLUpdateStatement.setWhereClause(expression);
            databaseRecord.add(this.getEnd(i), object);
            if (bl) {
                databaseRow.add(this.getStart(i), object);
            }
            statementQueryMechanism.getSQLStatements().add(sQLUpdateStatement);
        }
        if (statementQueryMechanism.hasMultipleStatements()) {
            modifyQuery.setModifyRow(databaseRecord);
            statementQueryMechanism.updateObject();
            modifyQuery.setModifyRow(databaseRow);
        }
    }

    public void mappingLogicalDelete(ModifyQuery modifyQuery, DatabaseRow databaseRow, Session session) {
        SQLDeleteStatement sQLDeleteStatement = (SQLDeleteStatement)modifyQuery.getSQLStatement();
        DatabaseTable databaseTable = sQLDeleteStatement.getTable();
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        DatabaseTable databaseTable2 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        sQLUpdateStatement.setTable(databaseTable2);
        Expression expression = (Expression)sQLDeleteStatement.getWhereClause().clone();
        DatabaseField databaseField = this.getEnd();
        expression = expression.getBuilder().getField(databaseField).isNull().and(expression);
        sQLUpdateStatement.setWhereClause(expression);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        DatabaseRow databaseRow2 = (DatabaseRow)databaseRow.clone();
        Object object = this.getCurrentTime(session);
        databaseRecord.add(this.getEnd(), object);
        databaseRow2.add(this.getEnd(), object);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        dataModifyQuery.setSQLStatement(sQLUpdateStatement);
        dataModifyQuery.setModifyRow(databaseRecord);
        session.executeQuery((DatabaseQuery)dataModifyQuery, databaseRow2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

