/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.history;

import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.ConstantExpression;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.Helper;

public class AsOfClause
implements Serializable {
    public static final AsOfClause NO_CLAUSE = new AsOfClause((Expression)null);
    private final Object value;

    public AsOfClause(Date date) {
        this.value = date;
    }

    public AsOfClause(Timestamp timestamp) {
        this.value = timestamp;
    }

    public AsOfClause(Calendar calendar) {
        this.value = calendar;
    }

    public AsOfClause(long l) {
        this.value = new Long(l);
    }

    public AsOfClause(Long l) {
        this.value = l;
    }

    protected AsOfClause(Number number) {
        this.value = number;
    }

    public AsOfClause(Expression expression) {
        this.value = expression;
    }

    protected AsOfClause(AsOfClause asOfClause) {
        this.value = asOfClause;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printString("AS OF TIMESTAMP (");
        Object object = this.getValue();
        if (object instanceof Expression) {
            if (object instanceof ConstantExpression && ((ConstantExpression)object).getValue() instanceof String) {
                expressionSQLPrinter.printString((String)((ConstantExpression)object).getValue());
            } else {
                expressionSQLPrinter.printExpression((Expression)object);
            }
        } else {
            ConversionManager conversionManager = ConversionManager.getDefaultManager();
            object = conversionManager.convertObject(object, ClassConstants.TIMESTAMP);
            expressionSQLPrinter.printPrimitive(object);
        }
        expressionSQLPrinter.printString(")");
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isAsOfSCNClause() {
        return false;
    }

    public boolean isUniversal() {
        return false;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        stringWriter.write(this.getValue().toString());
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

