/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.TableExpression;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class ExpressionBuilder
extends ObjectExpression {
    protected transient Session session;
    protected Class queryClass;
    protected SQLSelectStatement statement;
    protected DatabaseTable viewTable;
    protected DatabaseTable aliasedViewTable;

    public ExpressionBuilder() {
    }

    public ExpressionBuilder(Class clazz) {
        this.queryClass = clazz;
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        if (this.hasViewTable()) {
            return this.getAliasedViewTable();
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            Enumeration enumeration = this.derivedTables.elements();
            while (enumeration.hasMoreElements()) {
                TableExpression tableExpression = (TableExpression)enumeration.nextElement();
                DatabaseTable databaseTable2 = tableExpression.aliasForTable(databaseTable);
                if (databaseTable2 == null) continue;
                return databaseTable2;
            }
        } else {
            return super.aliasForTable(databaseTable);
        }
        return null;
    }

    public int assignTableAliasesStartingAt(int n) {
        if (this.hasBeenAliased()) {
            return n;
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            return n;
        }
        if (this.hasViewTable()) {
            DatabaseTable databaseTable = (DatabaseTable)this.viewTable.clone();
            String string = "t" + n;
            databaseTable.setName(string);
            this.assignAlias(string, this.viewTable);
            this.aliasedViewTable = databaseTable;
            return n + 1;
        }
        return super.assignTableAliasesStartingAt(n);
    }

    public String descriptionOfNodeType() {
        return "Base";
    }

    public boolean doesNotRepresentAnObjectInTheQuery() {
        return this.hasDerivedTables() && !this.hasDerivedFields() && !this.hasDerivedExpressions();
    }

    public DatabaseTable getAliasedViewTable() {
        return this.aliasedViewTable;
    }

    public ExpressionBuilder getBuilder() {
        return this;
    }

    public Descriptor getDescriptor() {
        if (this.descriptor == null) {
            if (this.getQueryClass() == null) {
                return null;
            }
            if (this.getSession() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            this.descriptor = this.getSession().getDescriptor(this.getQueryClass());
        }
        return this.descriptor;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public Session getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public DatabaseTable getViewTable() {
        return this.viewTable;
    }

    public boolean hasViewTable() {
        return this.viewTable != null;
    }

    public boolean isExpressionBuilder() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        Expression expression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        this.setHasBeenNormalized(true);
        if (this.getSession() == null) {
            this.setSession(expressionNormalizer.getSession());
            if (this.getDescriptor() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            expression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (expression != null) {
                expression = this.twist(expression, this);
                expressionNormalizer.addAdditionalExpression(expression);
            }
        }
        this.setStatement(expressionNormalizer.getStatement());
        if (this.getAsOfClause() == null) {
            this.asOf(AsOfClause.NO_CLAUSE);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            expression = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            expressionNormalizer.addAdditionalExpression(expression);
        }
        return super.normalize(expressionNormalizer);
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        expressionJavaPrinter.printString(expressionJavaPrinter.getBuilderString());
    }

    public Expression rebuildOn(Expression expression) {
        return expression;
    }

    protected Expression registerIn(Dictionary dictionary) {
        Object v = dictionary.get(dictionary);
        if (v == null || v == dictionary) {
            return super.registerIn(dictionary);
        }
        ObjectExpression objectExpression = (ObjectExpression)v;
        dictionary.put(dictionary, dictionary);
        dictionary.put(this, objectExpression);
        if (this.derivedExpressions != null) {
            if (objectExpression.derivedExpressions == null) {
                objectExpression.derivedExpressions = this.copyCollection(this.derivedExpressions, dictionary);
            } else {
                objectExpression.derivedExpressions.addAll(this.copyCollection(this.derivedExpressions, dictionary));
            }
        }
        objectExpression.postCopyIn(dictionary, this.derivedFields, this.derivedTables);
        return objectExpression;
    }

    public void setQueryClass(Class clazz) {
        this.queryClass = clazz;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }

    public void setViewTable(DatabaseTable databaseTable) {
        this.viewTable = databaseTable;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return expression;
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        return object;
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        String string = this.getQueryClass() == null ? "QUERY OBJECT" : this.getQueryClass().getName();
        bufferedWriter.write(string + this.tableAliasesDescription());
    }
}

