/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.exceptions;

import java.io.StringWriter;
import java.sql.SQLException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.Record;

public class DatabaseException
extends TopLinkException {
    protected SQLException exception;
    protected transient Call call;
    protected transient DatabaseQuery query;
    protected transient DatabaseRow queryArguments;
    protected transient Accessor accessor;
    public static final int SQL_EXCEPTION = 4002;
    public static final int CONFIGURATION_ERROR_CLASS_NOT_FOUND = 4003;
    public static final int DATABASE_ACCESSOR_NOT_CONNECTED = 4005;
    public static final int ERROR_READING_BLOB_DATA = 4006;
    public static final int COULD_NOT_CONVERT_OBJECT_TYPE = 4007;
    public static final int LOGOUT_WHILE_TRANSACTION_IN_PROGRESS = 4008;
    public static final int SEQUENCE_TABLE_INFORMATION_NOT_COMPLETE = 4009;
    public static final int ERROR_PREALLOCATING_SEQUENCE_NUMBERS = 4011;
    public static final int CANNOT_REGISTER_SYNCHRONIZATIONLISTENER_FOR_UNITOFWORK = 4014;
    public static final int SYNCHRONIZED_UNITOFWORK_DOES_NOT_SUPPORT_COMMITANDRESUME = 4015;
    public static final int CONFIGURATION_ERROR_NEW_INSTANCE_INSTANTIATION_EXCEPTION = 4016;
    public static final int CONFIGURATION_ERROR_NEW_INSTANCE_ILLEGAL_ACCESS_EXCEPTION = 4017;
    public static final int TRANSACTION_MANAGER_NOT_SET_FOR_JTS_DRIVER = 4018;
    public static final int ERROR_RETRIEVE_DB_METADATA_THROUGH_JDBC_CONNECTION = 4019;
    static /* synthetic */ Class class$oracle$toplink$exceptions$DatabaseException;

    protected DatabaseException(String string) {
        super(string);
    }

    protected DatabaseException(SQLException sQLException) {
        super(sQLException.toString(), sQLException);
    }

    public static DatabaseException cannotRegisterSynchronizatonListenerForUnitOfWork(Exception exception) {
        Object[] objectArray = new Object[]{exception};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4014, objectArray));
        databaseException.setErrorCode(4014);
        databaseException.setInternalException(exception);
        return databaseException;
    }

    public static DatabaseException configurationErrorClassNotFound(String string) {
        Object[] objectArray = new Object[]{string};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4003, objectArray));
        databaseException.setErrorCode(4003);
        return databaseException;
    }

    public static DatabaseException configurationErrorNewInstanceIllegalAccessException(IllegalAccessException illegalAccessException, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4017, objectArray));
        databaseException.setErrorCode(4017);
        databaseException.setInternalException(illegalAccessException);
        return databaseException;
    }

    public static DatabaseException configurationErrorNewInstanceInstantiationException(InstantiationException instantiationException, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4016, objectArray));
        databaseException.setErrorCode(4016);
        databaseException.setInternalException(instantiationException);
        return databaseException;
    }

    public static DatabaseException couldNotConvertObjectType(int n) {
        Object[] objectArray = new Object[]{CR, new Integer(n)};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4007, objectArray));
        databaseException.setErrorCode(4007);
        return databaseException;
    }

    public static DatabaseException databaseAccessorNotConnected() {
        Object[] objectArray = new Object[]{};
        String string = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4005, objectArray);
        DatabaseException databaseException = new DatabaseException(string);
        databaseException.setErrorCode(4005);
        return databaseException;
    }

    public static DatabaseException databaseAccessorNotConnected(DatabaseAccessor databaseAccessor) {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4005, objectArray));
        databaseException.setErrorCode(4005);
        databaseException.setAccessor(databaseAccessor);
        return databaseException;
    }

    public static DatabaseException errorPreallocatingSequenceNumbers() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4011, objectArray));
        databaseException.setErrorCode(4011);
        return databaseException;
    }

    public static DatabaseException errorReadingBlobData() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4006, objectArray));
        databaseException.setErrorCode(4006);
        return databaseException;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public int getDatabaseErrorCode() {
        if (this.getInternalException() == null) {
            return super.getErrorCode();
        }
        return ((SQLException)this.getInternalException()).getErrorCode();
    }

    public String getMessage() {
        if (this.getInternalException() == null) {
            return super.getMessage();
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(super.getMessage());
        stringWriter.write(this.getIndentationString());
        stringWriter.write(ExceptionMessageGenerator.getHeader("ErrorCodeHeader"));
        if (this.getInternalException() instanceof SQLException) {
            stringWriter.write(Integer.toString(((SQLException)this.getInternalException()).getErrorCode()));
        } else {
            stringWriter.write("000");
        }
        if (this.getCall() != null) {
            stringWriter.write(DatabaseException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write("Call:");
            if (this.getAccessor() != null) {
                stringWriter.write(this.getCall().getLogString(this.getAccessor()));
            } else {
                stringWriter.write(this.getCall().toString());
            }
        }
        if (this.getQuery() != null) {
            stringWriter.write(DatabaseException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write("Query:");
            try {
                stringWriter.write(this.getQuery().toString());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return stringWriter.toString();
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public DatabaseRow getQueryArguments() {
        return this.queryArguments;
    }

    public Record getQueryArgumentsRecord() {
        return this.queryArguments;
    }

    public static DatabaseException logoutWhileTransactionInProgress() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4008, objectArray));
        databaseException.setErrorCode(4008);
        return databaseException;
    }

    public static DatabaseException sequenceTableInformationNotComplete() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4009, objectArray));
        databaseException.setErrorCode(4009);
        return databaseException;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setQueryArguments(DatabaseRow databaseRow) {
        this.queryArguments = databaseRow;
    }

    public static DatabaseException sqlException(SQLException sQLException) {
        DatabaseException databaseException = new DatabaseException(sQLException);
        databaseException.setErrorCode(4002);
        return databaseException;
    }

    public static DatabaseException sqlException(SQLException sQLException, Accessor accessor, Session session) {
        DatabaseException databaseException = new DatabaseException(sQLException);
        databaseException.setErrorCode(4002);
        databaseException.setAccessor(accessor);
        databaseException.setSession(session);
        return databaseException;
    }

    public static DatabaseException sqlException(SQLException sQLException, Call call, Accessor accessor, Session session) {
        DatabaseException databaseException = new DatabaseException(sQLException);
        databaseException.setErrorCode(4002);
        databaseException.setAccessor(accessor);
        databaseException.setCall(call);
        return databaseException;
    }

    public static DatabaseException synchronizedUnitOfWorkDoesNotSupportCommitAndResume() {
        Object[] objectArray = new Object[]{};
        String string = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4015, objectArray);
        DatabaseException databaseException = new DatabaseException(string);
        databaseException.setErrorCode(4015);
        return databaseException;
    }

    public static DatabaseException transactionManagerNotSetForJTSDriver() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4018, objectArray));
        databaseException.setErrorCode(4018);
        return databaseException;
    }

    public static DatabaseException errorRetrieveDbMetadataThroughJDBCConnection() {
        Object[] objectArray = new Object[]{};
        DatabaseException databaseException = new DatabaseException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DatabaseException == null ? (class$oracle$toplink$exceptions$DatabaseException = DatabaseException.class$("oracle.toplink.exceptions.DatabaseException")) : class$oracle$toplink$exceptions$DatabaseException, 4019, objectArray));
        databaseException.setErrorCode(4019);
        return databaseException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

