/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.interactions;

import java.io.StringWriter;
import java.util.Enumeration;
import oracle.toplink.eis.interactions.MappedInteraction;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.QueryStringCall;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;

public class QueryStringInteraction
extends MappedInteraction
implements QueryStringCall {
    protected String queryString;

    public QueryStringInteraction() {
        this.queryString = "";
    }

    public QueryStringInteraction(String string) {
        this.queryString = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void translate(DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
        this.translateQueryString(databaseRow, databaseRow2, session);
    }

    public void prepare(Session session) {
        if (this.isPrepared()) {
            return;
        }
        this.translateCustomQuery();
        this.setIsPrepared(true);
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Executing ");
        stringWriter.write(this.toString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tspec => ");
        stringWriter.write(String.valueOf(this.getInteractionSpec()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tquery => ");
        stringWriter.write(this.getQueryString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tparameters => [");
        if (this.hasParameters()) {
            Enumeration enumeration = this.getParameters().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                stringWriter.write(String.valueOf(e));
                if (!enumeration.hasMoreElements()) continue;
                stringWriter.write(", ");
            }
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    public boolean isQueryStringCall() {
        return true;
    }
}

