/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis;

import java.util.List;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.eis.mappings.EISDirectMapping;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.ox.QNameInheritancePolicy;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseRecord;

public class EISDescriptor
extends ClassDescriptor {
    protected String dataFormat;
    public static final String MAPPED = "mapped";
    public static final String INDEXED = "indexed";
    public static final String XML = "xml";
    protected NamespaceResolver namespaceResolver;

    public EISDescriptor() {
        this.shouldOrderMappings = false;
        this.dataFormat = XML;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isEISMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public void setDataTypeName(String string) throws DescriptorException {
        this.setTableName(string);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            if (this.getDataFormat() == XML) {
                this.setInheritancePolicy(new QNameInheritancePolicy(this));
            } else {
                this.setInheritancePolicy(new InheritancePolicy(this));
            }
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setQueryManager(DescriptorQueryManager descriptorQueryManager) {
        this.queryManager = descriptorQueryManager;
        if (descriptorQueryManager != null) {
            descriptorQueryManager.setDescriptor(this);
        }
    }

    public void preInitialize(Session session) {
        if (this.isInitialized(1)) {
            return;
        }
        if (this.dataFormat.equals(XML)) {
            this.setObjectBuilder(new XMLObjectBuilder(this));
            if (this.hasInheritance()) {
                ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.namespaceResolver);
            }
        }
        super.preInitialize(session);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    public void useMappedRecordFormat() {
        this.setDataFormat(MAPPED);
    }

    public void useIndexedRecordFormat() {
        this.setDataFormat(INDEXED);
    }

    public void useXMLRecordFormat() {
        this.setDataFormat(XML);
    }

    public DatabaseRow buildNestedRowFromFieldValue(Object object) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(object instanceof List)) {
                return new DatabaseRecord(1);
            }
            List list = (List)object;
            if (list.isEmpty()) {
                return new DatabaseRecord(1);
            }
            if (!(list.get(0) instanceof DatabaseRow)) {
                return new DatabaseRecord(1);
            }
            return (DatabaseRow)list.get(0);
        }
        if (object instanceof XMLRecord) {
            return (XMLRecord)object;
        }
        if (!(object instanceof Vector)) {
            return this.getObjectBuilder().createRecord();
        }
        Vector vector = (Vector)object;
        if (vector.isEmpty()) {
            return this.getObjectBuilder().createRecord();
        }
        if (!(vector.firstElement() instanceof XMLRecord)) {
            return this.getObjectBuilder().createRecord();
        }
        return (XMLRecord)vector.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object object, Session session) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(object instanceof List)) {
                return new Vector();
            }
            return new Vector((List)object);
        }
        if (!(object instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)object;
    }

    public Vector buildDirectValuesFromFieldValue(Object object) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildDirectValuesFromFieldValue(object);
        }
        if (!(object instanceof Vector)) {
            Vector<Object> vector = new Vector<Object>(1);
            vector.add(object);
            return vector;
        }
        return (Vector)object;
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, Session session) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildFieldValueFromDirectValues(vector, string, session);
        }
        return vector;
    }

    public Object buildFieldValueFromNestedRow(DatabaseRow databaseRow, Session session) throws DatabaseException {
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(1);
        vector.addElement(databaseRow);
        return this.buildFieldValueFromNestedRows(vector, "", session);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, Session session) throws DatabaseException {
        return vector;
    }

    public DatabaseField buildField(String string) {
        if (this.getDataFormat().equals(XML)) {
            XMLField xMLField = new XMLField(string);
            xMLField.setNamespaceResolver(this.getNamespaceResolver());
            return xMLField;
        }
        return super.buildField(string);
    }

    public void buildField(DatabaseField databaseField) {
        if (databaseField instanceof XMLField) {
            ((XMLField)databaseField).setNamespaceResolver(this.getNamespaceResolver());
        } else {
            super.buildField(databaseField);
        }
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        EISDirectMapping eISDirectMapping = new EISDirectMapping();
        eISDirectMapping.setAttributeName(string);
        if (this.getDataFormat() == XML) {
            eISDirectMapping.setXPath(string2);
        } else {
            eISDirectMapping.setFieldName(string2);
        }
        return this.addMapping(eISDirectMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        EISDirectMapping eISDirectMapping = new EISDirectMapping();
        eISDirectMapping.setAttributeName(string);
        eISDirectMapping.setSetMethodName(string3);
        eISDirectMapping.setGetMethodName(string2);
        if (this.getDataFormat() == XML) {
            eISDirectMapping.setXPath(string4);
        } else {
            eISDirectMapping.setFieldName(string4);
        }
        return this.addMapping(eISDirectMapping);
    }

    public void addPrimaryKeyFieldName(String string) {
        super.addPrimaryKeyFieldName(string);
    }

    public void setSequenceNumberFieldName(String string) {
        super.setSequenceNumberFieldName(string);
    }

    public DatabaseCall buildCallFromStatement(SQLStatement sQLStatement, Session session) {
        throw QueryException.noCallOrInteractionSpecified();
    }

    public void initializeAggregateInheritancePolicy(Session session) {
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    protected void initializePrimaryKey(DatabaseField databaseField) {
        if (this.getDataFormat().equals(XML)) {
            this.buildField(databaseField);
        } else {
            super.initializePrimaryKey(databaseField);
        }
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return false;
    }
}

