/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.EISPlatform;
import oracle.toplink.eis.interactions.EISInteraction;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatasourceAccessor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;

public class EISAccessor
extends DatasourceAccessor {
    protected Connection cciConnection;
    protected RecordFactory recordFactory;

    protected void basicBeginTransaction(Session session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().begin();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, session);
        }
    }

    protected void closeDatasourceConnection() {
        try {
            this.getCCIConnection().close();
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, null);
        }
    }

    protected void basicCommitTransaction(Session session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().commit();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, session);
        }
    }

    protected void buildConnectLog(Session session) {
        try {
            if (session.shouldLog(4, "connection")) {
                ConnectionMetaData connectionMetaData = this.getCCIConnection().getMetaData();
                Object[] objectArray = new Object[]{connectionMetaData.getUserName(), connectionMetaData.getEISProductName(), connectionMetaData.getEISProductVersion(), Helper.cr(), "\t"};
                session.log(4, "connection", "connected_user_database", objectArray, this);
            }
        }
        catch (ResourceException resourceException) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public Object executeCall(Call call, DatabaseRow databaseRow, Session session) throws DatabaseException {
        return this.basicExecuteCall(call, databaseRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object basicExecuteCall(Call call, DatabaseRow databaseRow, Session session) throws DatabaseException {
        boolean bl;
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        Interaction interaction = null;
        Serializable serializable = null;
        EISInteraction eISInteraction = null;
        try {
            eISInteraction = (EISInteraction)call;
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseCall(call);
        }
        boolean bl2 = bl = !this.isInTransaction() && this.getEISPlatform().requiresAutoCommit();
        if (bl) {
            this.beginTransaction(session);
        }
        try {
            if (session.shouldLog(3, "sql")) {
                session.log(3, "sql", call.getLogString(this), null, this, false);
            }
            this.incrementCallCount(session);
            session.startOperationProfile("sql prepare");
            Record record = null;
            Record record2 = null;
            try {
                interaction = this.getCCIConnection().createInteraction();
                record = this.getEISPlatform().createInputRecord(eISInteraction, this);
                record2 = this.getEISPlatform().createOutputRecord(eISInteraction, this);
            }
            finally {
                session.endOperationProfile("sql prepare");
            }
            session.startOperationProfile("sql execute");
            try {
                InteractionSpec interactionSpec = this.getEISPlatform().buildInteractionSpec(eISInteraction);
                if (record2 == null) {
                    record2 = interaction.execute(interactionSpec, record);
                } else {
                    interaction.execute(interactionSpec, record, record2);
                }
                session.log(1, "query", "adapter_result", record2);
                if (eISInteraction.isNothingReturned()) {
                    DatabaseRow databaseRow2;
                    serializable = new Integer(1);
                    if (record2 != null && (databaseRow2 = this.getEISPlatform().buildRow(record2, eISInteraction, this)) != null) {
                        eISInteraction.getQuery().setProperty("output", databaseRow2);
                        session.getEventManager().outputParametersDetected(databaseRow2, eISInteraction);
                    }
                } else {
                    serializable = eISInteraction.isOneRowReturned() ? this.getEISPlatform().buildRow(record2, eISInteraction, this) : this.getEISPlatform().buildRows(record2, eISInteraction, this);
                }
                session.log(1, "query", "data_access_result", record2);
            }
            finally {
                session.endOperationProfile("sql execute");
            }
        }
        catch (ResourceException resourceException) {
            try {
                try {
                    interaction.close();
                }
                finally {
                    if (bl) {
                        this.commitTransaction(session);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw EISException.resourceException(resourceException, call, this, session);
        }
        catch (RuntimeException runtimeException) {
            try {
                try {
                    interaction.close();
                }
                finally {
                    if (bl) {
                        this.commitTransaction(session);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            try {
                interaction.close();
            }
            finally {
                if (bl) {
                    this.commitTransaction(session);
                }
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, session);
        }
        return serializable;
    }

    public Connection getCCIConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public EISPlatform getEISPlatform() {
        return (EISPlatform)this.getDatasourcePlatform();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    public void basicRollbackTransaction(Session session) throws DatabaseException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().rollback();
            }
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, this, session);
        }
    }

    protected boolean isDatasourceConnected() {
        return this.isConnected;
    }
}

