/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors.invalidation;

import java.util.Calendar;
import oracle.toplink.descriptors.invalidation.CacheInvalidationPolicy;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.internal.identitymaps.CacheKey;

public class DailyCacheInvalidationPolicy
extends CacheInvalidationPolicy {
    protected Calendar expiryTime = null;
    protected Calendar previousExpiry = null;

    public DailyCacheInvalidationPolicy() {
        this.expiryTime = Calendar.getInstance();
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
    }

    public DailyCacheInvalidationPolicy(int n, int n2, int n3, int n4) {
        this.setExpiryTime(n, n2, n3, n4);
    }

    public long getExpiryTimeInMillis(CacheKey cacheKey) {
        this.incrementExpiry();
        return JavaPlatform.getTimeInMillis(this.expiryTime);
    }

    public Calendar getExpiryTime() {
        return this.expiryTime;
    }

    public boolean isInvalidated(CacheKey cacheKey, long l) {
        if (cacheKey.getInvalidationState() == -1) {
            return true;
        }
        long l2 = JavaPlatform.getTimeInMillis(this.expiryTime);
        long l3 = cacheKey.getReadTime();
        if (l < l2) {
            long l4 = JavaPlatform.getTimeInMillis(this.previousExpiry);
            if (l3 >= l4) {
                return false;
            }
            return l >= l4;
        }
        if (l3 < l2) {
            this.incrementExpiry();
            return true;
        }
        this.incrementExpiry();
        return false;
    }

    public void incrementExpiry() {
        long l;
        long l2 = System.currentTimeMillis();
        if (l2 <= (l = JavaPlatform.getTimeInMillis(this.expiryTime))) {
            return;
        }
        while (l2 > JavaPlatform.getTimeInMillis(this.expiryTime)) {
            this.previousExpiry.add(6, 1);
            this.expiryTime.add(6, 1);
        }
    }

    public void setExpiryTime(int n, int n2, int n3, int n4) {
        this.expiryTime = Calendar.getInstance();
        this.expiryTime.set(11, n);
        this.expiryTime.set(12, n2);
        this.expiryTime.set(13, n3);
        this.expiryTime.set(14, n4);
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
        this.incrementExpiry();
    }

    public void setExpiryTime(Calendar calendar) {
        this.setExpiryTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }
}

