/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors.copying;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.descriptors.copying.AbstractCopyPolicy;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.sessions.Record;
import oracle.toplink.sessions.Session;

public class CloneCopyPolicy
extends AbstractCopyPolicy {
    protected String methodName;
    protected String workingCopyMethodName;
    protected transient Method method;
    protected transient Method workingCopyMethod;

    public Object buildClone(Object object, Session session) throws DescriptorException {
        if (this.getMethodName() == null) {
            return this.getDescriptor().getObjectBuilder().buildNewInstance();
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.getMethod(), object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileCloning(object, this.getMethodName(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileCloning(object, this.getMethodName(), this.getDescriptor(), invocationTargetException);
        }
    }

    public Object buildWorkingCopyClone(Object object, Session session) throws DescriptorException {
        if (this.getWorkingCopyMethodName() == null) {
            return this.buildClone(object, session);
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.getWorkingCopyMethod(), object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileCloning(object, this.getMethodName(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileCloning(object, this.getMethodName(), this.getDescriptor(), invocationTargetException);
        }
    }

    public Object buildWorkingCopyCloneFromRow(Record record, ObjectLevelReadQuery objectLevelReadQuery) throws DescriptorException {
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        if (this.getWorkingCopyMethodName() != null) {
            Object object = objectBuilder.buildNewInstance();
            objectBuilder.buildAttributesIntoShallowObject(object, (DatabaseRow)record, objectLevelReadQuery);
            return this.buildWorkingCopyClone(object, objectLevelReadQuery.getSession());
        }
        return objectBuilder.buildNewInstance();
    }

    protected Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected Method getWorkingCopyMethod() {
        return this.workingCopyMethod;
    }

    public String getWorkingCopyMethodName() {
        return this.workingCopyMethodName;
    }

    public void initialize(Session session) throws DescriptorException {
        try {
            if (this.getMethodName() != null) {
                this.setMethod(Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), this.getMethodName(), new Class[0]));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            session.getIntegrityChecker().handleError(DescriptorException.noSuchMethodWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), noSuchMethodException));
        }
        catch (SecurityException securityException) {
            session.getIntegrityChecker().handleError(DescriptorException.securityWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), securityException));
        }
        if (this.getWorkingCopyMethodName() != null) {
            try {
                this.setWorkingCopyMethod(Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), this.getWorkingCopyMethodName(), new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                session.getIntegrityChecker().handleError(DescriptorException.noSuchMethodWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), noSuchMethodException));
            }
            catch (SecurityException securityException) {
                session.getIntegrityChecker().handleError(DescriptorException.securityWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), securityException));
            }
        }
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    protected void setWorkingCopyMethod(Method method) {
        this.workingCopyMethod = method;
    }

    public void setWorkingCopyMethodName(String string) {
        this.workingCopyMethodName = string;
    }

    public boolean buildsNewInstance() {
        return this.getMethodName() == null;
    }

    public String toString() {
        return Helper.getShortClassName(this) + "(" + this.getMethodName() + ")";
    }
}

