/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.xerces;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.xml.XMLDataStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLToDatabaseRowTranslator {
    private static XMLParser parser;
    private static final String EMPTY_AGGREGATE_ATTRIBUTE_NAME_45 = "emptyAggregate";
    public static String NULL_ATTRIBUTE_NAME;
    public static String EMPTY_AGGREGATE_ATTRIBUTE_NAME;
    public static String ATTRIBUTE_VALUE_TRUE;
    public static String ATTRIBUTE_VALUE_FALSE;

    protected SDKFieldValue buildCompositeFieldValue(Node node) throws XMLDataStoreException {
        Node node2 = node.getFirstChild();
        while (this.nodeIsIgnorable(node2)) {
            node2 = node2.getNextSibling();
        }
        String string = node2.getNodeName();
        boolean bl = this.nodeIsSimple(node2);
        Vector<Object> vector = new Vector<Object>(node.getChildNodes().getLength());
        while (node2 != null) {
            if (this.nodeIsSimple(node2) != bl || !node2.getNodeName().equals(string)) {
                throw XMLDataStoreException.heterogeneousChildElements(node);
            }
            if (bl) {
                vector.addElement(this.buildSimpleFieldValue(node2));
            } else {
                vector.addElement(this.buildDatabaseRow(node2));
            }
            node2 = node2.getNextSibling();
            while (this.nodeIsIgnorable(node2)) {
                node2 = node2.getNextSibling();
            }
        }
        return new SDKFieldValue(vector, string, bl);
    }

    protected DatabaseRow buildDatabaseRow(Node node) throws XMLDataStoreException {
        DatabaseRecord databaseRecord = new DatabaseRecord(node.getChildNodes().getLength());
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (this.nodeIsIgnorable(node2)) continue;
            DatabaseField databaseField = new DatabaseField(node2.getNodeName(), node.getNodeName());
            Object object = this.buildFieldValue(node2);
            databaseRecord.put(databaseField, object);
        }
        return databaseRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document buildDocument(Reader reader) throws XMLDataStoreException {
        Document document = null;
        XMLParser xMLParser = XMLToDatabaseRowTranslator.getParser();
        try {
            XMLParser xMLParser2 = xMLParser;
            synchronized (xMLParser2) {
                document = xMLParser.parse(reader);
            }
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLDataStoreException.parserError(xMLPlatformException);
        }
        catch (Exception exception) {
            throw XMLDataStoreException.generalException(exception);
        }
        return document;
    }

    protected Object buildFieldValue(Node node) {
        if (this.nodeIsSimple(node)) {
            return this.buildSimpleFieldValue(node);
        }
        return this.buildCompositeFieldValue(node);
    }

    protected Object buildSimpleFieldValue(Node node) {
        if (node.hasChildNodes()) {
            return node.getFirstChild().getNodeValue();
        }
        if (this.nodeIsNull(node)) {
            return null;
        }
        return "";
    }

    private static XMLParser getParser() {
        if (parser == null) {
            try {
                XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                parser = xMLPlatform.newXMLParser();
                parser.setNamespaceAware(false);
                parser.setWhitespacePreserving(false);
            }
            catch (Exception exception) {
                throw XMLDataStoreException.generalException(exception);
            }
        }
        return parser;
    }

    protected boolean nodeIsEmptyAggregate(Node node) {
        if (node.hasAttributes()) {
            Node node2 = node.getAttributes().getNamedItem(EMPTY_AGGREGATE_ATTRIBUTE_NAME);
            if (node2 == null) {
                node2 = node.getAttributes().getNamedItem(EMPTY_AGGREGATE_ATTRIBUTE_NAME_45);
            }
            String string = null;
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            return string != null && string.equals(ATTRIBUTE_VALUE_TRUE);
        }
        return false;
    }

    protected boolean nodeIsIgnorable(Node node) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return node instanceof Text && xMLPlatform.isWhitespaceNode((Text)node);
    }

    protected boolean nodeIsNull(Node node) {
        if (node.hasAttributes()) {
            Node node2 = node.getAttributes().getNamedItem(NULL_ATTRIBUTE_NAME);
            String string = null;
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            return string != null && string.equals(ATTRIBUTE_VALUE_TRUE);
        }
        return false;
    }

    protected boolean nodeIsSimple(Node node) {
        if (this.nodeIsEmptyAggregate(node)) {
            return false;
        }
        if (!node.hasChildNodes()) {
            return true;
        }
        return node.getChildNodes().getLength() == 1 && node.getFirstChild() instanceof Text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRow read(Reader reader) throws XMLDataStoreException {
        Document document = null;
        try {
            document = this.buildDocument(reader);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw XMLDataStoreException.unableToCloseReadStream(this, iOException);
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.unableToCloseReadStream(this, iOException);
        }
        return this.buildDatabaseRow(document.getDocumentElement());
    }

    public String toString() {
        return Helper.getShortClassName(this);
    }

    static {
        NULL_ATTRIBUTE_NAME = "null";
        EMPTY_AGGREGATE_ATTRIBUTE_NAME = "empty-aggregate";
        ATTRIBUTE_VALUE_TRUE = "true";
        ATTRIBUTE_VALUE_FALSE = "false";
    }
}

