/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.stream;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sessions.Project;
import oracle.toplink.xml.xerces.DefaultXMLTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLStreamDatabase {
    public static final String ROOT_NODE_NAME = "toplink-command";
    private Hashtable elementStore = new Hashtable();

    public XMLStreamDatabase() {
    }

    public XMLStreamDatabase(Document document, Project project) {
        this();
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLTransformer xMLTransformer = xMLPlatform.newXMLTransformer();
        try {
            Iterator iterator = project.getDescriptors().values().iterator();
            while (iterator.hasNext()) {
                Descriptor descriptor = (Descriptor)iterator.next();
                if (descriptor.isAggregateDescriptor()) continue;
                String string = descriptor.getTableName();
                NodeList nodeList = document.getElementsByTagName(string);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    if (!element.getParentNode().getNodeName().equalsIgnoreCase(ROOT_NODE_NAME)) continue;
                    StringWriter stringWriter = new StringWriter();
                    xMLTransformer.transform((Node)element, stringWriter);
                    String string2 = stringWriter.toString();
                    List list = descriptor.getPrimaryKeyFields();
                    DefaultXMLTranslator defaultXMLTranslator = new DefaultXMLTranslator();
                    DatabaseRow databaseRow = defaultXMLTranslator.read(new StringReader(string2));
                    String string3 = this.buildUniqueKey(databaseRow, list);
                    this.getXMLWriters(string).put(string3, stringWriter);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Document getDocument() {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLParser xMLParser = xMLPlatform.newXMLParser();
        xMLParser.setNamespaceAware(false);
        xMLParser.setWhitespacePreserving(false);
        Document document = null;
        try {
            document = xMLPlatform.createDocument();
            document.appendChild(document.createElement(ROOT_NODE_NAME));
            Enumeration enumeration = this.elementStore.elements();
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = ((Hashtable)enumeration.nextElement()).elements();
                while (enumeration2.hasMoreElements()) {
                    String string = enumeration2.nextElement().toString();
                    InputSource inputSource = new InputSource(new StringReader(string));
                    Node node = document.importNode(xMLParser.parse(inputSource).getDocumentElement(), true);
                    document.getDocumentElement().appendChild(node);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    void putWriter(String string, DatabaseRow databaseRow, Vector vector, Writer writer) {
        String string2 = this.buildUniqueKey(databaseRow, vector);
        this.getXMLWriters(string).put(string2, writer);
    }

    Writer getWriter(String string, DatabaseRow databaseRow, Vector vector) {
        Hashtable hashtable = this.getXMLWriters(string);
        StringWriter stringWriter = new StringWriter();
        String string2 = this.buildUniqueKey(databaseRow, vector);
        this.getXMLWriters(string).put(string2, stringWriter);
        return stringWriter;
    }

    Reader getReader(String string, DatabaseRow databaseRow, Vector vector) {
        try {
            Hashtable hashtable = this.getXMLWriters(string);
            String string2 = this.buildUniqueKey(databaseRow, vector);
            Writer writer = (Writer)this.getXMLWriters(string).get(string2);
            return new StringReader(writer.toString());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    Enumeration getReaders(String string) {
        Vector<StringReader> vector = new Vector<StringReader>();
        Enumeration enumeration = this.getXMLWriters(string).elements();
        while (enumeration.hasMoreElements()) {
            Writer writer = (Writer)enumeration.nextElement();
            vector.add(new StringReader(writer.toString()));
        }
        return vector.elements();
    }

    Enumeration getReaders(String string, Vector vector, Vector vector2) {
        Vector<StringReader> vector3 = new Vector<StringReader>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = this.buildUniqueKey((DatabaseRow)enumeration.nextElement(), vector2);
            Writer writer = (Writer)this.getXMLWriters(string).get(string2);
            vector3.add(new StringReader(writer.toString()));
        }
        return vector3.elements();
    }

    void createStreamSource(String string) {
        if (!this.elementStore.containsKey(string)) {
            this.elementStore.put(string, new Hashtable());
        }
    }

    void dropStreamSource(String string) {
        this.elementStore.remove(string);
    }

    private Hashtable getXMLWriters(String string) {
        this.createStreamSource(string);
        return (Hashtable)this.elementStore.get(string);
    }

    private String buildUniqueKey(DatabaseRow databaseRow, List list) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Vector vector = this.extractPrimaryKeyValues(databaseRow, list);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.print(enumeration.nextElement());
        }
        return ((Object)stringWriter).toString();
    }

    private Vector extractPrimaryKeyValues(DatabaseRow databaseRow, List list) {
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            vector.addElement(databaseRow.get((DatabaseField)list.get(i)));
        }
        return vector;
    }
}

