/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.TraceLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sdk.SDKObjectCollectionMapping;
import oracle.toplink.xml.XMLCall;
import oracle.toplink.xml.XMLDataStoreException;

public class XMLReadAllCall
extends XMLCall {
    private SDKObjectCollectionMapping mapping;

    public XMLReadAllCall() {
    }

    public XMLReadAllCall(SDKObjectCollectionMapping sDKObjectCollectionMapping) {
        this();
        this.initialize(sDKObjectCollectionMapping);
    }

    public Object execute(DatabaseRow databaseRow, Accessor accessor) throws XMLDataStoreException {
        Enumeration enumeration = null;
        enumeration = this.getMapping() == null ? this.getStreamPolicy().getReadStreams(this.getRootElementName(), accessor) : this.getStreamPolicy().getReadStreams(this.getRootElementName(), this.extractForeignKeyRows(databaseRow), this.getOrderedForeignKeyElements(), accessor);
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>();
        while (enumeration.hasMoreElements()) {
            Reader reader = (Reader)enumeration.nextElement();
            if (reader == null) continue;
            DatabaseRow databaseRow2 = this.getXMLTranslator().read(reader);
            vector.addElement(this.getFieldTranslator().translateForRead(databaseRow2));
        }
        return vector;
    }

    protected Vector extractForeignKeyRows(DatabaseRow databaseRow) {
        return this.getMapping().extractForeignKeyRows(databaseRow, this.getSession());
    }

    protected SDKObjectCollectionMapping getMapping() {
        return this.mapping;
    }

    protected Vector getOrderedForeignKeyElements() {
        return this.getMapping().getOrderedForeignKeyFields();
    }

    protected void initialize(SDKObjectCollectionMapping sDKObjectCollectionMapping) {
        this.mapping = sDKObjectCollectionMapping;
    }

    public void setMapping(SDKObjectCollectionMapping sDKObjectCollectionMapping) {
        this.mapping = sDKObjectCollectionMapping;
    }

    protected void writeLogData(PrintWriter printWriter) {
        if (this.getMapping() != null) {
            Vector vector = this.extractForeignKeyRows(this.getTranslationRow());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.write(Helper.cr());
                printWriter.write("\t");
                this.write((DatabaseRow)enumeration.nextElement(), printWriter, 0);
            }
        }
    }

    protected void writeLogDescription(PrintWriter printWriter) {
        printWriter.write(TraceLocalization.buildMessage("XML_read_all", null));
        if (this.getMapping() != null) {
            printWriter.write("(");
            printWriter.print(this.getMapping());
            printWriter.write(")");
        }
    }
}

