/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sdk.SDKAccessor;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.Login;
import oracle.toplink.xml.DefaultXMLFileAccessorFilePolicy;
import oracle.toplink.xml.JARClassLoader;
import oracle.toplink.xml.XMLAccessor;
import oracle.toplink.xml.XMLDataStoreException;
import oracle.toplink.xml.XMLFileAccessorFilePolicy;
import oracle.toplink.xml.XMLFileLogin;
import oracle.toplink.xml.XMLFileStreamPolicy;
import oracle.toplink.xml.XMLStreamPolicy;
import oracle.toplink.xml.XMLTranslator;

public class XMLFileAccessor
extends SDKAccessor
implements XMLAccessor {
    private Map filePolicies;
    private XMLFileAccessorFilePolicy defaultFilePolicy;
    private XMLTranslator translator;
    private static ClassLoader customClassLoader;
    protected static final Class STRING_CLASS;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$oracle$toplink$xml$XMLFileLogin;

    public XMLFileAccessor() {
        this.setFilePolicies(this.buildDefaultFilePolicies());
        this.setDefaultFilePolicy(this.buildDefaultDefaultFilePolicy());
    }

    private static ClassLoader buildCustomClassLoader() {
        String[] stringArray = DatabaseLogin.getXMLParserJARFileNames();
        if (stringArray == null) {
            return null;
        }
        return XMLFileAccessor.buildCustomClassLoader(stringArray);
    }

    private static ClassLoader buildCustomClassLoader(String[] stringArray) {
        return new JARClassLoader(stringArray);
    }

    public void addFilePolicy(String string, XMLFileAccessorFilePolicy xMLFileAccessorFilePolicy) {
        this.getFilePolicies().put(string, xMLFileAccessorFilePolicy);
    }

    protected Map buildDefaultFilePolicies() {
        return new HashMap();
    }

    protected XMLFileAccessorFilePolicy buildDefaultDefaultFilePolicy() {
        return new DefaultXMLFileAccessorFilePolicy();
    }

    protected XMLTranslator buildDefaultXMLTranslator() {
        return (XMLTranslator)this.instantiate("oracle.toplink.xml.xerces.DefaultXMLTranslator");
    }

    protected XMLStreamPolicy buildStreamPolicy(Enumeration enumeration) {
        return new XMLFileStreamPolicy(enumeration);
    }

    protected XMLStreamPolicy buildStreamPolicy(File file) {
        return new XMLFileStreamPolicy(file);
    }

    public void connect(Login login, Session session) throws XMLDataStoreException {
        super.connect(login, session);
        if (!(login instanceof XMLFileLogin)) {
            throw this.buildIncorrectLoginInstanceProvidedException(class$oracle$toplink$xml$XMLFileLogin == null ? (class$oracle$toplink$xml$XMLFileLogin = XMLFileAccessor.class$("oracle.toplink.xml.XMLFileLogin")) : class$oracle$toplink$xml$XMLFileLogin);
        }
        try {
            this.validateFilePolicies();
        }
        catch (XMLDataStoreException xMLDataStoreException) {
            this.setIsConnected(false);
            throw xMLDataStoreException;
        }
        this.setIsConnected(true);
    }

    protected Object convert(Object object, Class clazz, Session session) {
        return session.getDatasourcePlatform().convertObject(object, clazz);
    }

    public DatabaseRow convert(DatabaseRow databaseRow, Session session) {
        if (databaseRow == null || databaseRow.isEmpty()) {
            return databaseRow;
        }
        DatabaseRow databaseRow2 = new DatabaseRow(databaseRow.size());
        Enumeration enumeration = databaseRow.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            object = object instanceof SDKFieldValue ? this.convert((SDKFieldValue)object, session) : this.convert(object, STRING_CLASS, session);
            databaseRow2.put(databaseField, object);
        }
        return databaseRow2;
    }

    protected Object convert(SDKFieldValue sDKFieldValue, Session session) {
        Vector<Object> vector = new Vector<Object>(sDKFieldValue.getElements().size());
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            Object object = null;
            object = sDKFieldValue.isDirectCollection() ? this.convert(enumeration.nextElement(), STRING_CLASS, session) : this.convert((DatabaseRow)enumeration.nextElement(), session);
            vector.addElement(object);
        }
        return sDKFieldValue.clone(vector);
    }

    public void createStreamSource(String string) throws XMLDataStoreException {
        this.getFilePolicy(string).createFileSource(string);
    }

    public Integer deleteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        File file = this.getFilePolicy(string).getFile(string, databaseRow, vector);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(file);
        return xMLStreamPolicy.deleteStream(string, databaseRow, vector, this);
    }

    public void disconnect(Session session) throws XMLDataStoreException {
        super.disconnect(session);
    }

    public void dropStreamSource(String string) throws XMLDataStoreException {
        this.getFilePolicy(string).dropFileSource(string);
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getCustomClassLoader();
        if (classLoader == null) {
            classLoader = PrivilegedAccessController.getClassLoaderForClass(this.getClass());
        }
        return classLoader;
    }

    private ClassLoader getCustomClassLoader() {
        if (customClassLoader == null) {
            customClassLoader = XMLFileAccessor.buildCustomClassLoader();
        }
        return customClassLoader;
    }

    public XMLFileAccessorFilePolicy getDefaultFilePolicy() {
        return this.defaultFilePolicy;
    }

    public Reader getExistenceCheckStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        File file = this.getFilePolicy(string).getFile(string, databaseRow, vector);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(file);
        return xMLStreamPolicy.getExistenceCheckStream(string, databaseRow, vector, this);
    }

    public Writer getExistingWriteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        File file = this.getFilePolicy(string).getFile(string, databaseRow, vector);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(file);
        return xMLStreamPolicy.getExistingWriteStream(string, databaseRow, vector, this);
    }

    protected Map getFilePolicies() {
        return this.filePolicies;
    }

    public XMLFileAccessorFilePolicy getFilePolicy(String string) {
        XMLFileAccessorFilePolicy xMLFileAccessorFilePolicy = (XMLFileAccessorFilePolicy)this.getFilePolicies().get(string);
        if (xMLFileAccessorFilePolicy == null) {
            xMLFileAccessorFilePolicy = this.getDefaultFilePolicy();
        }
        return xMLFileAccessorFilePolicy;
    }

    public Writer getNewWriteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        File file = this.getFilePolicy(string).getFile(string, databaseRow, vector);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(file);
        return xMLStreamPolicy.getNewWriteStream(string, databaseRow, vector, this);
    }

    public Reader getReadStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        File file = this.getFilePolicy(string).getFile(string, databaseRow, vector);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(file);
        return xMLStreamPolicy.getReadStream(string, databaseRow, vector, this);
    }

    public Enumeration getReadStreams(String string) throws XMLDataStoreException {
        Enumeration enumeration = this.getFilePolicy(string).getAllFiles(string);
        XMLStreamPolicy xMLStreamPolicy = this.buildStreamPolicy(enumeration);
        return xMLStreamPolicy.getReadStreams(string, this);
    }

    public Enumeration getReadStreams(String string, Vector vector, Vector vector2) throws XMLDataStoreException {
        return new StreamEnumerator(string, vector, vector2);
    }

    protected XMLFileLogin getXMLFileLogin() {
        return (XMLFileLogin)this.getLogin();
    }

    public XMLTranslator getXMLTranslator() {
        if (this.translator == null) {
            this.translator = this.buildDefaultXMLTranslator();
        }
        return this.translator;
    }

    protected Object instantiate(Class clazz) {
        try {
            return PrivilegedAccessController.newInstanceFromClass(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw XMLDataStoreException.instantiationException(clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw XMLDataStoreException.instantiationIllegalAccessException(clazz);
        }
    }

    protected Object instantiate(String string) {
        return this.instantiate(this.loadClass(string));
    }

    protected Class loadClass(String string) {
        try {
            return PrivilegedAccessController.getClassLoaderForClass(this.getClass()).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw XMLDataStoreException.classNotFound(string);
        }
    }

    void setBaseDirectoryName(String string) {
        ((DefaultXMLFileAccessorFilePolicy)this.getDefaultFilePolicy()).setBaseDirectoryName(string);
    }

    void setCreatesDirectoriesAsNeeded(boolean bl) {
        ((DefaultXMLFileAccessorFilePolicy)this.getDefaultFilePolicy()).setCreatesDirectoriesAsNeeded(bl);
    }

    public void setDefaultFilePolicy(XMLFileAccessorFilePolicy xMLFileAccessorFilePolicy) {
        this.defaultFilePolicy = xMLFileAccessorFilePolicy;
    }

    void setFileNameExtension(String string) {
        ((DefaultXMLFileAccessorFilePolicy)this.getDefaultFilePolicy()).setFileNameExtension(string);
    }

    protected void setFilePolicies(Map map) {
        this.filePolicies = map;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.translator = xMLTranslator;
    }

    protected void toString(PrintWriter printWriter) {
        printWriter.print(this.getDefaultFilePolicy());
    }

    protected void validateFilePolicies() {
        this.getDefaultFilePolicy().validateConfiguration();
        Iterator iterator = this.getFilePolicies().values().iterator();
        while (iterator.hasNext()) {
            ((XMLFileAccessorFilePolicy)iterator.next()).validateConfiguration();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        STRING_CLASS = class$java$lang$String == null ? (class$java$lang$String = XMLFileAccessor.class$("java.lang.String")) : class$java$lang$String;
    }

    protected class StreamEnumerator
    implements Enumeration {
        private String rootElementName;
        private Enumeration foreignKeyRows;
        private Vector orderedForeignKeyElements;

        public StreamEnumerator(String string, Vector vector, Vector vector2) {
            this.rootElementName = string;
            this.foreignKeyRows = vector.elements();
            this.orderedForeignKeyElements = vector2;
        }

        public boolean hasMoreElements() {
            return this.foreignKeyRows.hasMoreElements();
        }

        public Object nextElement() {
            return XMLFileAccessor.this.getReadStream(this.rootElementName, (DatabaseRow)this.foreignKeyRows.nextElement(), this.orderedForeignKeyElements);
        }
    }
}

