/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.sessionconfiguration;

import java.net.URL;
import java.util.Vector;
import oracle.toplink.exceptions.SessionLoaderException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLUnmarshaller;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.tools.sessionconfiguration.DTD2SessionConfigLoader;
import oracle.toplink.tools.sessionconfiguration.TopLinkEntityResolver;
import oracle.toplink.tools.sessionconfiguration.TopLinkSessionsFactory;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigProject;
import oracle.toplink.tools.sessionconfiguration.model.TopLinkSessions;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSessionConfigLoader {
    protected String m_resourceName;
    protected String m_resourcePath;
    protected Vector m_exceptionStore;
    protected TopLinkEntityResolver m_entityResolver;
    protected static final String DEFAULT_RESOURCE_NAME = "sessions.xml";
    protected static final String DEFAULT_RESOURCE_NAME_IN_META_INF = "META-INF/sessions.xml";
    protected static XMLSessionConfigProject m_project;
    static /* synthetic */ Class class$oracle$toplink$tools$sessionconfiguration$model$TopLinkSessions;

    public XMLSessionConfigLoader() {
        this(DEFAULT_RESOURCE_NAME);
    }

    public XMLSessionConfigLoader(String string) {
        this.m_resourceName = string;
        this.m_exceptionStore = new Vector();
        this.m_entityResolver = new TopLinkEntityResolver();
    }

    public String getResourcePath() {
        return this.m_resourcePath;
    }

    public Vector getExceptionStore() {
        return this.m_exceptionStore;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public boolean load(SessionManager sessionManager, ClassLoader classLoader) {
        Document document = this.loadDocument(classLoader);
        if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
            if (this.getExceptionStore().isEmpty()) {
                XMLContext xMLContext = new XMLContext(m_project);
                XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
                TopLinkSessions topLinkSessions = (TopLinkSessions)xMLUnmarshaller.unmarshal(document);
                sessionManager.setSessions(TopLinkSessionsFactory.getFactory().buildTopLinkSessions(topLinkSessions, classLoader));
                return true;
            }
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
        return false;
    }

    public TopLinkSessions loadConfigsForMappingWorkbench(ClassLoader classLoader) {
        return this.loadConfigsForMappingWorkbench(classLoader, true);
    }

    public TopLinkSessions loadConfigsForMappingWorkbench(ClassLoader classLoader, boolean bl) {
        Document document = this.loadDocument(classLoader, bl);
        if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
            if (this.getExceptionStore().isEmpty()) {
                XMLContext xMLContext = new XMLContext(m_project);
                XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
                return (TopLinkSessions)xMLUnmarshaller.unmarshal(document);
            }
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
        return new DTD2SessionConfigLoader().load(document);
    }

    protected Document loadDocument(ClassLoader classLoader) {
        return this.loadDocument(classLoader, SessionManager.shouldUseSchemaValidation());
    }

    protected Document loadDocument(ClassLoader classLoader, boolean bl) {
        URL uRL = classLoader.getResource(this.m_resourceName);
        if (uRL == null) {
            if (this.m_resourceName.equals(DEFAULT_RESOURCE_NAME)) {
                uRL = classLoader.getResource(DEFAULT_RESOURCE_NAME_IN_META_INF);
            }
            if (uRL == null) {
                throw ValidationException.noSessionsXMLFound(this.m_resourceName);
            }
        }
        this.m_resourcePath = uRL.getPath();
        if (m_project == null) {
            m_project = new XMLSessionConfigProject();
        }
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)m_project.getDescriptors().get(class$oracle$toplink$tools$sessionconfiguration$model$TopLinkSessions == null ? (class$oracle$toplink$tools$sessionconfiguration$model$TopLinkSessions = XMLSessionConfigLoader.class$("oracle.toplink.tools.sessionconfiguration.model.TopLinkSessions")) : class$oracle$toplink$tools$sessionconfiguration$model$TopLinkSessions);
        XMLParser xMLParser = xMLPlatform.newXMLParser();
        if (bl) {
            xMLParser.setValidationMode(3);
        } else {
            xMLParser.setValidationMode(0);
        }
        xMLParser.setWhitespacePreserving(false);
        xMLParser.setXMLSchema(xMLDescriptor.getSchemaReference().getURL());
        xMLParser.setEntityResolver(this.m_entityResolver);
        xMLParser.setErrorHandler(new XMLSessionConfigLoaderErrorHandler());
        return xMLParser.parse(uRL);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLSessionConfigLoaderErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(SessionLoaderException.failedToParseXML(ExceptionLocalization.buildMessage("parsing_warning"), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(sAXParseException);
        }
    }
}

