/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.tools.schemaframework.FieldDefinition;
import oracle.toplink.tools.schemaframework.StoredProcedureDefinition;

public class StoredFunctionDefinition
extends StoredProcedureDefinition {
    public StoredFunctionDefinition() {
        this.addOutputArgument(new FieldDefinition());
    }

    public Writer buildCreationWriter(Session session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.buildCreationWriter(session, writer);
        return writer;
    }

    public Writer buildDeletionWriter(Session session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.buildDeletionWriter(session, writer);
        return writer;
    }

    public String getCreationHeader() {
        return "CREATE FUNCTION ";
    }

    public String getDeletionHeader() {
        return "DROP FUNCTION ";
    }

    public int getFirstArgumentIndex() {
        return 1;
    }

    public void setReturnType(Class clazz) {
        FieldDefinition fieldDefinition = (FieldDefinition)this.getArguments().firstElement();
        fieldDefinition.setType(clazz);
    }

    protected void printReturn(Writer writer, Session session) throws ValidationException {
        try {
            writer.write("\n\t RETURN ");
            FieldDefinition fieldDefinition = (FieldDefinition)this.getArguments().firstElement();
            this.printArgument(fieldDefinition, writer, session);
            writer.write("\n");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }
}

