/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejb11;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EJBXmlWebLogicBeanDefinition {
    public String ejbName;
    public String jndiName;
    public Boolean clusterable;
    public boolean sessionBean;
    private static String WEBLOGIC_ENTERPRISE_BEAN = "weblogic-enterprise-bean";
    private static String EJB_NAME = "ejb-name";
    private static String ENTITY_DESCRIPTOR = "entity-descriptor";
    private static String PERSISTENCE = "persistence";
    private static String PERSISTENCE_TYPE = "persistence-type";
    private static String PERSISTENCE_USE = "persistence-use";
    private static String TYPE_IDENTIFIER = "type-identifier";
    private static String TYPE_VERSION = "type-version";
    private static String TYPE_STORAGE = "type-storage";
    private static String CLUSTERING_DESCRIPTOR = "clustering-descriptor";
    private static String HOME_IS_CLUSTERABLE = "home-is-clusterable";
    private static String STATELESS_BEAN_IS_CLUSTERABLE = "stateless-bean-is-clusterable";
    private static String ENABLE_CALL_BY_REFERENCE = "enable-call-by-reference";
    private static String JNDI_NAME = "jndi-name";
    private static String TOPLINK_TYPE_IDENTIFIER = "TOPLINK_CMP_1_1";
    private static String TOPLINK_TYPE_VERSION = "4.0";
    private static String TOPLINK_TYPE_STORAGE_PREFIX = "META-INF/";
    private static String TOPLINK_BEAN_FILENAME_PREFIX = "toplink-cmp-";
    private static String TOPLINK_BEAN_FILENAME_SUFFIX = ".xml";

    public EJBXmlWebLogicBeanDefinition(String string) {
        this.setEjbName(string);
        this.initializeToDefaults();
    }

    public Boolean getClusterable() {
        return this.clusterable;
    }

    public String getClusterableString() {
        if (this.getClusterable() == null) {
            return "False";
        }
        return this.getClusterable() != false ? "True" : "False";
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void initializeToDefaults() {
        this.isSessionBean(false);
        this.setJndiName(this.getEjbName());
    }

    public boolean isSessionBean() {
        return this.sessionBean;
    }

    public void isSessionBean(boolean bl) {
        this.sessionBean = bl;
    }

    public void setClusterable(boolean bl) {
        this.clusterable = new Boolean(bl);
    }

    public void setEjbName(String string) {
        this.ejbName = string;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public Element storeProperties(Element element, Document document) {
        Element element2;
        Element element3;
        Element element4;
        Element element5 = document.createElement(WEBLOGIC_ENTERPRISE_BEAN);
        element.appendChild(element5);
        Element element6 = document.createElement(EJB_NAME);
        element6.appendChild(document.createTextNode(this.getEjbName()));
        element5.appendChild(element6);
        if (!this.isSessionBean()) {
            element4 = document.createElement(ENTITY_DESCRIPTOR);
            element5.appendChild(element4);
            element3 = document.createElement(PERSISTENCE);
            element4.appendChild(element3);
            element2 = document.createElement(PERSISTENCE_TYPE);
            element3.appendChild(element2);
            element2.appendChild(this.topLinkTypeIdentifierElement(document));
            element2.appendChild(this.topLinkTypeVersionElement(document));
            element2.appendChild(this.topLinkTypeStorageElement(document));
            Element element7 = document.createElement(PERSISTENCE_USE);
            element3.appendChild(element7);
            element7.appendChild(this.topLinkTypeIdentifierElement(document));
            element7.appendChild(this.topLinkTypeVersionElement(document));
        }
        if (this.getClusterable() != null) {
            element4 = document.createElement(CLUSTERING_DESCRIPTOR);
            element5.appendChild(element4);
            element3 = document.createElement(HOME_IS_CLUSTERABLE);
            element3.appendChild(document.createTextNode(this.getClusterableString()));
            element4.appendChild(element3);
            if (this.isSessionBean()) {
                element2 = document.createElement(STATELESS_BEAN_IS_CLUSTERABLE);
                element2.appendChild(document.createTextNode(this.getClusterableString()));
                element4.appendChild(element2);
            }
        }
        element4 = document.createElement(ENABLE_CALL_BY_REFERENCE);
        element4.appendChild(document.createTextNode("True"));
        element5.appendChild(element4);
        element3 = document.createElement(JNDI_NAME);
        element3.appendChild(document.createTextNode(this.getJndiName()));
        element5.appendChild(element3);
        return element;
    }

    public String topLinkBeanFileName() {
        return TOPLINK_BEAN_FILENAME_PREFIX + this.getEjbName().toLowerCase() + TOPLINK_BEAN_FILENAME_SUFFIX;
    }

    protected Element topLinkTypeIdentifierElement(Document document) {
        Element element = document.createElement(TYPE_IDENTIFIER);
        element.appendChild(document.createTextNode(TOPLINK_TYPE_IDENTIFIER));
        return element;
    }

    protected Element topLinkTypeStorageElement(Document document) {
        Element element = document.createElement(TYPE_STORAGE);
        element.appendChild(document.createTextNode(TOPLINK_TYPE_STORAGE_PREFIX + this.topLinkBeanFileName()));
        return element;
    }

    protected Element topLinkTypeVersionElement(Document document) {
        Element element = document.createElement(TYPE_VERSION);
        element.appendChild(document.createTextNode(TOPLINK_TYPE_VERSION));
        return element;
    }
}

